/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractFormController;

public class SimpleFormController
extends AbstractFormController {
    private String formView;
    private String successView;

    public final void setFormView(String formView) {
        this.formView = formView;
    }

    public final String getFormView() {
        return this.formView;
    }

    public final void setSuccessView(String successView) {
        this.successView = successView;
    }

    public final String getSuccessView() {
        return this.successView;
    }

    protected ModelAndView showForm(HttpServletRequest request, HttpServletResponse response, BindException errors) throws Exception {
        return this.showForm(request, response, errors, null);
    }

    protected ModelAndView showForm(HttpServletRequest request, HttpServletResponse response, BindException errors, Map controlModel) throws Exception {
        return this.showForm(request, errors, this.getFormView(), controlModel);
    }

    protected Map referenceData(HttpServletRequest request, Object command, Errors errors) throws Exception {
        return this.referenceData(request);
    }

    protected Map referenceData(HttpServletRequest request) throws Exception {
        return null;
    }

    protected ModelAndView processFormSubmission(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        if (errors.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Data binding errors: " + errors.getErrorCount());
            }
            return this.showForm(request, response, errors);
        }
        if (this.isFormChangeRequest(request, command)) {
            this.logger.debug("Detected form change request -> routing request to onFormChange");
            this.onFormChange(request, response, command, errors);
            return this.showForm(request, response, errors);
        }
        this.logger.debug("No errors -> processing submit");
        return this.onSubmit(request, response, command, errors);
    }

    protected boolean suppressValidation(HttpServletRequest request, Object command) {
        return this.isFormChangeRequest(request, command);
    }

    protected boolean isFormChangeRequest(HttpServletRequest request, Object command) {
        return this.isFormChangeRequest(request);
    }

    protected boolean isFormChangeRequest(HttpServletRequest request) {
        return false;
    }

    protected void onFormChange(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        this.onFormChange(request, response, command);
    }

    protected void onFormChange(HttpServletRequest request, HttpServletResponse response, Object command) throws Exception {
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        return this.onSubmit(command, errors);
    }

    protected ModelAndView onSubmit(Object command, BindException errors) throws Exception {
        ModelAndView mv = this.onSubmit(command);
        if (mv != null) {
            return mv;
        }
        if (this.getSuccessView() == null) {
            throw new ServletException("successView isn't set");
        }
        return new ModelAndView(this.getSuccessView(), errors.getModel());
    }

    protected ModelAndView onSubmit(Object command) throws Exception {
        this.doSubmitAction(command);
        return null;
    }

    protected void doSubmitAction(Object command) throws Exception {
    }
}

