/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class JstlUtils {
    public static final String REQUEST_SCOPE_SUFFIX = ".request";

    public static MessageSource getJstlAwareMessageSource(ServletContext servletContext, MessageSource messageSource) {
        String jstlInitParam = servletContext.getInitParameter("javax.servlet.jsp.jstl.fmt.localizationContext");
        if (jstlInitParam != null) {
            ResourceBundleMessageSource jstlBundleWrapper = new ResourceBundleMessageSource();
            jstlBundleWrapper.setBasename(jstlInitParam);
            jstlBundleWrapper.setParentMessageSource(messageSource);
            return jstlBundleWrapper;
        }
        return messageSource;
    }

    public static void exposeLocalizationContext(HttpServletRequest request, MessageSource messageSource) {
        Locale jstlLocale = RequestContextUtils.getLocale(request);
        MessageSourceResourceBundle bundle = new MessageSourceResourceBundle(messageSource, jstlLocale);
        LocalizationContext jstlContext = new LocalizationContext((ResourceBundle)bundle, jstlLocale);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext", jstlContext);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.locale", jstlLocale);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.localizationContext.request", jstlContext);
        request.setAttribute("javax.servlet.jsp.jstl.fmt.locale.request", jstlLocale);
    }
}

