// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   MsgManager.java

package cn.gd.seismology.liss.server;

import cn.gd.seismology.liss.message.Result;
import cn.gd.seismology.liss.message.SystemLog;
import cn.gd.util.*;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

// Referenced classes of package cn.gd.seismology.liss.server:
//            LissServerProperties, Server, AddDataToJDataStore

public class MsgManager
{

    private MsgManager()
    {
    }

    public static void init()
    {
        try
        {
            maxMsgQueueLength = Integer.parseInt(LissServerProperties.getProperty("System.maxNetSeisMsgQueue", "600"));
        }
        catch(NumberFormatException nfEx)
        {
            System.err.println("Error: System.maxNetSeisMsgQueue should set Integer");
            System.err.println("  Use default: 600");
            maxMsgQueueLength = 600;
        }
        msgQueue = new SynchronizedFixQueue(maxMsgQueueLength, "NetSeisMsgQueue");
        logQueue = new SynchronizedFixQueue(maxMsgQueueLength, "NetSeisLogQueue");
    }

    public static void addQueueAddElementEventListener(QueueAddElementEventListener listener)
    {
        msgQueue.addQueueAddElementEventListener(listener);
        logQueue.addQueueAddElementEventListener(listener);
    }

    public static void removeQueueAddElementEventListener(QueueAddElementEventListener listener)
    {
        msgQueue.removeQueueAddElementEventListener(listener);
        logQueue.removeQueueAddElementEventListener(listener);
    }

    public static void sendLogInfo(int priority, String msg)
    {
        byte logb[] = SystemLog.buildSystemLogInfo(msg);
        Result res = Result.buildResult(true, priority, 0x20100, Server.networkID, Server.networkID + "IP", 0, new Date(), logb);
        addResult(res);
    }

    public static String printLogInfo()
    {
        StringBuffer sbuf = new StringBuffer(2048);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5E74MM\u6708dd\u65E5 HH:mm:ss");
        int size = logQueue.getSize();
        Result res = null;
        for(int i = size - 1; i >= 0; i--)
        {
            res = (Result)logQueue.at(i);
            if(res.getType() == 0x20100)
            {
                sbuf.append(sdf.format(res.getMsgTime()) + "\t");
                sbuf.append(new String(res.getData()) + "\r\n");
            }
        }

        return sbuf.substring(0);
    }

    public static String printBufferMsg(String user)
    {
        StringBuffer sbuf = new StringBuffer(2048);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5E74MM\u6708dd\u65E5 HH:mm:ss");
        Result res = null;
        SynchronizedFixQueue user2MsgQueue = (SynchronizedFixQueue)Server.sendMsgHistory.get(user);
        if(user2MsgQueue != null)
            synchronized(user2MsgQueue)
            {
                int size = user2MsgQueue.getSize();
                for(int i = 0; i < size; i++)
                {
                    res = (Result)user2MsgQueue.at(i);
                    sbuf.append(sdf.format(res.getMsgTime()) + "\t");
                    sbuf.append(Integer.toHexString(res.getType()) + "\r\n");
                }

            }
        return sbuf.substring(0);
    }

    public static void addResult(Result result)
    {
        if(result == null)
            return;
        if((result.getType() & 0x20100) == 0x20100)
            logQueue.addBack(result);
        else
            msgQueue.addBack(result);
/*
        if((result.getType() & 0x10000) == 0x10000)
        {
            SynchronizedFixQueue queue;
            for(Enumeration e = Server.sendMsgHistory.elements(); e.hasMoreElements(); queue.addBack(result))
                queue = (SynchronizedFixQueue)e.nextElement();

        }
*/
        Server.getAddWFThread().add(result);
    }

    public static synchronized boolean isMonitorSendStreamAlive(String user, String ipAddress, String port)
    {
        String key = user + "@" + ipAddress + ":" + port;
        Boolean info = (Boolean)monitorUserTbl.get(key);
        return info != null;
    }

    public static synchronized void addMonitorUser(String user, String ipAddress, String port)
    {
        String key = user + "@" + ipAddress + ":" + port;
        monitorUserTbl.put(key, new Boolean(true));
    }

    public static synchronized void removeMonitorUser(String user, String ipAddress, String port)
    {
        String key = user + "@" + ipAddress + ":" + port;
        monitorUserTbl.remove(key);
    }

    public static int getSize()
    {
        return msgQueue.getSize();
    }

    public static Result getNewest()
    {
        return (Result)msgQueue.at(getSize() - 1);
    }

    public static Result getOldest()
    {
        return (Result)msgQueue.at(0);
    }

    public static final String cvsid = "$Id: MsgManager.java,v 1.7.2.2 2005/04/15 00:12:49 hwh Exp $";
    private static SynchronizedFixQueue msgQueue = new SynchronizedFixQueue(120, "NetSeisMsgQueue");
    private static SynchronizedFixQueue logQueue = new SynchronizedFixQueue(120, "NetSeisLogQueue");
    private static int maxMsgQueueLength = 120;
    private static Hashtable monitorUserTbl = new Hashtable(10);

}
