// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packimports(3) 
// Source File Name:   SendMsgStream.java

package cn.gd.seismology.liss.server;

import cn.gd.convert.DateToString;
import cn.gd.seismology.config.XmlLocation;
import cn.gd.seismology.liss.message.Result;
import cn.gd.util.*;
import java.io.*;
import java.net.*;
import java.util.Date;
import java.util.Hashtable;

// Referenced classes of package cn.gd.seismology.liss.server:
//            ServerPI, LissUser, Server, MsgManager

public class SendMsgStream
    implements Runnable, QueueAddElementEventListener
{

    public SendMsgStream(ServerPI pi, Socket dataSocket, int msgAccessMask)
    {
        this.dataSocket = null;
        bAbortInSendMsgStream = false;
        bFinish = false;
        fixQueue = new SynchronizedFixQueue(512, "sendMsg");
        lock = new Object();
        this.msgAccessMask = 0;
        this.pi = pi;
        this.dataSocket = dataSocket;
        this.msgAccessMask = msgAccessMask;
        String sname = pi.getLissUser().getShortUserName();
        SynchronizedFixQueue user2MsgQueue = (SynchronizedFixQueue)Server.sendMsgHistory.get(sname);
        if(user2MsgQueue != null)
        {
            synchronized(user2MsgQueue)
            {
                int size = user2MsgQueue.getSize();
                for(int i = 0; i < size; i++)
                {
                    //fixQueue.addBack(user2MsgQueue.getFront());
                    user2MsgQueue.popFront();
                }

            }
            Server.sendMsgHistory.remove(sname);
        }
    }

    public void run()
    {
        System.err.println(pi.getLoggerHeader() + ":\tSendMsgPortClient-" + dataSocket.getInetAddress().getHostAddress() + ":" + dataSocket.getPort() + " start");
        MsgManager.sendLogInfo(5, "\u7528\u6237 " + pi.getPILoggerHeader() + " \u5F00\u59CB\u63A5\u6536\u4FE1\u606F");
        MsgManager.addMonitorUser(pi.getLoginUserName(), pi.getRemoteHostAddress(), "" + pi.getRemoteHostPort());
        addAccess();
        int size;
        while(!bFinish) 
            try
            {
                synchronized(lock)
                {
                    lock.wait(100L);
                }
                checkHistory();
                size = fixQueue.getSize();
                while(0 != size--) 
                {
                    Result result = (Result)fixQueue.getFront();
               	fixQueue.popFront();
                    if(fixQueue.getMaxQueueSize() < size + 2)
                    {
                        System.err.println(pi.getLoggerHeader() + ":\tWARNING: The Send Message Buffer(" + fixQueue.getSize() + "/" + fixQueue.getMaxQueueSize() + ") for " + dataSocket.getInetAddress().getHostAddress() + ":" + dataSocket.getPort() + " is overflow, the old data will lost.");
                        MsgManager.sendLogInfo(4, "\u7528\u6237 " + pi.getPILoggerHeader() + " \u7684\u53D1\u9001\u961F\u5217\u5FEB\u6EE1\uFF0C\u65E7\u6570\u636E\u5C06\u88AB\u629B\u5F03");
                    }
                    if((result.getType() & msgAccessMask) != 0)
                    {
                        dataSocket.getOutputStream().write(result.getBytes());
                        dataSocket.getOutputStream().flush();
                        if((result.getType() & 0x10020) == 0x10020 && Server.bGShare)
                        {
                            XmlLocation xl = new XmlLocation();
                            ByteArrayInputStream baIn = new ByteArrayInputStream(result.getData());
				boolean bparse = false;
				try{
					bparse = xl.parseLocation(baIn);
				}
				catch(Exception ex1){
				}
                            if(bparse)
                            {
                                String cata_id = result.getNetworkID() + DateToString.getFullTime(result.getMsgTime());
                                MsgManager.sendLogInfo(5, "\u670D\u52A1\u6210\u529F\u53D1\u9001\u4FE1\u606F " + cata_id + "\u7ED9\u7528\u6237\uFF1A " + pi.getPILoggerHeader());
                                System.err.println("--------send " + cata_id + " is OK--------");
                            } else
                            {
                                System.err.println(new Date() + ":\tWARNING FAILT to PARSE xml file");
                                MsgManager.sendLogInfo(4, "\u7528\u6237 " + pi.getPILoggerHeader() + "\u63A5\u6536\u7684\u5B9A\u4F4D\u7ED3\u679C\u4E0D\u5408\u6CD5\uFF0C\u5177\u4F53\u9519\u8BEF\u53EF\u5728log/server.log\u4E2D\u627E\u5230");
                            }
                        } else
                        {
                            MsgManager.sendLogInfo(5, "\u670D\u52A1\u6210\u529F\u53D1\u9001\u4FE1\u606F" + result + "\u7ED9\u7528\u6237 " + pi.getPILoggerHeader());
                        }
                    }
                    //fixQueue.popFront();
                }
            }
            catch(InterruptedException iEx) { }
            catch(SocketException sEx)
            {
                MsgManager.sendLogInfo(5, "\u670D\u52A1\u5668\u7ED9\u7528\u6237 " + pi.getPILoggerHeader() + "\u7684\u53D1\u9001\u8FDE\u63A5\u4E2D\u65AD\uFF1A " + sEx.getMessage());
                System.err.println(pi.getLoggerHeader() + ":\tSocketException in SendMsgStream");
                System.err.println("\tSendMsgPortClient-" + dataSocket.getInetAddress().getHostAddress() + ":" + dataSocket.getPort() + " connection Broken.");
                bFinish = true;
            }
            catch(InterruptedIOException iioEx)
            {
                MsgManager.sendLogInfo(5, "\u670D\u52A1\u5668\u7ED9\u7528\u6237 " + pi.getPILoggerHeader() + "\u7684\u53D1\u9001\u8FDE\u63A5\u8D85\u65F6\u4E2D\u65AD");
                System.err.println(pi.getLoggerHeader() + ":\tInterruptedIOException in SendMsgStream");
                bFinish = true;
                try
                {
                    Thread.sleep(5000L);
                }
                catch(InterruptedException iEx) { }
            }
            catch(IOException ioEx)
            {
                MsgManager.sendLogInfo(5, "\u670D\u52A1\u5668\u7ED9\u7528\u6237 " + pi.getPILoggerHeader() + "\u7684\u53D1\u9001\u8FDE\u63A5IO\u9519\u8BEF\u4E2D\u65AD\uFF1A " + ioEx.getMessage());
                System.err.println(pi.getLoggerHeader() + ":\tIOException in SendMsgStream");
                System.err.println("\tSendMsgPortClient-" + dataSocket.getInetAddress().getHostAddress() + ":" + dataSocket.getPort() + " connection Broken.");
                ioEx.printStackTrace();
                try
                {
                    if(dataSocket != null)
                        dataSocket.close();
                }
                catch(IOException e) { }
                bFinish = true;
            }
        try
        {
            if(dataSocket != null)
                dataSocket.close();
        }
        catch(IOException ioEx) { }
        MsgManager.removeMonitorUser(pi.getLoginUserName(), pi.getRemoteHostAddress(), "" + pi.getRemoteHostPort());
        removeAccess();
        size = fixQueue.getSize();
        String sname = pi.getLissUser().getShortUserName();
        SynchronizedFixQueue user2MsgQueue = (SynchronizedFixQueue)Server.sendMsgHistory.get(sname);
        if(user2MsgQueue == null)
            Server.sendMsgHistory.put(sname, new SynchronizedFixQueue(150, "sendMsg-" + sname));
        user2MsgQueue = (SynchronizedFixQueue)Server.sendMsgHistory.get(sname);
        for(int i = 0; i < size; i++)
        {
            user2MsgQueue.addBack(fixQueue.getFront());
            fixQueue.popFront();
        }

        System.err.println(pi.getLoggerHeader() + ":\tSendMsgPortClient-" + dataSocket.getInetAddress().getHostAddress() + ":" + dataSocket.getPort() + " stop");
        if(!bAbortInSendMsgStream)
            pi.quit();
    }

    private void checkHistory()
    {
        String sname = pi.getLissUser().getShortUserName();
        SynchronizedFixQueue user2MsgQueue = (SynchronizedFixQueue)Server.sendMsgHistory.get(sname);
        if(user2MsgQueue != null)
            synchronized(user2MsgQueue)
            {
                int size = user2MsgQueue.getSize();
                for(int i = 0; i < size; i++)
                {
                    fixQueue.addBack(user2MsgQueue.getFront());
                    user2MsgQueue.popFront();
                }

            }
    }

    public void QueueAddElementHandler(QueueAddElementEvent e)
    {
        Result result = (Result)(Result)e.getValue();
        fixQueue.addBack(result);
        synchronized(lock)
        {
            lock.notify();
        }
    }

    public synchronized void addAccess()
    {
        MsgManager.addQueueAddElementEventListener(this);
    }

    public synchronized void removeAccess()
    {
        MsgManager.removeQueueAddElementEventListener(this);
    }

    public void stop()
    {
        bAbortInSendMsgStream = true;
        bFinish = true;
    }

    public static final String cvsid = "$Id: SendMsgStream.java,v 1.9.2.3 2005/04/19 05:06:01 hwh Exp $";
    private ServerPI pi;
    Socket dataSocket;
    private boolean bAbortInSendMsgStream;
    private boolean bFinish;
    private SynchronizedFixQueue fixQueue;
    private Object lock;
    private int msgAccessMask;
}
