/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import cn.org.gddsn.jopens.entity.Catalog;

public abstract class AbstractCatalogFilter {
    private int minStation = 7;
    private int maxStation = Integer.MAX_VALUE;
    private double minMag = -9.999999999E9;
    private double maxMag = Double.MAX_VALUE;
    private double minLat = -90.0;
    private double maxLat = 90.0;
    private double minLon = -180.0;
    private double maxLon = 180.0;
    private double minDepth = 0.0;
    private double maxDepth = 0.0;
    private double minRms = 0.0;
    private double maxRms = 3.5;

    public boolean feed(Catalog c) {
        int nsta = c.getLocStn();
        if (nsta < this.minStation || nsta > this.maxStation) {
            return false;
        }
        double rms = c.getRms();
        if (rms < this.minRms || rms > this.maxRms) {
            return false;
        }
        double mag = c.getM();
        if (mag < this.minMag || mag > this.maxMag) {
            return false;
        }
        double lat = c.getLat();
        if (lat < this.minLat || lat > this.maxLat) {
            return false;
        }
        double lon = c.getLon();
        return !(lon < this.minLon) && !(lon > this.maxLon);
    }

    public double getMaxRms() {
        return this.maxRms;
    }

    public void setMaxRms(double maxRms) {
        this.maxRms = maxRms;
    }

    public double getMinRms() {
        return this.minRms;
    }

    public void setMinRms(double minRms) {
        this.minRms = minRms;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public void setMaxLat(double maxLat) {
        this.maxLat = maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public void setMaxLon(double maxLon) {
        this.maxLon = maxLon;
    }

    public double getMaxMag() {
        return this.maxMag;
    }

    public void setMaxMag(double maxMag) {
        this.maxMag = maxMag;
    }

    public int getMaxStation() {
        return this.maxStation;
    }

    public void setMaxStation(int maxStation) {
        this.maxStation = maxStation;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public void setMinLat(double minLat) {
        this.minLat = minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(double minDepth) {
        this.minDepth = minDepth;
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(double maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setMinLon(double minLon) {
        this.minLon = minLon;
    }

    public double getMinMag() {
        return this.minMag;
    }

    public void setMinMag(double minMag) {
        this.minMag = minMag;
    }

    public int getMinStation() {
        return this.minStation;
    }

    public void setMinStation(int minStation) {
        this.minStation = minStation;
    }
}

