/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import JSci.maths.ArrayMath;
import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogA;
import cn.org.gddsn.jopens.entity.CatalogC;
import cn.org.gddsn.jopens.entity.CatalogI;
import cn.org.gddsn.jopens.entity.CatalogR;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.MagA;
import cn.org.gddsn.jopens.entity.MagC;
import cn.org.gddsn.jopens.entity.MagI;
import cn.org.gddsn.jopens.entity.MagR;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.OffLineInfo;
import cn.org.gddsn.jopens.entity.PhaseA;
import cn.org.gddsn.jopens.entity.PhaseC;
import cn.org.gddsn.jopens.entity.PhaseI;
import cn.org.gddsn.jopens.entity.PhaseR;
import cn.org.gddsn.jopens.entity.ReirInfo;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.WaveformEvent;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette010;
import cn.org.gddsn.jopens.entity.seed.Blockette030;
import cn.org.gddsn.jopens.entity.seed.Blockette072;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.HistoryValue;
import cn.org.gddsn.jopens.entity.seed.Magnitude;
import cn.org.gddsn.jopens.entity.seed.Pair;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Response055;
import cn.org.gddsn.jopens.entity.seed.Span;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.entity.seed.VolumeIndex;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.seed.SeedVolume;
import edu.iris.miniseedutils.steim.GenericCompressMiniSeedRecord;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedChunk;
import edu.iris.timeutils.TimeStamp;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInfoUtils {
    static Logger logger = Logger.getLogger(EventInfoUtils.class);
    private static DecimalFormat fmt = new DecimalFormat("000000");
    private static Hashtable<String, MagType> mtTbl = new Hashtable(16);

    private static MagType findMagTypeById(SeedVolumeService svs, String id) {
        MagType mt = mtTbl.get(id);
        if (mt == null && (mt = svs.findMagTypeById(id)) != null) {
            mtTbl.put(id, mt);
        }
        return mt;
    }

    public static String getCatalogId(String eventId, char type, int cata_seq) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$s.%2$c.%3$03d", eventId, Character.valueOf(type), cata_seq);
        return sb.substring(0);
    }

    public static String getCatalogId(String eventId, char type, SeedVolumeService svs) {
        StringBuilder sb;
        int n = 1;
        String cataId = "";
        Catalog c = null;
        do {
            sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            fmt.format("%1$s.%2$c.%3$03d", eventId, Character.valueOf(type), n++);
        } while ((c = svs.findCatalog(cataId = sb.substring(0))) != null);
        return cataId;
    }

    public static boolean isCatalogCExist(EventInfo evtInfo) {
        if (evtInfo == null) {
            return false;
        }
        return EventInfoUtils.isExist(EventInfoUtils.getCatalogId(evtInfo.getEventId(), 'C', 1), evtInfo);
    }

    public static boolean isExist(String cataId, EventInfo evtInfo) {
        if (evtInfo == null) {
            return false;
        }
        List cls = evtInfo.getCatalogs();
        boolean found = false;
        for (Catalog c : cls) {
            if (!c.getId().equals(cataId)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static String getCatalogName(SourceParam s, String netCode, SeedVolumeService svs) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format("%1$s.%2$tF %2$tT%3$7.2f%4$6.2f%5$ 3.1f", netCode, s.getOriginTime(), s.getLon(), s.getLat(), s.getM() > -9999.0 ? s.getM() : -9.9);
        return sb.substring(0);
    }

    public static String getEventId(Date originTime, String netCode, SeedVolumeService svs) {
        StringBuilder sb;
        int n = 1;
        String eventId = null;
        do {
            sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            fmt.format("%1$s.%2$tY%2$tm%2$td%2$tH%2$tM.%3$04d", netCode, originTime, n++);
        } while (svs.findEventInfo(eventId = sb.substring(0)) != null);
        return eventId;
    }

    public static String getRtsEventId(Date originTime, String netCode, SeedVolumeService svs) {
        StringBuilder sb;
        int n = 1;
        String eventId = null;
        do {
            sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            fmt.format("%1$s.%2$tY%2$tm%2$td%2$tH%2$tM%2$tS.%3$02d", netCode, originTime, n++);
        } while (svs.findEventInfo(eventId = sb.substring(0)) != null);
        return eventId;
    }

    public static Phase entityPhase2Phase(cn.org.gddsn.jopens.entity.Phase dbPh, Phase ph) {
        try {
            BeanUtils.copyProperties((Object)ph, (Object)dbPh);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        ph.setPhaseTime(dbPh.getFullPhaseTime());
        ChannelLocator cl = dbPh.getChannelLocator();
        ph.setNetCode(cl.getNetCode());
        ph.setStationCode(cl.getStationCode());
        ph.setLocId(cl.getLocId());
        ph.setChanCode(cl.getChanCode());
        if (dbPh.getPhaseType().equals("time")) {
            ph.setPhaType(0);
        } else if (dbPh.getPhaseType().equals("amp")) {
            ph.setPhaType(1);
            if (dbPh.getAmpType().equals("half")) {
                ph.setAmpType(0);
            } else if (dbPh.getAmpType().equals("full")) {
                ph.setAmpType(1);
            }
        }
        ph.setPhaseTime(new Date(dbPh.getFullPhaseTime().getTime()));
        if (dbPh.getRecType().equals("V")) {
            ph.setRecType(1);
        } else if (dbPh.getRecType().equals("D")) {
            ph.setRecType(0);
        } else if (dbPh.getRecType().equals("A")) {
            ph.setRecType(2);
        } else if (dbPh.getRecType().equals("SD")) {
            ph.setRecType(3);
        }
        if (dbPh instanceof PhaseA) {
            ph.setProcessType('A');
        } else if (dbPh instanceof PhaseI) {
            ph.setProcessType('I');
        } else if (dbPh instanceof PhaseC) {
            ph.setProcessType('C');
        } else if (dbPh instanceof PhaseR) {
            ph.setProcessType('R');
        }
        return ph;
    }

    public static Vector<Phase>[] buildAllStationPhases(Catalog cata) {
        Hashtable tbl = new Hashtable();
        for (cn.org.gddsn.jopens.entity.Phase dbPh : cata.getPhases()) {
            String key = dbPh.getChannelLocator().toString();
            Vector<Phase> vec = (Vector<Phase>)tbl.get(key);
            if (vec == null) {
                vec = new Vector<Phase>();
                tbl.put(key, vec);
            }
            Phase ph = new Phase();
            EventInfoUtils.entityPhase2Phase(dbPh, ph);
            vec.add(ph);
        }
        Vector[] vecs = new Vector[tbl.values().size()];
        tbl.values().toArray(vecs);
        return vecs;
    }

    public static EventInfo copyEventInfo(EventInfo from) {
        EventInfo to = new EventInfo();
        try {
            ConvertUtils.register((Converter)new DateConverter(null), Date.class);
            BeanUtils.copyProperties((Object)to, (Object)from);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        to.setDataless(null);
        for (Catalog c : to.getCatalogs()) {
            c.setEventInfo(to);
            for (Mag m : c.getMags()) {
                m.setId(0L);
                m.setCatalog(c);
            }
            for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
                p.setId(0L);
                p.setCatalog(c);
            }
        }
        return to;
    }

    public static String getMagType(String ampName) {
        if (ampName.startsWith("SM")) {
            return "ML";
        }
        if (ampName.startsWith("L")) {
            return "Ms";
        }
        if (ampName.startsWith("PM")) {
            return "mb";
        }
        return "M";
    }

    public static cn.org.gddsn.jopens.entity.Phase phase2EntityPhase(Phase ph, cn.org.gddsn.jopens.entity.Phase dbPh, SeedVolumeService svs) {
        MagType mt;
        String mn;
        try {
            BeanUtils.copyProperties((Object)dbPh, (Object)ph);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dbPh.setFullPhaseTime(ph.getPhaseTime());
        dbPh.setChannelLocator(new ChannelLocator(ph.getNetCode(), ph.getStationCode(), ph.getLocId(), ph.getChanCode()));
        dbPh.setFullPhaseTime(ph.getPhaseTime());
        if (ph.getPhaType() == 0) {
            dbPh.setPhaseType("time");
            dbPh.setAmpType(null);
        } else if (ph.getPhaType() == 1) {
            dbPh.setPhaseType("amp");
            if (ph.getAmpType() == 0) {
                dbPh.setAmpType("half");
            } else if (ph.getAmpType() == 1) {
                dbPh.setAmpType("full");
            }
            mn = ph.getMagName();
            if (mn == null) {
                mn = EventInfoUtils.getMagType(ph.getPhaseName());
            }
            if (mn != null) {
                if (svs != null) {
                    dbPh.setMagType(EventInfoUtils.findMagTypeById(svs, mn));
                } else {
                    mt = new MagType();
                    mt.setId(mn);
                    dbPh.setMagType(mt);
                }
            }
        }
        if (ph.getRecType() == 1) {
            dbPh.setRecType("V");
        } else if (ph.getRecType() == 0) {
            dbPh.setRecType("D");
        } else if (ph.getRecType() == 2) {
            dbPh.setRecType("A");
        } else {
            dbPh.setRecType("SD");
        }
        if (Float.isNaN(dbPh.getMagVal())) {
            dbPh.setMagVal(-99999.0f);
        }
        if ((mn = ph.getMagName()) == null) {
            mn = EventInfoUtils.getMagType(ph.getPhaseName());
        }
        if (mn != null && (double)dbPh.getMagVal() > -9999.0) {
            if (svs != null) {
                dbPh.setMagType(EventInfoUtils.findMagTypeById(svs, mn));
            } else {
                mt = new MagType();
                mt.setId(mn);
                dbPh.setMagType(mt);
            }
        }
        return dbPh;
    }

    private static Mag buildMag(Catalog catalog) {
        if (catalog instanceof CatalogA) {
            return new MagA();
        }
        if (catalog instanceof CatalogI) {
            return new MagI();
        }
        if (catalog instanceof CatalogR) {
            return new MagR();
        }
        if (catalog instanceof CatalogC) {
            return new MagC();
        }
        return new Mag();
    }

    private static void fillMag(Mag mag, Catalog c, float magVal, String magName, int magNum, float std, SeedVolumeService svs) {
        mag.setCatalog(c);
        mag.setMagStn(magNum);
        if (Float.isNaN(std)) {
            mag.setMagError(null);
        } else {
            mag.setMagError(Float.valueOf(std));
        }
        if (Float.isNaN(magVal)) {
            mag.setMagVal(-99999.0f);
        } else {
            mag.setMagVal(magVal);
        }
        mag.setMagGap(-99999.0f);
        if (svs != null) {
            MagType mt = EventInfoUtils.findMagTypeById(svs, magName);
            if (mt == null) {
                logger.warn((Object)("CAN NOT found in DB: " + magName));
            }
            mag.setMagType(mt);
        } else {
            MagType mt = new MagType();
            mt.setId(magName);
            mag.setMagType(mt);
        }
    }

    public static SourceParam catalog2SourceParam(SourceParam source, Catalog c) {
        try {
            ConvertUtils.register((Converter)new DateConverter(null), Date.class);
            BeanUtils.copyProperties((Object)source, (Object)c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        source.setOriginTime(new Date(c.getFullOriginTime().getTime()));
        return source;
    }

    public static Catalog sourceParam2Catalog(SourceParam source, Catalog c, SeedVolumeService svs) {
        double[] mm;
        int i;
        float std;
        int n;
        Mag mag;
        try {
            ConvertUtils.register((Converter)new DateConverter(null), Date.class);
            BeanUtils.copyProperties((Object)c, (Object)source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long tms = source.getOriginTime().getTime();
        c.setFullOriginTime(new Date(tms));
        if (c.getErz() < 0.0f) {
            c.setDepfixFlag(1);
        }
        HashSet<Mag> mags = new HashSet<Mag>();
        c.setMags(mags);
        if (!Double.isNaN(source.getMs()) && source.getMs() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            n = -1;
            EventInfoUtils.fillMag(mag, c, (float)source.getMs(), "Ms", n, 0.0f, svs);
            mags.add(mag);
        }
        if (!Double.isNaN(source.getMl()) && source.getMl() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            n = -1;
            std = 0.0f;
            if (source.mag_ml != null && source.mag_ml.size() > 0) {
                n = source.mag_ml.size();
                i = 0;
                mm = new double[source.mag_ml.size()];
                for (Double f : source.mag_ml.values()) {
                    mm[i++] = f;
                }
                std = (float)ArrayMath.standardDeviation((double[])mm);
            }
            EventInfoUtils.fillMag(mag, c, (float)source.getMl(), "ML", n, std, svs);
            mags.add(mag);
        }
        if (!Double.isNaN(source.getMwp()) && source.getMwp() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            n = -1;
            std = 0.0f;
            if (source.mag_mwp_tsuboi != null && source.mag_mwp_tsuboi.size() > 0) {
                n = source.mag_mwp_tsuboi.size();
                i = 0;
                mm = new double[source.mag_mwp_tsuboi.size()];
                for (Double f : source.mag_mwp_tsuboi.values()) {
                    mm[i++] = f;
                }
                std = (float)ArrayMath.standardDeviation((double[])mm);
            }
            EventInfoUtils.fillMag(mag, c, (float)source.getMwp(), "Mwp", n, std, svs);
            mags.add(mag);
        }
        if (!Double.isNaN(source.getMw()) && source.getMw() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            n = -1;
            std = 0.0f;
            if (source.mag_mw != null && source.mag_mw.size() > 0) {
                n = source.mag_mw.size();
                i = 0;
                mm = new double[source.mag_mw.size()];
                for (Double f : source.mag_mw.values()) {
                    mm[i++] = f;
                }
                std = (float)ArrayMath.standardDeviation((double[])mm);
            }
            EventInfoUtils.fillMag(mag, c, (float)source.getMw(), "Mw", n, std, svs);
            mags.add(mag);
        }
        if (!Double.isNaN(source.getMb()) && source.getMb() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            n = -1;
            std = 0.0f;
            if (source.mag_mb != null && source.mag_mb.size() > 0) {
                n = source.mag_mb.size();
                i = 0;
                mm = new double[source.mag_mb.size()];
                for (Double f : source.mag_mb.values()) {
                    mm[i++] = f;
                }
                std = (float)ArrayMath.standardDeviation((double[])mm);
            }
            EventInfoUtils.fillMag(mag, c, (float)source.getMb(), "Mb", n, std, svs);
            mags.add(mag);
        }
        if (!Double.isNaN(source.getMd()) && source.getMd() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            EventInfoUtils.fillMag(mag, c, (float)source.getMd(), "Md", -1, 0.0f, svs);
            mags.add(mag);
        }
        if (!Double.isNaN(source.getMB()) && source.getMB() > -9999.0) {
            mag = EventInfoUtils.buildMag(c);
            n = -1;
            std = 0.0f;
            if (source.mag_mB != null && source.mag_mB.size() > 0) {
                n = source.mag_mB.size();
                i = 0;
                mm = new double[source.mag_mB.size()];
                for (Double f : source.mag_mB.values()) {
                    mm[i++] = f;
                }
                std = (float)ArrayMath.standardDeviation((double[])mm);
            }
            EventInfoUtils.fillMag(mag, c, (float)source.getMB(), "mBB", n, std, svs);
            mags.add(mag);
        }
        if (Float.isNaN(c.getM())) {
            c.setM(-99999.0f);
        }
        if (Float.isNaN(c.getErh())) {
            c.setErh(-99999.0f);
        }
        if (Float.isNaN(c.getErz())) {
            c.setErz(-99999.0f);
        }
        return c;
    }

    public static void buildCatalog(Catalog c, String eventId, SourceParam source, Phase[] phases, SeedVolumeService svs) {
        long now = System.currentTimeMillis();
        if (c.getId() == null) {
            if (c instanceof CatalogI) {
                c.setId(EventInfoUtils.getCatalogId(eventId, 'I', svs));
            } else if (c instanceof CatalogA) {
                c.setId(EventInfoUtils.getCatalogId(eventId, 'A', svs));
            } else if (c instanceof CatalogR) {
                c.setId(EventInfoUtils.getCatalogId(eventId, 'R', svs));
            } else if (c instanceof CatalogC) {
                c.setId(EventInfoUtils.getCatalogId(eventId, 'C', svs));
            }
        }
        LinkedList<PhaseI> dbPhs = new LinkedList<PhaseI>();
        c.setPhases(dbPhs);
        Phase[] phaseArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            Phase ph = phaseArray[n2];
            PhaseI dbPh = null;
            if (c instanceof CatalogI) {
                dbPh = new PhaseI();
            } else if (c instanceof CatalogA) {
                dbPh = new PhaseA();
            } else if (c instanceof CatalogR) {
                dbPh = new PhaseR();
            } else if (c instanceof CatalogC) {
                dbPh = new PhaseC();
            }
            EventInfoUtils.phase2EntityPhase(ph, (cn.org.gddsn.jopens.entity.Phase)dbPh, svs);
            dbPhs.add(dbPh);
            dbPh.setCatalog(c);
            ++n2;
        }
        EventInfoUtils.sourceParam2Catalog(source, c, svs);
        String catalogName = EventInfoUtils.getCatalogName(source, source.getNetCode(), svs);
        logger.info((Object)("catalog name: " + catalogName));
        if (catalogName.length() > 40) {
            catalogName = catalogName.substring(0, 40);
        }
        c.setCataName(catalogName);
        logger.info((Object)("buildCatalog: " + (System.currentTimeMillis() - now)));
    }

    public static ReirInfo buildReirInfo(String eventId, SourceParam source, Phase[] phases, SeedVolumeService svs) {
        CatalogR c = new CatalogR();
        c.setId(EventInfoUtils.getCatalogId(eventId, 'R', svs));
        logger.info((Object)("Gernerate Catalog Id: " + c.getId()));
        LinkedList<PhaseR> dbPhs = new LinkedList<PhaseR>();
        ReirInfo info = new ReirInfo();
        info.setSendTime(new Date());
        info.setRecvTime(new Date());
        c.setPhases(dbPhs);
        info.setCatalog((Catalog)c);
        Phase[] phaseArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            Phase ph = phaseArray[n2];
            PhaseR dbPh = new PhaseR();
            EventInfoUtils.phase2EntityPhase(ph, (cn.org.gddsn.jopens.entity.Phase)dbPh, svs);
            dbPhs.add(dbPh);
            dbPh.setCatalog((Catalog)c);
            ++n2;
        }
        EventInfoUtils.sourceParam2Catalog(source, (Catalog)c, svs);
        c.setCataName(EventInfoUtils.getCatalogName(source, source.getNetCode(), svs));
        return info;
    }

    public static EventInfo buildEventInfo(EventInfo info, SourceParam source, Phase[] phases, char autoFlag, EvtData evt, boolean offLine, File offFile, boolean bWF, int begSec, int cutSec, SeedVolumeService svs) {
        SeedVolume seed = null;
        if (!offLine) {
            seed = (SeedVolume)evt;
        }
        if (info == null) {
            info = new EventInfo();
            info.setEventId(EventInfoUtils.getEventId(source.getOriginTime(), source.getNetCode(), svs));
            LinkedList catalogs = new LinkedList();
            info.setCatalogs(catalogs);
        }
        if (!offLine) {
            Dataless dl = seed.getDataless();
            Dataless myDl = new Dataless();
            myDl.setSeedConfig(dl.getSeedConfig());
            VolumeIndex vi = new VolumeIndex();
            Blockette010 b010 = new Blockette010();
            b010.setLogicalRecordLength(12);
            b010.setStartTime(new Timestamp(seed.getArrivalTime(0).getTime() + (long)(begSec * 1000)));
            b010.setEndTime(new Timestamp(seed.getArrivalTime(0).getTime() + (long)begSec * 1000L + (long)cutSec * 1000L));
            vi.setBlockette010(b010);
            info.setStartTime((Date)b010.getStartTime());
            info.setEndTime((Date)b010.getEndTime());
            myDl.setVolumeIndex(vi);
            myDl.setTimeSpan(null);
            myDl.setSaveTime(new Timestamp(new Date().getTime()));
            info.setDataless(myDl);
        }
        HashSet wfs = new HashSet();
        CatalogI catalog = new CatalogI();
        if (autoFlag == 'C') {
            catalog = new CatalogC();
            catalog.setId(EventInfoUtils.getCatalogId(info.getEventId(), 'C', svs));
        } else if (autoFlag == 'A') {
            catalog = new CatalogA();
            catalog.setId(EventInfoUtils.getCatalogId(info.getEventId(), 'A', svs));
        } else if (autoFlag == 'R') {
            catalog = new CatalogR();
            catalog.setId(EventInfoUtils.getCatalogId(info.getEventId(), 'R', svs));
        } else {
            catalog.setId(EventInfoUtils.getCatalogId(info.getEventId(), 'I', svs));
        }
        LinkedList<PhaseI> dbPhs = new LinkedList<PhaseI>();
        info.setUniEventId(null);
        info.getCatalogs().add(catalog);
        catalog.setPhases(dbPhs);
        Phase[] phaseArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            Phase ph = phaseArray[n2];
            PhaseI dbPh = new PhaseI();
            if (autoFlag == 'C') {
                dbPh = new PhaseC();
            } else if (autoFlag == 'A') {
                dbPh = new PhaseA();
            } else if (autoFlag == 'R') {
                dbPh = new PhaseR();
            }
            EventInfoUtils.phase2EntityPhase(ph, (cn.org.gddsn.jopens.entity.Phase)dbPh, svs);
            dbPhs.add(dbPh);
            dbPh.setCatalog((Catalog)catalog);
            ++n2;
        }
        EventInfoUtils.sourceParam2Catalog(source, (Catalog)catalog, svs);
        catalog.setCataName(EventInfoUtils.getCatalogName(source, source.getNetCode(), svs));
        info.setWaveformEvents(wfs);
        if (!offLine) {
            EventInfoUtils.addWaveForm(info, seed, begSec, cutSec);
            info.setOffLineInfo(null);
        } else {
            OffLineInfo oli = new OffLineInfo();
            oli.setPath(offFile.getAbsolutePath());
            oli.setFileName(offFile.getName());
            info.setOffLineInfo(oli);
        }
        return info;
    }

    public static void addWaveForm(EventInfo info, EvtData evtData, int begSec, int cutSec) {
        if (evtData == null) {
            return;
        }
        short steimLevel = 2;
        short dframes = 63;
        GenericCompressMiniSeedRecord cmsr = new GenericCompressMiniSeedRecord(steimLevel, dframes);
        int tcn = evtData.getTCN();
        int chn = 0;
        while (chn < tcn) {
            TimeSeries TS = evtData.getTimeSeries(chn);
            cmsr.setStartTime(new TimeStamp(TS.getArrivalTime().getTime() + (long)(begSec * 1000)));
            cmsr.setSampleRate((double)((int)TS.getSampleRate()));
            cmsr.setStationInfo(TS.getNetworkCode(), TS.getStationCode(), TS.getAuxId(), TS.getChannelCode());
            cmsr.setActivityFlag(0);
            double[] sdata = TS.getSampData();
            int[] buf = new int[cutSec * (int)TS.getSampleRate()];
            int begPnt = begSec * (int)TS.getSampleRate();
            int j = 0;
            while (j < buf.length) {
                buf[j] = (int)sdata[begPnt + j];
                ++j;
            }
            int nSamps = cmsr.encodeMiniSeedRecord(buf, buf.length);
            if (nSamps != buf.length) {
                logger.warn((Object)"Error in handle gaps data in addWaveForm()");
            }
            int seq = 0;
            int size = 15;
            MiniSeedChunk msc = null;
            Vector vec = cmsr.getComressFrame();
            int i = 0;
            while (i < vec.size()) {
                byte[] msBytes = (byte[])vec.get(i);
                System.arraycopy(fmt.format(seq++).getBytes(), 0, msBytes, 0, 6);
                GenericMiniSeedRecord g = GenericMiniSeedRecord.buildMiniSeedRecord((byte[])msBytes);
                if (i % size == 0) {
                    msc = MiniSeedChunk.build((GenericMiniSeedRecord)g, (int)(size * 4096));
                } else {
                    msc.merge(MiniSeedChunk.build((GenericMiniSeedRecord)g, (int)4096));
                }
                if (i % size == size - 1) {
                    WaveformEvent wfe = new WaveformEvent(msc);
                    wfe.setEventInfo(info);
                    info.getWaveformEvents().add(wfe);
                    msc = null;
                }
                ++i;
            }
            if (msc != null) {
                WaveformEvent wfe = new WaveformEvent(msc);
                wfe.setEventInfo(info);
                info.getWaveformEvents().add(wfe);
            }
            ++chn;
        }
    }

    public static void resetEventInfo(EventInfo ei) {
        EventInfoUtils.resetDataless(ei.getDataless());
        for (Waveform w : ei.getWaveformEvents()) {
            w.setId(0L);
        }
        for (Catalog c : ei.getCatalogs()) {
            for (cn.org.gddsn.jopens.entity.Phase p : c.getPhases()) {
                p.setId(0L);
            }
            for (Mag m : c.getMags()) {
                m.setId(0L);
            }
        }
    }

    public static void resetDataless(Dataless dl) {
        dl.setId(0L);
        dl.getVolumeIndex().setId(0L);
        if (dl.getVolumeIndex().getBlockette010() != null) {
            dl.getVolumeIndex().getBlockette010().setId(0L);
        }
        if (dl.getVolumeIndex().getBlockette011() != null) {
            dl.getVolumeIndex().getBlockette011().setId(0L);
            for (Pair p : dl.getVolumeIndex().getBlockette011().getPairs()) {
                p.setId(0L);
            }
        }
        if (dl.getVolumeIndex().getBlockette012() != null) {
            dl.getVolumeIndex().getBlockette012().setId(0L);
            for (Span sp : dl.getVolumeIndex().getBlockette012().getSpans()) {
                sp.setId(0L);
            }
        }
        dl.getSeedConfig().setId(0L);
        Abbreviation abbr = dl.getSeedConfig().getAbbreviation();
        abbr.setId(0L);
        for (Blockette030 b : abbr.getBlockette030()) {
            b.setId(0L);
        }
        for (Blockette030 b : abbr.getBlockette031()) {
            b.setId(0L);
        }
        for (Blockette030 b : abbr.getBlockette032()) {
            b.setId(0L);
        }
        for (Blockette030 b : abbr.getBlockette033()) {
            b.setId(0L);
        }
        for (Blockette030 b : abbr.getBlockette034()) {
            b.setId(0L);
        }
        for (TimeSpan ts : dl.getTimeSpan()) {
            ts.setId(0L);
            ts.getBlockette070().setId(0L);
            if (ts.getBlockette071() != null) {
                ts.getBlockette071().setId(0L);
                for (Magnitude m : ts.getBlockette071().getMagnitudes()) {
                    m.setId(0L);
                }
            }
            for (Blockette072 b : ts.getBlockette072()) {
                b.setId(0L);
            }
            for (Blockette072 b : ts.getBlockette074()) {
                b.setId(0L);
            }
        }
        for (Station sta : dl.getSeedConfig().getStation()) {
            sta.setId(0L);
            if (sta.getBlockette050() != null) {
                sta.getBlockette050().setId(0L);
            }
            if (sta.getStationCorr() != null) {
                sta.getStationCorr().setId(0L);
            }
            if (sta.getStationInfo() != null) {
                sta.getStationInfo().setId(0L);
            }
            if (sta.getStationSite() != null) {
                sta.getStationSite().setId(0L);
            }
            for (Blockette072 b : sta.getBlockette051()) {
                b.setId(0L);
            }
            for (Channel chn : sta.getChannel()) {
                chn.setId(0L);
                if (chn.getChannelInfo() != null) {
                    chn.getChannelInfo().setId(0L);
                }
                chn.getBlockette052().setId(0L);
                for (Response rsp : chn.getResponse()) {
                    rsp.setId(0L);
                    if (rsp.getBlockette053() != null) {
                        rsp.getBlockette053().setId(0L);
                        rsp.getBlockette053().getZeroBlob().setId(0L);
                        rsp.getBlockette053().getPoleBlob().setId(0L);
                    }
                    if (rsp.getBlockette054() != null) {
                        rsp.getBlockette054().setId(0L);
                        rsp.getBlockette054().getDenBlob().setId(0L);
                        rsp.getBlockette054().getNumBlob().setId(0L);
                    }
                    if (rsp.getBlockette055() != null) {
                        rsp.getBlockette055().setId(0L);
                        for (Response055 b : rsp.getBlockette055().getResponses()) {
                            b.setId(0L);
                        }
                    }
                    if (rsp.getBlockette056() != null) {
                        rsp.getBlockette056().setId(0L);
                        for (Response055 b : rsp.getBlockette056().getCorners()) {
                            b.setId(0L);
                        }
                    }
                    if (rsp.getBlockette057() != null) {
                        rsp.getBlockette057().setId(0L);
                    }
                    if (rsp.getBlockette058() != null) {
                        rsp.getBlockette058().setId(0L);
                        for (HistoryValue h : rsp.getBlockette058().getHistoryValues()) {
                            h.setId(0L);
                        }
                    }
                    if (rsp.getBlockette061() == null) continue;
                    rsp.getBlockette061().setId(0L);
                    rsp.getBlockette061().getFirCoeffBlob().setId(0L);
                }
            }
        }
    }
}

