/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import cn.org.gddsn.convert.DateToString;
import cn.org.gddsn.convert.DoubleFormat;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Phase
implements Cloneable,
Serializable,
Comparable<Phase> {
    private static final long serialVersionUID = -8015476126096939028L;
    public static final int SINGLE_AMP = 0;
    public static final int DOUBLE_AMP = 1;
    public static final String ARTI_NONE = "";
    public static final String I = "I";
    public static final String E = "E";
    public static final String BRACKET = "(";
    public static final String SIGN_NONE = "";
    public static final String C = "C";
    public static final String D = "D";
    public static final String U = "U";
    public static final String R = "R";
    public static final int AT = 0;
    public static final int MA = 1;
    public static final int FM = 2;
    private String netCode = "";
    private String stationCode = "";
    private String locId = "00";
    private String chanCode = "";
    private String phaseName = "";
    private Date phaseTime;
    private double amp = 0.0;
    private double period = 0.0;
    private float azimuth = -99999.0f;
    private int weight = 1;
    private int phaType = 0;
    private int belongedChannelID;
    private int ampType = Integer.MAX_VALUE;
    private String clarity = "";
    private String wsign = "";
    private int recType;
    private double incident;
    private String instrumentName = "";
    private String cataId = "";
    private int waveType = 1;
    private double snr;
    public int offset = 0;
    public int iPeriod = 0;
    private float magVal = -99999.0f;
    private String magName;
    private float distance = -99999.0f;
    private float resi = -99999.0f;
    public static final char PROCESS_THEORETIC = 'T';
    public static final char PROCESS_INTERACTIVE = 'I';
    public static final char PROCESS_CATALOG = 'C';
    public static final char PROCESS_EQIM = 'R';
    public static final char PROCESS_AUTO = 'A';
    private char processType = (char)73;

    public int getOffset() {
        return this.offset;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object parm1) {
        if (parm1 instanceof Phase) {
            return ((Phase)parm1).phaseName.equals(this.phaseName);
        }
        return false;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int newWeight) {
        this.weight = newWeight;
    }

    public String toString() {
        if (this.phaType == 0) {
            StringBuilder sb = new StringBuilder(String.format("%s.%s, %s%s%s, %s", this.netCode, this.stationCode, this.clarity, this.phaseName, this.wsign, DateToString.getTime((Date)this.phaseTime)));
            if (this.azimuth >= 0.0f) {
                sb.append(String.format(", azi = %.1f", Float.valueOf(this.azimuth)));
            }
            sb.append(String.format(", w = %d", this.weight));
            if (this.snr >= 0.0) {
                sb.append(String.format(", snr = %.1f", this.snr));
            }
            if (this.distance >= 0.0f) {
                sb.append(String.format(", delta = %.2f", (double)this.distance / 111.19));
            }
            if (this.resi > -99999.0f) {
                sb.append(String.format(", resi = %.2f", Float.valueOf(this.resi)));
            }
            return sb.substring(0);
        }
        return String.valueOf(this.stationCode) + " --- " + this.phaseName + " : " + DateToString.getTime((Date)this.phaseTime) + ",  amp = " + DoubleFormat.toString((double)this.amp, (int)2) + ",  period = " + DoubleFormat.toString((double)this.period, (int)2) + " / W = " + this.weight + ",  Azimuth = " + DoubleFormat.toString((double)this.azimuth, (int)1) + " / SNR = " + DoubleFormat.toString((double)this.snr, (int)1);
    }

    public int getPhaType() {
        return this.phaType;
    }

    public void setPhaType(int newPhaType) {
        this.phaType = newPhaType;
    }

    public int getBelongedChannelID() {
        return this.belongedChannelID;
    }

    public void setBelongedChannelID(int newBelongedChannelID) {
        this.belongedChannelID = newBelongedChannelID;
    }

    public String getChanCode() {
        return this.chanCode;
    }

    public void setChanCode(String newBelongedChannelName) {
        this.chanCode = newBelongedChannelName;
    }

    public int getAmpType() {
        return this.ampType;
    }

    public void setAmpType(int newAmpType) {
        this.ampType = newAmpType;
    }

    public String getClarity() {
        return this.clarity;
    }

    public void setClarity(String newArticulation) {
        this.clarity = newArticulation;
    }

    public String getWsign() {
        return this.wsign;
    }

    public void setWsign(String newFirstMotionSign) {
        this.wsign = newFirstMotionSign;
    }

    public int getRecType() {
        return this.recType;
    }

    public double getSnr() {
        return this.snr;
    }

    public void setRecType(int newOriType) {
        this.recType = newOriType;
    }

    public void setSnr(double snr) {
        this.snr = snr;
    }

    @Override
    public int compareTo(Phase o) {
        if (this.phaseTime == null || o.phaseTime == null) {
            throw new IllegalArgumentException("Phase.phaseTime should not be null!");
        }
        return this.phaseTime.compareTo(o.phaseTime);
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public Date getPhaseTime() {
        return this.phaseTime;
    }

    public void setPhaseTime(Date phaseTime) {
        this.phaseTime = phaseTime;
    }

    public int getWaveType() {
        return this.waveType;
    }

    public void setWaveType(int waveType) {
        this.waveType = waveType;
    }

    public double getAmp() {
        return this.amp;
    }

    public void setAmp(double amp) {
        this.amp = amp;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float azimuth) {
        this.azimuth = Float.isNaN(azimuth) ? -99999.0f : azimuth;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String belongedStationName) {
        this.stationCode = belongedStationName;
    }

    public double getIncident() {
        return this.incident;
    }

    public void setIncident(double incident) {
        this.incident = incident;
    }

    public String getInstrumentName() {
        return this.instrumentName;
    }

    public void setInstrumentName(String instrumentName) {
        this.instrumentName = instrumentName;
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String net) {
        this.netCode = net;
    }

    public double getPeriod() {
        return this.period;
    }

    public void setPeriod(double period) {
        this.period = period;
    }

    public String getCataId() {
        return this.cataId;
    }

    public void setCataId(String cataId) {
        this.cataId = cataId;
    }

    public String getLocId() {
        return this.locId;
    }

    public void setLocId(String locId) {
        this.locId = locId;
    }

    public String getMagName() {
        return this.magName;
    }

    public void setMagName(String magName) {
        this.magName = magName;
    }

    public float getMagVal() {
        return this.magVal;
    }

    public void setMagVal(float magVal) {
        this.magVal = magVal;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getResi() {
        return this.resi;
    }

    public void setResi(float resi) {
        this.resi = resi;
    }

    public char getProcessType() {
        return this.processType;
    }

    public void setProcessType(char processType) {
        this.processType = processType;
    }

    public float getBackAzimuth() {
        float backAzi = this.azimuth;
        if ((backAzi += 180.0f) >= 360.0f) {
            backAzi -= 360.0f;
        }
        return backAzi;
    }

    public void setBackAzimuth(float backAzi) {
        if (Float.isNaN(backAzi) || backAzi == -99999.0f) {
            this.azimuth = backAzi;
        } else {
            this.azimuth = backAzi;
            this.azimuth += 180.0f;
            if (backAzi >= 360.0f) {
                this.azimuth -= 360.0f;
            }
        }
    }
}

