/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PhaseImporter {
    static Logger logger = Logger.getLogger(PhaseImporter.class);
    private SourceParam src;
    private Hashtable<ChannelLocator, Vector<Phase>> tbl = new Hashtable();

    public void readPhase(File phaseFile) throws IOException, ParseException {
        Vector<Phase> vecPhs;
        ChannelLocator cl;
        Phase p;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.src = new SourceParam();
        Scanner sc = new Scanner(phaseFile);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(sc.nextInt(), sc.nextInt() - 1, sc.nextInt(), sc.nextInt(), sc.nextInt(), 0);
        long ms = cal.getTime().getTime() / 1000L * 1000L + (long)(sc.nextFloat() * 1000.0f);
        this.src.setOriginTime(new Date(ms));
        this.src.setLat(sc.nextDouble());
        this.src.setErh(sc.nextDouble());
        this.src.setLon(sc.nextDouble());
        this.src.setErh(sc.nextDouble());
        this.src.setDepth(sc.nextDouble());
        this.src.setErz(sc.nextDouble());
        double m = sc.nextDouble();
        String mtype = sc.next();
        if (mtype.equals("ML")) {
            this.src.setMl(m);
        } else if (mtype.equals("Ms")) {
            this.src.setMs(ms);
        } else {
            this.src.setM(m);
        }
        sc.next();
        this.src.setRms(sc.nextDouble());
        sc.nextLine();
        sc.nextLine();
        sc.nextLine();
        String buf = sc.next();
        while (!buf.trim().startsWith("#")) {
            String sign;
            p = new Phase();
            p.setPhaType(0);
            cl = ChannelLocator.parse((String)buf, (String)"\\.");
            vecPhs = this.tbl.get(cl);
            if (vecPhs == null) {
                vecPhs = new Vector(32);
                this.tbl.put(cl, vecPhs);
            }
            p.setNetCode(cl.getNetCode());
            p.setStationCode(cl.getStationCode());
            p.setLocId(cl.getLocID());
            p.setChanCode(cl.getChanCode());
            p.setDistance(sc.nextFloat() * 111.19f);
            p.setAzimuth(sc.nextFloat());
            String pn = sc.next();
            String clarity = pn.substring(0, 1);
            if (clarity.equals("I") || clarity.equals("E")) {
                p.setClarity(clarity);
                pn = pn.substring(1);
            }
            if ((sign = pn.substring(pn.length() - 1)).equals("C") || sign.equals("D") || sign.equals("U") || sign.equals("R")) {
                p.setWsign(sign);
                pn = pn.substring(0, pn.length() - 1);
            }
            p.setPhaseName(pn);
            p.setPhaseTime(sdf.parse(String.valueOf(sc.next()) + " " + sc.next()));
            p.setResi(sc.nextFloat());
            p.setWeight((int)sc.nextDouble());
            vecPhs.add(p);
            buf = sc.next();
        }
        sc.nextLine();
        sc.nextLine();
        sc.nextLine();
        while (sc.hasNext()) {
            p = new Phase();
            p.setPhaType(1);
            cl = ChannelLocator.parse((String)sc.next(), (String)"\\.");
            vecPhs = this.tbl.get(cl);
            if (vecPhs == null) {
                vecPhs = new Vector(32);
                this.tbl.put(cl, vecPhs);
            }
            p.setNetCode(cl.getNetCode());
            p.setStationCode(cl.getStationCode());
            p.setLocId(cl.getLocID());
            p.setChanCode(cl.getChanCode());
            p.setDistance(sc.nextFloat() * 111.19f);
            p.setAzimuth(sc.nextFloat());
            p.setPhaseName(sc.next());
            p.setPhaseTime(sdf.parse(String.valueOf(sc.next()) + " " + sc.next()));
            p.setMagVal(sc.nextFloat());
            p.setResi(sc.nextFloat());
            p.setWeight(1);
            p.setAmp(sc.nextDouble());
            p.setAmpType(0);
            p.setPeriod(sc.nextDouble());
            vecPhs.add(p);
        }
        sc.close();
    }

    public void writePha(File phaFile) throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(phaFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            for (Vector<Phase> vecPhs : this.tbl.values()) {
                oos.writeObject(vecPhs);
            }
            oos.writeObject(this.src);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        PhaseImporter im = new PhaseImporter();
        String phaseName = "/opt/workspace/MSDP/pha/YN.201010180549.0001.phase";
        im.readPhase(new File(phaseName));
        im.writePha(new File("/tmp/test.pha"));
    }
}

