/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.calibration;

import cn.org.gddsn.seis.calibration.PulseAmpPeriodFinder;
import cn.org.gddsn.seis.db.WFDataModule;
import cn.org.gddsn.seis.evtformat.DatabaseEvtData;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BatchMeasurePulse {
    static Logger logger = Logger.getLogger(BatchMeasurePulse.class);
    private DatabaseEvtData evt;
    private Hashtable<String, PeriodInfo> tbl = new Hashtable(64);
    private String outFile = "/tmp/pulse.txt";
    private String startTime;
    private int days = 30;
    private int length = 3600;
    private PrintWriter pw;

    public void init() throws IOException {
        logger.info((Object)"reading properties.");
        Properties props = new Properties();
        FileInputStream fin = new FileInputStream("PulsePerDay.properties");
        props.load(fin);
        fin.close();
        this.length = Integer.parseInt(props.getProperty("Pulse.length"));
        this.days = Integer.parseInt(props.getProperty("Pulse.days"));
        this.outFile = props.getProperty("Pulse.outFile");
        this.startTime = props.getProperty("Pulse.startTime");
        StringTokenizer st = new StringTokenizer(props.getProperty("Pulse.period"), "+");
        int count = st.countTokens();
        StringTokenizer st0 = null;
        int i = 0;
        while (i < count) {
            st0 = new StringTokenizer(st.nextToken(), " :");
            PeriodInfo pi = new PeriodInfo();
            pi.net = st0.nextToken();
            pi.sta = st0.nextToken();
            pi.minPeriod = Integer.parseInt(st0.nextToken());
            pi.avgPeriod = Integer.parseInt(st0.nextToken());
            this.tbl.put(String.valueOf(pi.net) + "/" + pi.sta, pi);
            ++i;
        }
    }

    public void goPerDay() throws Exception {
        this.pw = new PrintWriter(new FileWriter(this.outFile));
        WFDataModule wfdm = WFDataModule.getDataModule("RTS.properties");
        Connection conn = null;
        DatabaseEvtData ded = null;
        conn = wfdm.getConnectionPool().getConnection();
        ded = new DatabaseEvtData(conn, true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = sdf.parse(this.startTime);
        int i = 0;
        while (i < this.days) {
            Date beg = new Date(start.getTime() + (long)(i * 24 * 3600) * 1000L);
            Date end = new Date(beg.getTime() + (long)this.length * 1000L);
            logger.info((Object)("process " + beg));
            ded.setTimeSpan(beg, end);
            if (ded.readEvtFile("")) {
                logger.info((Object)"Open DB cut data OK!");
            }
            this.evt = ded;
            this.calcOneEvent();
            ++i;
        }
        conn.close();
        wfdm.shutDownDatabase();
        this.pw.close();
    }

    public void calcOneEvent() {
        int ch = 0;
        while (ch < this.evt.getTCN()) {
            String net = this.evt.getNetworkCode(ch);
            String sta = this.evt.getStationCode(ch);
            PeriodInfo pi = this.tbl.get(String.valueOf(net) + "/" + sta);
            if (pi != null) {
                this.calcOneChannel(ch, pi.minPeriod, pi.avgPeriod);
            }
            ++ch;
        }
    }

    public void calcOneStation(String net, String sta) {
        int[] chns = this.evt.getChanOrder(net, sta);
        PeriodInfo pi = this.tbl.get(String.valueOf(net) + "/" + sta);
        if (pi == null) {
            return;
        }
        int[] nArray = chns;
        int n = chns.length;
        int n2 = 0;
        while (n2 < n) {
            int chn = nArray[n2];
            this.calcOneChannel(chn, pi.minPeriod, pi.avgPeriod);
            ++n2;
        }
    }

    public void calcOneChannel(int chn, double minPeriod, double avgPeriod) {
        PulseAmpPeriodFinder papf = new PulseAmpPeriodFinder();
        double sr = this.evt.getSampleRate(chn);
        papf.setData(this.evt.getSampData(chn));
        papf.setFindMin(true);
        papf.setMinPeriod((int)(sr * minPeriod));
        papf.setAvgPeriod((int)(sr * avgPeriod));
        papf.find();
        papf.getAmp();
        papf.getIndexOfPulse();
        String nsl = this.evt.getChannelLocator(chn).toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date minAmp = new Date(this.evt.getArrivalTime(chn).getTime() + (long)((double)papf.getIndexOfPulse() / sr * 1000.0));
        Object[] o = new Object[]{nsl, (double)papf.getPeriod() / sr, papf.getAmp(), sdf.format(minAmp)};
        String str = String.format("%s  %6.2f  %8.0f  %s", o);
        logger.info((Object)("calculation result: " + str));
        this.pw.println(str);
        this.pw.flush();
    }

    public static void main(String[] args) throws Exception {
        BatchMeasurePulse bmp = new BatchMeasurePulse();
        bmp.init();
        bmp.goPerDay();
    }

    private static class PeriodInfo {
        public String net;
        public String sta;
        public String loc_id;
        public double minPeriod = 60.0;
        public double avgPeriod = 20.0;

        private PeriodInfo() {
        }
    }
}

