/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.StationManagerService;
import cn.org.gddsn.util.Log4jConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class KeyFiles2JOPENS {
    static Logger logger = Logger.getLogger(KeyFiles2JOPENS.class);
    private StationManagerService stationManagerService;
    private String keyPath;
    private Vector<String> applyStations = new Vector(128);
    private Vector<String> unapplyStations = new Vector(128);
    private Vector<String> notInDB = new Vector(128);
    private Vector<String> notInKey = new Vector(128);
    private Vector<String> errorStations = new Vector(128);

    public boolean updateStation(long staId, KeyFileStation kfs) {
        String kns;
        Station fsta = this.stationManagerService.findStationById(staId);
        String ns = String.valueOf(fsta.getBlockette050().getNetworkCode()) + "_" + fsta.getBlockette050().getStation();
        if (!ns.equals(kns = String.valueOf(kfs.net) + "_" + kfs.sta)) {
            return false;
        }
        logger.info((Object)String.format("%-9s: (%8.4f, %9.4f, %7.1f) -> (%8.4f, %9.4f, %7.1f)", ns, fsta.getBlockette050().getLatitude(), fsta.getBlockette050().getLongitude(), fsta.getBlockette050().getElevation(), kfs.lat, kfs.lon, kfs.alt));
        fsta.getBlockette050().setLatitude(kfs.lat);
        fsta.getBlockette050().setLongitude(kfs.lon);
        fsta.getBlockette050().setElevation(kfs.alt);
        this.stationManagerService.updateStation(fsta);
        return true;
    }

    public KeyFileStation parse(File kf) throws IOException {
        KeyFileStation kfs = new KeyFileStation();
        String ns = kf.getName().substring(8);
        int idx = ns.indexOf(95);
        if (idx != 1 && idx != 2) {
            throw new IllegalArgumentException(String.valueOf(ns) + " should be NN_SSSS");
        }
        kfs.net = ns.substring(0, idx);
        kfs.sta = ns.substring(idx + 1);
        Scanner sc = new Scanner(kf).useDelimiter("[='\n]+");
        while (sc.hasNext()) {
            String word = sc.next();
            if (word.equals("LATITUDE")) {
                kfs.lat = sc.nextDouble();
            }
            if (word.equals("LONGITUDE")) {
                kfs.lon = sc.nextDouble();
            }
            if (!word.equals("ELEVATION")) continue;
            kfs.alt = sc.nextDouble();
        }
        return kfs;
    }

    public void importKeyFiles() {
        File keyPathFile = new File(this.keyPath);
        List stns = this.stationManagerService.findAllStation();
        Object[] staFiles = keyPathFile.listFiles(new StationFilter());
        Arrays.sort(staFiles);
        Object[] objectArray = staFiles;
        int n = staFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            String ns = ((File)f).getName().substring(8);
            this.notInDB.add(ns);
            ++n2;
        }
        for (Station sta : stns) {
            String ns = String.valueOf(sta.getBlockette050().getNetworkCode()) + "_" + sta.getBlockette050().getStation();
            File kf = new File(this.keyPath, "station_" + ns);
            if (!kf.exists()) {
                this.notInKey.add(ns);
                this.notInDB.remove(ns);
                continue;
            }
            try {
                KeyFileStation kfs = this.parse(kf);
                boolean bret = this.updateStation(sta.getId(), kfs);
                if (bret) {
                    this.applyStations.add(ns);
                } else {
                    this.unapplyStations.add(ns);
                }
                this.notInDB.remove(ns);
            }
            catch (Exception ex) {
                logger.warn((Object)ex.getMessage());
                this.errorStations.add(ns);
                this.notInDB.remove(ns);
            }
        }
        Collections.sort(this.applyStations);
        Collections.sort(this.unapplyStations);
        Collections.sort(this.notInDB);
        Collections.sort(this.notInKey);
        Collections.sort(this.errorStations);
        this.printResult();
    }

    public void printResult() {
        logger.info((Object)("Apply stations:           " + this.applyStations));
        logger.info((Object)("UnaApply stations:        " + this.unapplyStations));
        logger.info((Object)("Error stations:           " + this.errorStations));
        logger.info((Object)("Not in DB stations:       " + this.notInDB));
        logger.info((Object)("Not in Key file stations: " + this.notInKey));
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain((String)"KeyFiles2JOPENS.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"KeyFiles2JOPENS.xml"});
        KeyFiles2JOPENS kf2j = (KeyFiles2JOPENS)ctx.getBean("kf2j");
        kf2j.importKeyFiles();
    }

    public void setStationManagerService(StationManagerService sms) {
        this.stationManagerService = sms;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    static class KeyFileStation {
        public String staDesc;
        public String net;
        public String sta;
        public double lat;
        public double lon;
        public double alt;
        public double gain1;
        public double srate1;
        public String dataLogger1;
        public String seismometer1;
        public boolean configured = false;

        KeyFileStation() {
        }
    }

    class StationFilter
    implements FilenameFilter {
        StationFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("station_");
        }
    }
}

