/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.seis.location.locsat.LocSAT;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class Locsat2NetCDF {
    static Logger logger = Logger.getLogger(Locsat2NetCDF.class);

    public void writeNetCDF(String prefix, String[] phs, int nphs, int maxtbd, int maxtbz, String ncFilename) throws Exception {
        int j;
        int j2;
        int[] ntbd = new int[nphs];
        int[] ntbz = new int[nphs];
        float[][] tbz = new float[nphs][maxtbz];
        float[][] tbd = new float[nphs][maxtbd];
        float[][][] tbtt = new float[nphs][maxtbz][maxtbd];
        int i = 0;
        while (i < ntbd.length) {
            ntbd[i] = -2;
            ++i;
        }
        i = 0;
        while (i < ntbz.length) {
            ntbz[i] = -2;
            ++i;
        }
        i = 0;
        while (i < nphs) {
            j2 = 0;
            while (j2 < maxtbz) {
                tbz[i][j2] = -2.0f;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < nphs) {
            j2 = 0;
            while (j2 < maxtbd) {
                tbd[i][j2] = -2.0f;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < nphs) {
            j2 = 0;
            while (j2 < maxtbz) {
                int k = 0;
                while (k < maxtbd) {
                    tbtt[i][j2][k] = -2.0f;
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        LocSAT.rdtttab(prefix, phs, nphs, maxtbd, maxtbz, ntbd, ntbz, tbd, tbz, tbtt);
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)ncFilename, (boolean)true);
        Dimension nphsDim = ncfile.addDimension("nphs", nphs);
        Dimension maxtbzDim = ncfile.addDimension("maxtbz", maxtbz);
        Dimension maxtbdDim = ncfile.addDimension("maxtbd", maxtbd);
        Dimension maxPhaseLengthDim = ncfile.addDimension("maxPhaseLength", 8);
        ncfile.addVariable("phase", DataType.CHAR, new Dimension[]{nphsDim, maxPhaseLengthDim});
        ncfile.addVariable("ntbz", DataType.INT, new Dimension[]{nphsDim});
        ncfile.addVariable("ntbd", DataType.INT, new Dimension[]{nphsDim});
        ncfile.addVariable("tbz", DataType.FLOAT, new Dimension[]{nphsDim, maxtbzDim});
        ncfile.addVariable("tbd", DataType.FLOAT, new Dimension[]{nphsDim, maxtbdDim});
        ncfile.addVariable("tbtt", DataType.FLOAT, new Dimension[]{nphsDim, maxtbzDim, maxtbdDim});
        ncfile.addVariableAttribute("tbz", "_FillValue", (Number)-2);
        ncfile.addVariableAttribute("tbz", "missing_value", (Number)-1);
        ncfile.addVariableAttribute("tbd", "_FillValue", (Number)-2);
        ncfile.addVariableAttribute("tbd", "missing_value", (Number)-1);
        ncfile.addVariableAttribute("tbtt", "_FillValue", (Number)-2);
        ncfile.addVariableAttribute("tbtt", "missing_value", (Number)-1);
        ncfile.create();
        Variable v = ncfile.findVariable("tbtt");
        int[] shape = v.getShape();
        Array atbtt = v.read(":,:,:");
        Index ima = atbtt.getIndex();
        int i2 = 0;
        while (i2 < shape[0]) {
            j = 0;
            while (j < shape[1]) {
                int k = 0;
                while (k < shape[2]) {
                    atbtt.setFloat(ima.set(i2, j, k), tbtt[i2][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        int[] origin = new int[3];
        ncfile.write("tbtt", origin, atbtt);
        v = ncfile.findVariable("phase");
        ArrayChar acPh = (ArrayChar)v.read();
        ima = acPh.getIndex();
        i2 = 0;
        while (i2 < nphs) {
            acPh.setString(i2, phs[i2]);
            ++i2;
        }
        ncfile.write("phase", (Array)acPh);
        v = ncfile.findVariable("ntbd");
        Array antbd = v.read();
        ima = antbd.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            antbd.setInt(ima.set(i2), ntbd[i2]);
            ++i2;
        }
        ncfile.write("ntbd", new int[1], antbd);
        v = ncfile.findVariable("ntbz");
        Array antbz = v.read();
        ima = antbz.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            antbz.setInt(ima.set(i2), ntbz[i2]);
            ++i2;
        }
        ncfile.write("ntbz", new int[1], antbz);
        v = ncfile.findVariable("tbd");
        Array atbd = v.read();
        ima = atbd.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            j = 0;
            while (j < shape[1]) {
                atbd.setFloat(ima.set(i2, j), tbd[i2][j]);
                ++j;
            }
            ++i2;
        }
        ncfile.write("tbd", new int[2], atbd);
        v = ncfile.findVariable("tbz");
        Array atbz = v.read();
        ima = atbz.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            j = 0;
            while (j < shape[1]) {
                atbz.setFloat(ima.set(i2, j), tbz[i2][j]);
                ++j;
            }
            ++i2;
        }
        ncfile.write("tbz", new int[2], atbz);
        ncfile.close();
    }

    public void writeNetCDF0(String ncFile) throws Exception {
        int j;
        int j2;
        String prefix = "/home/hwh/try/locsat/tables/iasp91";
        String[] phs = new String[]{"LQ", "LR", "Lg", "P", "PKP", "PP", "PcP", "Pg", "Pn", "Rg", "S", "SKS", "SS", "ScS", "Sn", "Sg", "pP", "sP", "Pb", "Sb"};
        int nphs = phs.length;
        boolean fill = true;
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.openExisting((String)ncFile, (boolean)fill);
        Variable v = ncfile.findVariable("tbtt");
        int[] shape = v.getShape();
        int[] ntbd = new int[nphs];
        int[] ntbz = new int[nphs];
        int maxtbz = shape[1];
        int maxtbd = shape[2];
        float[][] tbz = new float[nphs][maxtbz];
        float[][] tbd = new float[nphs][maxtbd];
        float[][][] tbtt = new float[nphs][maxtbz][maxtbd];
        int i = 0;
        while (i < ntbd.length) {
            ntbd[i] = -2;
            ++i;
        }
        i = 0;
        while (i < ntbz.length) {
            ntbz[i] = -2;
            ++i;
        }
        i = 0;
        while (i < nphs) {
            j2 = 0;
            while (j2 < maxtbz) {
                tbz[i][j2] = -2.0f;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < nphs) {
            j2 = 0;
            while (j2 < maxtbd) {
                tbd[i][j2] = -2.0f;
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < nphs) {
            j2 = 0;
            while (j2 < maxtbz) {
                int k = 0;
                while (k < maxtbd) {
                    tbtt[i][j2][k] = -2.0f;
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        LocSAT.rdtttab(prefix, phs, phs.length, maxtbd, maxtbz, ntbd, ntbz, tbd, tbz, tbtt);
        Array atbtt = v.read(":,:,:");
        Index ima = atbtt.getIndex();
        int i2 = 0;
        while (i2 < shape[0]) {
            j = 0;
            while (j < shape[1]) {
                int k = 0;
                while (k < shape[2]) {
                    atbtt.setFloat(ima.set(i2, j, k), tbtt[i2][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        int[] origin = new int[3];
        ncfile.write("tbtt", origin, atbtt);
        v = ncfile.findVariable("phase");
        ArrayChar acPh = (ArrayChar)v.read();
        ima = acPh.getIndex();
        i2 = 0;
        while (i2 < nphs) {
            acPh.setString(i2, phs[i2]);
            ++i2;
        }
        ncfile.write("phase", (Array)acPh);
        v = ncfile.findVariable("ntbd");
        Array antbd = v.read();
        ima = antbd.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            antbd.setInt(ima.set(i2), ntbd[i2]);
            ++i2;
        }
        ncfile.write("ntbd", new int[1], antbd);
        v = ncfile.findVariable("ntbz");
        Array antbz = v.read();
        ima = antbz.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            antbz.setInt(ima.set(i2), ntbz[i2]);
            ++i2;
        }
        ncfile.write("ntbz", new int[1], antbz);
        v = ncfile.findVariable("tbd");
        Array atbd = v.read();
        ima = atbd.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            j = 0;
            while (j < shape[1]) {
                atbd.setFloat(ima.set(i2, j), tbd[i2][j]);
                ++j;
            }
            ++i2;
        }
        ncfile.write("tbd", new int[2], atbd);
        v = ncfile.findVariable("tbz");
        Array atbz = v.read();
        ima = atbz.getIndex();
        shape = v.getShape();
        i2 = 0;
        while (i2 < shape[0]) {
            j = 0;
            while (j < shape[1]) {
                atbz.setFloat(ima.set(i2, j), tbz[i2][j]);
                ++j;
            }
            ++i2;
        }
        ncfile.write("tbz", new int[2], atbz);
        ncfile.close();
    }

    public void test() {
        String filename = "/home/samba/north_china_3d_ttt_200812.nc";
        NetcdfFile ncfile = null;
        try {
            ncfile = NetcdfFile.open((String)filename);
            String varName = "ttt";
            Variable v = ncfile.findVariable(varName);
            if (v == null) {
                return;
            }
            try {
                try {
                    Array data = v.read("0:2:1, 0:1:1, :, :, :");
                    NCdumpW.printArray((Array)data, (String)varName, (PrintWriter)new PrintWriter(System.out), null);
                    int[] nArray = new int[5];
                    nArray[0] = 2;
                    int[] origin = nArray;
                    int[] size = new int[]{1, 1, 1, 13, 46};
                    Array data3D = v.read(origin, size);
                    data3D.reduce();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("trying to read " + varName), (Throwable)ioe);
                }
                catch (InvalidRangeException e) {
                    logger.warn((Object)("invalid Range for " + varName), (Throwable)e);
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)("trying to open " + filename), (Throwable)ioe);
            }
        }
        finally {
            if (ncfile != null) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("trying to close " + filename), (Throwable)ioe);
                }
            }
        }
    }

    public void readTTT() {
        block22: {
            String filename = "/home/samba/iasp91.nc";
            NetcdfFile ncfile = null;
            try {
                try {
                    ncfile = NetcdfFile.open((String)filename);
                    int nphs = ncfile.findDimension("nphs").getLength();
                    int maxtbz = ncfile.findDimension("maxtbz").getLength();
                    int maxtbd = ncfile.findDimension("maxtbd").getLength();
                    String[] phase = new String[nphs];
                    Variable v_phase = ncfile.findVariable("phase");
                    ArrayChar a_phase = (ArrayChar)v_phase.read();
                    int i = 0;
                    while (i < nphs) {
                        phase[i] = a_phase.getString(i);
                        ++i;
                    }
                    int[] ntbz = new int[nphs];
                    Variable v_ntbz = ncfile.findVariable("ntbz");
                    Array a_ntbz = v_ntbz.read();
                    int i2 = 0;
                    while (i2 < nphs) {
                        ntbz[i2] = a_ntbz.getInt(i2);
                        ++i2;
                    }
                    int[] ntbd = new int[nphs];
                    Variable v_ntbd = ncfile.findVariable("ntbd");
                    Array a_ntbd = v_ntbd.read();
                    int i3 = 0;
                    while (i3 < nphs) {
                        ntbd[i3] = a_ntbd.getInt(i3);
                        ++i3;
                    }
                    float[][] tbz = new float[nphs][maxtbz];
                    Variable v_tbz = ncfile.findVariable("tbz");
                    Array a_tbz = v_tbz.read();
                    Index ima_tbz = a_tbz.getIndex();
                    int i4 = 0;
                    while (i4 < nphs) {
                        int j = 0;
                        while (j < maxtbz) {
                            tbz[i4][j] = a_tbz.getFloat(ima_tbz.set(i4, j));
                            ++j;
                        }
                        ++i4;
                    }
                    float[][] tbd = new float[nphs][maxtbd];
                    Variable v_tbd = ncfile.findVariable("tbd");
                    Array a_tbd = v_tbd.read();
                    Index ima_tbd = a_tbd.getIndex();
                    int i5 = 0;
                    while (i5 < nphs) {
                        int j = 0;
                        while (j < maxtbd) {
                            tbd[i5][j] = a_tbd.getFloat(ima_tbd.set(i5, j));
                            ++j;
                        }
                        ++i5;
                    }
                    float[][][] tbtt = new float[nphs][maxtbz][maxtbd];
                    Variable v_tbtt = ncfile.findVariable("tbtt");
                    Array a_tbtt = v_tbtt.read();
                    Index ima_tbtt = a_tbtt.getIndex();
                    int i6 = 0;
                    while (i6 < nphs) {
                        int j = 0;
                        while (j < maxtbz) {
                            int k = 0;
                            while (k < maxtbd) {
                                tbtt[i6][j][k] = a_tbtt.getFloat(ima_tbtt.set(i6, j, k));
                                ++k;
                            }
                            ++j;
                        }
                        ++i6;
                    }
                    System.out.println("finished reading iaspi91.nc");
                }
                catch (IOException ioe) {
                    logger.warn((Object)("trying to open " + filename), (Throwable)ioe);
                    if (ncfile == null) break block22;
                    try {
                        ncfile.close();
                    }
                    catch (IOException ioe2) {
                        logger.warn((Object)("trying to close " + filename), (Throwable)ioe2);
                    }
                }
            }
            finally {
                if (ncfile != null) {
                    try {
                        ncfile.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("trying to close " + filename), (Throwable)ioe);
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Locsat2NetCDF ttt3d = new Locsat2NetCDF();
        String prefix = "/tmp/dd20/sc/southChina";
        String[] phs = new String[]{"Pn", "Pg", "Pb", "PmP", "PbP", "Sn", "Sg", "Sb", "SmS", "SbS"};
        int nphs = 10;
        int maxtbd = 890;
        int maxtbz = 7;
        String ncFilename = "/tmp/southChina.nc";
        ttt3d.writeNetCDF(prefix, phs, nphs, maxtbd, maxtbz, ncFilename);
    }
}

