/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetCDF2Locsat {
    static Logger logger = Logger.getLogger(NetCDF2Locsat.class);
    static boolean gps = true;

    public static void convert(String netcdfFile, String locsatPath) {
        NetcdfFile ncfile = null;
        try {
            ncfile = NetcdfFile.open((String)netcdfFile);
            int nphs = ncfile.findDimension("nphs").getLength();
            int maxtbz = ncfile.findDimension("maxtbz").getLength();
            int maxtbd = ncfile.findDimension("maxtbd").getLength();
            String[] phase = new String[nphs];
            Variable v_phase = ncfile.findVariable("phase");
            ArrayChar a_phase = (ArrayChar)v_phase.read();
            int i = 0;
            while (i < nphs) {
                phase[i] = a_phase.getString(i);
                ++i;
            }
            int[] ntbz = new int[nphs];
            Variable v_ntbz = ncfile.findVariable("ntbz");
            Array a_ntbz = v_ntbz.read();
            int i2 = 0;
            while (i2 < nphs) {
                ntbz[i2] = a_ntbz.getInt(i2);
                ++i2;
            }
            int[] ntbd = new int[nphs];
            Variable v_ntbd = ncfile.findVariable("ntbd");
            Array a_ntbd = v_ntbd.read();
            int i3 = 0;
            while (i3 < nphs) {
                ntbd[i3] = a_ntbd.getInt(i3);
                ++i3;
            }
            float[][] tbz = new float[nphs][maxtbz];
            Variable v_tbz = ncfile.findVariable("tbz");
            Array a_tbz = v_tbz.read();
            Index ima_tbz = a_tbz.getIndex();
            int i4 = 0;
            while (i4 < nphs) {
                int j = 0;
                while (j < maxtbz) {
                    tbz[i4][j] = a_tbz.getFloat(ima_tbz.set(i4, j));
                    ++j;
                }
                ++i4;
            }
            float[][] tbd = new float[nphs][maxtbd];
            Variable v_tbd = ncfile.findVariable("tbd");
            Array a_tbd = v_tbd.read();
            Index ima_tbd = a_tbd.getIndex();
            int i5 = 0;
            while (i5 < nphs) {
                int j = 0;
                while (j < maxtbd) {
                    tbd[i5][j] = a_tbd.getFloat(ima_tbd.set(i5, j));
                    ++j;
                }
                ++i5;
            }
            float[][][] tbtt = new float[nphs][maxtbz][maxtbd];
            Variable v_tbtt = ncfile.findVariable("tbtt");
            Array a_tbtt = v_tbtt.read();
            Index ima_tbtt = a_tbtt.getIndex();
            int i6 = 0;
            while (i6 < nphs) {
                int j = 0;
                while (j < maxtbz) {
                    int k = 0;
                    while (k < maxtbd) {
                        tbtt[i6][j][k] = a_tbtt.getFloat(ima_tbtt.set(i6, j, k));
                        ++k;
                    }
                    ++j;
                }
                ++i6;
            }
            logger.info((Object)("Finished reading " + netcdfFile));
            String prefix = new File(netcdfFile).getName();
            int idx = prefix.lastIndexOf(46);
            if (idx != -1) {
                prefix = prefix.substring(0, idx);
            }
            int i7 = 0;
            while (i7 < nphs) {
                File locsatFile = new File(locsatPath, String.valueOf(prefix) + "." + phase[i7]);
                PrintWriter pw = new PrintWriter(new FileWriter(locsatFile));
                logger.info((Object)("Writing " + locsatFile));
                pw.printf("n # %s      travel-time tables for %s structure\n", phase[i7], prefix);
                pw.printf("%d     # number of depth samples\n", ntbz[i7]);
                int j = 0;
                while (j < ntbz[i7]) {
                    if (j > 0 && j % 10 == 0) {
                        pw.println();
                    }
                    pw.printf("%8.2f", Float.valueOf(tbz[i7][j]));
                    ++j;
                }
                pw.println();
                pw.printf("%d    # number of distance samples\n", ntbd[i7]);
                int k = 0;
                while (k < ntbd[i7]) {
                    if (k > 0 && k % 10 == 0) {
                        pw.println();
                    }
                    pw.printf("%8.2f", Float.valueOf(tbd[i7][k]));
                    ++k;
                }
                pw.println();
                j = 0;
                while (j < ntbz[i7]) {
                    pw.printf("# Travel-time/amplitude for z =%8.2f\n", Float.valueOf(tbz[i7][j]));
                    int k2 = 0;
                    while (k2 < ntbd[i7]) {
                        pw.printf("%12.4f\n", Float.valueOf(tbtt[i7][j][k2]));
                        ++k2;
                    }
                    ++j;
                }
                pw.close();
                ++i7;
            }
            if (!gps) {
                return;
            }
            try {
                int nphs2 = 2;
                String[] phase2 = new String[nphs2];
                phase2[0] = "P";
                phase2[1] = "S";
                int[] ntbz2 = new int[nphs2];
                int i8 = 0;
                while (i8 < nphs2) {
                    ntbz2[i8] = ntbz[0];
                    ++i8;
                }
                int[] ntbd2 = new int[nphs2];
                int i9 = 0;
                while (i9 < nphs2) {
                    ntbd2[i9] = ntbd[0];
                    ++i9;
                }
                float[][] tbz2 = new float[nphs2][maxtbz];
                int i10 = 0;
                while (i10 < nphs2) {
                    int j = 0;
                    while (j < maxtbz) {
                        tbz2[i10][j] = tbz[0][j];
                        ++j;
                    }
                    ++i10;
                }
                float[][] tbd2 = new float[nphs2][maxtbd];
                int i11 = 0;
                while (i11 < nphs2) {
                    int j = 0;
                    while (j < maxtbd) {
                        tbd2[i11][j] = tbd[0][j];
                        ++j;
                    }
                    ++i11;
                }
                float[][][] tbtt2 = new float[nphs2][maxtbz][maxtbd];
                int i12 = 0;
                while (i12 < nphs2) {
                    File locsatFile = new File(locsatPath, String.valueOf(prefix) + "." + phase2[i12]);
                    PrintWriter pw = new PrintWriter(new FileWriter(locsatFile));
                    logger.info((Object)("Writing " + locsatFile));
                    pw.printf("n # %s      travel-time tables for %s structure\n", phase2[i12], prefix);
                    pw.printf("%d     # number of depth samples\n", ntbz2[i12]);
                    int j = 0;
                    while (j < ntbz2[i12]) {
                        if (j > 0 && j % 10 == 0) {
                            pw.println();
                        }
                        pw.printf("%8.2f", Float.valueOf(tbz2[i12][j]));
                        ++j;
                    }
                    pw.println();
                    pw.printf("%d    # number of distance samples\n", ntbd2[i12]);
                    int k = 0;
                    while (k < ntbd2[i12]) {
                        if (k > 0 && k % 10 == 0) {
                            pw.println();
                        }
                        pw.printf("%8.2f", Float.valueOf(tbd2[i12][k]));
                        ++k;
                    }
                    pw.println();
                    j = 0;
                    while (j < ntbz2[i12]) {
                        pw.printf("# Travel-time/amplitude for z =%8.2f\n", Float.valueOf(tbz2[i12][j]));
                        int k3 = 0;
                        while (k3 < ntbd2[i12]) {
                            float min = 99999.0f;
                            String ph = phase2[i12];
                            int ii = 0;
                            while (ii < nphs) {
                                if (phase[ii].startsWith(phase2[i12]) && (double)tbtt[ii][j][k3] >= -0.1 && min > tbtt[ii][j][k3]) {
                                    min = tbtt[ii][j][k3];
                                    ph = phase[ii];
                                }
                                ++ii;
                            }
                            if (min > 99990.0f) {
                                min = -1.0f;
                            }
                            tbtt2[i12][j][k3] = min;
                            pw.printf("%12.4f %s\n", Float.valueOf(tbtt2[i12][j][k3]), ph);
                            ++k3;
                        }
                        ++j;
                    }
                    pw.close();
                    ++i12;
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)("Trying to open " + netcdfFile), (Throwable)ioe);
            }
        }
        finally {
            if (ncfile != null) {
                try {
                    ncfile.close();
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Trying to close " + netcdfFile), (Throwable)ioe);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        NetCDF2Locsat.convert("/tmp/dd20/southChina.nc", "/tmp/dd20/sc");
    }
}

