/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.convert;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.convert.PhaseForDB;
import cn.org.gddsn.seis.convert.ResFileForDB;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class ResDB2Pha {
    public static void convert(String dbFile, String outFile) {
        ResFileForDB res = new ResFileForDB();
        res.readResFile(dbFile);
        PhaseForDB[] ps = res.phaseForDB;
        Hashtable<String, Vector<Phase>> tbl = new Hashtable<String, Vector<Phase>>();
        int i = 0;
        while (i < ps.length) {
            Phase p = new Phase();
            p.setAmp(ps[i].Amp);
            p.setAmpType(ps[i].AmpType);
            p.setChanCode(new String(ps[i].CompName).trim());
            p.setLocId("00");
            p.setStationCode(new String(ps[i].StnName).trim());
            p.setNetCode("XX");
            p.setPhaseName(new String(ps[i].name).trim());
            p.setPeriod(ps[i].Prd);
            if (ps[i].phaType == 2) {
                p.setPhaType(0);
            } else {
                p.setPhaType(1);
            }
            GregorianCalendar c = new GregorianCalendar();
            int sec = (int)ps[i].sec;
            float f_sec = ps[i].sec - (float)sec;
            c.set(ps[i].year, ps[i].mon - 1, ps[i].day, ps[i].hour, ps[i].min, sec);
            long ms = c.getTime().getTime() + (long)((int)(f_sec * 1000.0f));
            p.setPhaseTime(new Date(ms));
            String key = String.valueOf(p.getNetCode()) + p.getStationCode() + p.getChanCode();
            Vector<Phase> v = (Vector<Phase>)tbl.get(key);
            if (v == null) {
                v = new Vector<Phase>();
                tbl.put(key, v);
            }
            v.add(p);
            ++i;
        }
        try {
            FileOutputStream fos = new FileOutputStream(outFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            for (Vector v1 : tbl.values()) {
                oos.writeObject(v1);
            }
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ResDB2Pha.convert(args[0], args[1]);
    }
}

