/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.db;

import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.seis.EventInfoUtils;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class JopensMigration {
    public static ApplicationContext ctx;
    private SeedVolumeService svs;

    public void deleteOldDataless() {
        this.svs.deleteDataless(1L);
    }

    public void migrateDataless(String netCode) {
        Dataless dl = this.svs.findDatalessById(1L);
        EventInfoUtils.resetDataless(dl);
        long id = this.svs.writeDataless(dl);
        NetworkInfo ni = this.svs.findNetworkInfo(netCode);
        if (ni == null) {
            ni = new NetworkInfo();
            ni.setId(netCode);
        }
        ni.setUniCode(id);
        this.svs.writeNetworkInfo(ni);
    }

    public SeedVolumeService getSvs() {
        return this.svs;
    }

    public void setSvs(SeedVolumeService svs) {
        this.svs = svs;
    }

    public static void main(String[] args) throws IOException {
        Log4jConfig.loadForMain((String)"JopensMigration.properties");
        if (args.length == 0) {
            System.out.println("Usage: java -jar JopensMigration.jar netCode");
            System.exit(-1);
        }
        ctx = new FileSystemXmlApplicationContext(new String[]{"jopens.xml"});
        SeedVolumeService svs = (SeedVolumeService)ctx.getBean("seedVolumeJPAService");
        JopensMigration jm = new JopensMigration();
        jm.setSvs(svs);
        jm.deleteOldDataless();
        System.out.println("Dataless migration success.");
    }
}

