/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.db.WFDataModule;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.util.Log4jConfig;
import com.nr.Complex;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseEvtData
extends EvtData {
    static Logger logger = Logger.getLogger(DatabaseEvtData.class);
    private Connection wfdbConn = null;
    private boolean bUniTime = false;
    private Date beg = null;
    private Date end = null;
    private boolean bUseTimeSpan = false;

    public DatabaseEvtData(Connection wfdbConn, boolean bUniTime) {
        this.evtFormat = 8;
        this.wfdbConn = wfdbConn;
        this.bUniTime = bUniTime;
    }

    public void setTimeSpan(Date beg, Date end) {
        this.beg = beg;
        this.end = end;
        this.bUseTimeSpan = true;
    }

    void cleanTimeSpan() {
        this.bUseTimeSpan = false;
        this.beg = null;
        this.end = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readEvtFile(String fileName) {
        Timestamp ts;
        String sqlStr;
        long uniSTms;
        long now_ms = new Date().getTime();
        String event_id = fileName;
        if (!event_id.equals("")) {
            this.cleanTimeSpan();
        }
        this.list.clear();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getDefault());
        Statement stmt = null;
        ResultSet rs = null;
        Iterator itr = null;
        RTOneChannelData ocd2 = null;
        try {
            String sqlStr2;
            stmt = this.wfdbConn.createStatement();
            if (this.bUseTimeSpan) {
                String start_time = sdf.format(this.beg);
                String end_time = sdf.format(this.end);
                sqlStr2 = "select waveform.net, waveform.sta, waveform.loc_id, waveform.chan, station.ordr, chanmap.ordr from waveform, station,chanmap where waveform.end_time >= '" + start_time + "' AND waveform.start_time <= '" + end_time + "' AND waveform.chan=chanmap.chan AND waveform.net=station.net AND waveform.sta=station.sta" + " group by waveform.net, waveform.sta, waveform.loc_id, waveform.chan" + " order by waveform.net, station.ordr, waveform.loc_id, chanmap.ordr";
                sqlStr2 = "select channel.net, channel.sta, channel.loc_id, channel.chan, station.ordr, chanmap.ordr from channel, station,chanmap where channel.chan=chanmap.chan AND channel.net=station.net AND channel.sta=station.sta group by channel.net, channel.sta, channel.loc_id, channel.chan order by channel.net, station.ordr, channel.loc_id, chanmap.ordr";
            } else {
                sqlStr2 = "select channel.net, channel.sta, channel.loc_id, channel.chan, station.ordr, chanmap.ordr from channel, station,chanmap where channel.chan=chanmap.chan AND channel.net=station.net AND channel.sta=station.sta group by channel.net, channel.sta, channel.loc_id, channel.chan order by channel.net, station.ordr, channel.loc_id, chanmap.ordr";
            }
            rs = stmt.executeQuery(sqlStr2);
            int nchan = 0;
            while (true) {
                if (!rs.next()) {
                    rs.close();
                    if (nchan == 0) {
                        logger.warn((Object)"None of Station/Channel infomation can be used!");
                        return false;
                    }
                    break;
                }
                ++nchan;
                RTOneChannelData oneChannel = new RTOneChannelData();
                this.list.add(oneChannel);
                oneChannel.setNetworkCode(rs.getString("net"));
                oneChannel.setStationCode(rs.getString("sta"));
                oneChannel.setAuxId(rs.getString("loc_id"));
                oneChannel.setChannelCode(rs.getString("chan"));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("PreProcess: " + oneChannel.getNetworkCode() + "/" + oneChannel.getStationCode() + "/" + oneChannel.getAuxId() + "/" + oneChannel.getChannelCode()));
            }
        }
        catch (SQLException sqlEx) {
            logger.warn((Object)"Error in how many channel: ");
            logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            return false;
        }
        this.setTimeSeries();
        long uniEDms = -1L;
        if (this.bUseTimeSpan) {
            uniSTms = this.beg.getTime();
            uniEDms = this.end.getTime();
        } else {
            try {
                sqlStr = "select start_time,end_time from eventinf where event_id='" + event_id + "'";
                rs = stmt.executeQuery(sqlStr);
                if (!rs.next()) {
                    logger.warn((Object)("Event ID is " + event_id + ". but Could not find EVENTINF"));
                    rs.close();
                    stmt.close();
                    return false;
                }
                ts = rs.getTimestamp("start_time");
                uniSTms = ts.getTime();
                ts = rs.getTimestamp("end_time");
                if (ts != null) {
                    uniEDms = ts.getTime();
                }
                rs.close();
            }
            catch (SQLException sqlEx) {
                logger.warn((Object)"Error in query eventinf: ");
                logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
                return false;
            }
        }
        try {
            for (RTOneChannelData ocd2 : this.list) {
                if (this.bUniTime) {
                    ocd2.setArrivalTime(new Date(uniSTms));
                    continue;
                }
                sqlStr = "select start_time, start_time_ns from waveform where event_id='" + event_id + "' AND net='" + ocd2.getNetworkCode() + "' AND sta='" + ocd2.getStationCode() + "' AND loc_id='" + ocd2.getAuxId() + "' AND chan='" + ocd2.getChannelCode() + "' ORDER BY start_time, start_time_ns LIMIT 1";
                rs = stmt.executeQuery(sqlStr);
                if (!rs.next()) {
                    logger.warn((Object)("Event ID is " + event_id + ". but" + " could not find start time for: " + ocd2.getNetworkCode() + "/" + ocd2.getStationCode() + "/" + ocd2.getAuxId() + "/" + ocd2.getChannelCode()));
                    rs.close();
                    stmt.close();
                    return false;
                }
                ts = rs.getTimestamp("start_time");
                int ns = rs.getInt("start_time_ns");
                long ms = ts.getTime() + (long)(ns / 1000000);
                ocd2.setArrivalTime(new Date(ms));
                rs.close();
            }
        }
        catch (SQLException sqlEx) {
            logger.warn((Object)"Error in query start_time of channel: ");
            logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            return false;
        }
        try {
            for (RTOneChannelData ocd2 : this.list) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Process Station Info: " + ocd2.getNetworkCode() + "/" + ocd2.getStationCode()));
                }
                String start_time = sdf.format(ocd2.getArrivalTime());
                String sqlStr3 = "select lat, lon, elev,coordsys, type, num_chan from station where net='" + ocd2.getNetworkCode() + "' AND sta='" + ocd2.getStationCode() + "' AND " + start_time + " > start_time AND ( end_time=0 OR " + start_time + "< end_time )";
                rs = stmt.executeQuery(sqlStr3);
                if (rs.next()) {
                    ocd2.setStationLocation(new Location(rs.getDouble("lat"), rs.getDouble("lon"), rs.getDouble("elev") / 1000.0));
                    ocd2.setChannelComp(rs.getInt("num_chan"));
                    ocd2.setStationType(rs.getString("type"));
                    ocd2.setCoordSys(rs.getString("coordsys"));
                    rs.close();
                    continue;
                }
                logger.warn((Object)("Event ID is " + event_id + ". but" + " could not find suitable station info for: " + ocd2.getNetworkCode() + "/" + ocd2.getStationCode()));
                rs.close();
            }
        }
        catch (SQLException sqlEx) {
            logger.warn((Object)"Error in query station: ");
            logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            return false;
        }
        try {
            Vector<Complex> poleVec = new Vector<Complex>();
            Vector<Complex> zeroVec = new Vector<Complex>();
            block17: for (RTOneChannelData ocd2 : this.list) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Process Channel Info: " + ocd2.getAuxId() + "/" + ocd2.getChannelCode()));
                }
                String start_time = sdf.format(ocd2.getArrivalTime());
                String sqlStr4 = "select data_type,serial,value1,value2 from channel where net='" + ocd2.getNetworkCode() + "' AND sta='" + ocd2.getStationCode() + "' AND loc_id='" + ocd2.getAuxId() + "' AND chan='" + ocd2.getChannelCode() + "' AND " + start_time + " > start_time AND ( end_time=0 OR " + start_time + "< end_time )" + " order by data_type, serial";
                rs = stmt.executeQuery(sqlStr4);
                int checkSum = 8;
                while (true) {
                    double im;
                    if (!rs.next()) {
                        Complex[] zero = new Complex[zeroVec.size()];
                        Complex[] pole = new Complex[poleVec.size()];
                        zeroVec.toArray(zero);
                        zeroVec.removeAllElements();
                        poleVec.toArray(pole);
                        poleVec.removeAllElements();
                        ocd2.setZero(zero);
                        ocd2.setPole(pole);
                        rs.close();
                        if (zero.length != 0 && pole.length != 0 && checkSum == 0) continue block17;
                        logger.warn((Object)("Event ID is " + event_id + ". but" + " could not find suitable channel info for: " + ocd2.getNetworkCode() + "/" + ocd2.getStationCode() + "/" + ocd2.getAuxId() + "/" + ocd2.getChannelCode()));
                        rs.close();
                        continue block17;
                    }
                    String data_type = rs.getString("data_type");
                    if (data_type.equals("caliper")) {
                        ocd2.setCalper(Double.parseDouble(rs.getString("value1")));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("caliFactor")) {
                        ocd2.setCalibFactor(Double.parseDouble(rs.getString("value1")));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("hAng")) {
                        ocd2.setHAng(Double.parseDouble(rs.getString("value1")));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("vAng")) {
                        ocd2.setVAng(Double.parseDouble(rs.getString("value1")));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("instrumentType")) {
                        ocd2.setInstrumentType(rs.getString("value1"));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("originalType")) {
                        String orgType = rs.getString("value1");
                        if (orgType.equals("V")) {
                            ocd2.setOriginalType(1);
                        } else if (orgType.equals("D")) {
                            ocd2.setOriginalType(0);
                        } else {
                            ocd2.setOriginalType(2);
                        }
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("sampleRate")) {
                        ocd2.setSampleRate(Double.parseDouble(rs.getString("value1")));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("ScaleFactor")) {
                        ocd2.setScaleFactor(Double.parseDouble(rs.getString("value1")));
                        --checkSum;
                        continue;
                    }
                    if (data_type.equals("pole")) {
                        double re = Double.parseDouble(rs.getString("value1"));
                        im = Double.parseDouble(rs.getString("value2"));
                        poleVec.add(new Complex(re, im));
                        continue;
                    }
                    if (!data_type.equals("zero")) continue;
                    double re = Double.parseDouble(rs.getString("value1"));
                    im = Double.parseDouble(rs.getString("value2"));
                    zeroVec.add(new Complex(re, im));
                }
            }
        }
        catch (SQLException sqlEx) {
            logger.warn((Object)"Error in query channel: ");
            logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            return false;
        }
        long n_now_ms = new Date().getTime();
        logger.info((Object)("Load station info elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        try {
            ChannelLocator cl;
            String sqlStr5;
            double[] dat = null;
            int nTotal = -1;
            if (this.bUseTimeSpan) {
                String start_time = sdf.format(new Date(uniSTms - 30000L));
                String end_time = sdf.format(new Date(uniEDms));
                sqlStr5 = "select * from waveform where start_time >= '" + start_time + "' AND start_time <= '" + end_time + "' order by net, sta, loc_id, chan, start_time, start_time_ns";
                rs = stmt.executeQuery(sqlStr5);
            } else {
                sqlStr5 = "select * from waveform where event_id='" + event_id + "' order by net, sta, loc_id, chan, start_time, start_time_ns";
                rs = stmt.executeQuery(sqlStr5);
            }
            GenericMiniSeedRecord gmsr = new GenericMiniSeedRecord(64, 512);
            boolean bgmsr4096 = false;
            byte[] buf = null;
            Vector<Element> bufVec = new Vector<Element>(512, 128);
            if (!rs.next()) {
                logger.warn((Object)("Event ID is " + event_id + " contain nothing!"));
                return false;
            }
            while (this.getTimeSeries(cl = new ChannelLocator(rs.getString("net"), rs.getString("sta"), rs.getString("loc_id"), rs.getString("chan"))) == null && rs.next()) {
            }
            ChannelLocator pre_cl = cl;
            logger.info((Object)cl);
            TimeSeries tSeries = this.getTimeSeries(cl);
            double srate = tSeries.getSampleRate();
            logger.info((Object)(cl + "\trate= " + srate));
            long start_ms = tSeries.getArrivalTime().getTime();
            if (this.bUseTimeSpan) {
                nTotal = (int)((double)(uniEDms - uniSTms) * srate / 1000.0);
                if (nTotal < 0) {
                    nTotal = -1;
                }
            } else {
                nTotal = -1;
            }
            if (this.bUniTime && uniEDms != -1L) {
                nTotal = (int)((double)(uniEDms - uniSTms) * srate / 1000.0);
            }
            do {
                cl = new ChannelLocator(rs.getString("net"), rs.getString("sta"), rs.getString("loc_id"), rs.getString("chan"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Process Wavform: " + cl));
                }
                if (this.getTimeSeries(cl) == null) continue;
                if (!cl.equals((Object)pre_cl)) {
                    dat = this.getSamples(event_id, pre_cl, start_ms, srate, nTotal, bufVec);
                    tSeries.setSampData(dat);
                    bufVec.removeAllElements();
                    pre_cl = cl;
                    tSeries = this.getTimeSeries(cl);
                    srate = tSeries.getSampleRate();
                    if (rs.getDouble("srate") != srate) {
                        logger.warn((Object)(cl + ": waveform sample rate(" + rs.getDouble("srate") + ") is not as same as sample rate in channel table(" + srate + ")."));
                    }
                    start_ms = tSeries.getArrivalTime().getTime();
                    if (this.bUseTimeSpan) {
                        nTotal = (int)((double)(uniEDms - uniSTms) * srate / 1000.0);
                        if (nTotal < 0) {
                            nTotal = -1;
                        }
                    } else {
                        nTotal = -1;
                    }
                    if (this.bUniTime && uniEDms != -1L && (nTotal = (int)((double)(uniEDms - uniSTms) * srate / 1000.0)) < 0) {
                        nTotal = -1;
                    }
                }
                Blob waveform = rs.getBlob("waveform");
                int len = (int)waveform.length();
                buf = waveform.getBytes(1L, len);
                if (buf.length != 4096 && buf.length != 512) {
                    logger.warn((Object)("Internal Error! buf.length =" + buf.length));
                }
                if (!bgmsr4096 && buf.length == 4096) {
                    bgmsr4096 = true;
                    gmsr = new GenericMiniSeedRecord(64, 4096);
                }
                gmsr.setEncodeBuffer(buf);
                long ms = rs.getTimestamp("start_time").getTime() / 1000L * 1000L + (long)(rs.getInt("start_time_ns") / 1000000);
                if (!gmsr.decompress()) {
                    logger.warn((Object)("Event ID is " + event_id + ", contain bad mini seed block, ignore this block: " + cl));
                    continue;
                }
                Element elmnt = new Element();
                elmnt.start_ms = ms;
                elmnt.intDat = gmsr.getUData();
                elmnt.end_ms = rs.getTimestamp("end_time").getTime() / 1000L * 1000L + (long)(rs.getInt("end_time_ns") / 1000000);
                bufVec.add(elmnt);
            } while (rs.next());
            dat = this.getSamples(event_id, pre_cl, start_ms, srate, nTotal, bufVec);
            tSeries.setSampData(dat);
            n_now_ms = new Date().getTime();
            logger.info((Object)("DECODE MiniSeed elapse time: " + (n_now_ms - now_ms) + " ms."));
            now_ms = n_now_ms;
            rs.close();
            stmt.close();
        }
        catch (SQLException sqlEx) {
            logger.warn((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            return false;
        }
        ListIterator li = this.list.listIterator();
        while (li.hasNext()) {
            TimeSeries TS = (TimeSeries)li.next();
            if (TS.getSampData() != null) continue;
            li.remove();
        }
        this.setTimeSeries();
        try {
            int i = 0;
            while (true) {
                if (i >= this.TSN) {
                    return true;
                }
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        return true;
    }

    @Override
    public boolean writeEvtFile(String fileName) {
        return false;
    }

    private double[] getSamples(String event_id, ChannelLocator cl, long start_ms, double srate, int nTotal, Vector<Element> vec) {
        int cnt = 0;
        Collections.sort(vec);
        if (nTotal == -1) {
            Element E = vec.lastElement();
            nTotal = (int)((double)(E.end_ms - start_ms) * srate / 1000.0);
        }
        if (nTotal < 0) {
            logger.error((Object)(cl + " has bad lucky! check database."));
        }
        double[] dat = new double[nTotal];
        long pre_end_ms = start_ms;
        Enumeration<Element> enu = vec.elements();
        while (enu.hasMoreElements()) {
            Element E = enu.nextElement();
            if (E.end_ms < pre_end_ms) continue;
            int firstIdx = 0;
            int endIdx = E.intDat.length;
            int ngaps = (int)((double)(E.start_ms - pre_end_ms) * srate / 1000.0);
            if (ngaps > 0) {
                logger.info((Object)("Event ID is " + event_id + ", contain gaps : " + cl + " at " + new Date(pre_end_ms) + ",length=" + (double)ngaps / srate + " seconds"));
                if ((cnt += ngaps) > dat.length) {
                    logger.info((Object)("Event ID is " + event_id + ", contain big gaps ignore blocks after gaps: " + cl));
                    return dat;
                }
            } else if (ngaps < 0) {
                firstIdx = -ngaps;
                endIdx = E.intDat.length;
            }
            if (cnt + E.intDat.length > dat.length) {
                firstIdx = 0;
                endIdx = dat.length - cnt;
            }
            int j = firstIdx;
            while (j < endIdx) {
                dat[cnt++] = E.intDat[j];
                ++j;
            }
            pre_end_ms = E.end_ms;
        }
        return dat;
    }

    public static void main(String[] args) throws Exception {
        Log4jConfig.loadForMain((String)"DatabaseEvtData.properties");
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: java databaseEvtData cata_id  or");
            System.out.println("Usage: java databaseEvtData start_time end_time");
            System.exit(-1);
        }
        WFDataModule wfdm = WFDataModule.getDataModule("RTS.properties");
        Connection conn = null;
        DatabaseEvtData ded = null;
        conn = wfdm.getConnectionPool().getConnection();
        ded = new DatabaseEvtData(conn, true);
        if (args.length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = args[0];
            String endTime = args[1];
            Date beg = sdf.parse(startTime);
            Date end = sdf.parse(endTime);
            ded.setTimeSpan(beg, end);
            if (ded.readEvtFile("")) {
                logger.info((Object)"Open DB cut data OK!");
            }
        } else if (args.length == 1 && ded.readEvtFile(args[0])) {
            logger.info((Object)"Open DB Event OK!");
        }
        conn.close();
        wfdm.shutDownDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Element
    implements Comparable<Element> {
        long start_ms;
        int[] intDat;
        long end_ms;

        Element() {
        }

        @Override
        public int compareTo(Element anotherElement) {
            long another_start_ms = anotherElement.start_ms;
            return this.start_ms < another_start_ms ? -1 : (this.start_ms == another_start_ms ? 0 : 1);
        }
    }
}

