/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.evtformat.TransferFun;
import com.nr.Complex;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class PZMgr {
    static Logger logger = Logger.getLogger(PZMgr.class);
    private String pzFn;
    private Properties pzProps = new Properties();

    public void load(String fname) {
        try {
            this.pzFn = fname;
            FileInputStream fis = new FileInputStream(this.pzFn);
            this.pzProps.load(fis);
            fis.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
    }

    public TransferFun getTransferFun(String sta) {
        String fname = this.pzProps.getProperty(sta);
        if (fname == null) {
            logger.warn((Object)(String.valueOf(this.pzFn) + " did not config P&Z info of station " + sta + "!"));
            return null;
        }
        TransferFun tf = new TransferFun();
        File pzFile = new File("cfg", fname);
        try {
            String ls = System.getProperty("line.separator");
            String d = "(#.*\n)+|\\p{javaWhitespace}+".replace("\n", ls);
            Scanner sc = new Scanner(pzFile).useDelimiter(d);
            tf.a0 = sc.nextDouble();
            tf.f0 = sc.nextDouble();
            tf.iNumZeros = sc.nextInt();
            tf.iNumPoles = sc.nextInt();
            tf.zeros = new Complex[tf.iNumZeros];
            tf.poles = new Complex[tf.iNumPoles];
            int i = 0;
            while (i < tf.iNumZeros) {
                tf.zeros[i] = new Complex(sc.nextDouble(), sc.nextDouble());
                ++i;
            }
            i = 0;
            while (i < tf.iNumPoles) {
                tf.poles[i] = new Complex(sc.nextDouble(), sc.nextDouble());
                ++i;
            }
            sc.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        logger.info((Object)("Load pole & zero info from: " + pzFile));
        return tf;
    }
}

