/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.config.StationProfile;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.RTStreamManager;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import cn.org.gddsn.seis.evtformat.UnsupportedEventFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class RTMiniSeedData
extends EvtData {
    static Logger logger = Logger.getLogger(RTMiniSeedData.class);

    public RTMiniSeedData() {
        this.evtFormat = 6;
    }

    public boolean readEvtFile(String fileName) {
        boolean ret = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            File file = new File(fileName);
            String parent = file.getParent();
            if (!parent.endsWith(File.separator)) {
                parent = String.valueOf(parent) + File.separator;
            }
            RTStreamManager rtStreamManager = new RTStreamManager();
            LinkedList<TimeSeries> aList = new LinkedList<TimeSeries>();
            String lineStr = reader.readLine();
            if (lineStr == null) {
                reader.close();
                return ret;
            }
            if (!lineStr.equals("FORMAT_RTMiniSeedData")) {
                reader.close();
                throw new UnsupportedEventFormat("RTEvtData waveform discription file format error");
            }
            lineStr = reader.readLine();
            if (lineStr == null) {
                reader.close();
                return ret;
            }
            FileInputStream fis = new FileInputStream(String.valueOf(parent) + lineStr);
            StationProfile profile = new StationProfile();
            profile.parseNetwork((InputStream)fis);
            fis.close();
            while ((lineStr = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(lineStr);
                ChannelLocator cl = new ChannelLocator();
                cl.setChannelLocator(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken());
                String fullName = String.valueOf(parent) + st.nextToken();
                RTOneChannelData rtOneChannelData = rtStreamManager.readTimeSeries(profile, cl, fullName);
                if (rtOneChannelData != null) {
                    aList.add(rtOneChannelData);
                    continue;
                }
                logger.warn((Object)(String.valueOf(fullName) + "Not Found!"));
            }
            if (aList.size() != 0) {
                this.setTimeSeries(aList);
                ret = true;
            }
            reader.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            return ret;
        }
        catch (NoSuchElementException noEx) {
            logger.warn((Object)noEx.getMessage(), (Throwable)noEx);
            return ret;
        }
        return ret;
    }

    private void duqi(List aList) {
        long ms;
        RTOneChannelData rs;
        long lms = Long.MIN_VALUE;
        ListIterator itr = aList.listIterator();
        while (itr.hasNext()) {
            rs = (RTOneChannelData)itr.next();
            ms = rs.getArrivalTime().getTime();
            if (lms >= ms) continue;
            lms = ms;
        }
        lms = lms / 1000L * 1000L + 1000L;
        itr = aList.listIterator();
        while (itr.hasNext()) {
            rs = (RTOneChannelData)itr.next();
            ms = rs.getArrivalTime().getTime();
            int nmove = (int)((double)(lms - ms) * rs.getSampleRate()) / 1000;
            double[] data = rs.getSampData();
            int len = data.length;
            double[] newdata = new double[len - nmove];
            System.arraycopy(data, nmove, newdata, 0, len - nmove);
            rs.setArrivalTime(new Date(lms));
            rs.setSampData(newdata);
        }
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    public boolean readEvtFile(URL urlFile) {
        return false;
    }

    public boolean writeEvtFile(URL urlFile) {
        return false;
    }

    public static void main(String[] args) {
        EvtData test = EvtData.readEvtData("C:/jbuilder5/projects/RTS/EVT/20011130234902.wfdisc");
    }
}

