/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat;

import cn.org.gddsn.seis.ChannelLocator;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTResponse;
import cn.org.gddsn.seis.evtformat.RTStationInfo;
import cn.org.gddsn.seis.evtformat.TimeSeries;
import com.nr.Complex;
import edu.iris.miniseedutils.steim.MiniSeedRecordDouble;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTOneChannelData
implements TimeSeries,
Cloneable,
Serializable {
    static Logger logger = Logger.getLogger(RTOneChannelData.class);
    static final long serialVersionUID = 5188272734733252642L;
    private int stationSeqNumber;
    private RTStationInfo rtSI = new RTStationInfo();
    private RTResponse rtRsp = new RTResponse();
    private Date arrivalTime = null;
    private double[] sampData = null;
    private Vector<Phase> phases = new Vector();
    private Vector<Phase> autoPhases = new Vector();
    private Vector<Phase> theoreticPhases = new Vector();

    public RTOneChannelData() {
    }

    @Override
    public int getStationSeqNumber() {
        return this.stationSeqNumber;
    }

    public void setStationSeqNumber(int stationSeqNumber) {
        this.stationSeqNumber = stationSeqNumber;
    }

    public RTOneChannelData(RTStationInfo rtSI, RTResponse rtRsp, Date arrivalTime, double[] SampData) {
        this.setData(rtSI, rtRsp, arrivalTime, SampData);
    }

    @Override
    public Vector<Phase> getPhases() {
        return this.phases;
    }

    @Override
    public void setPhases(Vector<Phase> phases) {
        this.phases = phases;
    }

    @Override
    public int compareTo(TimeSeries o) {
        RTOneChannelData wp = (RTOneChannelData)o;
        if (EvtData.WaveFormSortType == 2) {
            return this.getChannelLocator().compareTo(wp.getChannelLocator());
        }
        if (EvtData.WaveFormSortType == 3) {
            int r = this.getStationSeqNumber() - wp.getStationSeqNumber();
            if (r != 0) {
                return r;
            }
            return this.getChannelLocator().compareTo(wp.getChannelLocator());
        }
        if (EvtData.WaveFormSortType == 1) {
            Phase wp_phase;
            int rr = this.getStationCode().compareTo(wp.getStationCode());
            if (rr == 0) {
                return this.getChannelLocator().compareTo(wp.getChannelLocator());
            }
            Vector<Phase> the_vec_phase = new Vector<Phase>();
            int[] chns = EvtData.thisEvtData.getChanOrder(this.getNetworkCode(), this.getStationCode());
            int i = 0;
            while (i < chns.length) {
                the_vec_phase.addAll(EvtData.thisEvtData.getPhases(chns[i]));
                ++i;
            }
            Collections.sort(the_vec_phase);
            Vector<Phase> wp_vec_phase = new Vector<Phase>();
            int[] chns1 = EvtData.thisEvtData.getChanOrder(wp.getNetworkCode(), wp.getStationCode());
            int i2 = 0;
            while (i2 < chns1.length) {
                wp_vec_phase.addAll(EvtData.thisEvtData.getPhases(chns1[i2]));
                ++i2;
            }
            Collections.sort(wp_vec_phase);
            if (the_vec_phase.size() == 0 && wp_vec_phase.size() == 0) {
                return this.getChannelLocator().compareTo(wp.getChannelLocator());
            }
            if (the_vec_phase.size() != 0 && wp_vec_phase.size() == 0) {
                return -1;
            }
            if (the_vec_phase.size() == 0 && wp_vec_phase.size() != 0) {
                return 1;
            }
            Phase the_phase = (Phase)the_vec_phase.firstElement();
            int r = the_phase.compareTo(wp_phase = (Phase)wp_vec_phase.firstElement());
            if (r != 0) {
                return r;
            }
            return this.getChannelLocator().compareTo(wp.getChannelLocator());
        }
        if (EvtData.WaveFormSortType == 0) {
            if (EvtData.source != null) {
                double wp_dist;
                double the_dist = this.getStationLocation().getDelta();
                return the_dist < (wp_dist = wp.getStationLocation().getDelta()) ? -1 : (the_dist == wp_dist ? 0 : 1);
            }
            return this.getChannelLocator().compareTo(wp.getChannelLocator());
        }
        if (EvtData.WaveFormSortType == 4) {
            if (EvtData.source != null) {
                double wp_azi;
                double the_azi = this.getStationLocation().getAzimuth();
                return the_azi < (wp_azi = wp.getStationLocation().getAzimuth()) ? -1 : (the_azi == wp_azi ? 0 : 1);
            }
            return this.getChannelLocator().compareTo(wp.getChannelLocator());
        }
        if (EvtData.WaveFormSortType == 5) {
            if (EvtData.source != null) {
                double wp_res;
                double the_res = this.getStationLocation().getMaxResi();
                return the_res > (wp_res = wp.getStationLocation().getMaxResi()) ? -1 : (the_res == wp_res ? 0 : 1);
            }
            return this.getChannelLocator().compareTo(wp.getChannelLocator());
        }
        if (EvtData.WaveFormSortType == 6) {
            double wp_lat;
            double lat = this.getStationLocation().getLatitude();
            if (lat == (wp_lat = wp.getStationLocation().getLatitude())) {
                double lon = this.getStationLocation().getLongtitude();
                double wp_lon = wp.getStationLocation().getLongtitude();
                return (int)Math.signum(wp_lon - lon);
            }
            return (int)Math.signum(wp_lat - lat);
        }
        if (EvtData.WaveFormSortType == 7) {
            double wp_lon;
            double lon = this.getStationLocation().getLongtitude();
            if (lon == (wp_lon = wp.getStationLocation().getLongtitude())) {
                double lat = this.getStationLocation().getLatitude();
                double wp_lat = wp.getStationLocation().getLatitude();
                return (int)Math.signum(wp_lat - lat);
            }
            return (int)Math.signum(wp_lon - lon);
        }
        return 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public RTStationInfo getStationInfo() {
        return this.rtSI;
    }

    public RTResponse getResponseInfo() {
        return this.rtRsp;
    }

    public void setData(RTStationInfo rtSI, RTResponse rtRsp, Date arrivalTime, double[] sampData) {
        this.rtSI = rtSI;
        this.rtRsp = rtRsp;
        this.arrivalTime = arrivalTime;
        this.sampData = sampData;
    }

    @Override
    public Date getArrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public void setArrivalTime(Date newArrivalTime) {
        this.arrivalTime = newArrivalTime;
    }

    @Override
    public int getSamples() {
        return this.sampData == null ? -1 : this.sampData.length;
    }

    @Override
    public double[] getSampData() {
        return this.sampData;
    }

    @Override
    public void setSampData(double[] sampData) {
        this.sampData = sampData;
    }

    @Override
    public String getNetworkCode() {
        return this.rtSI.getNetworkCode();
    }

    @Override
    public String getStationCode() {
        return this.rtSI.getStationCode();
    }

    @Override
    public String getAuxId() {
        return this.rtSI.getAuxId();
    }

    @Override
    public String getStationType() {
        return this.rtSI.getStationType();
    }

    @Override
    public String getChannelCode() {
        return this.rtSI.getChannelCode();
    }

    @Override
    public ChannelLocator getChannelLocator() {
        return new ChannelLocator(this.rtSI.getNetworkCode(), this.rtSI.getStationCode(), this.rtSI.getAuxId(), this.rtSI.getChannelCode());
    }

    @Override
    public Location getStationLocation() {
        return this.rtSI.getStationLocation();
    }

    @Override
    public String getCoordSys() {
        return this.rtSI.getCoordSys();
    }

    @Override
    public String getInstrumentType() {
        return this.rtSI.getInstrumentType();
    }

    @Override
    public double getHAng() {
        return this.rtSI.getHAng();
    }

    @Override
    public double getVAng() {
        return this.rtSI.getVAng();
    }

    @Override
    public void setChannelComp(int newChannelComp) {
        this.rtSI.setChannelComp(newChannelComp);
    }

    @Override
    public int getChannelComp() {
        return this.rtSI.getChannelComp();
    }

    @Override
    public void setAuxId(String newAuxId) {
        this.rtSI.setAuxId(newAuxId);
    }

    @Override
    public void setChannelCode(String newChannelCode) {
        this.rtSI.setChannelCode(newChannelCode);
    }

    @Override
    public void setCoordSys(String newCoordSys) {
        this.rtSI.setCoordSys(newCoordSys);
    }

    @Override
    public void setHAng(double newHAng) {
        this.rtSI.setHAng(newHAng);
    }

    @Override
    public void setInstrumentType(String newInstrumentType) {
        this.rtSI.setInstrumentType(newInstrumentType);
    }

    @Override
    public void setNetworkCode(String newNetworkCode) {
        this.rtSI.setNetworkCode(newNetworkCode);
    }

    @Override
    public void setStationLocation(Location newStationlocation) {
        this.rtSI.setStationLocation(newStationlocation);
    }

    @Override
    public void setStationCode(String newStationCode) {
        this.rtSI.setStationCode(newStationCode);
    }

    @Override
    public void setStationType(String newStationType) {
        this.rtSI.setStationType(newStationType);
    }

    @Override
    public void setVAng(double newVAng) {
        this.rtSI.setVAng(newVAng);
    }

    @Override
    public void setSampleRate(double newSampleRate) {
        this.rtSI.setSampleRate(newSampleRate);
    }

    @Override
    public double getSampleRate() {
        return this.rtSI.getSampleRate();
    }

    @Override
    public double getCalibFactor() {
        return this.rtRsp.getCalibFactor();
    }

    @Override
    public void setCalibFactor(double newCalibFactor) {
        this.rtRsp.setCalibFactor(newCalibFactor);
    }

    @Override
    public void setCalper(double newCalper) {
        this.rtRsp.setCalper(newCalper);
    }

    @Override
    public double getCalper() {
        return this.rtRsp.getCalper();
    }

    @Override
    public void setScaleFactor(double newScaleFactor) {
        this.rtRsp.setScaleFactor(newScaleFactor);
    }

    @Override
    public double getScaleFactor() {
        return this.rtRsp.getScaleFactor();
    }

    @Override
    public void setZero(Complex[] newZero) {
        this.rtRsp.setZero(newZero);
    }

    @Override
    public Complex[] getZero() {
        return this.rtRsp.getZero();
    }

    @Override
    public void setPole(Complex[] newPole) {
        this.rtRsp.setPole(newPole);
    }

    @Override
    public Complex[] getPole() {
        return this.rtRsp.getPole();
    }

    @Override
    public int getZeroNum() {
        return this.rtRsp.getZeroNum();
    }

    @Override
    public int getPoleNum() {
        return this.rtRsp.getPoleNum();
    }

    @Override
    public void setOriginalType(int newOriginalType) {
        this.rtRsp.setOriginalType(newOriginalType);
    }

    @Override
    public int getOriginalType() {
        return this.rtRsp.getOriginalType();
    }

    @Override
    public Vector<Phase> getTheoreticPhases() {
        return this.theoreticPhases;
    }

    @Override
    public void setTheoreticPhases(Vector<Phase> theoreticPhase) {
        this.theoreticPhases = theoreticPhase;
    }

    @Override
    public Vector<Phase> getAutoPhases() {
        return this.autoPhases;
    }

    @Override
    public void setAutoPhases(Vector<Phase> autoPhases) {
        this.autoPhases = autoPhases;
    }

    @Override
    public double[] getTimeWindow(Date start, int len) {
        return null;
    }

    @Override
    public double[][] getTreeCompTimeWindow(Date start, int len) {
        return null;
    }

    @Override
    public boolean add(Date newArrival, MiniSeedRecordDouble mrd) {
        int i;
        int start;
        if (this.sampData == null) {
            return false;
        }
        if (!newArrival.equals(this.arrivalTime)) {
            start = (int)Math.round(((double)newArrival.getTime() / 1000.0 - (double)this.arrivalTime.getTime() / 1000.0) * this.getSampleRate());
            if (start >= 0 && start < this.sampData.length) {
                System.arraycopy(this.sampData, start, this.sampData, 0, this.sampData.length - start);
                i = this.sampData.length - start;
                while (i < this.sampData.length) {
                    this.sampData[i] = 0.0;
                    ++i;
                }
                this.arrivalTime = newArrival;
            } else if (start >= 0 && start >= this.sampData.length) {
                i = 0;
                while (i < this.sampData.length) {
                    this.sampData[i] = 0.0;
                    ++i;
                }
                this.arrivalTime = newArrival;
            } else {
                return false;
            }
        }
        if (mrd == null) {
            return true;
        }
        if (Math.abs(mrd.getSampleRate() - this.getSampleRate()) > 1.0E-4) {
            logger.warn((Object)("samprate is not same(" + this.getSampleRate() + "), Ignore packet: " + mrd));
            return false;
        }
        start = (int)Math.round((mrd.getStartTime() - (double)this.arrivalTime.getTime() / 1000.0) * this.getSampleRate());
        if (start >= 0 && start + mrd.getNumSamples() < this.sampData.length) {
            System.arraycopy(mrd.getData(), 0, this.sampData, start, mrd.getNumSamples());
            i = start + mrd.getNumSamples();
            while (i < this.sampData.length) {
                this.sampData[i] = 0.0;
                ++i;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByAzimuth
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            if (EvtData.source != null) {
                double wp_azi;
                double the_azi = o1.getStationLocation().getAzimuth();
                return the_azi < (wp_azi = o2.getStationLocation().getAzimuth()) ? -1 : (the_azi == wp_azi ? 0 : 1);
            }
            return o1.getChannelLocator().compareTo(o2.getChannelLocator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByDelta
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            if (EvtData.source != null) {
                double wp_dist;
                double the_dist = o1.getStationLocation().getDelta();
                return the_dist < (wp_dist = o2.getStationLocation().getDelta()) ? -1 : (the_dist == wp_dist ? 0 : 1);
            }
            return o1.getChannelLocator().compareTo(o2.getChannelLocator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByLatLon
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            double wp_lat;
            double lat = o1.getStationLocation().getLatitude();
            if (lat == (wp_lat = o2.getStationLocation().getLatitude())) {
                double lon = o1.getStationLocation().getLongtitude();
                double wp_lon = o2.getStationLocation().getLongtitude();
                return (int)Math.signum(wp_lon - lon);
            }
            return (int)Math.signum(wp_lat - lat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByLonLat
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            double wp_lon;
            double lon = o1.getStationLocation().getLongtitude();
            if (lon == (wp_lon = o2.getStationLocation().getLongtitude())) {
                double lat = o1.getStationLocation().getLatitude();
                double wp_lat = o2.getStationLocation().getLatitude();
                return (int)Math.signum(wp_lat - lat);
            }
            return (int)Math.signum(wp_lon - lon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByPArrival
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            Phase o2_phase;
            int rr = o1.getStationCode().compareTo(o2.getStationCode());
            if (rr == 0) {
                return o1.getChannelLocator().compareTo(o2.getChannelLocator());
            }
            Vector<Phase> the_vec_phase = new Vector<Phase>();
            int[] chns = EvtData.thisEvtData.getChanOrder(o1.getNetworkCode(), o1.getStationCode());
            int i = 0;
            while (i < chns.length) {
                the_vec_phase.addAll(EvtData.thisEvtData.getPhases(chns[i]));
                ++i;
            }
            Collections.sort(the_vec_phase);
            Vector<Phase> o2_vec_phase = new Vector<Phase>();
            int[] chns1 = EvtData.thisEvtData.getChanOrder(o2.getNetworkCode(), o2.getStationCode());
            int i2 = 0;
            while (i2 < chns1.length) {
                o2_vec_phase.addAll(EvtData.thisEvtData.getPhases(chns1[i2]));
                ++i2;
            }
            Collections.sort(o2_vec_phase);
            if (the_vec_phase.size() == 0 && o2_vec_phase.size() == 0) {
                return o1.getChannelLocator().compareTo(o2.getChannelLocator());
            }
            if (the_vec_phase.size() != 0 && o2_vec_phase.size() == 0) {
                return -1;
            }
            if (the_vec_phase.size() == 0 && o2_vec_phase.size() != 0) {
                return 1;
            }
            Phase the_phase = (Phase)the_vec_phase.firstElement();
            int r = the_phase.compareTo(o2_phase = (Phase)o2_vec_phase.firstElement());
            if (r != 0) {
                return r;
            }
            return o1.getChannelLocator().compareTo(o2.getChannelLocator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByRes
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            if (EvtData.source != null) {
                double wp_res;
                double the_res = o1.getStationLocation().getMaxResi();
                return the_res > (wp_res = o2.getStationLocation().getMaxResi()) ? -1 : (the_res == wp_res ? 0 : 1);
            }
            return o1.getChannelLocator().compareTo(o2.getChannelLocator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByStationName
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            return o1.getChannelLocator().compareTo(o2.getChannelLocator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SortByStationNum
    implements Comparator<RTOneChannelData> {
        @Override
        public int compare(RTOneChannelData o1, RTOneChannelData o2) {
            int r = o1.getStationSeqNumber() - o2.getStationSeqNumber();
            if (r != 0) {
                return r;
            }
            return o1.getChannelLocator().compareTo(o2.getChannelLocator());
        }
    }
}

