/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.edas;

import cn.org.gddsn.seis.evtformat.edas.GeoDevEvtData;
import cn.org.gddsn.seis.evtformat.edas.JZipEvtHead;
import cn.org.gddsn.seis.evtformat.edas.JZipOneStnEvtData;
import cn.org.gddsn.seis.evtformat.edas.Response;
import cn.org.gddsn.seis.evtformat.edas.StationInfo;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class JZipEvent
extends GeoDevEvtData {
    static Logger logger = Logger.getLogger(JZipEvent.class);

    public JZipEvent() {
        this.evtFormat = 2;
    }

    public boolean readEvtFile(String fileName) {
        try {
            ZipFile zf = new ZipFile(fileName);
            ZipEntry head = zf.getEntry("head");
            ObjectInputStream ois = new ObjectInputStream(zf.getInputStream(head));
            JZipEvtHead evtHead = (JZipEvtHead)ois.readObject();
            this.TSN = evtHead.TSN;
            this.TCN = evtHead.TCN;
            this.TRL = evtHead.TRL;
            this.aEventDate = new Date[this.TSN];
            this.aTRL = new int[this.TSN];
            this.SI = new StationInfo[this.TSN];
            this.Rspns = new Response[this.TCN];
            this.Flag = new int[this.TSN][];
            this.WDat = new double[this.TCN][];
            int i = 0;
            while (i < this.TSN) {
                ZipEntry stnEntry = zf.getEntry("" + i);
                ois = new ObjectInputStream(zf.getInputStream(stnEntry));
                JZipOneStnEvtData stnData = (JZipOneStnEvtData)ois.readObject();
                this.aEventDate[i] = stnData.EventDate;
                this.aTRL[i] = stnData.TRL;
                this.SI[i] = stnData.SI;
                int k = 0;
                while (k < stnData.SI.stn_par.comp) {
                    this.Rspns[this.getCN((int)i) + k] = stnData.Rspns[k];
                    ++k;
                }
                this.Flag[i] = stnData.Flag;
                int j = 0;
                while (j < stnData.SI.stn_par.comp) {
                    this.WDat[this.getCN((int)i) + j] = stnData.WDat[j];
                    ++j;
                }
                ++i;
            }
            ois.close();
            zf.close();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            logger.warn((Object)("Trouble writing " + fileName));
            return false;
        }
        this.convertToTimeSeries();
        return true;
    }

    public boolean writeEvtFile(String fileName) {
        try {
            FileOutputStream Out = new FileOutputStream(fileName);
            BufferedOutputStream BufferedOut = new BufferedOutputStream(Out, 4096);
            ZipOutputStream zipOut = new ZipOutputStream(BufferedOut);
            zipOut.setLevel(1);
            ZipEntry head = new ZipEntry("head");
            zipOut.putNextEntry(head);
            JZipEvtHead evtHead = new JZipEvtHead();
            evtHead.TSN = this.TSN;
            evtHead.TCN = this.TCN;
            evtHead.TRL = this.TRL;
            ObjectOutputStream oos = new ObjectOutputStream(zipOut);
            oos.writeObject(evtHead);
            oos.flush();
            zipOut.closeEntry();
            int i = 0;
            while (i < evtHead.TSN) {
                ZipEntry stnEntry = new ZipEntry("" + i);
                zipOut.putNextEntry(stnEntry);
                JZipOneStnEvtData stnData = new JZipOneStnEvtData();
                stnData.EventDate = this.aEventDate[i];
                stnData.TRL = this.aTRL[i];
                stnData.SI = this.SI[i];
                stnData.Rspns = new Response[stnData.SI.stn_par.comp];
                int k = 0;
                while (k < stnData.SI.stn_par.comp) {
                    stnData.Rspns[k] = this.Rspns[this.getCN(i) + k];
                    ++k;
                }
                stnData.Flag = this.Flag[i];
                stnData.WDat = new double[stnData.SI.stn_par.comp][];
                int j = 0;
                while (j < stnData.SI.stn_par.comp) {
                    stnData.WDat[j] = this.WDat[this.getCN(i) + j];
                    ++j;
                }
                oos = new ObjectOutputStream(zipOut);
                oos.writeObject(stnData);
                oos.flush();
                zipOut.closeEntry();
                stnData = null;
                ++i;
            }
            zipOut.close();
            BufferedOut.close();
            Out.close();
        }
        catch (ZipException zEx) {
            logger.warn((Object)zEx.getMessage(), (Throwable)zEx);
            return false;
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        JZipEvent jzipEvent = new JZipEvent();
        jzipEvent.readEvtFile("D:\\public\\EvtFormat\\JZIPEvent.EVT");
    }
}

