/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.gse;

import cn.org.gddsn.seis.evtformat.gse.ChannelMsg;
import cn.org.gddsn.seis.evtformat.gse.GSEDataMessage;
import cn.org.gddsn.seis.evtformat.gse.GSEFormatException;
import cn.org.gddsn.seis.evtformat.gse.GSELogMsg;
import cn.org.gddsn.seis.evtformat.gse.GSEWaveFormMsg;
import cn.org.gddsn.seis.evtformat.gse.ResponseMsg;
import cn.org.gddsn.seis.evtformat.gse.StationMsg;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class GSEManager {
    public static final int GSE_MESSAGE_REQUEST_TYPE = 0;
    public static final int GSE_MESSAGE_SUBSCRIPTION_TYPE = 1;
    public static final int GSE_MESSAGE_DATA_TYPE = 2;
    private String version = "GSE2.1";
    private String headLine;
    private LinkedList list;
    private BufferedReader reader = null;

    public int getGSEDataMsgType(String oneLine) {
        StringTokenizer st = new StringTokenizer(oneLine);
        int retVal = -1;
        if (st.nextToken().toUpperCase().startsWith("DATA_TYPE")) {
            String strType = st.nextToken();
            if (strType.toUpperCase().startsWith("LOG")) {
                retVal = 0;
            } else if (strType.toUpperCase().startsWith("ERROR_LOG")) {
                retVal = 1;
            } else if (strType.toUpperCase().startsWith("FTP_LOG")) {
                retVal = 2;
            } else if (strType.toUpperCase().startsWith("WAVEFORM")) {
                retVal = 3;
            } else if (strType.toUpperCase().startsWith("NETWORK")) {
                retVal = 4;
            } else if (strType.toUpperCase().startsWith("STATION")) {
                retVal = 5;
            } else if (strType.toUpperCase().startsWith("BEAM")) {
                retVal = 7;
            } else if (strType.toUpperCase().startsWith("RESPONSE")) {
                retVal = 8;
            } else if (strType.toUpperCase().startsWith("OUTAGE")) {
                retVal = 9;
            } else if (strType.toUpperCase().startsWith("ORIGIN")) {
                retVal = 11;
            } else if (strType.toUpperCase().startsWith("EVENT")) {
                retVal = 11;
            }
        } else {
            throw new GSEFormatException("GSEFormat Error");
        }
        return retVal;
    }

    public void readGSE(String fileName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
    }

    boolean isStop(String oneLine) {
        return oneLine.toUpperCase().startsWith("STOP");
    }

    public void parseDataMessage(BufferedReader reader) throws IOException {
    }

    public void openGSEFile(BufferedReader newReader) throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = newReader;
    }

    public GSEDataMessage getNextDataMsg() throws IOException {
        GSEDataMessage gseDataMessage = null;
        if (this.isStop(this.headLine)) {
            return null;
        }
        int type = this.getGSEDataMsgType(this.headLine);
        switch (type) {
            case 0: {
                gseDataMessage = new GSELogMsg();
                break;
            }
            case 6: {
                gseDataMessage = new ChannelMsg();
                break;
            }
            case 5: {
                gseDataMessage = new StationMsg();
                break;
            }
            case 3: {
                gseDataMessage = new GSEWaveFormMsg();
                break;
            }
            case 8: {
                gseDataMessage = new ResponseMsg();
                break;
            }
            default: {
                throw new GSEFormatException("unexpect GSE Format error");
            }
        }
        gseDataMessage.deCod(this.headLine, this.reader);
        return gseDataMessage;
    }

    public void parseRequestMessage(BufferedReader reader) throws IOException {
    }

    public void parseSubscriptionMessage(BufferedReader reader) throws IOException {
    }
}

