/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.gse;

import cn.org.gddsn.seis.evtformat.gse.CAL2;
import cn.org.gddsn.seis.evtformat.gse.GSEDataMessage;
import cn.org.gddsn.seis.evtformat.gse.PAZ2;
import cn.org.gddsn.seis.evtformat.gse.ResponseBlk;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

final class ResponseMsg
extends GSEDataMessage {
    HashMap map = new HashMap();

    public ResponseMsg() {
        this.dataType = "RESPONSE";
    }

    public void deCod(String aheadLine, BufferedReader reader) throws IOException {
        super.deCod(aheadLine, reader);
        this.headLine = aheadLine;
        while (!this.isDataMessageHead(this.headLine)) {
            if (this.headLine.startsWith(" (")) continue;
            ResponseBlk rspBlk = new ResponseBlk();
            if (this.headLine.startsWith("CAL2")) {
                rspBlk.cal2 = new CAL2();
                rspBlk.cal2.deCod(this.headLine, reader);
                this.headLine = rspBlk.cal2.getNextTypeHeadLine();
            }
            if (this.headLine.startsWith("PAZ2")) {
                rspBlk.paz2 = new PAZ2();
                rspBlk.paz2.deCod(aheadLine, reader);
                this.headLine = rspBlk.paz2.getNextTypeHeadLine();
                int i = 1;
                int npz = (Integer)rspBlk.paz2.getFieldValue(6) + (Integer)rspBlk.paz2.getFieldValue(7);
                rspBlk.real = new double[npz];
                rspBlk.im = new double[npz];
                do {
                    StringTokenizer st = new StringTokenizer(this.headLine);
                    rspBlk.real[i - 1] = Double.parseDouble(st.nextToken());
                    rspBlk.im[i - 1] = Double.parseDouble(st.nextToken());
                } while (i++ == npz);
            }
            String key = String.valueOf((String)rspBlk.cal2.getFieldValue(1)) + (String)rspBlk.cal2.getFieldValue(2);
            this.map.put(key, rspBlk);
        }
    }

    public void enCod(BufferedWriter writer) throws IOException {
        super.enCod(writer);
        ResponseBlk[] rspBlk = (ResponseBlk[])this.map.values().toArray();
        int i = 0;
        while (i < rspBlk.length) {
            rspBlk[i].cal2.enCod(writer);
            if (rspBlk[i].paz2 != null) {
                rspBlk[i].paz2.enCod(writer);
                int j = 0;
                while (i < rspBlk[i].real.length) {
                    writer.write(" " + rspBlk[i].real[j] + " " + rspBlk[i].im[j]);
                    writer.newLine();
                    ++j;
                }
            }
            ++i;
        }
    }
}

