/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.reftek;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.PZMgr;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.TransferFun;
import cn.org.gddsn.seis.evtformat.reftek.RefData;
import com.nr.Complex;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class RefEvent
extends EvtData {
    static Logger logger = Logger.getLogger(RefEvent.class);
    private static final long serialVersionUID = 1L;
    private static final String[] compCode = new String[]{"SHZ", "SHN", "SHE"};
    private boolean uniTime = false;
    private static HashMap<String, String> sta_info_tab = new HashMap();

    public RefEvent() {
        this.evtFormat = 10;
    }

    public RefEvent(EvtData evt) {
        super(evt);
        this.evtFormat = 10;
    }

    public boolean readEvtFile(String filePath) {
        long now_ms = new Date().getTime();
        PZMgr pzMgr = new PZMgr();
        pzMgr.load("cfg/pz.cfg");
        this.list.clear();
        long uniSTms = -1L;
        FileDemo fd = new FileDemo(filePath);
        String[] file = fd.fileName.toString().split("\n");
        String sfile = "./cfg/reftek_sta_info.tab";
        if (!this.readStationInfo(sfile)) {
            logger.warn((Object)("Please check the input file: " + sfile));
            return false;
        }
        int chn = 0;
        String[] stringArray = file;
        int n = file.length;
        int n2 = 0;
        while (n2 < n) {
            block30: {
                String fid = stringArray[n2];
                RefData ref = new RefData();
                RTOneChannelData[] rtd = new RTOneChannelData[3];
                int i = 0;
                while (i < 3) {
                    rtd[i] = new RTOneChannelData();
                    ++i;
                }
                try {
                    logger.info((Object)("readding " + fid));
                    DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(fid)));
                    ref.readRefTek(din);
                    din.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                    break block30;
                }
                i = 0;
                while (i < rtd.length) {
                    String st;
                    this.list.add(rtd[i]);
                    String[] sta_inf = new String[6];
                    rtd[i].setStationSeqNumber(chn++);
                    rtd[i].setStationCode(ref.stationName);
                    rtd[i].setAuxId("00");
                    rtd[i].setChannelCode(compCode[i]);
                    rtd[i].setStationType("3C");
                    if (i == 0) {
                        st = sta_info_tab.get(String.valueOf(ref.stationName.toUpperCase()) + "Z");
                        if (st == null) {
                            logger.error((Object)("Missing the station " + ref.stationName + "'s Z component information!"));
                            rtd[i].setNetworkCode("XX");
                            rtd[i].setChannelCode("SHZ");
                            rtd[i].setCalibFactor(1.0);
                        } else {
                            sta_inf = st.split("\\s+");
                            rtd[i].setNetworkCode(sta_inf[0]);
                            rtd[i].setChannelCode(sta_inf[2]);
                            rtd[i].setCalibFactor(Double.valueOf(sta_inf[3]) / (Double.valueOf(ref.chGain.substring(0, 1)) * Double.valueOf(ref.lsb.substring(0, 6))));
                        }
                    } else if (i == 1) {
                        st = sta_info_tab.get(String.valueOf(ref.stationName.toUpperCase()) + "N");
                        if (st == null) {
                            logger.error((Object)("Missing the station " + ref.stationName + "'s N component information!"));
                            rtd[i].setNetworkCode("XX");
                            rtd[i].setChannelCode("SHN");
                            rtd[i].setCalibFactor(1.0);
                        } else {
                            sta_inf = st.split("\\s+");
                            rtd[i].setNetworkCode(sta_inf[0]);
                            rtd[i].setChannelCode(sta_inf[2]);
                            rtd[i].setCalibFactor(Double.valueOf(sta_inf[3]) / (Double.valueOf(ref.chGain.substring(1, 2)) * Double.valueOf(ref.lsb.substring(8, 14))));
                        }
                    } else if (i == 2) {
                        st = sta_info_tab.get(String.valueOf(ref.stationName.toUpperCase()) + "E");
                        if (st == null) {
                            logger.error((Object)("Missing the station " + ref.stationName + "'s E component information!"));
                            rtd[i].setNetworkCode("XX");
                            rtd[i].setChannelCode("SHE");
                            rtd[i].setCalibFactor(1.0);
                        } else {
                            sta_inf = st.split("\\s+");
                            rtd[i].setNetworkCode(sta_inf[0]);
                            rtd[i].setChannelCode(sta_inf[2]);
                            rtd[i].setCalibFactor(Double.valueOf(sta_inf[3]) / (Double.valueOf(ref.chGain.substring(2)) * Double.valueOf(ref.lsb.substring(16, 22))));
                        }
                    }
                    if (this.uniTime) {
                        rtd[i].setArrivalTime(new Date(uniSTms));
                    } else {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                        cal.set(1, ref.tyear);
                        cal.set(6, ref.tday);
                        cal.set(11, ref.thour);
                        cal.set(12, ref.tmin);
                        cal.set(13, ref.tsec);
                        cal.set(14, ref.tmsec);
                        rtd[i].setArrivalTime(new Date(cal.getTime().getTime()));
                    }
                    rtd[i].setStationLocation(new Location(ref.lat.floatValue(), ref.lon.floatValue(), ref.alt.floatValue() / 1000.0f));
                    rtd[i].setCoordSys("");
                    if (i == 0) {
                        rtd[i].setHAng(0.0);
                        rtd[i].setVAng(0.0);
                    } else if (i == 1) {
                        rtd[i].setHAng(0.0);
                        rtd[i].setVAng(90.0);
                    } else {
                        rtd[i].setHAng(90.0);
                        rtd[i].setVAng(90.0);
                    }
                    rtd[i].setInstrumentType("");
                    rtd[i].setOriginalType(1);
                    rtd[i].setSampleRate(ref.sampleRate);
                    TransferFun tf = pzMgr.getTransferFun(rtd[i].getStationCode());
                    if (tf != null) {
                        rtd[i].setScaleFactor(tf.a0);
                        rtd[i].setCalper(tf.f0);
                        rtd[i].setZero(tf.zeros);
                        rtd[i].setPole(tf.poles);
                    } else {
                        rtd[i].setScaleFactor(1.0);
                        rtd[i].setCalper(1.0);
                        rtd[i].setZero(new Complex[0]);
                        rtd[i].setPole(new Complex[0]);
                    }
                    ++i;
                }
                rtd[0].setSampData(ref.data0);
                rtd[1].setSampData(ref.data1);
                rtd[2].setSampData(ref.data2);
            }
            ++n2;
        }
        long n_now_ms = new Date().getTime();
        logger.info((Object)("DECODE MiniSeed elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        if (this.list.size() == 0) {
            logger.warn((Object)"No channel info found!");
            return false;
        }
        this.setTimeSeries();
        try {
            int i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        EvtData.WaveFormSortType = 2;
        this.sort();
        return true;
    }

    private boolean readStationInfo(String sfile) {
        sta_info_tab.clear();
        String ss = null;
        String nw = null;
        String nst = null;
        String cst = null;
        try {
            Scanner sc = new Scanner(new File(sfile));
            while (sc.hasNextLine()) {
                ss = sc.nextLine();
                if (ss.startsWith("#")) {
                    int i = ss.indexOf("#");
                    nw = ss.substring(i + 1);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    nst = st.nextToken();
                    cst = st.nextToken();
                }
                if (cst.endsWith("Z")) {
                    sta_info_tab.put(String.valueOf(nst.toUpperCase()) + "Z", String.valueOf(nw) + " " + ss);
                    continue;
                }
                if (cst.endsWith("N")) {
                    sta_info_tab.put(String.valueOf(nst.toUpperCase()) + "N", String.valueOf(nw) + " " + ss);
                    continue;
                }
                if (!cst.endsWith("E")) continue;
                sta_info_tab.put(String.valueOf(nst.toUpperCase()) + "E", String.valueOf(nw) + " " + ss);
            }
            sc.close();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return sta_info_tab.size() != 0;
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    public static void main(String[] args) {
        RefEvent re = new RefEvent();
        String filePath = "./TestData/reftek/050108000_00000000.00000000";
        re.readEvtFile(filePath);
        System.out.println(re.getTRL(1));
    }

    class FileDemo {
        StringBuffer fileName = new StringBuffer();

        public FileDemo(String path) {
            File fp = new File(path);
            if (fp.isDirectory()) {
                this.listFile(path);
            } else if (fp.isFile()) {
                this.fileName.append(path);
            }
        }

        void listFile(String path) {
            File file = new File(path);
            if (file.isFile()) {
                String s = file.getAbsolutePath();
                if (s.contains(String.valueOf(File.separator) + "1" + File.separator)) {
                    this.fileName.append(s);
                    this.fileName.append("\n");
                }
            } else {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.listFile(files[i].getPath());
                    ++i;
                }
            }
        }
    }
}

