/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.sac;

import JSci.maths.ArrayMath;
import cn.org.gddsn.convert.CStringToJava;
import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.io.LittleEndianOutputStream;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SAC {
    public static final float F_UNUSED = -12345.0f;
    public static final int I_UNUSED = -12345;
    public static final String K_UNUSED = "-12345";
    public static final int ITIME = 1;
    public static final int IRLIM = 2;
    public static final int IAMPH = 3;
    public static final int IXY = 4;
    public static final int IUNKN = 5;
    public static final int IDISP = 6;
    public static final int IVEL = 7;
    public static final int IACC = 8;
    public static final int IB = 9;
    public static final int IDAY = 10;
    public static final int IO = 11;
    public static final int IA = 12;
    public static final int IT0 = 13;
    public static final int IT1 = 14;
    public static final int IT2 = 15;
    public static final int IT3 = 16;
    public static final int IT4 = 17;
    public static final int IT5 = 18;
    public static final int IT6 = 19;
    public static final int IT7 = 20;
    public static final int IT8 = 21;
    public static final int IT9 = 22;
    public static final int IRADNV = 23;
    public static final int ITANNV = 24;
    public static final int IRADEV = 25;
    public static final int ITANEV = 26;
    public static final int INORTH = 27;
    public static final int IEAST = 28;
    public static final int IHORZA = 29;
    public static final int IDOWN = 30;
    public static final int IUP = 31;
    public static final int ILLLBB = 32;
    public static final int IWWSN1 = 33;
    public static final int IWWSN2 = 34;
    public static final int IHGLP = 35;
    public static final int ISRO = 36;
    public static final int INUCL = 37;
    public static final int IPREN = 38;
    public static final int IPOSTN = 39;
    public static final int IQUAKE = 40;
    public static final int IPREQ = 41;
    public static final int IPOSTQ = 42;
    public static final int ICHEM = 43;
    public static final int IOTHER = 44;
    public static final int IGOOD = 45;
    public static final int IGLCH = 46;
    public static final int IDROP = 47;
    public static final int ILOWSN = 48;
    public static final int IRLDTA = 49;
    public static final int IVOLTS = 50;
    public static final int IXYZ = 51;
    public static final int IMB = 52;
    public static final int IMS = 53;
    public static final int IML = 54;
    public static final int IMW = 55;
    public static final int IMD = 56;
    public static final int IMX = 57;
    public static final int INEIC = 58;
    public static final int IPDE = 59;
    public static final int IISC = 60;
    public static final int IREB = 61;
    public static final int IUSGS = 62;
    public static final int IBRK = 63;
    public static final int ICALTECH = 64;
    public static final int ILLNL = 65;
    public static final int IEVLOC = 66;
    public static final int IJSOP = 67;
    public static final int IUSER = 68;
    public static final int IUNKNOWN = 69;
    public static final int IQB = 70;
    public static final int IQB1 = 71;
    public static final int IQB2 = 72;
    public static final int IQBX = 73;
    public static final int IQMT = 74;
    public static final int IEQ = 75;
    public static final int IEQ1 = 76;
    public static final int IEQ2 = 77;
    public static final int IME = 78;
    public static final int IEX = 79;
    public static final int INU = 80;
    public static final int INC = 81;
    public static final int IO_ = 82;
    public static final int IL = 83;
    public static final int IR = 84;
    public static final int IT = 85;
    public static final int IU = 86;
    public float DELTA = -12345.0f;
    public float DEPMIN = -12345.0f;
    public float DEPMAX = -12345.0f;
    public float SCALE = -12345.0f;
    public float ODELTA = -12345.0f;
    public float B = -12345.0f;
    public float E = -12345.0f;
    public float O = -12345.0f;
    public float A = -12345.0f;
    public float INTERNAL0 = -12345.0f;
    public float T0 = -12345.0f;
    public float T1 = -12345.0f;
    public float T2 = -12345.0f;
    public float T3 = -12345.0f;
    public float T4 = -12345.0f;
    public float T5 = -12345.0f;
    public float T6 = -12345.0f;
    public float T7 = -12345.0f;
    public float T8 = -12345.0f;
    public float T9 = -12345.0f;
    public float F = -12345.0f;
    public float RESP0 = -12345.0f;
    public float RESP1 = -12345.0f;
    public float RESP2 = -12345.0f;
    public float RESP3 = -12345.0f;
    public float RESP4 = -12345.0f;
    public float RESP5 = -12345.0f;
    public float RESP6 = -12345.0f;
    public float RESP7 = -12345.0f;
    public float RESP8 = -12345.0f;
    public float RESP9 = -12345.0f;
    public float STLA = -12345.0f;
    public float STLO = -12345.0f;
    public float STEL = -12345.0f;
    public float STDP = -12345.0f;
    public float EVLA = -12345.0f;
    public float EVLO = -12345.0f;
    public float EVEL = -12345.0f;
    public float EVDP = -12345.0f;
    public float MAG = -12345.0f;
    public float USER0 = -12345.0f;
    public float USER1 = -12345.0f;
    public float USER2 = -12345.0f;
    public float USER3 = -12345.0f;
    public float USER4 = -12345.0f;
    public float USER5 = -12345.0f;
    public float USER6 = -12345.0f;
    public float USER7 = -12345.0f;
    public float USER8 = -12345.0f;
    public float USER9 = -12345.0f;
    public float DIST = -12345.0f;
    public float AZ = -12345.0f;
    public float BAZ = -12345.0f;
    public float GCARC = -12345.0f;
    public float INTERNAL1 = -12345.0f;
    public float INTERNAL2 = -12345.0f;
    public float DEPMEN = -12345.0f;
    public float CMPAZ = -12345.0f;
    public float CMPINC = -12345.0f;
    public float XMINIMUM = -12345.0f;
    public float XMAXIMUM = -12345.0f;
    public float YMINIMUM = -12345.0f;
    public float YMAXIMUM = -12345.0f;
    public float ADJTM = -12345.0f;
    public float UNUSED0 = -12345.0f;
    public float UNUSED1 = -12345.0f;
    public float UNUSED2 = -12345.0f;
    public float UNUSED3 = -12345.0f;
    public float UNUSED4 = -12345.0f;
    public float UNUSED5 = -12345.0f;
    public float UNUSED6 = -12345.0f;
    public int NZYEAR = -12345;
    public int NZJDAY = -12345;
    public int NZHOUR = -12345;
    public int NZMIN = -12345;
    public int NZSEC = -12345;
    public int NZMSEC = -12345;
    public int NVHDR = 6;
    public int NORID = -12345;
    public int NEVID = -12345;
    public int NPTS = -12345;
    public int INTERNAL3 = -12345;
    public int NWFID = -12345;
    public int NXSIZE = -12345;
    public int NYSIZE = -12345;
    public int UNUSED7 = -12345;
    public int IFTYPE = -12345;
    public int IDEP = -12345;
    public int IZTYPE = -12345;
    public int UNUSED8 = -12345;
    public int IINST = -12345;
    public int ISTREG = -12345;
    public int IEVREG = -12345;
    public int IEVTYP = -12345;
    public int IQUAL = -12345;
    public int ISYNTH = -12345;
    public int IMAGTYP = -12345;
    public int IMAGSRC = -12345;
    public int UNUSED9 = -12345;
    public int UNUSED10 = -12345;
    public int UNUSED11 = -12345;
    public int UNUSED12 = -12345;
    public int UNUSED13 = -12345;
    public int UNUSED14 = -12345;
    public int UNUSED15 = -12345;
    public int UNUSED16 = -12345;
    public int LEVEN = -12345;
    public int LPSPOL = -12345;
    public int LOVROK = -12345;
    public int LCALDA = -12345;
    public int UNUSED17 = -12345;
    public String KSTNM = "-12345";
    public String KEVNM = "-12345";
    public String KHOLE = "-12345";
    public String KO = "-12345";
    public String KA = "-12345";
    public String KT0 = "-12345";
    public String KT1 = "-12345";
    public String KT2 = "-12345";
    public String KT3 = "-12345";
    public String KT4 = "-12345";
    public String KT5 = "-12345";
    public String KT6 = "-12345";
    public String KT7 = "-12345";
    public String KT8 = "-12345";
    public String KT9 = "-12345";
    public String KF = "-12345";
    public String KUSER0 = "-12345";
    public String KUSER1 = "-12345";
    public String KUSER2 = "-12345";
    public String KCMPNM = "-12345";
    public String KNETWK = "-12345";
    public String KDATRD = "-12345";
    public String KINST = "-12345";
    public float[] data1;
    public float[] data2;

    public static void sachdr(SAC hd, float dt, int ns, float b0) {
        hd.NPTS = ns;
        hd.DELTA = dt;
        hd.B = b0;
        hd.O = 0.0f;
        hd.E = b0 + (float)(ns - 1) * hd.DELTA;
        hd.IZTYPE = 11;
        hd.IFTYPE = 1;
        hd.LEVEN = 1;
    }

    public void readBinarySAC(File fn) throws IOException {
        int sacType = SAC.isIntelSAC(fn);
        Object in = null;
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fn), 8192);
        if (sacType == 0) {
            in = new LittleEndianInputStream((InputStream)fis);
        } else if (sacType == 1) {
            in = new DataInputStream(fis);
        } else {
            throw new IOException("Could NOT read unknown SAC file");
        }
        this.DELTA = in.readFloat();
        this.DEPMIN = in.readFloat();
        this.DEPMAX = in.readFloat();
        this.SCALE = in.readFloat();
        this.ODELTA = in.readFloat();
        this.B = in.readFloat();
        this.E = in.readFloat();
        this.O = in.readFloat();
        this.A = in.readFloat();
        this.INTERNAL0 = in.readFloat();
        this.T0 = in.readFloat();
        this.T1 = in.readFloat();
        this.T2 = in.readFloat();
        this.T3 = in.readFloat();
        this.T4 = in.readFloat();
        this.T5 = in.readFloat();
        this.T6 = in.readFloat();
        this.T7 = in.readFloat();
        this.T8 = in.readFloat();
        this.T9 = in.readFloat();
        this.F = in.readFloat();
        this.RESP0 = in.readFloat();
        this.RESP1 = in.readFloat();
        this.RESP2 = in.readFloat();
        this.RESP3 = in.readFloat();
        this.RESP4 = in.readFloat();
        this.RESP5 = in.readFloat();
        this.RESP6 = in.readFloat();
        this.RESP7 = in.readFloat();
        this.RESP8 = in.readFloat();
        this.RESP9 = in.readFloat();
        this.STLA = in.readFloat();
        this.STLO = in.readFloat();
        this.STEL = in.readFloat();
        this.STDP = in.readFloat();
        this.EVLA = in.readFloat();
        this.EVLO = in.readFloat();
        this.EVEL = in.readFloat();
        this.EVDP = in.readFloat();
        this.MAG = in.readFloat();
        this.USER0 = in.readFloat();
        this.USER1 = in.readFloat();
        this.USER2 = in.readFloat();
        this.USER3 = in.readFloat();
        this.USER4 = in.readFloat();
        this.USER5 = in.readFloat();
        this.USER6 = in.readFloat();
        this.USER7 = in.readFloat();
        this.USER8 = in.readFloat();
        this.USER9 = in.readFloat();
        this.DIST = in.readFloat();
        this.AZ = in.readFloat();
        this.BAZ = in.readFloat();
        this.GCARC = in.readFloat();
        this.INTERNAL1 = in.readFloat();
        this.INTERNAL2 = in.readFloat();
        this.DEPMEN = in.readFloat();
        this.CMPAZ = in.readFloat();
        this.CMPINC = in.readFloat();
        this.XMINIMUM = in.readFloat();
        this.XMAXIMUM = in.readFloat();
        this.YMINIMUM = in.readFloat();
        this.YMAXIMUM = in.readFloat();
        this.UNUSED0 = in.readFloat();
        this.UNUSED1 = in.readFloat();
        this.UNUSED2 = in.readFloat();
        this.UNUSED3 = in.readFloat();
        this.UNUSED4 = in.readFloat();
        this.UNUSED5 = in.readFloat();
        this.UNUSED6 = in.readFloat();
        this.NZYEAR = in.readInt();
        this.NZJDAY = in.readInt();
        this.NZHOUR = in.readInt();
        this.NZMIN = in.readInt();
        this.NZSEC = in.readInt();
        this.NZMSEC = in.readInt();
        this.NVHDR = in.readInt();
        this.NORID = in.readInt();
        this.NEVID = in.readInt();
        this.NPTS = in.readInt();
        this.INTERNAL3 = in.readInt();
        this.NWFID = in.readInt();
        this.NXSIZE = in.readInt();
        this.NYSIZE = in.readInt();
        this.UNUSED7 = in.readInt();
        this.IFTYPE = in.readInt();
        this.IDEP = in.readInt();
        this.IZTYPE = in.readInt();
        this.UNUSED8 = in.readInt();
        this.IINST = in.readInt();
        this.ISTREG = in.readInt();
        this.IEVREG = in.readInt();
        this.IEVTYP = in.readInt();
        this.IQUAL = in.readInt();
        this.ISYNTH = in.readInt();
        this.IMAGTYP = in.readInt();
        this.IMAGSRC = in.readInt();
        this.UNUSED8 = in.readInt();
        this.UNUSED10 = in.readInt();
        this.UNUSED11 = in.readInt();
        this.UNUSED12 = in.readInt();
        this.UNUSED13 = in.readInt();
        this.UNUSED14 = in.readInt();
        this.UNUSED15 = in.readInt();
        this.UNUSED16 = in.readInt();
        this.LEVEN = in.readInt();
        this.LPSPOL = in.readInt();
        this.LOVROK = in.readInt();
        this.LCALDA = in.readInt();
        this.UNUSED17 = in.readInt();
        byte[] buf = new byte[16];
        this.KSTNM = SAC.readString((DataInput)in, buf, 8);
        this.KEVNM = SAC.readString((DataInput)in, buf, 16);
        this.KHOLE = SAC.readString((DataInput)in, buf, 8);
        this.KO = SAC.readString((DataInput)in, buf, 8);
        this.KA = SAC.readString((DataInput)in, buf, 8);
        this.KT0 = SAC.readString((DataInput)in, buf, 8);
        this.KT1 = SAC.readString((DataInput)in, buf, 8);
        this.KT2 = SAC.readString((DataInput)in, buf, 8);
        this.KT3 = SAC.readString((DataInput)in, buf, 8);
        this.KT4 = SAC.readString((DataInput)in, buf, 8);
        this.KT5 = SAC.readString((DataInput)in, buf, 8);
        this.KT6 = SAC.readString((DataInput)in, buf, 8);
        this.KT7 = SAC.readString((DataInput)in, buf, 8);
        this.KT8 = SAC.readString((DataInput)in, buf, 8);
        this.KT9 = SAC.readString((DataInput)in, buf, 8);
        this.KF = SAC.readString((DataInput)in, buf, 8);
        this.KUSER0 = SAC.readString((DataInput)in, buf, 8);
        this.KUSER1 = SAC.readString((DataInput)in, buf, 8);
        this.KUSER2 = SAC.readString((DataInput)in, buf, 8);
        this.KCMPNM = SAC.readString((DataInput)in, buf, 8);
        this.KNETWK = SAC.readString((DataInput)in, buf, 8);
        this.KDATRD = SAC.readString((DataInput)in, buf, 8);
        this.KINST = SAC.readString((DataInput)in, buf, 8);
        this.data1 = new float[this.NPTS];
        int i = 0;
        while (i < this.NPTS) {
            this.data1[i] = in.readFloat();
            ++i;
        }
        if (this.IFTYPE != 1) {
            this.data2 = new float[this.NPTS];
            i = 0;
            while (i < this.NPTS) {
                this.data2[i] = in.readFloat();
                ++i;
            }
        }
        if (this.KCMPNM.length() == 1) {
            this.KCMPNM = "BH" + this.KCMPNM.toUpperCase();
        }
        ((InputStream)fis).close();
    }

    private static String readString(DataInput in, byte[] buf, int len) throws IOException {
        in.readFully(buf, 0, len);
        CStringToJava.tailToZero((byte[])buf, (int)len);
        return new String(buf).trim();
    }

    public static void writeBinarySAC(File fn, SAC sac) throws IOException {
        Object out = null;
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fn), 8192);
        out = ByteOrder.nativeOrder().toString().equals(ByteOrder.LITTLE_ENDIAN.toString()) ? new LittleEndianOutputStream((OutputStream)fos) : new DataOutputStream(fos);
        out.writeFloat(sac.DELTA);
        out.writeFloat(sac.DEPMIN);
        out.writeFloat(sac.DEPMAX);
        out.writeFloat(sac.SCALE);
        out.writeFloat(sac.ODELTA);
        out.writeFloat(sac.B);
        out.writeFloat(sac.E);
        out.writeFloat(sac.O);
        out.writeFloat(sac.A);
        out.writeFloat(sac.INTERNAL0);
        out.writeFloat(sac.T0);
        out.writeFloat(sac.T1);
        out.writeFloat(sac.T2);
        out.writeFloat(sac.T3);
        out.writeFloat(sac.T4);
        out.writeFloat(sac.T5);
        out.writeFloat(sac.T6);
        out.writeFloat(sac.T7);
        out.writeFloat(sac.T8);
        out.writeFloat(sac.T9);
        out.writeFloat(sac.F);
        out.writeFloat(sac.RESP0);
        out.writeFloat(sac.RESP1);
        out.writeFloat(sac.RESP2);
        out.writeFloat(sac.RESP3);
        out.writeFloat(sac.RESP4);
        out.writeFloat(sac.RESP5);
        out.writeFloat(sac.RESP6);
        out.writeFloat(sac.RESP7);
        out.writeFloat(sac.RESP8);
        out.writeFloat(sac.RESP9);
        out.writeFloat(sac.STLA);
        out.writeFloat(sac.STLO);
        out.writeFloat(sac.STEL);
        out.writeFloat(sac.STDP);
        out.writeFloat(sac.EVLA);
        out.writeFloat(sac.EVLO);
        out.writeFloat(sac.EVEL);
        out.writeFloat(sac.EVDP);
        out.writeFloat(sac.MAG);
        out.writeFloat(sac.USER0);
        out.writeFloat(sac.USER1);
        out.writeFloat(sac.USER2);
        out.writeFloat(sac.USER3);
        out.writeFloat(sac.USER4);
        out.writeFloat(sac.USER5);
        out.writeFloat(sac.USER6);
        out.writeFloat(sac.USER7);
        out.writeFloat(sac.USER8);
        out.writeFloat(sac.USER9);
        out.writeFloat(sac.DIST);
        out.writeFloat(sac.AZ);
        out.writeFloat(sac.BAZ);
        out.writeFloat(sac.GCARC);
        out.writeFloat(sac.INTERNAL1);
        out.writeFloat(sac.INTERNAL2);
        out.writeFloat(sac.DEPMEN);
        out.writeFloat(sac.CMPAZ);
        out.writeFloat(sac.CMPINC);
        out.writeFloat(sac.XMINIMUM);
        out.writeFloat(sac.XMAXIMUM);
        out.writeFloat(sac.YMINIMUM);
        out.writeFloat(sac.YMAXIMUM);
        out.writeFloat(sac.UNUSED0);
        out.writeFloat(sac.UNUSED1);
        out.writeFloat(sac.UNUSED2);
        out.writeFloat(sac.UNUSED3);
        out.writeFloat(sac.UNUSED4);
        out.writeFloat(sac.UNUSED5);
        out.writeFloat(sac.UNUSED6);
        out.writeInt(sac.NZYEAR);
        out.writeInt(sac.NZJDAY);
        out.writeInt(sac.NZHOUR);
        out.writeInt(sac.NZMIN);
        out.writeInt(sac.NZSEC);
        out.writeInt(sac.NZMSEC);
        out.writeInt(sac.NVHDR);
        out.writeInt(sac.NORID);
        out.writeInt(sac.NEVID);
        out.writeInt(sac.NPTS);
        out.writeInt(sac.INTERNAL3);
        out.writeInt(sac.NWFID);
        out.writeInt(sac.NXSIZE);
        out.writeInt(sac.NYSIZE);
        out.writeInt(sac.UNUSED7);
        out.writeInt(sac.IFTYPE);
        out.writeInt(sac.IDEP);
        out.writeInt(sac.IZTYPE);
        out.writeInt(sac.UNUSED8);
        out.writeInt(sac.IINST);
        out.writeInt(sac.ISTREG);
        out.writeInt(sac.IEVREG);
        out.writeInt(sac.IEVTYP);
        out.writeInt(sac.IQUAL);
        out.writeInt(sac.ISYNTH);
        out.writeInt(sac.IMAGTYP);
        out.writeInt(sac.IMAGSRC);
        out.writeInt(sac.UNUSED8);
        out.writeInt(sac.UNUSED10);
        out.writeInt(sac.UNUSED11);
        out.writeInt(sac.UNUSED12);
        out.writeInt(sac.UNUSED13);
        out.writeInt(sac.UNUSED14);
        out.writeInt(sac.UNUSED15);
        out.writeInt(sac.UNUSED16);
        out.writeInt(sac.LEVEN);
        out.writeInt(sac.LPSPOL);
        out.writeInt(sac.LOVROK);
        out.writeInt(sac.LCALDA);
        out.writeInt(sac.UNUSED17);
        SAC.writeBytes((DataOutput)out, sac.KSTNM, 8);
        SAC.writeBytes((DataOutput)out, sac.KEVNM, 16);
        SAC.writeBytes((DataOutput)out, sac.KHOLE, 8);
        SAC.writeBytes((DataOutput)out, sac.KO, 8);
        SAC.writeBytes((DataOutput)out, sac.KA, 8);
        SAC.writeBytes((DataOutput)out, sac.KT0, 8);
        SAC.writeBytes((DataOutput)out, sac.KT1, 8);
        SAC.writeBytes((DataOutput)out, sac.KT2, 8);
        SAC.writeBytes((DataOutput)out, sac.KT3, 8);
        SAC.writeBytes((DataOutput)out, sac.KT4, 8);
        SAC.writeBytes((DataOutput)out, sac.KT5, 8);
        SAC.writeBytes((DataOutput)out, sac.KT6, 8);
        SAC.writeBytes((DataOutput)out, sac.KT7, 8);
        SAC.writeBytes((DataOutput)out, sac.KT8, 8);
        SAC.writeBytes((DataOutput)out, sac.KT9, 8);
        SAC.writeBytes((DataOutput)out, sac.KF, 8);
        SAC.writeBytes((DataOutput)out, sac.KUSER0, 8);
        SAC.writeBytes((DataOutput)out, sac.KUSER1, 8);
        SAC.writeBytes((DataOutput)out, sac.KUSER2, 8);
        SAC.writeBytes((DataOutput)out, sac.KCMPNM, 8);
        SAC.writeBytes((DataOutput)out, sac.KNETWK, 8);
        SAC.writeBytes((DataOutput)out, sac.KDATRD, 8);
        SAC.writeBytes((DataOutput)out, sac.KINST, 8);
        int i = 0;
        while (i < sac.NPTS) {
            out.writeFloat(sac.data1[i]);
            ++i;
        }
        if (sac.IFTYPE != 1) {
            i = 0;
            while (i < sac.NPTS) {
                out.writeFloat(sac.data2[i]);
                ++i;
            }
        }
        ((OutputStream)fos).close();
    }

    private static void writeBytes(DataOutput out, String ss, int len) throws IOException {
        byte[] s = ss.getBytes();
        int length = s.length;
        if (len < length) {
            int i = 0;
            while (i < len) {
                out.write(s[i]);
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < length) {
            out.write(s[i]);
            ++i;
        }
        i = 0;
        while (i < len - length) {
            out.write(0);
            ++i;
        }
    }

    public static void writeAsciiSAC(PrintWriter pw, SAC sac) throws IOException {
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.DELTA), Float.valueOf(sac.DEPMIN), Float.valueOf(sac.DEPMAX), Float.valueOf(sac.SCALE), Float.valueOf(sac.ODELTA));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.B), Float.valueOf(sac.E), Float.valueOf(sac.O), Float.valueOf(sac.A), Float.valueOf(sac.INTERNAL0));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.T0), Float.valueOf(sac.T1), Float.valueOf(sac.T2), Float.valueOf(sac.T3), Float.valueOf(sac.T4));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.T5), Float.valueOf(sac.T6), Float.valueOf(sac.T7), Float.valueOf(sac.T8), Float.valueOf(sac.T9));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.F), Float.valueOf(sac.RESP0), Float.valueOf(sac.RESP1), Float.valueOf(sac.RESP2), Float.valueOf(sac.RESP3));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.RESP4), Float.valueOf(sac.RESP5), Float.valueOf(sac.RESP6), Float.valueOf(sac.RESP7), Float.valueOf(sac.RESP8));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.RESP9), Float.valueOf(sac.STLA), Float.valueOf(sac.STLO), Float.valueOf(sac.STEL), Float.valueOf(sac.STDP));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.EVLA), Float.valueOf(sac.EVLO), Float.valueOf(sac.EVEL), Float.valueOf(sac.EVDP), Float.valueOf(sac.MAG));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.USER0), Float.valueOf(sac.USER1), Float.valueOf(sac.USER2), Float.valueOf(sac.USER3), Float.valueOf(sac.USER4));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.USER5), Float.valueOf(sac.USER6), Float.valueOf(sac.USER7), Float.valueOf(sac.USER8), Float.valueOf(sac.USER9));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.DIST), Float.valueOf(sac.AZ), Float.valueOf(sac.BAZ), Float.valueOf(sac.GCARC), Float.valueOf(sac.INTERNAL1));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.INTERNAL2), Float.valueOf(sac.DEPMEN), Float.valueOf(sac.CMPAZ), Float.valueOf(sac.CMPINC), Float.valueOf(sac.XMINIMUM));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.XMAXIMUM), Float.valueOf(sac.YMINIMUM), Float.valueOf(sac.YMAXIMUM), Float.valueOf(sac.UNUSED0), Float.valueOf(sac.UNUSED1));
        pw.printf("%15.7g %15.7g %15.7g %15.7g %15.7g\n", Float.valueOf(sac.UNUSED2), Float.valueOf(sac.UNUSED3), Float.valueOf(sac.UNUSED4), Float.valueOf(sac.UNUSED5), Float.valueOf(sac.UNUSED6));
        pw.printf("%10d %10d %10d %10d %10d\n", sac.NZYEAR, sac.NZJDAY, sac.NZHOUR, sac.NZMIN, sac.NZSEC);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.NZMSEC, sac.NVHDR, sac.NORID, sac.NEVID, sac.NPTS);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.INTERNAL3, sac.NWFID, sac.NXSIZE, sac.NYSIZE, sac.UNUSED7);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.IFTYPE, sac.IDEP, sac.IZTYPE, sac.UNUSED8, sac.IINST);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.ISTREG, sac.IEVREG, sac.IEVTYP, sac.IQUAL, sac.ISYNTH);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.IMAGTYP, sac.IMAGSRC, sac.UNUSED9, sac.UNUSED10, sac.UNUSED11);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.UNUSED12, sac.UNUSED13, sac.UNUSED14, sac.UNUSED15, sac.UNUSED16);
        pw.printf("%10d %10d %10d %10d %10d\n", sac.LEVEN, sac.LPSPOL, sac.LOVROK, sac.LCALDA, sac.UNUSED17);
        pw.printf("%8s %8s\n", sac.KSTNM, sac.KEVNM);
        pw.printf("%8s %8s %8s\n", sac.KHOLE, sac.KO, sac.KA);
        pw.printf("%8s %8s %8s\n", sac.KT0, sac.KT1, sac.KT2);
        pw.printf("%8s %8s %8s\n", sac.KT3, sac.KT4, sac.KT5);
        pw.printf("%8s %8s %8s\n", sac.KT6, sac.KT7, sac.KT8);
        pw.printf("%8s %8s %8s\n", sac.KT9, sac.KF, sac.KUSER0);
        pw.printf("%8s %8s %8s\n", sac.KUSER1, sac.KUSER2, sac.KCMPNM);
        pw.printf("%8s %8s %8s\n", sac.KNETWK, sac.KDATRD, sac.KINST);
        int n = sac.NPTS / 5;
        int L = sac.NPTS % 5;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < 5) {
                pw.printf("%15.7g ", Float.valueOf(sac.data1[i * 5 + j]));
                ++j;
            }
            pw.println();
            ++i;
        }
        int j = 0;
        while (j < L) {
            pw.printf("%15.7g ", Float.valueOf(sac.data1[n * 5 + j]));
            ++j;
        }
        pw.println();
    }

    public static void evtData2SAC(EvtData evt, File outDir, boolean bb) throws IOException {
        int i = 0;
        while (i < evt.getTCN()) {
            SAC.evtData2SAC(evt, i, outDir, bb);
            ++i;
        }
    }

    public static void evtData2SAC(EvtData evt, int chn, File outDir, boolean bb) throws IOException {
        SAC sac = new SAC();
        String fname = null;
        sac.NPTS = evt.getSampData(chn).length;
        double[] sd = evt.getSampData(chn);
        sac.data1 = new float[sac.NPTS];
        double gain = evt.getCalibFactor(chn);
        int i = 0;
        while (i < sac.NPTS) {
            sac.data1[i] = (float)sd[i];
            ++i;
        }
        sac.NVHDR = 6;
        sac.B = 0.0f;
        sac.E = (float)evt.getTRL(chn);
        sac.IFTYPE = 1;
        sac.LEVEN = 1;
        sac.DELTA = (float)(1.0 / evt.getSampleRate(chn));
        sac.IDEP = 5;
        switch (evt.getOriginalType(chn)) {
            case 0: {
                break;
            }
            case 1: {
                sac.IDEP = 7;
                break;
            }
            case 2: {
                sac.IDEP = 8;
                break;
            }
            default: {
                sac.IDEP = 5;
            }
        }
        sac.SCALE = (float)gain * 1000.0f;
        sac.DEPMIN = (float)ArrayMath.min((double[])sd);
        sac.DEPMAX = (float)ArrayMath.max((double[])sd);
        sac.DEPMEN = (float)ArrayMath.mean((double[])sd);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(evt.getArrivalTime(chn));
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        sac.NZYEAR = cal.get(1);
        sac.NZJDAY = cal.get(6);
        sac.NZHOUR = cal.get(11);
        sac.NZMIN = cal.get(12);
        sac.NZSEC = cal.get(13);
        sac.NZMSEC = cal.get(14);
        sac.IZTYPE = 9;
        sac.KNETWK = evt.getNetworkCode(chn);
        sac.KSTNM = evt.getStationCode(chn);
        sac.KINST = evt.getInstrumentType(chn);
        sac.STLA = (float)evt.getStationLocation(chn).getLatitude();
        sac.STLO = (float)evt.getStationLocation(chn).getLongtitude();
        sac.STEL = (float)evt.getStationLocation(chn).getAltitude();
        sac.CMPAZ = (float)evt.getHAng(chn);
        sac.CMPINC = -((float)evt.getVAng(chn));
        sac.KCMPNM = evt.getChannelCode(chn);
        sac.LPSPOL = 0;
        sac.LCALDA = 0;
        fname = String.format("%04d.%03d.%02d.%02d.%02d.%04d.%2s.%s.%s.%s.D.SAC", sac.NZYEAR, sac.NZJDAY, sac.NZHOUR, sac.NZMIN, sac.NZSEC, sac.NZMSEC * 10, sac.KNETWK, sac.KSTNM, evt.getAuxId(chn), sac.KCMPNM);
        if (bb) {
            SAC.writeBinarySAC(new File(outDir, fname), sac);
        } else {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(new File(outDir, String.valueOf(fname) + "_ASC")), 8192));
            SAC.writeAsciiSAC(pw, sac);
            pw.close();
        }
    }

    public static int isIntelSAC(File sacFile) {
        int sacType = -1;
        try {
            FileChannel fc = new FileInputStream(sacFile).getChannel();
            ByteBuffer bb = ByteBuffer.allocate(616);
            fc.read(bb);
            fc.close();
            bb.flip();
            int ver = bb.getInt(304);
            if (ver > 0 && ver <= 6) {
                sacType = 1;
            } else {
                bb.order(ByteOrder.LITTLE_ENDIAN);
                ver = bb.getInt(304);
                if (ver > 0 && ver <= 6) {
                    sacType = 0;
                }
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            sacType = -1;
        }
        return sacType;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: SAC [-b|-a] eventFile outDir");
            System.exit(-1);
        }
        boolean bb = true;
        String fname = null;
        String outDir = null;
        String arg0 = args[0];
        if (arg0.equals("-b") && args.length > 2) {
            bb = true;
            fname = args[1];
            outDir = args[2];
        } else if (arg0.equals("-a") && args.length > 2) {
            bb = false;
            fname = args[1];
            outDir = args[2];
        } else {
            bb = true;
            fname = args[0];
            outDir = args[1];
        }
        EvtData evt = EvtData.readEvtData(fname);
        SAC.evtData2SAC(evt, new File(outDir), bb);
    }
}

