/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.smwin32;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.smwin32.SMWin32Data;
import com.nr.Complex;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SMWin32Event
extends EvtData {
    private static final long serialVersionUID = 5730088485429981288L;
    static Logger logger = Logger.getLogger(SMWin32Event.class);
    private boolean uniTime = false;
    private int totalChannelNumber = 0;
    private HashMap<String, SMWin32Data> staData = new HashMap();

    public SMWin32Event() {
        this.evtFormat = 12;
    }

    public SMWin32Event(EvtData evt) {
        super(evt);
        this.evtFormat = 12;
    }

    private void processDirectory(File file) {
        if (file.isFile()) {
            this.processFile(file);
            return;
        }
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.processDirectory(files[i]);
            } else {
                this.processFile(files[i]);
            }
            ++i;
        }
    }

    private void processFile(File file) {
        String fileStr = file.getAbsolutePath();
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(fileStr));
            if (dis.readByte() == 10 && dis.readByte() == 2) {
                dis = new DataInputStream(new FileInputStream(fileStr));
                logger.info((Object)("reading K-NET or KIK-NET Win32 data! " + fileStr));
                SMWin32Data swd = new SMWin32Data();
                swd.readSMWin32(dis);
                dis.close();
                this.totalChannelNumber += swd.chlNum;
                StringBuffer sb = new StringBuffer();
                sb.append(Integer.toHexString(swd.orgID));
                sb.append(Integer.toHexString(swd.netID));
                sb.append(swd.staName);
                String akey = sb.toString();
                if (this.staData.containsKey(akey)) {
                    this.totalChannelNumber -= this.staData.get((Object)akey).chlNum;
                    logger.warn((Object)String.format("This event %s has more then one same station: %10s !", fileStr, swd.staName));
                }
                this.staData.put(akey, swd);
                logger.info((Object)String.format("Record length :%10d (s)", swd.recordLength));
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public boolean readEvtFile(String fileName) {
        int i;
        long now_ms = new Date().getTime();
        int k = 0;
        int chn = 0;
        long uniSTms = -1L;
        this.list.clear();
        this.processDirectory(new File(fileName));
        if (this.totalChannelNumber == 0) {
            logger.error((Object)"No data!");
            return false;
        }
        RTOneChannelData[] rtd = new RTOneChannelData[this.totalChannelNumber];
        int i2 = 0;
        while (i2 < this.totalChannelNumber) {
            rtd[i2] = new RTOneChannelData();
            ++i2;
        }
        for (String akey : this.staData.keySet()) {
            SMWin32Data swd = this.staData.get(akey);
            i = 0;
            while (i < swd.chlNum) {
                rtd[k].setStationSeqNumber(chn++);
                rtd[k].setNetworkCode(swd.staName.substring(0, 2));
                rtd[k].setStationCode(swd.staName.substring(2));
                rtd[k].setAuxId("00");
                rtd[k].setStationType("3C");
                rtd[k].setSampleRate(swd.srate);
                rtd[k].setCoordSys("");
                rtd[k].setChannelCode(swd.ci[i].chlCode);
                rtd[k].setStationLocation(new Location(swd.staLat, swd.staLon, swd.staAlt));
                if (i % 3 == 0) {
                    rtd[k].setHAng(0.0);
                    rtd[k].setVAng(90.0);
                } else if (i % 3 == 1) {
                    rtd[k].setHAng(90.0);
                    rtd[k].setVAng(90.0);
                } else if (i % 3 == 2) {
                    rtd[k].setHAng(0.0);
                    rtd[k].setVAng(0.0);
                }
                rtd[k].setScaleFactor(swd.ci[i].gain);
                rtd[k].setCalper(1.0);
                rtd[k].setZero(new Complex[0]);
                rtd[k].setPole(new Complex[0]);
                rtd[k].setCalibFactor(1.0 / (swd.ci[i].factor * 1000000.0));
                rtd[k].setOriginalType(2);
                rtd[k].setInstrumentType(swd.sensorType);
                double[] countData = new double[swd.ci[i].dataList.size()];
                int j = 0;
                while (j < countData.length) {
                    countData[j] = swd.ci[i].dataList.get(j).intValue();
                    ++j;
                }
                swd.ci[i].dataList.clear();
                rtd[k].setSampData(countData);
                if (this.uniTime) {
                    rtd[k].setArrivalTime(new Date(uniSTms));
                } else {
                    rtd[k].setArrivalTime(new Date(swd.startRecordTime));
                }
                this.list.add(rtd[k]);
                ++k;
                ++i;
            }
        }
        this.staData.clear();
        long n_now_ms = new Date().getTime();
        logger.info((Object)("DECODE Strong Motion Win32 elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        if (this.list.size() == 0) {
            logger.warn((Object)"No channel info found!");
            return false;
        }
        this.setTimeSeries();
        try {
            i = 0;
            while (i < this.TSN) {
                double theTRL = this.getTRL(i);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        EvtData.WaveFormSortType = 2;
        this.sort();
        return true;
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }
}

