/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.win32;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Win32Data {
    static Logger logger = Logger.getLogger(Win32Data.class);
    public Calendar beg_time = null;
    public Calendar end_time = null;
    public HashMap<Integer, ArrayList<Float>> chl_data = new HashMap();
    public HashMap<Integer, Integer> chl_srate = new HashMap();

    public int readWin32(DataInputStream din) throws IOException {
        int MAX_RATE = 2000;
        int headi = din.readInt();
        if (headi != 0) {
            logger.warn((Object)"The data format is not WIN32!!");
            return -1;
        }
        int sec = 0;
        byte[] tmp1 = new byte[8];
        din.readFully(tmp1);
        this.beg_time = this.getBCDTime(tmp1);
        while (din.available() > 0) {
            int rate = 0;
            int b_size = 0;
            int tmp = 0;
            int kk = 0;
            if (sec == 0) {
                this.end_time = this.beg_time;
            } else {
                int b = din.read();
                if (b == 0) {
                    din.read();
                    din.read();
                    din.read();
                    din.readFully(tmp1);
                } else {
                    tmp1[0] = (byte)b;
                    din.readFully(tmp1, 1, 7);
                }
                this.end_time = this.getBCDTime(tmp1);
            }
            tmp = din.readInt();
            int block_size = din.readInt();
            float[] data = new float[2000];
            while (kk < block_size) {
                int i;
                int ngaps;
                din.readByte();
                din.readByte();
                int chId = din.readShort() & 0xFFFF;
                tmp = din.readShort();
                b_size = tmp >>> 12 & 0xF;
                rate = tmp & 0xFFF;
                Integer srate = this.chl_srate.get(chId);
                if (srate == null) {
                    srate = rate;
                    this.chl_srate.put(chId, srate);
                }
                if (rate != srate) {
                    logger.info((Object)("The sample rate of channel " + Integer.toHexString(chId) + " " + srate + " != " + rate));
                }
                if (rate > 2000) {
                    logger.warn((Object)String.format("The sample rate of channel %s is %d", Integer.toHexString(chId), rate));
                    return -1;
                }
                data[0] = din.readInt();
                kk += 10;
                block0 : switch (b_size) {
                    case 0: {
                        int i2 = 1;
                        while (i2 < rate) {
                            byte b = din.readByte();
                            int d0 = b >> 4;
                            data[i2] = data[i2 - 1] + (float)d0;
                            ++kk;
                            if (i2 + 1 >= rate) break block0;
                            d0 = b << 28;
                            data[i2 + 1] = data[i2] + (float)(d0 >>= 28);
                            i2 += 2;
                        }
                        break;
                    }
                    case 1: {
                        int i3 = 1;
                        while (i3 < rate) {
                            data[i3] = data[i3 - 1] + (float)din.readByte();
                            ++kk;
                            ++i3;
                        }
                        break;
                    }
                    case 2: {
                        int i4 = 1;
                        while (i4 < rate) {
                            data[i4] = data[i4 - 1] + (float)din.readShort();
                            kk += 2;
                            ++i4;
                        }
                        break;
                    }
                    case 3: {
                        int i5 = 1;
                        while (i5 < rate) {
                            int b1 = din.read();
                            int s2 = din.readShort() & 0xFFFF;
                            int d3 = (b1 << 24) + (s2 << 8);
                            data[i5] = data[i5 - 1] + (float)(d3 >>= 8);
                            kk += 3;
                            ++i5;
                        }
                        break;
                    }
                    case 4: {
                        int i6 = 1;
                        while (i6 < rate) {
                            data[i6] = data[i6 - 1] + (float)din.readInt();
                            kk += 4;
                            ++i6;
                        }
                        break;
                    }
                    default: {
                        logger.warn((Object)("Wrong bit size: " + b_size));
                    }
                }
                if (rate != srate) continue;
                ArrayList<Float> ld = this.chl_data.get(chId);
                if (ld == null) {
                    ld = new ArrayList(12000);
                    ngaps = sec * srate;
                    if (ngaps > 0) {
                        i = 0;
                        while (i < ngaps) {
                            ld.add(Float.valueOf(0.0f));
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < rate) {
                        ld.add(Float.valueOf(data[i]));
                        ++i;
                    }
                    this.chl_data.put(chId, ld);
                    continue;
                }
                ngaps = sec * srate - ld.size();
                if (ngaps > 0) {
                    i = 0;
                    while (i < ngaps) {
                        ld.add(Float.valueOf(0.0f));
                        ++i;
                    }
                }
                if (ngaps < 0) continue;
                i = 0;
                while (i < rate) {
                    ld.add(Float.valueOf(data[i]));
                    ++i;
                }
            }
            ++sec;
        }
        return sec;
    }

    private Calendar getBCDTime(byte[] bt) {
        int[] tmp = new int[8];
        int i = 0;
        while (i < 8) {
            tmp[i] = (bt[i] >> 4 & 0xF) * 10 + (bt[i] & 0xF);
            ++i;
        }
        GregorianCalendar date = new GregorianCalendar(tmp[0] * 100 + tmp[1], tmp[2] - 1, tmp[3], tmp[4], tmp[5], tmp[6]);
        return date;
    }

    public static void main(String[] args) throws FileNotFoundException {
        int b = 8;
        b <<= 28;
        System.out.println(b >>= 28);
        DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream("/home/hwh/tmp/nied/U20100705000084_20/U20100705000084_20.evt")));
        Win32Data wd = new Win32Data();
        try {
            wd.readWin32(din);
            din.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(wd.chl_data.size());
        ArrayList<Object> ld1 = new ArrayList();
        ld1 = wd.chl_data.get("3ec3");
        int i = 0;
        while (i < ld1.size()) {
            System.out.println(ld1.get(i));
            ++i;
        }
    }
}

