/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.evtformat.win32;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.Location;
import cn.org.gddsn.seis.evtformat.PZMgr;
import cn.org.gddsn.seis.evtformat.RTOneChannelData;
import cn.org.gddsn.seis.evtformat.TransferFun;
import cn.org.gddsn.seis.evtformat.win32.Win32Data;
import com.nr.Complex;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class Win32Event
extends EvtData {
    static Logger logger = Logger.getLogger(Win32Event.class);
    private static final long serialVersionUID = 1L;
    private boolean uniTime = false;
    static HashMap<Integer, String> sta_tab = new HashMap();

    public Win32Event() {
        this.evtFormat = 11;
    }

    public Win32Event(EvtData evt) {
        super(evt);
        this.evtFormat = 11;
    }

    public boolean readEvtFile(String fileName) {
        long now_ms = new Date().getTime();
        PZMgr pzMgr = new PZMgr();
        pzMgr.load("cfg/pz.cfg");
        this.list.clear();
        long uniSTms = -1L;
        int chn = 0;
        int k = 0;
        int chId = 0;
        double sense = 0.0;
        Win32Data wd = new Win32Data();
        File pf = new File(fileName).getParentFile();
        File chFile = null;
        File[] fileArray = pf.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().endsWith(".ch")) {
                chFile = f;
                break;
            }
            ++n2;
        }
        if (chFile == null) {
            logger.warn((Object)"Could not found *.ch file for this win32 file.");
            return false;
        }
        this.readStationInfo(chFile.getAbsolutePath());
        if (wd.chl_data.size() > sta_tab.size()) {
            logger.warn((Object)"The using station information data miss some stations, please check the input!");
            return false;
        }
        try {
            logger.info((Object)("readding Win32 data:" + fileName));
            DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName), 8192));
            int nsec = wd.readWin32(din);
            din.close();
            logger.info((Object)String.format("Total second %d", nsec));
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        RTOneChannelData[] rtd = new RTOneChannelData[wd.chl_data.size()];
        int i = 0;
        while (i < wd.chl_data.size()) {
            rtd[i] = new RTOneChannelData();
            ++i;
        }
        Iterator<Map.Entry<Integer, ArrayList<Float>>> it = wd.chl_data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ArrayList<Float>> entry = it.next();
            ArrayList<Object> cdata = new ArrayList();
            String[] st = new String[19];
            String sta_inf = null;
            chId = entry.getKey();
            cdata = entry.getValue();
            Integer srate = wd.chl_srate.get(chId);
            if (srate == null || (sta_inf = sta_tab.get(chId)) == null || Double.valueOf((st = sta_inf.split("\\s+"))[6]) > 32.0) continue;
            if (Integer.parseInt(st[0].trim(), 16) != chId) {
                logger.warn((Object)("This channel ID : " + Integer.toHexString(chId) + " is error!"));
                return false;
            }
            rtd[k].setStationSeqNumber(chn++);
            String stn = st[3].replace(".", "0");
            rtd[k].setStationCode(stn);
            if (stn.length() > 2) {
                rtd[k].setNetworkCode(stn.substring(0, 2));
                rtd[k].setStationCode(stn.substring(2));
            } else {
                rtd[k].setNetworkCode("JP");
                rtd[k].setStationCode(stn);
            }
            rtd[k].setAuxId("00");
            String comp = "SH";
            if ((double)Float.parseFloat(st[9]) > 10.0) {
                comp = "BH";
            }
            if (st[4].contains("U") || st[4].contains("Z")) {
                rtd[k].setChannelCode(String.valueOf(comp) + "Z");
            } else if (st[4].contains("E") || st[4].contains("X")) {
                rtd[k].setChannelCode(String.valueOf(comp) + "E");
            } else if (st[4].contains("N") || st[4].contains("Y")) {
                rtd[k].setChannelCode(String.valueOf(comp) + "N");
            } else {
                logger.error((Object)"ChannelCode unkonw!!");
                rtd[k].setChannelCode("XXX");
                continue;
            }
            rtd[k].setStationType("3C");
            rtd[k].setStationLocation(new Location(Double.valueOf(st[13]), Double.valueOf(st[14]), Double.valueOf(st[15]) / 1000.0));
            rtd[k].setSampleRate(srate.intValue());
            rtd[k].setCoordSys("");
            float[] hvang = new float[2];
            hvang = this.HVang(st[4].trim());
            rtd[k].setHAng(hvang[0]);
            rtd[k].setVAng(hvang[1]);
            rtd[k].setInstrumentType("");
            rtd[k].setOriginalType(1);
            TransferFun tf = pzMgr.getTransferFun(rtd[k].getStationCode());
            if (tf != null) {
                rtd[k].setScaleFactor(tf.a0);
                rtd[k].setCalper(tf.f0);
                rtd[k].setZero(tf.zeros);
                rtd[k].setPole(tf.poles);
            } else {
                rtd[k].setScaleFactor(1.0);
                rtd[k].setCalper(1.0);
                rtd[k].setZero(new Complex[0]);
                rtd[k].setPole(new Complex[0]);
            }
            double[] countData = new double[cdata.size()];
            int i2 = 0;
            while (i2 < countData.length) {
                countData[i2] = ((Float)cdata.get(i2)).floatValue();
                ++i2;
            }
            cdata.clear();
            rtd[k].setSampData(countData);
            sense = Double.valueOf(st[12]) / Math.pow(10.0, Double.valueOf(st[11]) / 20.0) / Double.valueOf(st[7]);
            if (st[8].equals("m/s")) {
                rtd[k].setCalibFactor(1.0 / (sense * 1000000.0));
                rtd[k].setOriginalType(1);
            } else if (st[8].equals("m/s/s")) {
                rtd[k].setCalibFactor(1.0 / (sense * 1000000.0));
                rtd[k].setOriginalType(2);
            } else {
                if (!st[8].equals("rad")) continue;
                continue;
            }
            if (this.uniTime) {
                rtd[k].setArrivalTime(new Date(uniSTms));
            } else {
                rtd[k].setArrivalTime(wd.beg_time.getTime());
            }
            this.list.add(rtd[k]);
            ++k;
            it.remove();
        }
        wd.chl_srate.clear();
        wd.chl_data.clear();
        long n_now_ms = new Date().getTime();
        logger.info((Object)("DECODE Win32 elapse time: " + (n_now_ms - now_ms) + " ms."));
        now_ms = n_now_ms;
        if (this.list.size() == 0) {
            logger.warn((Object)"No channel info found!");
            return false;
        }
        this.setTimeSeries();
        try {
            int i3 = 0;
            while (i3 < this.TSN) {
                double theTRL = this.getTRL(i3);
                if ((double)this.maxTRL < theTRL) {
                    this.maxTRL = (int)theTRL;
                }
                ++i3;
            }
        }
        catch (NullPointerException npe) {
            this.maxTRL = -1;
        }
        EvtData.WaveFormSortType = 2;
        this.sort();
        return true;
    }

    private void readStationInfo(String sfile) {
        sta_tab.clear();
        String ss = null;
        try {
            Scanner sc = new Scanner(new File(sfile));
            while (sc.hasNextLine()) {
                ss = sc.nextLine();
                if (ss == null || ss.startsWith("#")) continue;
                int chId = Integer.parseInt(ss.substring(0, 4).trim(), 16);
                sta_tab.put(chId, ss);
            }
            sc.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private float[] HVang(String st) {
        float[] hvAng = new float[2];
        switch (st.charAt(0)) {
            case 'U': 
            case 'Z': {
                hvAng[0] = 0.0f;
                hvAng[1] = 0.0f;
                break;
            }
            case 'V': {
                hvAng[0] = 0.0f;
                hvAng[1] = 0.0f;
                break;
            }
            case 'D': {
                hvAng[0] = 0.0f;
                hvAng[1] = 180.0f;
                break;
            }
            case 'N': 
            case 'Y': {
                hvAng[0] = 0.0f;
                hvAng[1] = 90.0f;
                break;
            }
            case 'S': {
                hvAng[0] = 180.0f;
                hvAng[1] = 90.0f;
                break;
            }
            case 'E': 
            case 'X': {
                hvAng[0] = 90.0f;
                hvAng[1] = 90.0f;
                break;
            }
            case 'W': {
                hvAng[0] = -90.0f;
                hvAng[1] = 90.0f;
                break;
            }
            default: {
                logger.warn((Object)("Component name error:" + st));
            }
        }
        return hvAng;
    }

    public boolean writeEvtFile(String fileName) {
        return false;
    }

    public static void main(String[] args) {
        Win32Event we = new Win32Event();
        ((EvtData)we).readEvtFile("/home/lzy/test/data/jp/data/2010031321450101VM.cnt");
    }
}

