/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

public class Complex {
    public double x;
    public double y;
    public static final Complex Zero = new Complex(0.0, 0.0);
    public static final Complex One = new Complex(1.0, 0.0);
    public static final Complex IMAGE = new Complex(0.0, 1.0);

    public Complex(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Complex() {
    }

    static Complex cplus(Complex a, Complex b) {
        return new Complex(a.x + b.x, a.y + b.y);
    }

    static Complex cngtv(Complex a) {
        return new Complex(-a.x, -a.y);
    }

    static Complex cinvs(Complex a) {
        return Complex.dmltp(1.0 / (a.x * a.x + a.y * a.y), Complex.conjg(a));
    }

    static Complex conjg(Complex a) {
        return new Complex(a.x, -a.y);
    }

    static Complex dmltp(double a, Complex b) {
        return new Complex(b.x * a, b.y * a);
    }

    static Complex Csqrt(Complex a) {
        double mo = Math.sqrt(Complex.ccabs(a));
        double ar = 0.5 * Math.atan2(a.y, a.x);
        Complex c = new Complex();
        c.x = mo * Math.cos(ar);
        c.y = mo * Math.sin(ar);
        return c;
    }

    static Complex cmltp(Complex a, Complex b) {
        Complex c = new Complex();
        c.x = a.x * b.x - a.y * b.y;
        c.y = a.x * b.y + a.y * b.x;
        return c;
    }

    static Complex cmplx(double x, double y) {
        return new Complex(x, y);
    }

    static Complex cphase(Complex w) {
        double mo = Math.exp(w.x);
        return Complex.cmplx(mo * Math.cos(w.y), mo * Math.sin(w.y));
    }

    static double ccabs(Complex a) {
        return Math.sqrt(a.x * a.x + a.y * a.y);
    }

    static void c2r(double[] r, Complex[] c) {
        int i = 0;
        while (i < c.length) {
            r[2 * i] = c[i].x;
            r[2 * i + 1] = c[i].y;
            ++i;
        }
    }

    static void r2c(Complex[] c, double[] r) {
        int i = 0;
        while (i < r.length / 2) {
            c[i] = new Complex(r[2 * i], r[2 * i + 1]);
            ++i;
        }
    }
}

