/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

import JSci.util.ArrayCaster;
import cn.org.gddsn.seis.evtformat.sac.SAC;
import cn.org.gddsn.seis.hk.Complex;
import cn.org.gddsn.seis.hk.Deconvolution;
import cn.org.gddsn.seis.hk.FFT;
import java.io.File;
import java.io.IOException;
import org.netlib.util.doubleW;

public class Deconvolution2 {
    boolean cut = false;
    int tmark = -5;
    double t1 = 0.0;
    double t2;
    private double tau = -1.0;
    private int filter = 0;
    private double f1;
    private double f2;
    private boolean intg = true;
    private boolean diff = false;
    private boolean keepTime = false;
    private int maxiter = 50;
    private double taper = 0.5;
    private boolean positive = false;
    private boolean saveRes = false;

    public int run(String[] rvName) throws IOException {
        int nft = 0;
        int nft2 = 0;
        int ntau = 0;
        double[] src = null;
        double[] res = null;
        double[] spikes = null;
        double[] wndw = null;
        double srcAutoCor = 0.0;
        double dt = 0.0;
        doubleW amp = new doubleW(0.0);
        Complex[] src_spec = null;
        Complex[] res_spec = null;
        Complex[] temp = null;
        SAC hd = new SAC();
        this.f1 = 0.0;
        this.f2 = 0.0;
        this.maxiter = 50;
        this.saveRes = false;
        this.filter = 0;
        this.cut = false;
        double pre = 0.0;
        this.positive = false;
        double thr = 1.0E-4;
        this.tau = -1.0;
        this.taper = 0.0;
        this.intg = false;
        this.diff = false;
        this.keepTime = false;
        double delay = 0.0;
        src = null;
        dt = 0.0;
        int nn = 0;
        this.filter = 1;
        this.f1 = 3.0;
        this.f2 = -5.0;
        this.maxiter = 100;
        this.cut = true;
        this.tmark = -2;
        this.t1 = -10.0;
        this.t2 = 80.0;
        this.taper = 0.1;
        pre = -this.f2;
        String[] stringArray = rvName;
        int n = rvName.length;
        int n2 = 0;
        while (n2 < n) {
            int j;
            String fn;
            String tttt = fn = stringArray[n2];
            System.out.printf("%s\n", tttt);
            if (src == null) {
                if (this.cut) {
                    Deconvolution.read_sac(new File(tttt), hd, this.tmark, (float)this.t1, (float)this.t2);
                    src = ArrayCaster.toDouble((float[])hd.data1);
                } else {
                    hd.readBinarySAC(new File(tttt));
                    src = ArrayCaster.toDouble((float[])hd.data1);
                    this.tmark = -5;
                    this.t1 = 0.0;
                    this.t2 = (float)hd.NPTS * hd.DELTA;
                }
                nn = hd.NPTS;
                dt = hd.DELTA;
                if (this.diff) {
                    FFT.diffrt(src, nn, dt);
                }
                if (this.taper > 0.0) {
                    wndw = FFT.coswndw(nn, this.taper);
                    j = 0;
                    while (j < nn) {
                        int n3 = j;
                        src[n3] = src[n3] * wndw[j];
                        ++j;
                    }
                }
                nft = 1;
                while (nft < nn) {
                    nft *= 2;
                }
                nft2 = nft;
                nft *= 2;
                ntau = nft2;
                if (this.tau > 0.0 && (ntau = (int)Math.ceil(this.tau / dt)) > nft2) {
                    ntau = nft2;
                }
                spikes = new double[nft];
                src_spec = new Complex[nft2];
                res_spec = new Complex[nft2];
                temp = new Complex[nft2];
                j = 0;
                while (j < nft2) {
                    src_spec[j] = new Complex();
                    ++j;
                }
                j = 0;
                while (j < nn / 2) {
                    src_spec[j] = new Complex(src[2 * j], src[2 * j + 1]);
                    ++j;
                }
                FFT.fftr(src_spec, 0, nft2, dt);
                if (this.filter > 1 && this.f2 < 0.0) {
                    FFT.fltGauss(src_spec, nft2, this.f1 * dt);
                }
                srcAutoCor = FFT.specPwr(src_spec, nft2) / dt;
            } else {
                Deconvolution.read_sac(new File(tttt), hd, this.tmark, (float)this.t1, (float)this.t2);
                res = ArrayCaster.toDouble((float[])hd.data1);
                if (hd.NPTS == nn) {
                    if (this.taper > 0.0) {
                        j = 0;
                        while (j < nn) {
                            res[j] = res[j] * wndw[j];
                            ++j;
                        }
                    }
                    if (this.intg) {
                        FFT.cumsum(res, nn, dt);
                    }
                    j = 0;
                    while (j < nft2) {
                        res_spec[j] = new Complex();
                        ++j;
                    }
                    j = 0;
                    while (j < nn / 2) {
                        res_spec[j] = new Complex(res[2 * j], res[2 * j + 1]);
                        ++j;
                    }
                    FFT.fftr(res_spec, 0, nft2, dt);
                    if (this.filter > 2 && this.f2 < 0.0) {
                        FFT.fltGauss(res_spec, nft2, this.f1 * dt);
                    }
                    double rms0 = FFT.specPwr(res_spec, nft2);
                    j = 0;
                    while (j < nft) {
                        spikes[j] = 0.0;
                        ++j;
                    }
                    int i = 0;
                    amp.val = 1.0;
                    double amp0 = 1.0;
                    while (i++ < this.maxiter && Math.abs(amp.val / amp0) > thr) {
                        j = 0;
                        while (j < nft2) {
                            temp[j] = new Complex(res_spec[j].x, res_spec[j].y);
                            ++j;
                        }
                        FFT.cor(src_spec, temp, dt, nft2);
                        double[] tmp_r = new double[nft];
                        Complex.c2r(tmp_r, temp);
                        int shift = this.positive ? FFT.findMax(tmp_r, nft2, ntau, amp) : FFT.findMaxAbs(tmp_r, nft2, ntau, amp);
                        amp.val /= srcAutoCor;
                        if (i == 1) {
                            amp0 = amp.val;
                        }
                        j = 0;
                        while (j < nft2) {
                            temp[j] = new Complex(src_spec[j].x, src_spec[j].y);
                            ++j;
                        }
                        FFT.shiftSpec(temp, nft2, shift);
                        FFT.specScale(temp, -amp.val, nft2);
                        FFT.specAdd(res_spec, temp, nft2);
                        double rms = Math.sqrt(FFT.specPwr(res_spec, nft2) / rms0);
                        int n4 = shift;
                        spikes[n4] = spikes[n4] + amp.val / dt;
                        System.out.printf("iteration %d amp=%6.2f shift=%6.2f rms=%4.2f\n", i, amp.val, (double)shift * dt, rms);
                    }
                    if (this.filter > 0 && !(this.f2 > 0.0)) {
                        Complex[] s_c = new Complex[nft2];
                        Complex.r2c(s_c, spikes);
                        FFT.fftr(s_c, 0, nft2, dt);
                        FFT.shiftSpec(s_c, nft2, pre / dt);
                        FFT.fltGauss(s_c, nft2, this.f1 * dt);
                        FFT.fftr(s_c, 0, nft2, -dt);
                        Complex.c2r(spikes, s_c);
                    }
                    hd.NPTS = nn;
                    if (this.tau > 0.0 && this.filter <= 0) {
                        hd.NPTS = ntau;
                    }
                    hd.B = (float)(-pre);
                    if (this.keepTime) {
                        if (this.tmark == -1) {
                            hd.B = (float)((double)hd.B + delay);
                        } else {
                            float tref = 0.0f;
                            switch (this.tmark) {
                                case -5: {
                                    tref = hd.B;
                                    break;
                                }
                                case -3: {
                                    tref = hd.O;
                                    break;
                                }
                                case -2: {
                                    tref = hd.A;
                                    break;
                                }
                                case 0: {
                                    tref = hd.USER0;
                                    break;
                                }
                                case 1: {
                                    tref = hd.USER1;
                                    break;
                                }
                                case 2: {
                                    tref = hd.USER2;
                                    break;
                                }
                                case 3: {
                                    tref = hd.USER3;
                                    break;
                                }
                                case 4: {
                                    tref = hd.USER4;
                                    break;
                                }
                                case 5: {
                                    tref = hd.USER5;
                                    break;
                                }
                                case 6: {
                                    tref = hd.USER6;
                                    break;
                                }
                                case 7: {
                                    tref = hd.USER7;
                                    break;
                                }
                                case 8: {
                                    tref = hd.USER8;
                                    break;
                                }
                                case 9: {
                                    tref = hd.USER9;
                                }
                            }
                            hd.B = (float)((double)hd.B + ((double)tref + delay));
                        }
                    }
                    hd.E = hd.B + (float)hd.NPTS * hd.DELTA;
                    hd.USER1 = (float)this.f1;
                    if (this.intg || this.diff) {
                        FFT.diffrt(spikes, nft2, dt);
                    }
                    hd.data1 = ArrayCaster.toFloat((double[])spikes);
                    SAC.writeBinarySAC(new File(String.valueOf(tttt) + "i"), hd);
                    if (this.saveRes) {
                        FFT.fftr(res_spec, 0, nft2, -dt);
                        double[] res_r = new double[nft];
                        Complex.c2r(res_r, res_spec);
                        hd.data1 = ArrayCaster.toFloat((double[])res_r);
                        SAC.writeBinarySAC(new File(String.valueOf(tttt) + "i.res"), hd);
                    }
                }
            }
            ++n2;
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        Deconvolution2 decon = new Deconvolution2();
        String[] rfName = new String[]{"/home/hwh/try/hk/example/KUL.z", "/home/hwh/try/hk/example/KUL.r", "/home/hwh/try/hk/example/KUL.t"};
        decon.run(rfName);
    }
}

