/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.hk;

import JSci.util.ArrayCaster;
import cn.org.gddsn.seis.evtformat.sac.SAC;
import cn.org.gddsn.seis.hk.FFT;
import cn.org.gddsn.seis.hk.Grid2dSearch;
import java.io.File;
import java.io.IOException;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class KStack {
    private static final int NS = 1000;
    private double x_min = 20.0;
    private double x_max = 60.0;
    private double y_min = 1.5;
    private double y_max = 2.0;
    private double x_inc = 0.5;
    private double y_inc = 0.01;
    private boolean addmore = false;
    private int nRoot = 1;
    private double smtht = 1.0;
    private int cxWidth = 0;
    private double vp = 6.3;
    private double w1 = 0.7;
    private double w2 = 0.2;
    private double w3 = 0.1;
    private String outf;

    public int run(String[] rfName) throws IOException {
        int j;
        double p;
        int k;
        double[][] buff = new double[1000][];
        int nx = (int)Math.rint((this.x_max - this.x_min) / this.x_inc) + 1;
        int ny = (int)Math.rint((this.y_max - this.y_min) / this.y_inc) + 1;
        double temp = 2.0 * this.smtht;
        this.w1 /= temp;
        this.w2 /= temp;
        this.w3 /= temp;
        int n = nx * ny;
        if (n < 1) {
            return -1;
        }
        double[] ss = new double[n];
        double[] var = new double[n];
        SAC hd = new SAC();
        this.vp = 1.0 / (this.vp * this.vp);
        int num_of_traces = 0;
        int i = 0;
        String[] stringArray = rfName;
        int n2 = rfName.length;
        int n3 = 0;
        while (n3 < n2) {
            String fn = stringArray[n3];
            hd.readBinarySAC(new File(fn));
            double[] r = ArrayCaster.toDouble((float[])hd.data1);
            k = (int)Math.rint(-hd.B / hd.DELTA);
            if (k >= 0) {
                double tps;
                int npts = hd.NPTS - k;
                double dt = this.x_inc / (double)hd.DELTA;
                double t0 = tps = this.x_min / (double)hd.DELTA;
                if (num_of_traces == 1000) {
                    System.out.printf("too many traces\n", n);
                    return -1;
                }
                double[] fpt = new double[n];
                buff[num_of_traces] = fpt;
                p = hd.USER0 * hd.USER0;
                double am_cor = 151.5478 * p + 3.2896 * Math.sqrt(p) + 0.2618;
                double eta_p = Math.sqrt(this.vp - p);
                ++num_of_traces;
                int ii = 0;
                double vs = this.y_max;
                j = 0;
                while (j < ny) {
                    double eta_s = Math.sqrt(this.vp * vs * vs - p);
                    if (nx == 1) {
                        t0 = tps / (eta_s - eta_p);
                    } else {
                        tps = t0 * (eta_s - eta_p);
                    }
                    double dtps = dt * (eta_s - eta_p);
                    double tppps = t0 * (eta_s + eta_p);
                    double dtppps = dt * (eta_s + eta_p);
                    double tpsps = t0 * 2.0 * eta_s;
                    double dtpsps = dt * 2.0 * eta_s;
                    int kk = 0;
                    while (kk < nx) {
                        fpt[ii] = this.w1 * FFT.amp(tps - this.smtht, tps + this.smtht, r, k, npts) / am_cor + this.w2 * FFT.amp(tppps - this.smtht, tppps + this.smtht, r, k, npts) - this.w3 * FFT.amp(tpsps - this.smtht, tpsps + this.smtht, r, k, npts);
                        if (this.cxWidth > 0) {
                            int n4 = ii;
                            fpt[n4] = fpt[n4] * FFT.acc(r, k, npts, tps, tppps, this.cxWidth);
                        }
                        if (this.addmore) {
                            int n5 = ii;
                            fpt[n5] = fpt[n5] + (-this.w1 * FFT.amp(tps + tpsps - this.smtht, tps + tpsps + this.smtht, r, k, npts) - this.w2 * FFT.amp(tppps + tpsps - this.smtht, tppps + tpsps + this.smtht, r, k, npts) + this.w3 * FFT.amp(tpsps + tpsps - this.smtht, tpsps + tpsps + this.smtht, r, k, npts) + this.w1 * FFT.amp(tps + 2.0 * tpsps - this.smtht, tps + 2.0 * tpsps + this.smtht, r, k, npts) + this.w2 * FFT.amp(tppps + 2.0 * tpsps - this.smtht, tppps + 2.0 * tpsps + this.smtht, r, k, npts) - this.w3 * FFT.amp(tpsps + 2.0 * tpsps - this.smtht, tpsps + 2.0 * tpsps + this.smtht, r, k, npts));
                        }
                        if (nx > 1) {
                            tps += dtps;
                        }
                        tppps += dtppps;
                        tpsps += dtpsps;
                        ++kk;
                        ++ii;
                    }
                    ++j;
                    vs -= this.y_inc;
                }
            }
            ++n3;
        }
        if (num_of_traces < 1) {
            return -1;
        }
        k = 0;
        while (k < n) {
            temp = 0.0;
            i = 0;
            while (i < num_of_traces) {
                temp += (double)(buff[i][k] > 0.0 ? 1 : -1) * Math.exp(Math.log(Math.abs(buff[i][k])) / (double)this.nRoot);
                ++i;
            }
            ss[k] = (double)(temp > 0.0 ? 1 : -1) * Math.exp((double)this.nRoot * Math.log(Math.abs(temp) / (double)num_of_traces));
            temp = 0.0;
            i = 0;
            while (i < num_of_traces) {
                temp += (buff[i][k] - ss[k]) * (buff[i][k] - ss[k]);
                ++i;
            }
            var[k] = Math.sqrt(temp / (double)(num_of_traces - 1));
            ++k;
        }
        if (ny == 1 || nx == 1) {
            if (ny == 1) {
                hd.NPTS = nx;
                p = 0.0036;
                temp = Math.sqrt(this.vp * this.y_max * this.y_max - p) - Math.sqrt(this.vp - p);
                hd.B = (float)(this.x_min * temp);
                hd.DELTA = (float)(this.x_inc * temp);
            } else {
                hd.NPTS = ny;
                hd.B = (float)this.y_min;
                hd.DELTA = (float)this.y_inc;
                j = 0;
                k = n - 1;
                while (j < k) {
                    temp = ss[j];
                    ss[j] = ss[k];
                    ss[k] = temp;
                    temp = var[j];
                    var[j] = var[k];
                    var[k] = temp;
                    ++j;
                    --k;
                }
            }
            hd.data1 = ArrayCaster.toFloat((double[])ss);
            SAC.writeBinarySAC(new File(this.outf), hd);
            hd.data1 = ArrayCaster.toFloat((double[])var);
            SAC.writeBinarySAC(new File(String.valueOf(this.outf) + ".std"), hd);
        } else {
            k = 0;
            while (k < n) {
                ss[k] = -ss[k];
                ++k;
            }
            doubleW x = new doubleW(0.0);
            doubleW vx = new doubleW(0.0);
            doubleW y = new doubleW(0.0);
            doubleW vy = new doubleW(0.0);
            doubleW vxy = new doubleW(0.0);
            intW ixy = new intW(0);
            intW fg = new intW(0);
            double f0 = Grid2dSearch.grid2d(ss, nx, ny, x, vx, y, vy, vxy, ixy, fg);
            vx.val /= this.x_inc * this.x_inc;
            vy.val /= this.y_inc * this.y_inc;
            vxy.val = -vxy.val / (this.x_inc * this.y_inc);
            double dev = 1.0;
            dev = ss[ixy.val];
            dev = var[ixy.val];
            double moho_h = this.x_min + x.val * this.x_inc;
            double vpvs = this.y_max - y.val * this.y_inc;
            System.out.printf("%8.3f %8.3f %8.3f %8.3f %8.3f %8.2e %8.2e\n", moho_h, vpvs, vx.val, vy.val, vxy.val, f0, dev);
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        KStack kstack = new KStack();
        String[] rfName = new String[]{"/home/hwh/try/hk/example/pp.0.ri", "/home/hwh/try/hk/example/pp.1.ri", "/home/hwh/try/hk/example/pp.18.ri", "/home/hwh/try/hk/example/pp.4.ri", "/home/hwh/try/hk/example/pp.6.ri"};
        kstack.run(rfName);
    }
}

