/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.isf;

import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISF {
    static Logger logger = Logger.getLogger(ISF.class);
    public static final int ISF_NULL = 9999999;
    public static final int ISF_LINE_LEN = 140;
    public static final int ISF_COMM_LEN = 80;
    public static final int ISF_EVID_LEN = 8;
    public static final int ISF_REGION_LEN = 65;
    public static final int ISF_ETYPE_LEN = 2;
    public static final int ISF_AUTHOR_LEN = 9;
    public static final int ISF_ORIGID_LEN = 8;
    public static final int ISF_MAGTYPE_LEN = 5;
    public static final int ISF_STA_LEN = 5;
    public static final int ISF_NET_LEN = 9;
    public static final int ISF_CHAN_LEN = 3;
    public static final int ISF_PHASE_LEN = 8;
    public static final int ISF_ARRID_LEN = 8;
    public static final int ISF_F_TYPE_LEN = 3;
    public static final int ISF_F_PLANE_LEN = 5;
    public static final int ISF_I_LOCTYPE_LEN = 6;
    public static final int ISF_COUNTRY_LEN = 3;
    public static final int ISF_POSTCODE_LEN = 10;
    public static final int ISF_I_SCALE_LEN = 5;
    public String dataType;
    public String subType;
    public String dataFormat;
    public String subFormat;
    public List<Event> evtList;

    public ISF() {
    }

    public ISF(String dataType, String subType, String dataFormat, String subFormat, List<Event> evtList) {
        this.dataType = dataType;
        this.subType = subType;
        this.dataFormat = dataFormat;
        this.subFormat = subFormat;
        this.evtList = evtList;
    }

    public boolean parseHeader(String line) {
        if (line.substring(0, 9).equals("DATA_TYPE")) {
            logger.warn((Object)String.format("not a data_type line: %s", line));
            return false;
        }
        this.dataType = "";
        this.subType = "";
        this.dataFormat = "";
        this.subFormat = "";
        if (line.length() > 89) {
            logger.warn((Object)String.format("line too long: %s", line));
            return false;
        }
        Scanner sc = new Scanner(line).useDelimiter("[: ]+");
        try {
            this.dataType = sc.next();
            this.subType = sc.next();
            this.dataFormat = sc.next();
            this.subFormat = sc.next();
        }
        catch (Exception ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    static boolean noSpace(String str) {
        return str.indexOf(32) == -1 && str.indexOf(9) == -1;
    }

    public static String read_comment(String line) {
        if (!line.startsWith(" (") || line.indexOf(41) == -1) {
            return null;
        }
        return line.trim();
    }

    public static double get_time(int yyyy, int mm, int dd, int hh, int mi, int ss, int msec) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeZone(TimeZone.getTimeZone("UTC"));
        gc.set(yyyy, mm - 1, dd, hh, mi, ss);
        long ms = gc.getTime().getTime() / 1000L * 1000L;
        if (msec != 9999999) {
            ms += (long)msec;
        }
        return (double)ms / 1000.0;
    }

    public static class Axes {
        int scale_factor;
        public float t_val;
        public float t_azim;
        public float t_pl;
        public float b_val;
        public float b_azim;
        public float b_pl;
        public float p_val;
        public float p_azim;
        public float p_pl;
        public String author;

        public Axes() {
        }

        public Axes(int scale_factor, float t_val, float t_azim, float t_pl, float b_val, float b_azim, float b_pl, float p_val, float p_azim, float p_pl, String author) {
            this.scale_factor = scale_factor;
            this.t_val = t_val;
            this.t_azim = t_azim;
            this.t_pl = t_pl;
            this.b_val = b_val;
            this.b_azim = b_azim;
            this.b_pl = b_pl;
            this.p_val = p_val;
            this.p_azim = p_azim;
            this.p_pl = p_pl;
            this.author = author;
        }
    }

    public static class AxesError {
        public float t_val_unc;
        public float t_azim_unc;
        public float t_pl_unc;
        public float b_val_unc;
        public float b_azim_unc;
        public float b_pl_unc;
        public float p_val_unc;
        public float p_azim_unc;
        public float p_pl_unc;
        public float fclvd;

        public AxesError() {
        }

        public AxesError(float t_val_unc, float t_azim_unc, float t_pl_unc, float b_val_unc, float b_azim_unc, float b_pl_unc, float p_val_unc, float p_azim_unc, float p_pl_unc, float fclvd) {
            this.t_val_unc = t_val_unc;
            this.t_azim_unc = t_azim_unc;
            this.t_pl_unc = t_pl_unc;
            this.b_val_unc = b_val_unc;
            this.b_azim_unc = b_azim_unc;
            this.b_pl_unc = b_pl_unc;
            this.p_val_unc = p_val_unc;
            this.p_azim_unc = p_azim_unc;
            this.p_pl_unc = p_pl_unc;
            this.fclvd = fclvd;
        }
    }

    public static class Effects {
        public String heard;
        public String felt;
        public String damage;
        public String casualties;
        public String uplift;
        public String subsidence;
        public String fault;
        public String tsunami;
        public String seiche;
        public String volcano;
        public String acoustic;
        public String gravity;
        public String t_wave;
        public String liquification;
        public String geyser;
        public String landslide;
        public String sandblow;
        public String cracks;
        public String lights;
        public String odours;
        public String loctype;
        public float lat;
        public float lon;
        public float dist;
        public float azim;
        public String country;
        public String postcode;
        public String net;
        public String sta;
        public float intensity1;
        public String modifier;
        public float intensity2;
        public String scale;
        public String author;

        public Effects() {
        }

        public Effects(String heard, String felt, String damage, String casualties, String uplift, String subsidence, String fault, String tsunami, String seiche, String volcano, String acoustic, String gravity, String t_wave, String liquification, String geyser, String landslide, String sandblow, String cracks, String lights, String odours, String loctype, float lat, float lon, float dist, float azim, String country, String postcode, String net, String sta, float intensity1, String modifier, float intensity2, String scale, String author) {
            this.heard = heard;
            this.felt = felt;
            this.damage = damage;
            this.casualties = casualties;
            this.uplift = uplift;
            this.subsidence = subsidence;
            this.fault = fault;
            this.tsunami = tsunami;
            this.seiche = seiche;
            this.volcano = volcano;
            this.acoustic = acoustic;
            this.gravity = gravity;
            this.t_wave = t_wave;
            this.liquification = liquification;
            this.geyser = geyser;
            this.landslide = landslide;
            this.sandblow = sandblow;
            this.cracks = cracks;
            this.lights = lights;
            this.odours = odours;
            this.loctype = loctype;
            this.lat = lat;
            this.lon = lon;
            this.dist = dist;
            this.azim = azim;
            this.country = country;
            this.postcode = postcode;
            this.net = net;
            this.sta = sta;
            this.intensity1 = intensity1;
            this.modifier = modifier;
            this.intensity2 = intensity2;
            this.scale = scale;
            this.author = author;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Event {
        public String evid;
        public String region;
        public List<Origin> origList;

        public Event() {
        }

        public Event(String evid, String region, List<Origin> origList) {
            this.evid = evid;
            this.region = region;
            this.origList = origList;
        }

        public boolean parseEventId(String line) {
            if (!line.startsWith("Event ") && !line.startsWith("EVENT ")) {
                logger.warn((Object)String.format("not an event title line: %s", line));
                return false;
            }
            this.evid = line.substring(6, 14).trim();
            if (!ISF.noSpace(this.evid)) {
                logger.warn((Object)String.format("bad evid: %s", line));
                return false;
            }
            if (line.length() < 16) {
                return true;
            }
            if (line.charAt(14) != ' ') {
                logger.warn((Object)String.format("bad format, char 15: %s", line));
                return false;
            }
            this.region = line.substring(15).trim();
            return true;
        }
    }

    public static class FaultPlane {
        public String f_type;
        public float strike;
        public float dip;
        float rake;
        public int np;
        public int ns;
        public String f_plane;
        public String author;

        public FaultPlane() {
        }

        public FaultPlane(String f_type, float strike, float dip, float rake, int np, int ns, String f_plane, String author) {
            this.f_type = f_type;
            this.strike = strike;
            this.dip = dip;
            this.rake = rake;
            this.np = np;
            this.ns = ns;
            this.f_plane = f_plane;
            this.author = author;
        }
    }

    public static class MomentTensor1 {
        public int scale_factor;
        public float scalar_moment;
        public float fclvd;
        public float mrr;
        public float mtt;
        public float mpp;
        public float mrt;
        public float mtp;
        public float mpr;
        public int nsta1;
        public int nsta2;
        public String author;

        public MomentTensor1() {
        }

        public MomentTensor1(int scale_factor, float scalar_moment, float fclvd, float mrr, float mtt, float mpp, float mrt, float mtp, float mpr, int nsta1, int nsta2, String author) {
            this.scale_factor = scale_factor;
            this.scalar_moment = scalar_moment;
            this.fclvd = fclvd;
            this.mrr = mrr;
            this.mtt = mtt;
            this.mpp = mpp;
            this.mrt = mrt;
            this.mtp = mtp;
            this.mpr = mpr;
            this.nsta1 = nsta1;
            this.nsta2 = nsta2;
            this.author = author;
        }
    }

    public static class MomentTensor2 {
        public float scalar_moment_unc;
        public float fclvd_unc;
        public float mrr_unc;
        public float mtt_unc;
        public float mpp_unc;
        public float mrt_unc;
        public float mtp_unc;
        public float mpr_unc;
        public int ncomp1;
        public int ncomp2;
        public float duration;

        public MomentTensor2() {
        }

        public MomentTensor2(float scalar_moment_unc, float fclvd_unc, float mrr_unc, float mtt_unc, float mpp_unc, float mrt_unc, float mtp_unc, float mpr_unc, int ncomp1, int ncomp2, float duration) {
            this.scalar_moment_unc = scalar_moment_unc;
            this.fclvd_unc = fclvd_unc;
            this.mrr_unc = mrr_unc;
            this.mtt_unc = mtt_unc;
            this.mpp_unc = mpp_unc;
            this.mrt_unc = mrt_unc;
            this.mtp_unc = mtp_unc;
            this.mpr_unc = mpr_unc;
            this.ncomp1 = ncomp1;
            this.ncomp2 = ncomp2;
            this.duration = duration;
        }
    }

    public static class NetMag {
        public String magtype;
        public String magind;
        public float mag;
        public float magerr;
        public int nsta;
        public String author;
        public String origid;

        public NetMag() {
        }

        public NetMag(String magtype, String magind, float mag, float magerr, int nsta, String author, String origid) {
            this.magtype = magtype;
            this.magind = magind;
            this.mag = mag;
            this.magerr = magerr;
            this.nsta = nsta;
            this.author = author;
            this.origid = origid;
        }
    }

    public static class Origin {
        private static final String head = "   Date       Time        Err   RMS Latitude Longitude  Smaj  Smin  Az Depth   Err Ndef Nsta Gap  mdist  Mdist Qual   Author      OrigID";
        public String line;
        public int yyyy;
        public int mm;
        public int dd;
        public int hh;
        public int mi;
        public int ss;
        public int msec;
        public char timfix;
        public float stime;
        public float sdobs;
        public float lat;
        public float lon;
        public char epifix;
        public float smaj;
        public float smin;
        public int strike;
        public float depth;
        public char depfix;
        public float sdepth;
        public int ndef;
        public int nsta;
        public int gap;
        public float mindist;
        public float maxdist;
        public String antype;
        public String loctype;
        public String etype;
        public String author;
        public String origid;

        public Origin() {
        }

        public Origin(String line, int yyyy, int mm, int dd, int hh, int mi, int ss, int msec, char timfix, float stime, float sdobs, float lat, float lon, char epifix, float smaj, float smin, int strike, float depth, char depfix, float sdepth, int ndef, int nsta, int gap, float mindist, float maxdist, String antype, String loctype, String etype, String author, String origid) {
            this.line = line;
            this.yyyy = yyyy;
            this.mm = mm;
            this.dd = dd;
            this.hh = hh;
            this.mi = mi;
            this.ss = ss;
            this.msec = msec;
            this.timfix = timfix;
            this.stime = stime;
            this.sdobs = sdobs;
            this.lat = lat;
            this.lon = lon;
            this.epifix = epifix;
            this.smaj = smaj;
            this.smin = smin;
            this.strike = strike;
            this.depth = depth;
            this.depfix = depfix;
            this.sdepth = sdepth;
            this.ndef = ndef;
            this.nsta = nsta;
            this.gap = gap;
            this.mindist = mindist;
            this.maxdist = maxdist;
            this.antype = antype;
            this.loctype = loctype;
            this.etype = etype;
            this.author = author;
            this.origid = origid;
        }

        public boolean parseOriginHead(String line) {
            boolean match = line.equals(head);
            if (!match) {
                logger.warn((Object)String.format("not an origin header: %s", line));
            }
            return match;
        }

        public boolean parseOrigin(String line) {
            String tmp;
            if (line.length() < 136) {
                logger.warn((Object)String.format("Length less than 136,not Origin line: %s", line));
                return false;
            }
            try {
                this.yyyy = Integer.parseInt(line.substring(0, 4).trim());
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad year: %s", line));
                return false;
            }
            if (line.charAt(4) != '/') {
                logger.warn((Object)String.format("bad date: %s", line));
                return false;
            }
            try {
                this.mm = Integer.parseInt(line.substring(5, 7).trim());
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad month: %s", line));
                return false;
            }
            if (line.charAt(7) != '/') {
                logger.warn((Object)String.format("bad date: %s", line));
                return false;
            }
            try {
                this.dd = Integer.parseInt(line.substring(8, 10).trim());
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad day: %s", line));
                return false;
            }
            if (line.charAt(10) != ' ') {
                logger.warn((Object)String.format("bad date: %s", line));
                return false;
            }
            try {
                this.hh = Integer.parseInt(line.substring(11, 13).trim());
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad hour: %s", line));
                return false;
            }
            if (line.charAt(13) != ':') {
                logger.warn((Object)String.format("bad date: %s", line));
                return false;
            }
            try {
                this.mi = Integer.parseInt(line.substring(14, 16).trim());
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad minute: %s", line));
                return false;
            }
            if (line.charAt(16) != ':') {
                logger.warn((Object)String.format("bad minute: %s", line));
                return false;
            }
            try {
                this.ss = Integer.parseInt(line.substring(17, 19).trim());
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad second: %s", line));
                return false;
            }
            try {
                tmp = line.substring(19, 22).trim();
                this.msec = tmp.length() != 0 && ISF.noSpace(tmp) ? Math.round(Float.parseFloat(tmp) * 1000.0f) : 9999999;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad msec: %s", line));
                return false;
            }
            if (line.charAt(22) != ' ' && line.charAt(22) != 'f') {
                logger.warn((Object)String.format("bad timfix: %s", line));
                return false;
            }
            this.timfix = line.charAt(22);
            if (line.charAt(23) != ' ') {
                logger.warn((Object)String.format("bad format, char 24: %s", line));
                return false;
            }
            try {
                tmp = line.substring(24, 29).trim();
                this.stime = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad stime: %s", line));
                return false;
            }
            if (line.charAt(29) != ' ') {
                logger.warn((Object)String.format("bad format, char 30: %s", line));
                return false;
            }
            try {
                tmp = line.substring(30, 35).trim();
                this.sdobs = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad sdobs: %s", line));
                return false;
            }
            if (line.charAt(35) != ' ') {
                logger.warn((Object)String.format("bad format, char 36: %s", line));
                return false;
            }
            try {
                tmp = line.substring(36, 44).trim();
                this.lat = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad lat: %s", line));
                return false;
            }
            if (line.charAt(44) != ' ') {
                logger.warn((Object)String.format("bad format, char 45: %s", line));
                return false;
            }
            try {
                tmp = line.substring(45, 54).trim();
                this.lon = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad lon: %s", line));
                return false;
            }
            if (line.charAt(54) != ' ' && line.charAt(54) != 'f') {
                logger.warn((Object)String.format("bad epifix: %s", line));
                return false;
            }
            this.epifix = line.charAt(54);
            try {
                tmp = line.substring(55, 60).trim();
                this.smaj = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad smaj: %s", line));
                return false;
            }
            if (line.charAt(60) != ' ') {
                logger.warn((Object)String.format("bad format, char 61: %s", line));
                return false;
            }
            try {
                tmp = line.substring(61, 66).trim();
                this.smin = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad smin: %s", line));
                return false;
            }
            if (line.charAt(66) != ' ') {
                logger.warn((Object)String.format("bad format, char 67: %s", line));
                return false;
            }
            try {
                tmp = line.substring(67, 70).trim();
                this.strike = tmp.length() != 0 ? Integer.parseInt(tmp) : 9999999;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad strike: %s", line));
                return false;
            }
            if (line.charAt(70) != ' ') {
                logger.warn((Object)String.format("bad format, char 71: %s", line));
                return false;
            }
            try {
                tmp = line.substring(71, 76).trim();
                this.depth = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad depth: %s", line));
                return false;
            }
            if (line.charAt(76) != ' ' && line.charAt(76) != 'f' && line.charAt(76) != 'd') {
                logger.warn((Object)String.format("bad depfix: %s", line));
                return false;
            }
            this.depfix = line.charAt(76);
            if (line.charAt(77) != ' ') {
                logger.warn((Object)String.format("bad format, char 78: %s", line));
                return false;
            }
            try {
                tmp = line.substring(78, 82).trim();
                this.sdepth = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad sdepth: %s", line));
                return false;
            }
            if (line.charAt(82) != ' ') {
                logger.warn((Object)String.format("bad format, char 83: %s", line));
                return false;
            }
            try {
                tmp = line.substring(83, 87).trim();
                this.ndef = tmp.length() != 0 ? Integer.parseInt(tmp) : 9999999;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad ndef: %s", line));
                return false;
            }
            if (line.charAt(87) != ' ') {
                logger.warn((Object)String.format("bad format, char 88: %s", line));
                return false;
            }
            try {
                tmp = line.substring(88, 92).trim();
                this.nsta = tmp.length() != 0 ? Integer.parseInt(tmp) : 9999999;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad nsta: %s", line));
                return false;
            }
            if (line.charAt(92) != ' ') {
                logger.warn((Object)String.format("bad format, char 93: %s", line));
                return false;
            }
            try {
                tmp = line.substring(93, 96).trim();
                this.gap = tmp.length() != 0 ? Integer.parseInt(tmp) : 9999999;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad gap: %s", line));
                return false;
            }
            if (line.charAt(96) != ' ') {
                logger.warn((Object)String.format("bad format, char 97: %s", line));
                return false;
            }
            try {
                tmp = line.substring(97, 103).trim();
                this.mindist = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad mindist: %s", line));
                return false;
            }
            if (line.charAt(103) != ' ') {
                logger.warn((Object)String.format("bad format, char 104: %s", line));
                return false;
            }
            try {
                tmp = line.substring(104, 110).trim();
                this.maxdist = tmp.length() != 0 ? Float.parseFloat(tmp) : 9999999.0f;
            }
            catch (Exception ex) {
                logger.warn((Object)String.format("bad maxdist: %s", line));
                return false;
            }
            if (line.charAt(110) != ' ') {
                logger.warn((Object)String.format("bad format, char 111: %s", line));
                return false;
            }
            if (line.charAt(111) != ' ' && line.charAt(111) != 'a' && line.charAt(111) != 'm' && line.charAt(111) != 'g') {
                logger.warn((Object)String.format("bad antype: %s", line));
                return false;
            }
            this.antype = line.substring(111, 112);
            if (line.charAt(112) != ' ') {
                logger.warn((Object)String.format("bad format, char 113: %s", line));
                return false;
            }
            if (line.charAt(113) != ' ' && line.charAt(113) != 'i' && line.charAt(113) != 'p' && line.charAt(113) != 'g' && line.charAt(113) != 'o') {
                logger.warn((Object)String.format("bad loctype: %s", line));
                return false;
            }
            this.loctype = line.substring(113, 114);
            if (line.charAt(114) != ' ') {
                logger.warn((Object)String.format("bad format, char 115: %s", line));
                return false;
            }
            this.etype = line.substring(115, 117);
            if (this.etype.length() != 2) {
                logger.warn((Object)String.format("bad etype: %s", line));
                return false;
            }
            if (line.charAt(117) != ' ') {
                logger.warn((Object)String.format("bad format, char 118: %s", line));
                return false;
            }
            this.author = line.substring(118, 127).trim();
            if (!ISF.noSpace(this.author)) {
                logger.warn((Object)String.format("bad author: %s", line));
                return false;
            }
            if (line.charAt(127) != ' ') {
                logger.warn((Object)String.format("bad format, char 128: %s", line));
                return false;
            }
            this.origid = line.substring(128, 136).trim();
            if (!ISF.noSpace(this.origid)) {
                logger.warn((Object)String.format("bad origid: %s", line));
                return false;
            }
            if (line.substring(136).length() != 0) {
                logger.warn((Object)String.format("extra characters at end: %s", line));
                return false;
            }
            return true;
        }
    }

    public static class Phase {
        private static final String head = "Sta     Dist  EvAz Phase        Time      TRes  Azim AzRes   Slow   SRes Def   SNR       Amp   Per Qual Magnitude    ArrID";
        public String sta;
        public float dist;
        public float esaz;
        public String phase;
        public int hh;
        public int mi;
        public int ss;
        public int msec;
        public float timeres;
        public float azim;
        public float azimres;
        public float slow;
        public float slowres;
        public char timedef;
        public char azimdef;
        public char slowdef;
        public float snr;
        public float amp;
        public float per;
        public char picktype;
        public char sp_fm;
        public char detchar;
        public String magtype;
        public String magind;
        public float mag;
        public String arrid;

        public Phase() {
        }

        public Phase(String sta, float dist, float esaz, String phase, int hh, int mi, int ss, int msec, float timeres, float azim, float azimres, float slow, float slowres, char timedef, char azimdef, char slowdef, float snr, float amp, float per, char picktype, char sp_fm, char detchar, String magtype, String magind, float mag, String arrid) {
            this.sta = sta;
            this.dist = dist;
            this.esaz = esaz;
            this.phase = phase;
            this.hh = hh;
            this.mi = mi;
            this.ss = ss;
            this.msec = msec;
            this.timeres = timeres;
            this.azim = azim;
            this.azimres = azimres;
            this.slow = slow;
            this.slowres = slowres;
            this.timedef = timedef;
            this.azimdef = azimdef;
            this.slowdef = slowdef;
            this.snr = snr;
            this.amp = amp;
            this.per = per;
            this.picktype = picktype;
            this.sp_fm = sp_fm;
            this.detchar = detchar;
            this.magtype = magtype;
            this.magind = magind;
            this.mag = mag;
            this.arrid = arrid;
        }

        public boolean parsePhaseHead(String line) {
            boolean match = line.equals(head);
            if (!match) {
                logger.warn((Object)String.format("Not an phase header: %s", line));
            }
            return match;
        }

        public boolean parsePhase(String line) {
            block89: {
                String tmp;
                block88: {
                    if (line.length() < 122) {
                        logger.warn((Object)String.format("Length less than 136,not Phase line: %s", line));
                        return false;
                    }
                    try {
                        tmp = line.substring(0, 5).trim();
                        if (tmp.length() != 0 && ISF.noSpace(tmp)) {
                            this.sta = tmp;
                            break block88;
                        }
                        logger.warn((Object)String.format("bad sta: %s", line));
                        return false;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("missing sta: %s", line));
                        return false;
                    }
                }
                if (line.charAt(5) != ' ') {
                    logger.warn((Object)String.format("bad format, char 6: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(6, 12).trim();
                    this.dist = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad ditance: %s", line));
                    return false;
                }
                if (line.charAt(12) != ' ') {
                    logger.warn((Object)String.format("bad format, char 13: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(13, 18).trim();
                    this.esaz = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad ditance: %s", line));
                    return false;
                }
                if (line.charAt(18) != ' ') {
                    logger.warn((Object)String.format("bad format, char 19: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(19, 27).trim();
                    this.phase = tmp.length() != 0 && ISF.noSpace(tmp) ? tmp : "";
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad phase: %s", line));
                    return false;
                }
                if (line.charAt(27) != ' ') {
                    logger.warn((Object)String.format("bad format, char 28: %s", line));
                    return false;
                }
                if (line.substring(28, 40).trim().length() != 0) {
                    try {
                        tmp = line.substring(28, 30).trim();
                        this.hh = tmp.length() != 0 && ISF.noSpace(tmp) ? Integer.parseInt(tmp) : 9999999;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("missing hour: %s", line));
                        return false;
                    }
                    if (line.charAt(30) != ':') {
                        logger.warn((Object)String.format("bad date: %s", line));
                        return false;
                    }
                    try {
                        tmp = line.substring(31, 33).trim();
                        this.mi = tmp.length() != 0 && ISF.noSpace(tmp) ? Integer.parseInt(tmp) : 9999999;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("missing minute: %s", line));
                        return false;
                    }
                    if (line.charAt(33) != ':') {
                        logger.warn((Object)String.format("bad date: %s", line));
                        return false;
                    }
                    try {
                        tmp = line.substring(34, 36).trim();
                        this.ss = tmp.length() != 0 && ISF.noSpace(tmp) ? Integer.parseInt(tmp) : 9999999;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("missing second: %s", line));
                        return false;
                    }
                    try {
                        tmp = line.substring(36, 40).trim();
                        if (tmp.length() != 0 && ISF.noSpace(tmp)) {
                            this.msec = Math.round(Float.parseFloat(tmp) * 1000.0f);
                        }
                        this.msec = 9999999;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("bad msec: %s", line));
                        return false;
                    }
                } else {
                    this.hh = 9999999;
                    this.mi = 9999999;
                    this.ss = 9999999;
                    this.msec = 9999999;
                }
                if (line.charAt(40) != ' ') {
                    logger.warn((Object)String.format("bad format, char 41: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(41, 46).trim();
                    this.timeres = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad timeres: %s", line));
                    return false;
                }
                if (line.charAt(46) != ' ') {
                    logger.warn((Object)String.format("bad format, char 47: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(47, 52).trim();
                    this.azim = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad azim: %s", line));
                    return false;
                }
                if (line.charAt(52) != ' ') {
                    logger.warn((Object)String.format("bad format, char 53: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(53, 58).trim();
                    this.azimres = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad azimres: %s", line));
                    return false;
                }
                if (line.charAt(58) != ' ') {
                    logger.warn((Object)String.format("bad format, char 59: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(59, 65).trim();
                    this.slow = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad slow: %s", line));
                    return false;
                }
                if (line.charAt(65) != ' ') {
                    logger.warn((Object)String.format("bad format, char 66: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(66, 72).trim();
                    this.slowres = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad slowres: %s", line));
                    return false;
                }
                if (line.charAt(72) != ' ') {
                    logger.warn((Object)String.format("bad format, char 73: %s", line));
                    return false;
                }
                if (line.charAt(73) == 'T' || line.charAt(73) == '_') {
                    this.timedef = line.charAt(73);
                } else if (line.charAt(73) == ' ') {
                    this.timedef = (char)95;
                } else {
                    logger.warn((Object)String.format("bad timedef flag: %s", line));
                    return false;
                }
                if (line.charAt(74) == 'A' || line.charAt(74) == '_') {
                    this.azimdef = line.charAt(74);
                } else if (line.charAt(74) == ' ') {
                    this.azimdef = (char)95;
                } else {
                    logger.warn((Object)String.format("bad azimdef flag: %s", line));
                    return false;
                }
                if (line.charAt(75) == 'S' || line.charAt(75) == '_') {
                    this.slowdef = line.charAt(75);
                } else if (line.charAt(75) == ' ') {
                    this.slowdef = (char)95;
                } else {
                    logger.warn((Object)String.format("bad slowdef flag: %s", line));
                    return false;
                }
                if (line.charAt(76) != ' ') {
                    logger.warn((Object)String.format("bad format, char 77: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(77, 82).trim();
                    this.snr = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad snr: %s", line));
                    return false;
                }
                if (line.charAt(82) != ' ') {
                    logger.warn((Object)String.format("bad format, char 83: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(83, 92).trim();
                    this.amp = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad amp: %s", line));
                    return false;
                }
                if (line.charAt(92) != ' ') {
                    logger.warn((Object)String.format("bad format, char 93: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(93, 99).trim();
                    this.per = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad per: %s", line));
                    return false;
                }
                if (line.charAt(98) != ' ') {
                    logger.warn((Object)String.format("bad format, char 99: %s", line));
                    return false;
                }
                if (line.charAt(99) == 'a' || line.charAt(99) == 'm' || line.charAt(99) == '_') {
                    this.picktype = line.charAt(99);
                } else if (line.charAt(99) == ' ') {
                    this.picktype = (char)95;
                } else {
                    logger.warn((Object)String.format("bad picktype: %s", line));
                    return false;
                }
                if (line.charAt(100) == 'c' || line.charAt(100) == 'd' || line.charAt(100) == '_') {
                    this.sp_fm = line.charAt(100);
                } else if (line.charAt(100) == ' ') {
                    this.sp_fm = (char)95;
                } else {
                    logger.warn((Object)String.format("bad sp_fm: %s", line));
                    return false;
                }
                if (line.charAt(101) == 'i' || line.charAt(101) == 'e' || line.charAt(101) == 'q' || line.charAt(101) == '_') {
                    this.detchar = line.charAt(101);
                } else if (line.charAt(101) == ' ') {
                    this.detchar = (char)95;
                } else {
                    logger.warn((Object)String.format("bad detchar: %s", line));
                    return false;
                }
                if (line.charAt(102) != ' ') {
                    logger.warn((Object)String.format("bad format, char 103: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(59, 65).trim();
                    this.magtype = tmp.length() != 0 && ISF.noSpace(tmp) ? tmp : "";
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad magtype: %s", line));
                    return false;
                }
                if (line.charAt(108) != ' ' && line.charAt(108) != '<' && line.charAt(108) != '>') {
                    logger.warn((Object)String.format("bad magind: %s", line));
                    return false;
                }
                this.magind = line.substring(108, 109);
                try {
                    tmp = line.substring(109, 113).trim();
                    this.mag = tmp.length() != 0 && ISF.noSpace(tmp) ? Float.parseFloat(tmp) : 9999999.0f;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("bad mag: %s", line));
                    return false;
                }
                if (line.charAt(113) != ' ') {
                    logger.warn((Object)String.format("bad format, char 114: %s", line));
                    return false;
                }
                try {
                    tmp = line.substring(114, 122).trim();
                    if (tmp.length() != 0 && ISF.noSpace(tmp)) {
                        this.arrid = tmp;
                        break block89;
                    }
                    logger.warn((Object)String.format("missing arrid: %s", line));
                    return false;
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("missing arrid: %s", line));
                    return false;
                }
            }
            if (line.substring(122).trim().length() != 0) {
                logger.warn((Object)String.format("extra characters at end: %s", line));
                return false;
            }
            return true;
        }
    }

    public static class PhaseCorr {
        public float timecorr;
        public float azcorr;
        public float slowcorr;
        public float ampcorr;
        public float percorr;
        public float magcorr;

        public PhaseCorr() {
        }

        public PhaseCorr(float timecorr, float azcorr, float slowcorr, float ampcorr, float percorr, float magcorr) {
            this.timecorr = timecorr;
            this.azcorr = azcorr;
            this.slowcorr = slowcorr;
            this.ampcorr = ampcorr;
            this.percorr = percorr;
            this.magcorr = magcorr;
        }
    }

    public static class PhaseInfo {
        public String net;
        public String chan;
        public String filter;
        public float filter_min;
        public float filter_max;
        public String phase;
        public int yyyy;
        public int mm;
        public int dd;
        public float time_unc;
        public float time_weight;
        public float azim_unc;
        public float azim_weight;
        public float slow_unc;
        public float slow_weight;
        public float amp_unc;
        public float per_unc;
        public float mag_unc;
        public String author;
        public String arrid;

        public PhaseInfo() {
        }

        public PhaseInfo(String net, String chan, String filter, float filter_min, float filter_max, String phase, int yyyy, int mm, int dd, float time_unc, float time_weight, float azim_unc, float azim_weight, float slow_unc, float slow_weight, float amp_unc, float per_unc, float mag_unc, String author, String arrid) {
            this.net = net;
            this.chan = chan;
            this.filter = filter;
            this.filter_min = filter_min;
            this.filter_max = filter_max;
            this.phase = phase;
            this.yyyy = yyyy;
            this.mm = mm;
            this.dd = dd;
            this.time_unc = time_unc;
            this.time_weight = time_weight;
            this.azim_unc = azim_unc;
            this.azim_weight = azim_weight;
            this.slow_unc = slow_unc;
            this.slow_weight = slow_weight;
            this.amp_unc = amp_unc;
            this.per_unc = per_unc;
            this.mag_unc = mag_unc;
            this.author = author;
            this.arrid = arrid;
        }
    }

    public static class PhaseOriginal {
        public String chan;
        public String sta;
        public int yyyy;
        public int mm;
        public int dd;
        public int hh;
        public int mi;
        public int ss;
        public int msec;
        public float azim;
        public float slow;
        public float amp;
        public float per;
        public float mag;

        public PhaseOriginal() {
        }

        public PhaseOriginal(String chan, String sta, int yyyy, int mm, int dd, int hh, int mi, int ss, int msec, float azim, float slow, float amp, float per, float mag) {
            this.chan = chan;
            this.sta = sta;
            this.yyyy = yyyy;
            this.mm = mm;
            this.dd = dd;
            this.hh = hh;
            this.mi = mi;
            this.ss = ss;
            this.msec = msec;
            this.azim = azim;
            this.slow = slow;
            this.amp = amp;
            this.per = per;
            this.mag = mag;
        }
    }

    public static class Station {
        public String net = "";
        public String sta;
        public String type;
        public float lat;
        public float lon;
        public String coord = "";
        public float elev;
        public String start = "";
        public String stop = "";

        public Station() {
        }

        public Station(String net, String sta, String type, float lat, float lon, String coord, float elev, String start, String stop) {
            this.net = net;
            this.sta = sta;
            this.type = type;
            this.lat = lat;
            this.lon = lon;
            this.coord = coord;
            this.elev = elev;
            this.start = start;
            this.stop = stop;
        }

        public static Station parse(String line) {
            if (line.length() < 81) {
                logger.warn((Object)String.format("bad format, length less than 82: %s", line));
                return null;
            }
            Station sta = new Station();
            sta.net = line.substring(0, 9).trim();
            if (!ISF.noSpace(sta.net)) {
                logger.warn((Object)String.format("bad net: %s", line));
                return null;
            }
            if (line.charAt(9) != ' ') {
                logger.warn((Object)String.format("bad format, char 10: %s", line));
                return null;
            }
            sta.sta = line.substring(10, 15).trim();
            if (!ISF.noSpace(sta.sta)) {
                logger.warn((Object)String.format("bad sta: %s", line));
                return null;
            }
            if (line.charAt(15) != ' ') {
                logger.warn((Object)String.format("bad format, char 16: %s", line));
                return null;
            }
            sta.net = line.substring(16, 20).trim();
            if (!ISF.noSpace(sta.net)) {
                logger.warn((Object)String.format("bad net: %s", line));
                return null;
            }
            if (line.charAt(20) != ' ') {
                logger.warn((Object)String.format("bad format, char 21: %s", line));
                return null;
            }
            sta.lat = Float.parseFloat(line.substring(21, 30).trim());
            if (line.charAt(30) != ' ') {
                logger.warn((Object)String.format("bad format, char 31: %s", line));
                return null;
            }
            sta.lon = Float.parseFloat(line.substring(31, 41).trim());
            if (line.charAt(41) != ' ') {
                logger.warn((Object)String.format("bad format, char 42: %s", line));
                return null;
            }
            sta.coord = line.substring(42, 54).trim();
            try {
                sta.elev = Float.parseFloat(line.substring(54, 60).trim());
            }
            catch (Exception ex) {
                sta.elev = 9999999.0f;
            }
            if (line.charAt(60) != ' ') {
                logger.warn((Object)String.format("bad format, char 61: %s", line));
                return null;
            }
            sta.start = line.substring(61, 71).trim();
            if (line.charAt(71) != ' ') {
                logger.warn((Object)String.format("bad format, char 72: %s", line));
                return null;
            }
            if (line.length() >= 82) {
                sta.stop = line.substring(72, 82).trim();
                if (line.substring(82).trim().length() != 0) {
                    logger.warn((Object)String.format("extra characters at end: %s", line));
                    return null;
                }
            } else {
                sta.stop = "";
            }
            return sta;
        }
    }
}

