/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import JSci.maths.ArrayMath;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.CalMagnitude;
import java.util.ArrayList;

public class AmpFilter {
    private EvtData evt;
    private final float SNR = 3.0f;
    private final float factorOfSigma = 3.0f;
    private final int numberOfZero = 5;

    public AmpFilter() {
    }

    public AmpFilter(EvtData evt) {
        this.evt = evt;
    }

    public void filter() {
        this.filterBySNR();
        this.filterBySigma();
        this.filterByInterruption();
    }

    public void filterBySNR() {
        if (this.evt == null) {
            return;
        }
        int TCN = this.evt.getTCN();
        int chn = 0;
        while (chn < TCN) {
            if (this.evt.hasPhase(chn)) {
                Phase phaseAMP = null;
                for (Phase p : this.evt.getPhases(chn)) {
                    if (p.getPhaType() != 1) continue;
                    phaseAMP = p;
                    break;
                }
                if (phaseAMP != null) {
                    double noiseAmp = this.getNoiseAmp(chn);
                    double amp = this.getMaxPPCount(chn, phaseAMP) / 2.0;
                    if (amp < 0.0 || Math.abs(amp / noiseAmp) < 3.0) {
                        this.removePhaseAMP(this.evt.getNetworkCode(chn), this.evt.getStationCode(chn), this.evt.getAuxId(chn));
                    }
                }
            }
            ++chn;
        }
    }

    public void filterBySigma() {
        String[] allNetSta;
        if (this.evt == null) {
            return;
        }
        ArrayList<StaMag> smList = new ArrayList<StaMag>();
        String[] stringArray = allNetSta = this.evt.getAllNetStation();
        int n = allNetSta.length;
        int n2 = 0;
        while (n2 < n) {
            int[] chns;
            double delta;
            String s = stringArray[n2];
            String[] netSta = s.split("/");
            Phase phaseN = this.evt.getPhase(netSta[0], netSta[1], "SMN");
            Phase phaseE = this.evt.getPhase(netSta[0], netSta[1], "SME");
            CalMagnitude magnitudeInf = new CalMagnitude();
            Phase phaseZ = this.evt.getPhase(netSta[0], netSta[1], "SMZ");
            double ml = magnitudeInf.getML(phaseZ, phaseE, phaseN, delta = this.evt.getStationLocation((chns = this.evt.getChanOrder(netSta[0], netSta[1]))[0]).getDelta() * 111.19);
            if (!Double.isNaN(ml)) {
                smList.add(new StaMag(s, ml));
            }
            ++n2;
        }
        if (smList.size() == 0) {
            return;
        }
        double[] mForCalcu = new double[smList.size()];
        int i = 0;
        while (i < mForCalcu.length) {
            mForCalcu[i] = ((StaMag)smList.get(i)).getMl();
            ++i;
        }
        double multiSigma = 3.0 * ArrayMath.standardDeviation((double[])mForCalcu);
        double mMean = ArrayMath.mean((double[])mForCalcu);
        int i2 = 0;
        while (i2 < smList.size()) {
            if (Math.abs(((StaMag)smList.get(i2)).getMl() - mMean) > multiSigma) {
                String[] netSta = ((StaMag)smList.get(i2)).getSta().split("/");
                this.removePhaseAMP(netSta[0], netSta[1], null);
            }
            ++i2;
        }
    }

    public void filterByInterruption() {
        if (this.evt == null) {
            return;
        }
        int TCN = this.evt.getTCN();
        int chn = 0;
        while (chn < TCN) {
            if (this.evt.hasPhase(chn)) {
                Phase phaseAMP = null;
                for (Phase p : this.evt.getPhases(chn)) {
                    if (p.getPhaType() != 1) continue;
                    phaseAMP = p;
                    break;
                }
                if (phaseAMP != null) {
                    Phase phaseS = this.evt.getTheoreticPhase(chn, "S");
                    if (phaseS == null) {
                        phaseS = this.evt.getTheoreticPhase(chn, "s");
                    }
                    if (phaseS != null) {
                        int start = phaseS.offset;
                        int end = phaseAMP.offset + (int)this.evt.getSampleRate(chn) * 50;
                        end = Math.min(end, this.evt.getSampData(chn).length);
                        int wDatLengh = end - start;
                        double[] wDat = new double[wDatLengh];
                        System.arraycopy(this.evt.getSampData(chn), phaseS.offset, wDat, 0, wDat.length);
                        int zeroNum = 0;
                        double[] dArray = wDat;
                        int n = wDat.length;
                        int n2 = 0;
                        while (n2 < n) {
                            double d = dArray[n2];
                            zeroNum = Math.abs(d - 0.0) < 1.0E-6 ? ++zeroNum : 0;
                            if (zeroNum >= 5) {
                                this.removePhaseAMP(this.evt.getNetworkCode(chn), this.evt.getStationCode(chn), this.evt.getAuxId(chn));
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++chn;
        }
    }

    private double getNoiseAmp(int chn) {
        double noiseAmp = 0.0;
        Phase phaseP = this.evt.getTheoreticPhase(chn, "P");
        if (phaseP == null) {
            phaseP = this.evt.getTheoreticPhase(chn, "p");
        }
        if (phaseP == null) {
            noiseAmp = ArrayMath.standardDeviation((double[])this.evt.getSampData(chn));
        } else {
            int wDatLengh = Math.min((int)this.evt.getSampleRate(chn) * 180, phaseP.offset);
            double[] wDat = new double[wDatLengh];
            System.arraycopy(this.evt.getSampData(chn), phaseP.offset - wDatLengh, wDat, 0, wDat.length);
            noiseAmp = ArrayMath.standardDeviation((double[])wDat);
        }
        return noiseAmp;
    }

    private double getMaxPPCount(int chn, Phase phase) {
        double[] wDat = this.evt.getSampData(chn);
        int start = phase.offset - phase.iPeriod / 2;
        int end = phase.offset + phase.iPeriod / 2;
        if (start < 0 || end > wDat.length) {
            return -1.0;
        }
        int minIndex = start;
        int maxIndex = start;
        int j = start;
        while (j < end) {
            if (wDat[minIndex] <= wDat[j]) {
                if (wDat[maxIndex] <= wDat[j]) {
                    maxIndex = j;
                }
            } else {
                minIndex = j;
            }
            ++j;
        }
        return wDat[maxIndex] - wDat[minIndex];
    }

    private void removePhaseAMP(String net, String sta, String locId) {
        int[] chns;
        int[] nArray = chns = this.evt.getChanOrder(net, sta);
        int n = chns.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            int j = this.evt.getPhases(i).size() - 1;
            while (j >= 0) {
                Phase p = this.evt.getPhases(i).get(j);
                if (p.getPhaType() == 1 && (locId == null || p.getLocId().equals(locId))) {
                    this.evt.getPhases(i).remove(j);
                }
                --j;
            }
            ++n2;
        }
    }

    public EvtData getEvt() {
        return this.evt;
    }

    public void setEvt(EvtData evt) {
        this.evt = evt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StaMag
    implements Comparable<StaMag> {
        private String sta;
        private Double ml;

        public StaMag(String sta, Double ml) {
            this.sta = sta;
            this.ml = ml;
        }

        @Override
        public int compareTo(StaMag s) {
            return this.ml.compareTo(s.ml);
        }

        public String getSta() {
            return this.sta;
        }

        public Double getMl() {
            return this.ml;
        }

        public void setSta(String sta) {
            this.sta = sta;
        }

        public void setMl(Double ml) {
            this.ml = ml;
        }
    }
}

