/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import JSci.maths.ArrayMath;
import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.LocationMath;
import cn.org.gddsn.seis.location.PeriodBound;
import cn.org.gddsn.signal.seismograph.Emulate;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AutoMag {
    static Logger logger = Logger.getLogger(AutoMag.class);
    private static int MS_MIN_DIST = 10;
    private static int MS_MAX_DIST = 150;
    private static int MS_STEP = 5;
    private static double[] AIRY_sigma = new double[]{4.5, 7.0, 9.5, 11.0, 13.5, 15.5, 18.5, 21.0, 24.0, 26.0, 28.5, 31.0, 33.0, 35.0, 37.0, 39.5, 42.0, 43.0, 45.5, 47.5, 48.5, 53.0, 55.0, 57.0, 60.0, 62.0, 64.0, 67.0, 70.0, 73.0};
    private static double ML_STEP = 0.5;
    private static double[] RICHARD_sigma = new double[]{8.0, 30.0, 30.0, 30.0, 40.0, 50.0, 65.0, 90.0, 100.0, 110.0, 130.0, 160.0, 170.0, 180.0, 200.0, 200.0, 210.0, 230.0, 240.0, 250.0, 280.0, 290.0};
    private static double[] DELAY_TIME = new double[]{2.0, 4.0, 6.0, 8.0, 12.0, 20.0, 40.0};
    private EvtData evt;

    public static double getDelayTime(double delta, double mag) {
        int imag = (int)Math.round(mag) - 2;
        if (imag < 0) {
            imag = 0;
        }
        if (imag > 6) {
            imag = 6;
        }
        if (delta < (double)MS_MIN_DIST) {
            int idist = (int)delta;
            int idx = (int)((double)idist / ML_STEP);
            double d = (delta - (double)idx * ML_STEP) / ML_STEP;
            double min = (RICHARD_sigma[idx] + (d *= RICHARD_sigma[idx + 1] - RICHARD_sigma[idx])) / 60.0;
            return min + DELAY_TIME[imag];
        }
        int idist = (int)delta;
        if (idist > MS_MAX_DIST) {
            idist = MS_MAX_DIST;
        }
        int idx = (idist - MS_MIN_DIST) / MS_STEP;
        double d = (delta - (double)MS_MIN_DIST - (double)(idx * MS_STEP)) / (double)MS_STEP;
        double min = AIRY_sigma[idx] + (d *= AIRY_sigma[idx + 1] - AIRY_sigma[idx]);
        return min + DELAY_TIME[imag];
    }

    public void autoMeasure() {
        this.autoMeasureMl();
        this.autoMeasureMB();
        this.autoMeasureMs();
    }

    public void autoMeasureAfterEmulateWA() {
        this.autoMeasureMlAfterEmulateWA();
        this.autoMeasureMBAfterEmulateWA();
        this.autoMeasureMsAfterEmulateWA();
    }

    public void autoMeasureMB() {
        int TCN = this.evt.getTCN();
        PeriodBoundMB pb = new PeriodBoundMB();
        int chn = 0;
        while (chn < TCN) {
            double delta = this.evt.getStationLocation(chn).getDelta();
            int idist = (int)Math.round(delta);
            if (idist >= 16 && idist <= 120) {
                Phase phaseP = this.evt.getPhase(chn, "P");
                Phase phasePMZ = this.evt.getPhase(chn, "PMZ");
                if (phaseP != null && phasePMZ == null) {
                    double mean;
                    double[] wdat = this.evt.getSampData(chn);
                    double sr = this.evt.getSampleRate(chn);
                    int start = phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    int end = phaseP.offset + (int)(sr * 5.0);
                    int max = this.evt.getMaxPPCountWithPeriod(chn, start = Math.max(0, start), end = Math.min(end, wdat.length), mean = this.evt.getMean(chn, start, end), pb);
                    double[] par = LocationMath.measurePeriod(wdat, max, start, end, sr, mean);
                    if (pb.accept(par)) {
                        phasePMZ = new Phase();
                        phasePMZ.setPhaseName("PMZ");
                        phasePMZ.setMagName("MB");
                        phasePMZ.setStationCode(this.evt.getStationCode(chn));
                        phasePMZ.setBelongedChannelID(this.evt.toComp(chn) - 1);
                        phasePMZ.setChanCode(this.evt.getChannelCode(chn));
                        phasePMZ.setRecType(this.evt.getOriginalType(chn));
                        phasePMZ.setInstrumentName(this.evt.getInstrumentType(chn));
                        phasePMZ.setNetCode(this.evt.getNetworkCode(chn));
                        phasePMZ.setLocId(this.evt.getAuxId(chn));
                        phasePMZ.setPhaType(1);
                        phasePMZ.setAmpType(0);
                        phasePMZ.offset = max;
                        phasePMZ.iPeriod = (int)(sr * par[0]);
                        phasePMZ.setPeriod(par[0]);
                        double amp = this.evt.getMaxPPCount(chn, phasePMZ.offset - phasePMZ.iPeriod / 2, phasePMZ.offset + phasePMZ.iPeriod / 2) / 2.0;
                        phasePMZ.setAmp(amp / this.evt.getCalibFactor(chn));
                        long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phasePMZ.offset * 1000L) / sr);
                        phasePMZ.setPhaseTime(new Date(date));
                        this.evt.getPhases(chn).addElement(phasePMZ);
                    }
                }
            }
            ++chn;
        }
    }

    public void autoMeasureMBAfterEmulateWA() {
        int TCN = this.evt.getTCN();
        PeriodBoundMB pb = new PeriodBoundMB();
        int chn = 0;
        while (chn < TCN) {
            double delta = this.evt.getStationLocation(chn).getDelta();
            int idist = (int)Math.round(delta);
            if (idist >= 16 && idist <= 120) {
                Phase phaseP = this.evt.getPhase(chn, "P");
                Phase phasePMZ = this.evt.getPhase(chn, "PMZ");
                if (phaseP != null && phasePMZ == null) {
                    double[] wdat = this.evt.getSampData(chn);
                    double sr = this.evt.getSampleRate(chn);
                    int start = phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    int end = phaseP.offset + (int)(sr * 5.0);
                    if (this.evt.hasGapsData(chn, start = Math.max(0, start), end = Math.min(end, wdat.length))) {
                        logger.info((Object)String.format("Ignore channel %s as gapsing data", this.evt.getChannelLocator(chn).toDotString()));
                    } else if (this.evt.hasClippingData(chn, start, end)) {
                        logger.info((Object)String.format("Ignore channel %s as clipping data", this.evt.getChannelLocator(chn).toDotString()));
                    } else {
                        double noiseMean = this.getNoiseMean(chn);
                        Emulate emulate = new Emulate();
                        List<double[]> result = emulate.emulateWA(this.evt, chn, start, end, noiseMean);
                        double[] wDat = result.get(0);
                        double calibFactor = result.get(1)[0];
                        double sum = 0.0;
                        int i = 0;
                        while (i < wDat.length) {
                            sum += wDat[i];
                            ++i;
                        }
                        double mean = sum / (double)wDat.length;
                        int max = this.getMaxCountIndex(sr, wDat, mean, pb);
                        double[] par = LocationMath.measurePeriod(wDat, max, 0, wDat.length, sr, mean);
                        if (pb.accept(par)) {
                            phasePMZ = new Phase();
                            phasePMZ.setPhaseName("PMZ");
                            phasePMZ.setMagName("MB");
                            phasePMZ.setStationCode(this.evt.getStationCode(chn));
                            phasePMZ.setBelongedChannelID(this.evt.toComp(chn) - 1);
                            phasePMZ.setChanCode(this.evt.getChannelCode(chn));
                            phasePMZ.setRecType(0);
                            phasePMZ.setInstrumentName("W.A.");
                            phasePMZ.setNetCode(this.evt.getNetworkCode(chn));
                            phasePMZ.setLocId(this.evt.getAuxId(chn));
                            phasePMZ.setPhaType(1);
                            phasePMZ.setAmpType(0);
                            phasePMZ.offset = start + max;
                            phasePMZ.iPeriod = (int)(sr * par[0]);
                            phasePMZ.setPeriod(par[0]);
                            double amp = this.getMaxPPCount(wDat, max - phasePMZ.iPeriod / 2, max + phasePMZ.iPeriod / 2) / 2.0;
                            phasePMZ.setAmp(amp / calibFactor);
                            long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phasePMZ.offset * 1000L) / sr);
                            phasePMZ.setPhaseTime(new Date(date));
                            this.evt.getPhases(chn).addElement(phasePMZ);
                        }
                    }
                }
            }
            ++chn;
        }
    }

    public static double getAiryWaveMaxAmpTime(double delta) {
        int idist = (int)delta;
        if (idist < MS_MIN_DIST || idist > MS_MAX_DIST) {
            return Double.NaN;
        }
        int idx = (idist - MS_MIN_DIST) / MS_STEP;
        double d = (delta - (double)MS_MIN_DIST - (double)(idx * MS_STEP)) / (double)MS_STEP;
        double second = (int)((AIRY_sigma[idx] + (d *= AIRY_sigma[idx + 1] - AIRY_sigma[idx])) * 60.0);
        return second;
    }

    public void autoMeasureMs() {
        int TCN = this.evt.getTCN();
        PeriodBoundMs pb = new PeriodBoundMs();
        int chn = 0;
        while (chn < TCN) {
            block8: {
                double mean;
                int max;
                double[] par;
                double sr;
                int end;
                int start;
                double[] wdat;
                Phase phaseAMP;
                String ampName;
                block9: {
                    String sta;
                    double delta = this.evt.getStationLocation(chn).getDelta();
                    double sec = AutoMag.getAiryWaveMaxAmpTime(delta);
                    if (Double.isNaN(sec)) break block8;
                    int second = (int)sec;
                    String chan = this.evt.getChannelCode(chn);
                    if (chan.endsWith("Z") && this.evt.isThreeComp(chn)) break block8;
                    ampName = "LE";
                    if (chan.endsWith("N")) {
                        ampName = "LN";
                    }
                    if (chan.endsWith("Z")) {
                        ampName = "LZ";
                    }
                    Phase[] theoreticPhases = this.getFrontTheoreticPhase(chn);
                    Phase phaseP = theoreticPhases[0];
                    Phase phaseS = theoreticPhases[1];
                    phaseAMP = this.evt.getPhase(chn, ampName);
                    String net = this.evt.getNetworkCode(chn);
                    if (!this.evt.hasPhase(net, sta = this.evt.getStationCode(chn)) || phaseAMP != null) break block8;
                    wdat = this.evt.getSampData(chn);
                    start = 0;
                    end = wdat.length;
                    sr = this.evt.getSampleRate(chn);
                    if (phaseP == null) break block9;
                    phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    start = Math.max(0, phaseP.offset + (int)((double)(second - 120) * sr));
                    if (phaseS != null) {
                        start = Math.max(start, phaseS.offset);
                    }
                    end = Math.min(phaseP.offset + (int)((double)(second + 120) * sr), wdat.length);
                    if ((start = Math.max(0, start)) > (end = Math.min(end, wdat.length))) break block8;
                }
                if (pb.accept(par = LocationMath.measurePeriod(wdat, max = this.evt.getMaxPPCountWithPeriod(chn, start, end, mean = this.evt.getMean(chn, start, end), pb), start, end, sr, mean))) {
                    phaseAMP = new Phase();
                    phaseAMP.setPhaseName(ampName);
                    phaseAMP.setMagName("Ms");
                    phaseAMP.setStationCode(this.evt.getStationCode(chn));
                    phaseAMP.setBelongedChannelID(this.evt.toComp(chn) - 1);
                    phaseAMP.setChanCode(this.evt.getChannelCode(chn));
                    phaseAMP.setRecType(this.evt.getOriginalType(chn));
                    phaseAMP.setInstrumentName(this.evt.getInstrumentType(chn));
                    phaseAMP.setNetCode(this.evt.getNetworkCode(chn));
                    phaseAMP.setLocId(this.evt.getAuxId(chn));
                    phaseAMP.setPhaType(1);
                    phaseAMP.setAmpType(0);
                    phaseAMP.offset = max;
                    phaseAMP.iPeriod = (int)(sr * par[0]);
                    phaseAMP.setPeriod(par[0]);
                    double amp = this.evt.getMaxPPCount(chn, phaseAMP.offset - phaseAMP.iPeriod / 2, phaseAMP.offset + phaseAMP.iPeriod / 2) / 2.0;
                    phaseAMP.setAmp(amp / this.evt.getCalibFactor(chn));
                    long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phaseAMP.offset * 1000L) / sr);
                    phaseAMP.setPhaseTime(new Date(date));
                    this.evt.getPhases(chn).addElement(phaseAMP);
                }
            }
            ++chn;
        }
    }

    public void autoMeasureMsAfterEmulateWA() {
        int TCN = this.evt.getTCN();
        PeriodBoundMs pb = new PeriodBoundMs();
        int chn = 0;
        while (chn < TCN) {
            block13: {
                double sr;
                int end;
                int start;
                Phase phaseAMP;
                String ampName;
                block14: {
                    String sta;
                    double delta = this.evt.getStationLocation(chn).getDelta();
                    double sec = AutoMag.getAiryWaveMaxAmpTime(delta);
                    if (Double.isNaN(sec)) break block13;
                    int second = (int)sec;
                    String chan = this.evt.getChannelCode(chn);
                    if (chan.endsWith("Z") && this.evt.isThreeComp(chn)) break block13;
                    ampName = "LE";
                    if (chan.endsWith("N")) {
                        ampName = "LN";
                    }
                    if (chan.endsWith("Z")) {
                        ampName = "LZ";
                    }
                    Phase[] theoreticPhases = this.getFrontTheoreticPhase(chn);
                    Phase phaseP = theoreticPhases[0];
                    Phase phaseS = theoreticPhases[1];
                    phaseAMP = this.evt.getPhase(chn, ampName);
                    String net = this.evt.getNetworkCode(chn);
                    if (!this.evt.hasPhase(net, sta = this.evt.getStationCode(chn)) || phaseAMP != null) break block13;
                    double[] wdat = this.evt.getSampData(chn);
                    start = 0;
                    end = wdat.length;
                    sr = this.evt.getSampleRate(chn);
                    if (phaseP == null) break block14;
                    phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    start = Math.max(0, phaseP.offset + (int)((double)(second - 120) * sr));
                    if (phaseS != null) {
                        start = Math.max(start, phaseS.offset);
                    }
                    end = Math.min(phaseP.offset + (int)((double)(second + 120) * sr), wdat.length);
                    if ((start = Math.max(0, start)) > (end = Math.min(end, wdat.length))) break block13;
                }
                if (this.evt.hasGapsData(chn, start, end)) {
                    logger.info((Object)String.format("Ignore channel %s as gapsing data", this.evt.getChannelLocator(chn).toDotString()));
                } else if (this.evt.hasClippingData(chn, start, end)) {
                    logger.info((Object)String.format("Ignore channel %s as clipping data", this.evt.getChannelLocator(chn).toDotString()));
                } else {
                    double noiseMean = this.getNoiseMean(chn);
                    Emulate emulate = new Emulate();
                    List<double[]> result = emulate.emulateWA(this.evt, chn, start, end, noiseMean);
                    double[] wDat = result.get(0);
                    double calibFactor = result.get(1)[0];
                    double sum = 0.0;
                    int i = 0;
                    while (i < wDat.length) {
                        sum += wDat[i];
                        ++i;
                    }
                    double mean = sum / (double)wDat.length;
                    int max = this.getMaxCountIndex(sr, wDat, mean, pb);
                    double[] par = LocationMath.measurePeriod(wDat, max, 0, wDat.length, sr, mean);
                    if (pb.accept(par)) {
                        phaseAMP = new Phase();
                        phaseAMP.setPhaseName(ampName);
                        phaseAMP.setMagName("Ms");
                        phaseAMP.setStationCode(this.evt.getStationCode(chn));
                        phaseAMP.setBelongedChannelID(this.evt.toComp(chn) - 1);
                        phaseAMP.setChanCode(this.evt.getChannelCode(chn));
                        phaseAMP.setRecType(0);
                        phaseAMP.setInstrumentName("W.A.");
                        phaseAMP.setNetCode(this.evt.getNetworkCode(chn));
                        phaseAMP.setLocId(this.evt.getAuxId(chn));
                        phaseAMP.setPhaType(1);
                        phaseAMP.setAmpType(0);
                        phaseAMP.offset = start + max;
                        phaseAMP.iPeriod = (int)(sr * par[0]);
                        phaseAMP.setPeriod(par[0]);
                        double amp = this.getMaxPPCount(wDat, max - phaseAMP.iPeriod / 2, max + phaseAMP.iPeriod / 2) / 2.0;
                        phaseAMP.setAmp(amp / calibFactor);
                        long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phaseAMP.offset * 1000L) / sr);
                        phaseAMP.setPhaseTime(new Date(date));
                        this.evt.getPhases(chn).addElement(phaseAMP);
                    }
                }
            }
            ++chn;
        }
    }

    public void autoMeasureMl() {
        int TCN = this.evt.getTCN();
        PeriodBoundMl pb = new PeriodBoundMl();
        int chn = 0;
        while (chn < TCN) {
            block8: {
                double mean;
                int max;
                double[] par;
                double sr;
                int end;
                int start;
                double[] wdat;
                Phase phaseAMP;
                String ampName;
                block9: {
                    String sta;
                    String chan;
                    double delta = this.evt.getStationLocation(chn).getDelta();
                    int idist = (int)delta;
                    if ((double)idist > 10.0 || (chan = this.evt.getChannelCode(chn)).endsWith("Z") && this.evt.isThreeComp(chn)) break block8;
                    ampName = "SME";
                    if (chan.endsWith("N")) {
                        ampName = "SMN";
                    }
                    if (chan.endsWith("Z")) {
                        ampName = "SMZ";
                    }
                    Phase[] theoreticPhases = this.getFrontTheoreticPhase(chn);
                    Phase phaseP = theoreticPhases[0];
                    Phase phaseS = theoreticPhases[1];
                    phaseAMP = this.evt.getPhase(chn, ampName);
                    String net = this.evt.getNetworkCode(chn);
                    if (!this.evt.hasPhase(net, sta = this.evt.getStationCode(chn)) || phaseAMP != null) break block8;
                    wdat = this.evt.getSampData(chn);
                    start = 0;
                    Phase phaseSg = this.evt.getPhase(net, sta, "Sg");
                    if (phaseSg != null) {
                        start = phaseSg.offset;
                    }
                    end = wdat.length;
                    sr = this.evt.getSampleRate(chn);
                    if (phaseS == null || phaseP == null) break block9;
                    phaseS.offset = (int)((double)(phaseS.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * this.evt.getSampleRate(chn) / 1000.0);
                    start = Math.max(start, phaseS.offset);
                    int idx = (int)((double)idist / ML_STEP);
                    double d = (delta - (double)idx * ML_STEP) / ML_STEP;
                    int second = (int)(RICHARD_sigma[idx] + (d *= RICHARD_sigma[idx + 1] - RICHARD_sigma[idx]));
                    end = Math.min(phaseP.offset + (int)(sr * (double)second), wdat.length);
                    if (start > end) break block8;
                }
                if (pb.accept(par = LocationMath.measurePeriod(wdat, max = this.evt.getMaxPPCountWithPeriod(chn, start, end, mean = this.evt.getMean(chn, start, end), pb), start, end, sr, mean))) {
                    phaseAMP = new Phase();
                    phaseAMP.setPhaseName(ampName);
                    phaseAMP.setMagName("Ml");
                    phaseAMP.setStationCode(this.evt.getStationCode(chn));
                    phaseAMP.setBelongedChannelID(this.evt.toComp(chn) - 1);
                    phaseAMP.setChanCode(this.evt.getChannelCode(chn));
                    phaseAMP.setRecType(this.evt.getOriginalType(chn));
                    phaseAMP.setInstrumentName(this.evt.getInstrumentType(chn));
                    phaseAMP.setNetCode(this.evt.getNetworkCode(chn));
                    phaseAMP.setLocId(this.evt.getAuxId(chn));
                    phaseAMP.setPhaType(1);
                    phaseAMP.setAmpType(0);
                    phaseAMP.offset = max;
                    phaseAMP.iPeriod = (int)(sr * par[0]);
                    phaseAMP.setPeriod(par[0]);
                    double amp = this.evt.getMaxPPCount(chn, phaseAMP.offset - phaseAMP.iPeriod / 2, phaseAMP.offset + phaseAMP.iPeriod / 2) / 2.0;
                    phaseAMP.setAmp(amp / this.evt.getCalibFactor(chn));
                    long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phaseAMP.offset * 1000L) / sr);
                    phaseAMP.setPhaseTime(new Date(date));
                    this.evt.getPhases(chn).addElement(phaseAMP);
                }
            }
            ++chn;
        }
    }

    public void autoMeasureMlAfterEmulateWA() {
        int TCN = this.evt.getTCN();
        PeriodBoundMl pb = new PeriodBoundMl();
        int chn = 0;
        while (chn < TCN) {
            block14: {
                double sr;
                int end;
                int start;
                Phase phaseAMP;
                String ampName;
                block15: {
                    String sta;
                    String chan;
                    double delta = this.evt.getStationLocation(chn).getDelta();
                    int idist = (int)delta;
                    if ((double)idist > 10.0 || (chan = this.evt.getChannelCode(chn)).endsWith("Z") && this.evt.isThreeComp(chn)) break block14;
                    ampName = "SME";
                    if (chan.endsWith("N")) {
                        ampName = "SMN";
                    }
                    if (chan.endsWith("Z")) {
                        ampName = "SMZ";
                    }
                    Phase[] theoreticPhases = this.getFrontTheoreticPhase(chn);
                    Phase phaseP = theoreticPhases[0];
                    Phase phaseS = theoreticPhases[1];
                    phaseAMP = this.evt.getPhase(chn, ampName);
                    String net = this.evt.getNetworkCode(chn);
                    if (!this.evt.hasPhase(net, sta = this.evt.getStationCode(chn)) || phaseAMP != null) break block14;
                    start = 0;
                    end = this.evt.getSamples(chn);
                    sr = this.evt.getSampleRate(chn);
                    if (phaseS == null || phaseP == null) break block15;
                    phaseS.offset = (int)((double)(phaseS.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * sr / 1000.0);
                    phaseP.offset = (int)((double)(phaseP.getPhaseTime().getTime() - this.evt.getArrivalTime(chn).getTime()) * sr / 1000.0);
                    start = phaseS.offset;
                    Phase phaseSg = this.evt.getPhase(net, sta, "Sg");
                    if (phaseSg != null) {
                        start = phaseSg.offset;
                    }
                    int idx = (int)((double)idist / ML_STEP);
                    double d = (delta - (double)idx * ML_STEP) / ML_STEP;
                    int second = (int)(RICHARD_sigma[idx] + (d *= RICHARD_sigma[idx + 1] - RICHARD_sigma[idx]));
                    end = Math.min(start + (int)(sr * (double)second), this.evt.getSamples(chn));
                    start -= (int)sr * 5;
                    if (end > this.evt.getSamples(chn)) {
                        end = this.evt.getSamples(chn);
                    }
                    if (start > end) break block14;
                }
                if (this.evt.hasGapsData(chn, start, end)) {
                    logger.info((Object)String.format("Ignore channel %s as gapsing data", this.evt.getChannelLocator(chn).toDotString()));
                } else if (this.evt.hasClippingData(chn, start, end)) {
                    logger.info((Object)String.format("Ignore channel %s as clipping data", this.evt.getChannelLocator(chn).toDotString()));
                } else {
                    double noiseMean = this.getNoiseMean(chn);
                    Emulate emulate = new Emulate();
                    List<double[]> result = emulate.emulateWA(this.evt, chn, start, end, noiseMean);
                    double[] wDat = result.get(0);
                    double calibFactor = result.get(1)[0];
                    double sum = 0.0;
                    int i = 0;
                    while (i < wDat.length) {
                        sum += wDat[i];
                        ++i;
                    }
                    double mean = sum / (double)wDat.length;
                    int max = this.getMaxCountIndex(sr, wDat, mean, pb);
                    double[] par = LocationMath.measurePeriod(wDat, max, 0, wDat.length, sr, mean);
                    if (pb.accept(par)) {
                        phaseAMP = new Phase();
                        phaseAMP.setPhaseName(ampName);
                        phaseAMP.setMagName("Ml");
                        phaseAMP.setStationCode(this.evt.getStationCode(chn));
                        phaseAMP.setBelongedChannelID(this.evt.toComp(chn) - 1);
                        phaseAMP.setChanCode(this.evt.getChannelCode(chn));
                        phaseAMP.setRecType(0);
                        phaseAMP.setInstrumentName("W.A.");
                        phaseAMP.setNetCode(this.evt.getNetworkCode(chn));
                        phaseAMP.setLocId(this.evt.getAuxId(chn));
                        phaseAMP.setPhaType(1);
                        phaseAMP.setAmpType(0);
                        phaseAMP.offset = start + max;
                        phaseAMP.iPeriod = (int)(sr * par[0]);
                        phaseAMP.setPeriod(par[0]);
                        double amp = this.getMaxPPCount(wDat, max - phaseAMP.iPeriod / 2, max + phaseAMP.iPeriod / 2) / 2.0;
                        phaseAMP.setAmp(amp / calibFactor);
                        long date = this.evt.getArrivalTime(chn).getTime() + (long)((double)((long)phaseAMP.offset * 1000L) / sr);
                        phaseAMP.setPhaseTime(new Date(date));
                        this.evt.getPhases(chn).addElement(phaseAMP);
                    }
                }
            }
            ++chn;
        }
    }

    private int getMaxCountIndex(double sampleRate, double[] WDat, double mean, PeriodBound pb) {
        int maxIdx = 0;
        double maxAmp = -1.0;
        int maxPer = 0;
        int i = 0;
        while (i < WDat.length) {
            double[] par = LocationMath.measurePeriod(WDat, i, 0, WDat.length, sampleRate, mean);
            int per = (int)(sampleRate * par[0]);
            double amp = this.getMaxPPCount(WDat, i - per / 2, i + per / 2);
            if (pb.accept(par) && maxAmp < amp) {
                maxIdx = i;
                maxAmp = amp;
                maxPer = per;
            }
            i += per / 2;
            ++i;
        }
        int startIdx = maxIdx - maxPer / 2;
        int endIdx = maxIdx + maxPer / 2;
        if (endIdx >= WDat.length) {
            endIdx = WDat.length - 1;
        }
        if (startIdx >= WDat.length) {
            startIdx = WDat.length - 1;
        }
        if (startIdx < 0) {
            startIdx = 0;
        }
        double max = Math.abs(WDat[startIdx] - mean);
        int imax = startIdx;
        int i2 = startIdx + 1;
        while (i2 < endIdx) {
            if (max < Math.abs(WDat[i2] - mean)) {
                max = Math.abs(WDat[i2] - mean);
                imax = i2;
            }
            ++i2;
        }
        return imax;
    }

    private double getMaxPPCount(double[] WDat, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end >= WDat.length) {
            end = WDat.length - 1;
        }
        if (start >= WDat.length) {
            start = WDat.length - 1;
        }
        int minIndex = start;
        int maxIndex = start;
        int j = start;
        while (j < end) {
            if (WDat[minIndex] <= WDat[j]) {
                if (WDat[maxIndex] <= WDat[j]) {
                    maxIndex = j;
                }
            } else {
                minIndex = j;
            }
            ++j;
        }
        return WDat[maxIndex] - WDat[minIndex];
    }

    private double getNoiseMean(int chn) {
        double noiseMean = 0.0;
        Phase phaseP = this.evt.getTheoreticPhase(chn, "P");
        if (phaseP == null) {
            phaseP = this.evt.getTheoreticPhase(chn, "p");
        }
        if (phaseP == null) {
            noiseMean = ArrayMath.mean((double[])this.evt.getSampData(chn));
        } else {
            int wDatLengh = Math.min((int)this.evt.getSampleRate(chn) * 180, phaseP.offset);
            double[] wDat = new double[wDatLengh];
            System.arraycopy(this.evt.getSampData(chn), phaseP.offset - wDatLengh, wDat, 0, wDat.length);
            noiseMean = ArrayMath.mean((double[])wDat);
        }
        return noiseMean;
    }

    private Phase[] getFrontTheoreticPhase(int chn) {
        Vector<Phase> phases = this.evt.getTheoreticPhases(chn);
        Phase pPhase = null;
        Phase sPhase = null;
        for (Phase p : phases) {
            if (p.getPhaType() == 0 && p.getPhaseName().substring(0, 1).equalsIgnoreCase("p") && (pPhase == null || pPhase.getPhaseTime().after(p.getPhaseTime()))) {
                pPhase = p;
            }
            if (p.getPhaType() != 0 || !p.getPhaseName().substring(0, 1).equalsIgnoreCase("s") || sPhase != null && !sPhase.getPhaseTime().after(p.getPhaseTime())) continue;
            sPhase = p;
        }
        return new Phase[]{pPhase, sPhase};
    }

    public EvtData getEvt() {
        return this.evt;
    }

    public void setEvt(EvtData evt) {
        this.evt = evt;
    }

    private static class PeriodBoundMB
    implements PeriodBound {
        private PeriodBoundMB() {
        }

        public boolean accept(double[] par) {
            return !Double.isNaN(par[0]) && !(par[1] > 2.0) && !(par[0] > 4.0) && !(par[0] < 0.2);
        }
    }

    private static class PeriodBoundMl
    implements PeriodBound {
        private PeriodBoundMl() {
        }

        public boolean accept(double[] par) {
            return !Double.isNaN(par[0]) && !(par[1] > 1.0) && !(par[0] > 5.0);
        }
    }

    private static class PeriodBoundMs
    implements PeriodBound {
        private PeriodBoundMs() {
        }

        public boolean accept(double[] par) {
            return !Double.isNaN(par[0]) && !(par[1] > 5.0) && !(par[0] > 30.0) && !(par[0] < 5.0);
        }
    }
}

