/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.Hypomh;
import org.apache.log4j.Logger;
import org.netlib.util.intW;

public class HLayedTravelTime
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(HLayedTravelTime.class);
    private Hypomh.STRUCT strc;

    public double calDelta(double depth, double time, int phaseType) {
        return -1.0;
    }

    public double calTravelTime(double depth, double deta, int type) {
        return -1.0;
    }

    public double calTravelTime(double[] Src, double[] Stn, int type) {
        return -1.0;
    }

    public double calDelta(double depth, double time, String phaseType) {
        return -1.0;
    }

    public double calTravelTime(double[] src, double[] stn, String phaseType) {
        if (!(phaseType.equals("Pn") || phaseType.equals("Sn") || phaseType.equals("Pg") || phaseType.equals("Sg") || phaseType.equals("P") || phaseType.equals("S"))) {
            return -1.0;
        }
        double rr = SphereUtil.distOnSphere((double)src[0], (double)src[1], (double)stn[0], (double)stn[1]) * 111.19;
        intW np = new intW(0);
        double[] ang = new double[this.strc.n1 + 1];
        double[] tt = new double[this.strc.n1 + 1];
        double[] bng = new double[this.strc.n1 + 1];
        Hypomh.travel(rr, src[2], stn[2], np, ang, tt, bng, this.strc);
        System.out.printf("rr=%7.2f, ya=%7.2f, yb=%7.2f, np=%d\n", rr, src[2], stn[2], np.val);
        System.out.printf(" ang    bng     trv\n", new Object[0]);
        int i = 0;
        while (i < np.val) {
            System.out.printf("%5.1f  %5.1f  %7.2f\n", ang[i] / Math.PI * 180.0, bng[i] / Math.PI * 180.0, tt[i]);
            ++i;
        }
        double rtt = -1.0;
        double mintt = Double.MAX_VALUE;
        double maxtt = Double.MIN_VALUE;
        double min_ang = 0.0;
        double max_ang = 0.0;
        int j = 0;
        while (j < np.val) {
            if (tt[j] < mintt) {
                mintt = tt[j];
                min_ang = ang[j];
            }
            if (tt[j] > maxtt) {
                maxtt = tt[j];
                max_ang = ang[j];
            }
            ++j;
        }
        min_ang *= 57.29577951308232;
        max_ang *= 57.29577951308232;
        if (phaseType.equals("P") || phaseType.equals("S")) {
            rtt = mintt;
        }
        if (phaseType.equals("Pn") || phaseType.equals("Sn")) {
            if (min_ang < 70.0) {
                rtt = mintt;
            } else {
                return mintt;
            }
        }
        if (phaseType.equals("Pg") || phaseType.equals("Sg")) {
            if (max_ang >= 70.0) {
                rtt = maxtt;
            } else {
                return maxtt;
            }
        }
        if (phaseType.equals("Sn") || phaseType.equals("Sg") || phaseType.equals("S")) {
            rtt *= this.strc.vpvs;
        }
        return rtt;
    }

    public double calTravelTime(double depth, double delta, String phaseType) {
        return -1.0;
    }

    public void setSTRUCT(String model, int nlayer, double[] th, double[] vp) {
        this.strc = Hypomh.STRUCT.build(model, nlayer, th, vp);
    }

    public static void main(String[] args) {
        int nlayer = 5;
        double[] th = new double[]{21.3, 0.01, 11.0, 0.01, 600.0};
        double[] vp = new double[]{6.01, 6.02, 6.88, 6.89, 7.88, 8.0};
        HLayedTravelTime htt = new HLayedTravelTime();
        htt.setSTRUCT("HWH", nlayer, th, vp);
        double[] src = new double[]{21.0, 120.0, 10.0};
        double[] sta = new double[]{21.0, 124.0, 0.0};
        double tt = htt.calTravelTime(src, sta, "Pn");
        System.out.printf("tt=%7.2f\n", tt);
    }
}

