/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.hypoinverse.Phase;
import cn.org.gddsn.seis.location.hypoinverse.SourceParam;
import cn.org.gddsn.seis.location.hypoinverse.Station;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Hypo2000
extends IterateNearloc {
    static Logger logger = Logger.getLogger(Hypo2000.class);
    private String workingPath = "/usr/local/jopens/msdp/work";
    private String program = "/usr/local/jopens/lib/hyp2000";
    private EvtData evtData;

    public boolean findSourceLoc() {
        File out = new File(this.workingPath, "hyp200-out.arc");
        if (out.isFile() && out.canWrite()) {
            out.delete();
        }
        return this.exportStation() && this.exportPhase() && this.shell() && this.fillSourceParam();
    }

    public cn.org.gddsn.seis.SourceParam getSourceParam() {
        cn.org.gddsn.seis.SourceParam sp = super.getSourceParam();
        sp.setLocProgram("Hyp2000");
        return sp;
    }

    private boolean exportStation() {
        File allStation = new File(this.workingPath, "hyp2000-sta");
        try {
            FileWriter fos = new FileWriter(allStation);
            int tch = this.evtData.getTCN();
            int i = 0;
            while (i < tch) {
                Station s = new Station();
                s.parse(this.evtData.getTimeSeries(i));
                fos.write(s.format());
                fos.write("\n");
                ++i;
            }
            fos.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean exportPhase() {
        File phaseArc = new File(this.workingPath, "hyp2000-in.arc");
        try {
            SourceParam s = new SourceParam();
            s.setEventId(11111111);
            FileWriter fos = new FileWriter(phaseArc);
            fos.write(String.valueOf(s.format()) + "\n");
            int tch = this.evtData.getTCN();
            int i = 0;
            while (i < tch) {
                Vector<cn.org.gddsn.seis.Phase> phs = this.evtData.getPhases(i);
                for (cn.org.gddsn.seis.Phase p : phs) {
                    Phase hp = new Phase();
                    hp.parse(p);
                    fos.write(hp.format());
                    fos.write("\n");
                }
                ++i;
            }
            fos.write("                                                                " + s.getEventId() + "\n");
            fos.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean shell() {
        int ret = -1;
        try {
            Process process = Runtime.getRuntime().exec(new File(this.program).getAbsolutePath(), null, new File(this.workingPath));
            ret = process.waitFor();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return ret == 0;
    }

    private boolean fillSourceParam() {
        File phaseArc = new File(this.workingPath, "hyp2000-out.arc");
        try {
            BufferedReader fr = new BufferedReader(new FileReader(phaseArc));
            String line = fr.readLine();
            SourceParam s = new SourceParam();
            s.parse(line);
            this.sourceParam.setLat(s.getLat() + s.getLatFrac() / 60.0f);
            this.sourceParam.setLon(s.getLon() + s.getLonFrac() / 60.0f);
            this.sourceParam.setDepth(s.getDepth());
            this.sourceParam.setRms(s.getRms());
            this.sourceParam.setErh(s.getHorError());
            this.sourceParam.setErz(s.getVerError());
            GregorianCalendar c = new GregorianCalendar();
            c.set(s.getYear(), s.getMonth() - 1, s.getDay(), s.getHour(), s.getMinute(), (int)s.getSecond());
            float ms = (s.getSecond() - (float)((int)s.getSecond())) * 1000.0f;
            this.sourceParam.setOriginTime(new Date(c.getTimeInMillis() / 1000L * 1000L + (long)((int)ms)));
            logger.info((Object)this.sourceParam.getOriginTime());
            Hashtable<String, Float> tbl = new Hashtable<String, Float>();
            while (!(line = fr.readLine()).startsWith(" ")) {
                Phase hp = new Phase();
                hp.parse(line);
                if (hp.getRemarkP().endsWith("P")) {
                    tbl.put(String.valueOf(hp.getNetCode()) + "_" + hp.getStationCode() + "_P", Float.valueOf(hp.getResidualP()));
                }
                if (!hp.getRemarkS().endsWith("S")) continue;
                tbl.put(String.valueOf(hp.getNetCode()) + "_" + hp.getStationCode() + "_S", Float.valueOf(hp.getResidualS()));
            }
            fr.close();
            Vector<cn.org.gddsn.seis.Phase>[] vec = this.getStnPhases();
            int i = 0;
            while (i < vec.length) {
                for (cn.org.gddsn.seis.Phase p : vec[i]) {
                    String key;
                    Float resi;
                    if (p.getPhaType() != 0 || (resi = (Float)tbl.get(key = String.valueOf(p.getNetCode()) + "_" + p.getStationCode() + "_" + p.getPhaseName().substring(0, 1))) == null) continue;
                    p.setResi(resi.floatValue());
                }
                ++i;
            }
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public double getDetailResidual(int stn, String phaseName) {
        cn.org.gddsn.seis.Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        this.evtData = evtData;
    }
}

