/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.io.LittleEndianInputStream;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class IASPEI91Table
implements ComputedTravelTime {
    static Logger logger = Logger.getLogger(IASPEI91Table.class);
    private int nPhase;
    private int nDelta;
    private int nDepth;
    private int stepDelta;
    private int stepDepth;
    private String[] phaseName;
    private float[][][] at;
    private String iaspei91FileName = "iaspei91.bin";

    private void readASPI91BIN() throws IOException {
        LittleEndianInputStream tableIn = new LittleEndianInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.iaspei91FileName), 4096));
        this.nPhase = tableIn.readInt();
        this.nDelta = tableIn.readInt();
        this.nDepth = tableIn.readInt();
        this.stepDelta = tableIn.readInt();
        this.stepDepth = tableIn.readInt();
        this.phaseName = new String[this.nPhase];
        byte[] bPhaseName = new byte[10];
        int i = 0;
        while (i < this.nPhase) {
            tableIn.read(bPhaseName);
            this.phaseName[i] = new String(bPhaseName).trim();
            ++i;
        }
        this.at = new float[this.nPhase][this.nDelta][this.nDepth];
        i = 0;
        while (i < this.nPhase) {
            int k = 0;
            while (k < this.nDelta) {
                int j = 0;
                while (j < this.nDepth) {
                    this.at[i][k][j] = tableIn.readFloat();
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        tableIn.close();
    }

    double calTravalTimeAtCalcOneMode(double Depth, double Delta, String phaseType) {
        float t2;
        float t1;
        int k;
        LittleEndianInputStream tableIn;
        double t;
        block14: {
            block13: {
                int i;
                block12: {
                    block11: {
                        block10: {
                            t = 0.0;
                            tableIn = new LittleEndianInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.iaspei91FileName), 4096));
                            this.nPhase = tableIn.readInt();
                            this.nDelta = tableIn.readInt();
                            this.nDepth = tableIn.readInt();
                            this.stepDelta = tableIn.readInt();
                            this.stepDepth = tableIn.readInt();
                            this.phaseName = new String[this.nPhase];
                            byte[] bPhaseName = new byte[10];
                            i = 0;
                            while (i < this.nPhase) {
                                tableIn.read(bPhaseName);
                                this.phaseName[i] = new String(bPhaseName).trim();
                                ++i;
                            }
                            i = 0;
                            while (i < this.nPhase) {
                                if (phaseType.equals(this.phaseName[i])) break;
                                ++i;
                            }
                            if (i != this.nPhase) break block10;
                            tableIn.close();
                            return Double.NaN;
                        }
                        if (!(Delta > (double)((this.nDepth - 1) * this.stepDelta))) break block11;
                        tableIn.close();
                        return Double.NaN;
                    }
                    if (!(Depth > (double)((this.nDepth - 1) * this.stepDepth))) break block12;
                    tableIn.close();
                    return Double.NaN;
                }
                k = (int)(Delta / (double)this.stepDelta);
                int j = (int)(Depth / (double)this.stepDepth);
                tableIn.skipBytes((i * this.nDelta * this.nDepth + k * this.nDepth + j) * 4);
                t1 = tableIn.readFloat();
                if (!((double)t1 < 0.0)) break block13;
                tableIn.close();
                return Double.NaN;
            }
            if (Delta == (double)(k * this.stepDelta)) {
                t = t1;
                tableIn.close();
                return t;
            }
            tableIn.skipBytes(this.nDepth * 4 - 4);
            t2 = tableIn.readFloat();
            if (!((double)t2 < 0.0)) break block14;
            return Double.NaN;
        }
        try {
            t = (double)t1 + (double)(t2 - t1) * (Delta - (double)(k * this.stepDelta)) / (double)this.stepDelta;
            tableIn.close();
        }
        catch (IOException IOE) {
            IOE.printStackTrace();
        }
        return t;
    }

    private double calTravelTimeAtCalcAllMode(double depth, double delta, String phaseType) {
        int i = 0;
        while (i < this.nPhase) {
            if (phaseType.equals(this.phaseName[i])) break;
            ++i;
        }
        if (i == this.nPhase) {
            return Double.NaN;
        }
        if (delta > (double)((this.nDepth - 1) * this.stepDelta)) {
            return Double.NaN;
        }
        if (depth > (double)((this.nDepth - 1) * this.stepDepth)) {
            return Double.NaN;
        }
        int k = (int)(delta / (double)this.stepDelta);
        int j = (int)(depth / (double)this.stepDepth);
        float t1 = this.at[i][k][j];
        if ((double)t1 < 0.0) {
            return Double.NaN;
        }
        if (delta == (double)(k * this.stepDelta)) {
            double t = t1;
            return t;
        }
        float t2 = this.at[i][k + 1][j];
        if ((double)t2 < 0.0) {
            return Double.NaN;
        }
        double t = (double)t1 + (double)(t2 - t1) * (delta - (double)(k * this.stepDelta)) / (double)this.stepDelta;
        return t;
    }

    public double calTravelTime(double depth, double delta, String phaseType) {
        return this.calTravelTimeAtCalcAllMode(depth, delta, phaseType);
    }

    private int getPhaseIndex(String ph) {
        int iph = -1;
        int i = 0;
        while (i < this.nPhase) {
            if (ph.equals(this.phaseName[i])) {
                iph = i;
                break;
            }
            ++i;
        }
        return iph;
    }

    public double calDelta(double depth, double time, String phaseType) {
        int j;
        int idepth = (int)Math.round(depth / (double)this.stepDepth);
        if (idepth >= this.nDepth) {
            return Double.NaN;
        }
        int iphf = -1;
        int iphl = -1;
        boolean isSingle = false;
        if (phaseType.indexOf(44) == -1) {
            isSingle = true;
            iphf = this.getPhaseIndex(phaseType);
            if (iphf == -1) {
                return Double.NaN;
            }
        } else {
            isSingle = false;
            int idx = phaseType.indexOf(44);
            String pName = phaseType.substring(0, idx);
            String sName = phaseType.substring(idx + 1);
            iphf = this.getPhaseIndex(pName);
            if (iphf == -1) {
                return Double.NaN;
            }
            iphl = this.getPhaseIndex(sName);
            if (iphl == -1) {
                return Double.NaN;
            }
        }
        if (isSingle) {
            if (this.at[iphf][0][idepth] < this.at[iphf][this.nDelta - 1][idepth]) {
                if (time < (double)this.at[iphf][0][idepth] || time > (double)this.at[iphf][this.nDelta - 1][idepth]) {
                    return Double.NaN;
                }
                j = 0;
                while (j < this.nDelta) {
                    if (time < (double)this.at[iphf][j][idepth]) break;
                    ++j;
                }
                return (double)(this.stepDelta * (j - 1)) + (double)this.stepDelta * (time - (double)this.at[iphf][j - 1][idepth]) / (double)(this.at[iphf][j][idepth] - this.at[iphf][j - 1][idepth]);
            }
            if (time > (double)this.at[iphf][0][idepth] || time < (double)this.at[iphf][this.nDelta - 1][idepth]) {
                return Double.NaN;
            }
            j = this.nDelta - 1;
            while (j >= 0) {
                if (time < (double)this.at[iphf][j][idepth]) break;
                --j;
            }
            return (double)(this.stepDelta * (j + 1)) + (double)this.stepDelta * (time - (double)this.at[iphf][j + 1][idepth]) / (double)(this.at[iphf][j][idepth] - this.at[iphf][j + 1][idepth]);
        }
        if (time < (double)(this.at[iphl][0][idepth] - this.at[iphf][0][idepth])) {
            return Double.NaN;
        }
        j = 0;
        while (j < this.nDelta) {
            if (time < (double)(this.at[iphl][j][idepth] - this.at[iphf][j][idepth])) break;
            ++j;
        }
        if (j == this.nDelta) {
            return Double.NaN;
        }
        return (double)(this.stepDelta * (j - 1)) + (double)this.stepDelta * (time - (double)(this.at[iphl][j - 1][idepth] - this.at[iphf][j - 1][idepth])) / (double)(this.at[iphl][j][idepth] - this.at[iphf][j][idepth] - (this.at[iphl][j - 1][idepth] - this.at[iphf][j - 1][idepth]));
    }

    public double calTravelTime(double depth, double Delta, int phaseType) {
        return this.calTravelTime(depth, Delta, this.getPhaseType(phaseType));
    }

    public double calDelta(double depth, double time, int phaseType) {
        return this.calDelta(depth, time, this.getPhaseType(phaseType));
    }

    public double calTravelTime(double[] Src, double[] Stn, String phaseType) {
        return Double.NaN;
    }

    public double calTravelTime(double[] Src, double[] Stn, int phaseType) {
        return Double.NaN;
    }

    public String getPhaseType(int phaseType) {
        String pType = "";
        if (phaseType == 1) {
            pType = "Pn";
        } else if (phaseType == 2) {
            pType = "Sn";
        } else if (phaseType == 3) {
            pType = "Pg";
        } else if (phaseType == 4) {
            pType = "Sg";
        } else if (phaseType == 8) {
            pType = "P";
        } else if (phaseType == 9) {
            pType = "S";
        } else if (phaseType == 13) {
            pType = "Pg1";
        } else if (phaseType == 14) {
            pType = "Sg1";
        } else if (phaseType == 11) {
            pType = "LG1";
        } else if (phaseType == 12) {
            pType = "LG2";
        } else if (phaseType == 5) {
            pType = "Pg,Sg";
        } else if (phaseType == 6) {
            pType = "Pn,Sn";
        } else if (phaseType == 7) {
            pType = "Pn,Sg";
        } else if (phaseType == 10) {
            pType = "P,S";
        }
        return pType;
    }

    public String getAspi91FileName() {
        return this.iaspei91FileName;
    }

    public void setIaspei91FileName(String iaspei91FileName) {
        this.iaspei91FileName = iaspei91FileName;
        try {
            this.readASPI91BIN();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        IASPEI91Table aspi = new IASPEI91Table();
        aspi.setIaspei91FileName("/home/jopens-0.2/msdp/cfg/iaspei91.bin");
        double t = aspi.calTravelTime(10.0, 30.0, "PP");
        System.out.println(t);
        t = aspi.calTravelTime(50.0, 2.0, "P");
        System.out.println(t);
        System.out.println(aspi.calDelta(50.0, 31.310999, "P"));
        System.out.println(aspi.calDelta(49.0, 31.310999, "P"));
        System.out.println(aspi.calDelta(51.0, 31.310999, "P"));
        System.out.println(aspi.calDelta(10.0, 436.5, "PP"));
        System.out.println(aspi.calDelta(5.0, 24.18, "Pn,Sn") * 111.19);
    }
}

