/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.optimization.RealValueFunction;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.location.InputInfoForLoc;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.location.StnLocation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class IterateNearlocL1Residual
extends IterateNearloc
implements RealValueFunction {
    public static final int PG = 0;
    public static final int PGandSG = 1;
    public static final int PNandSN = 2;
    public static final int PandS = 3;
    public static final int PPhaseOnly = 4;
    public static final int ALL = 5;
    private double simpleSearchStep = 1.0;
    int usePhaseType = 5;
    int phsCnts;
    double arrivedSum = 0.0;
    double travelsum = 0.0;
    double[] T;
    StnLocation[] stnLoc = null;
    double[] arriveT;

    public void useWhatPhase(int type) {
        this.usePhaseType = type;
    }

    public void setInputInfoForLoc(InputInfoForLoc inputInfoForLoc) {
        super.setInputInfoForLoc(inputInfoForLoc);
        int stnSum = this.getStnSum();
        this.T = new double[stnSum];
        this.stnLoc = new StnLocation[stnSum];
        int i = 0;
        while (i < stnSum) {
            this.stnLoc[i] = new StnLocation();
            ++i;
        }
        this.arriveT = new double[stnSum];
    }

    double oneErrorSum(double[] x, int phaseType) {
        this.phsCnts = this.getLocationData(this.stnLoc, this.arriveT, phaseType);
        if (this.phsCnts == 0) {
            return 0.0;
        }
        int i = 0;
        while (i < this.phsCnts) {
            if (x[2] < 0.0) {
                x[2] = 10.0;
            }
            double[] sta = new double[]{this.stnLoc[i].getLat(), this.stnLoc[i].getLon(), this.stnLoc[i].getAlt()};
            this.T[i] = this.computedTravelTime.calTravelTime(x, sta, phaseType);
            ++i;
        }
        double errorSum = 0.0;
        double error = 0.0;
        int i2 = 0;
        while (i2 < this.phsCnts) {
            error = Math.abs(this.arriveT[i2] - this.T[i2]);
            errorSum += error;
            ++i2;
        }
        return errorSum / (double)this.phsCnts;
    }

    private void doSumStempOne(double[] x, int phaseType) {
        int counts = this.getLocationData(this.stnLoc, this.arriveT, phaseType);
        int i = 0;
        while (i < counts) {
            if (x[2] < 0.0) {
                x[2] = 10.0;
            }
            double[] sta = new double[]{this.stnLoc[i].getLat(), this.stnLoc[i].getLon(), this.stnLoc[i].getAlt()};
            this.T[i] = this.computedTravelTime.calTravelTime(x, sta, phaseType);
            if (!Double.isNaN(this.T[i])) {
                this.arrivedSum += this.arriveT[i];
                this.travelsum += this.T[i];
                ++this.phsCnts;
            }
            ++i;
        }
    }

    private void doSum(double[] x) {
        this.phsCnts = 0;
        this.arrivedSum = 0.0;
        this.travelsum = 0.0;
        switch (this.usePhaseType) {
            case 0: {
                this.doSumStempOne(x, 3);
                break;
            }
            case 1: {
                this.doSumStempOne(x, 3);
                this.doSumStempOne(x, 4);
                break;
            }
            case 2: {
                this.doSumStempOne(x, 1);
                this.doSumStempOne(x, 2);
                break;
            }
            case 3: {
                this.doSumStempOne(x, 8);
                this.doSumStempOne(x, 9);
                break;
            }
            case 4: {
                this.doSumStempOne(x, 3);
                this.doSumStempOne(x, 1);
                this.doSumStempOne(x, 8);
                break;
            }
            case 5: {
                this.doSumStempOne(x, 3);
                this.doSumStempOne(x, 4);
                this.doSumStempOne(x, 1);
                this.doSumStempOne(x, 2);
                this.doSumStempOne(x, 8);
                this.doSumStempOne(x, 9);
                this.doSumStempOne(x, 18);
                this.doSumStempOne(x, 19);
                this.doSumStempOne(x, 15);
                this.doSumStempOne(x, 16);
                this.doSumStempOne(x, 17);
                this.doSumStempOne(x, 13);
                this.doSumStempOne(x, 14);
            }
        }
    }

    private double oneAvgErrorSum(double[] x, int phaseType) {
        int counts = this.getLocationData(this.stnLoc, this.arriveT, phaseType);
        if (counts == 0) {
            return 0.0;
        }
        int i = 0;
        while (i < counts) {
            if (x[2] < 0.0) {
                x[2] = 10.0;
            }
            double[] sta = new double[]{this.stnLoc[i].getLat(), this.stnLoc[i].getLon(), this.stnLoc[i].getAlt()};
            this.T[i] = this.computedTravelTime.calTravelTime(x, sta, phaseType);
            ++i;
        }
        double errorSum = 0.0;
        double error = 0.0;
        int i2 = 0;
        while (i2 < counts) {
            if (!Double.isNaN(this.T[i2])) {
                error = Math.abs(this.arriveT[i2] - this.arrivedSum / (double)this.phsCnts - (this.T[i2] - this.travelsum / (double)this.phsCnts));
                errorSum += error;
            }
            ++i2;
        }
        return errorSum / (double)this.phsCnts;
    }

    public double funk(double[] x) {
        double retVal = 0.0;
        this.doSum(x);
        switch (this.usePhaseType) {
            case 0: {
                retVal = this.oneAvgErrorSum(x, 3);
                break;
            }
            case 1: {
                retVal = this.oneAvgErrorSum(x, 3);
                retVal += this.oneAvgErrorSum(x, 4);
                break;
            }
            case 2: {
                retVal = this.oneAvgErrorSum(x, 1);
                retVal += this.oneAvgErrorSum(x, 2);
                break;
            }
            case 3: {
                retVal = this.oneAvgErrorSum(x, 8);
                retVal += this.oneAvgErrorSum(x, 9);
                break;
            }
            case 4: {
                retVal = this.oneAvgErrorSum(x, 3);
                retVal += this.oneAvgErrorSum(x, 1);
                retVal += this.oneAvgErrorSum(x, 8);
                break;
            }
            case 5: {
                retVal = this.oneAvgErrorSum(x, 3);
                retVal += this.oneAvgErrorSum(x, 4);
                retVal += this.oneAvgErrorSum(x, 1);
                retVal += this.oneAvgErrorSum(x, 2);
                retVal += this.oneAvgErrorSum(x, 8);
                retVal += this.oneAvgErrorSum(x, 9);
                retVal += this.oneAvgErrorSum(x, 18);
                retVal += this.oneAvgErrorSum(x, 19);
                retVal += this.oneAvgErrorSum(x, 15);
                retVal += this.oneAvgErrorSum(x, 16);
                retVal += this.oneAvgErrorSum(x, 17);
                retVal += this.oneAvgErrorSum(x, 13);
                retVal += this.oneAvgErrorSum(x, 14);
            }
        }
        return retVal;
    }

    public SourceParam simpleSearch() {
        return this.simpleSearch(this.simpleSearchStep);
    }

    public void printResultMap(SourceParam sp, double width, double step) throws IOException {
        PrintWriter bos = new PrintWriter(new FileOutputStream("/tmp/resi.tmp"));
        double stp = step;
        double[] x = new double[3];
        int i = (int)(-width / stp);
        while (i < (int)(width / stp)) {
            int j = (int)(-width / stp);
            while (j < (int)(width / stp)) {
                x[0] = sp.lat + (double)i * stp;
                x[1] = sp.lon + (double)j * stp;
                x[2] = 10.0;
                double val = this.funk(x);
                if (!Double.isNaN(val)) {
                    bos.println(String.valueOf(x[0]) + " " + x[1] + " " + val);
                }
                ++j;
            }
            ++i;
        }
        bos.close();
    }

    public SourceParam simpleSearch(double step) {
        SourceParam sp = new SourceParam();
        double stp = step;
        double slat = 0.0;
        double slon = 0.0;
        double min = Double.MAX_VALUE;
        double[] x = new double[3];
        int i = (int)(-90.0 / stp);
        while (i < (int)(90.0 / stp)) {
            double min_p = Double.MAX_VALUE;
            double lat_p = 0.0;
            double lon_p = 0.0;
            int j = (int)(-180.0 / stp);
            while (j < (int)(180.0 / stp)) {
                x[0] = (double)i * stp;
                x[1] = (double)j * stp;
                x[2] = 10.0;
                double val = this.funk(x);
                if (!Double.isNaN(val)) {
                    if (min_p > val) {
                        min_p = val;
                        lat_p = x[0];
                        lon_p = x[1];
                    }
                    if (min > val) {
                        min = val;
                        slat = x[0];
                        slon = x[1];
                    }
                }
                ++j;
            }
            if (min_p != Double.MAX_VALUE) {
                System.out.println(String.valueOf(lat_p) + " " + lon_p + " " + min_p);
            }
            ++i;
        }
        sp.lat = slat;
        sp.lon = slon;
        sp.rms = min;
        return sp;
    }

    public abstract boolean findSourceLoc();

    public double getSimpleSearchStep() {
        return this.simpleSearchStep;
    }

    public void setSimpleSearchStep(double simpleSearchStep) {
        this.simpleSearchStep = simpleSearchStep;
    }
}

