/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.Phase;
import cn.org.gddsn.seis.SourceParam;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import cn.org.gddsn.seis.location.IterateNearloc;
import cn.org.gddsn.seis.ttt3d.TTTChuanDian;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Loc3dSB
extends IterateNearloc {
    static Logger logger = Logger.getLogger(Loc3dSB.class);
    private String workingPath = "/usr/local/jopens/msdp/work";
    private long firstMs = Long.MAX_VALUE;
    private StringBuffer result = new StringBuffer();
    private EvtData evtData;

    public boolean findSourceLoc() {
        TTTChuanDian ttt = (TTTChuanDian)this.computedTravelTime;
        File out = new File(ttt.getOutFileName());
        if (out.isFile() && out.canWrite()) {
            out.delete();
        }
        return this.exportPhase() && this.shell();
    }

    public SourceParam getSourceParam() {
        SourceParam sp = super.getSourceParam();
        sp.setLocProgram("Loc3dSB");
        return sp;
    }

    private String sourceParamToString(SourceParam s) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(String.format("%1$tY %1$tm %1$td %1$tH %1$tM", new Date(this.firstMs / 1000L / 60L * 1000L * 60L)));
        double sec = (double)(this.firstMs % 60000L) / 1000.0;
        sb.append(String.format(" %5.2f %4.2f", sec, 0.0));
        sb.append(String.format(" %7.3f %6.3f %8.3f %6.3f %6.2f,%5.2f %4d", s.getLat(), 0.0, s.getLon(), 0.0, s.getDepth(), 0.0, s.getLocPha()));
        sb.append(" 0.0 0.00 0.0     1     1");
        return sb.substring(0);
    }

    private String phaseToString(Phase p) {
        TTTChuanDian ttt = (TTTChuanDian)this.computedTravelTime;
        int nstn = ttt.findStationIndex(p.getNetCode(), p.getStationCode());
        if (nstn == -1) {
            logger.warn((Object)("Could not found station Index: " + p.getNetCode() + "/" + p.getStationCode()));
            return null;
        }
        int npha = ttt.findPhaseIndex(p.getPhaseName());
        if (npha == -1) {
            logger.warn((Object)("Could not found Phase Index: " + p.getPhaseName() + " for " + p.getNetCode() + "/" + p.getStationCode()));
            return null;
        }
        double pt = (double)(p.getPhaseTime().getTime() - this.firstMs / 1000L / 60L * 1000L * 60L) / 1000.0;
        return String.format("%4d%7.2f%3d", nstn, pt, npha);
    }

    private boolean exportPhase() {
        TTTChuanDian ttt = (TTTChuanDian)this.computedTravelTime;
        int tch = this.evtData.getTCN();
        this.firstMs = Long.MAX_VALUE;
        int firstChn = 0;
        int numData = 0;
        int i = 0;
        while (i < tch) {
            Vector<Phase> phs = this.evtData.getPhases(i);
            for (Phase p : phs) {
                int npha = ttt.findPhaseIndex(p.getPhaseName());
                if (p.getPhaType() == 0 && npha > -1 && npha < 9 && p.getWeight() == 1) {
                    ++numData;
                }
                if (this.firstMs <= p.getPhaseTime().getTime()) continue;
                this.firstMs = p.getPhaseTime().getTime();
                firstChn = i;
            }
            ++i;
        }
        SourceParam s = new SourceParam();
        boolean useIni = true;
        if (s.getOriginTime().getTime() != 0L) {
            s = (SourceParam)EvtData.source.clone();
            this.firstMs = s.getOriginTime().getTime();
        } else {
            s.setOriginTime(new Date(this.firstMs));
            s.setLat(this.evtData.getStationLocation(firstChn).getLatitude());
            s.setLon(this.evtData.getStationLocation(firstChn).getLongtitude());
            s.setDepth(10.0);
        }
        s.setLocPha(numData);
        File phaseFile = new File(ttt.getPhaseFileName());
        try {
            FileWriter fos = new FileWriter(phaseFile);
            fos.write(String.valueOf(this.sourceParamToString(s)) + "\n");
            int n = 0;
            int i2 = 0;
            while (i2 < tch) {
                Vector<Phase> phs = this.evtData.getPhases(i2);
                Collections.sort(phs);
                for (Phase p : phs) {
                    String phaStr;
                    int npha = ttt.findPhaseIndex(p.getPhaseName());
                    if (p.getPhaType() != 0 || npha <= -1 || npha >= 9 || p.getWeight() != 1) continue;
                    if (n > 0 && n % 5 == 0) {
                        fos.write("\n");
                    }
                    if ((phaStr = this.phaseToString(p)) != null) {
                        fos.write(phaStr);
                    }
                    ++n;
                }
                ++i2;
            }
            fos.write("\n");
            fos.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean shell() {
        TTTChuanDian ttt = (TTTChuanDian)this.computedTravelTime;
        int ret = -1;
        int nobs = -1;
        int nzero = 0;
        this.result = new StringBuffer();
        try {
            int[] neqs = new int[]{1};
            TTTChuanDian.inpute_(neqs);
            TTTChuanDian.loceqk_sb_(neqs);
            Scanner sc = new Scanner(new File(ttt.getOutFileName()));
            while (sc.hasNextLine()) {
                this.result.append(String.valueOf(sc.nextLine()) + "\n");
            }
            sc.close();
            sc = new Scanner(new File(ttt.getOutFileName()));
            sc.nextLine();
            int y = sc.nextInt();
            int m = sc.nextInt();
            int d = sc.nextInt();
            int h = sc.nextInt();
            int min = sc.nextInt();
            float sec = sc.nextFloat();
            GregorianCalendar c = new GregorianCalendar(y, m - 1, d, h, min, 0);
            long oms = c.getTime().getTime() / 1000L * 1000L + (long)((int)(sec * 1000.0f));
            this.sourceParam.setOriginTime(new Date(oms));
            this.sourceParam.setLat(sc.nextDouble());
            this.sourceParam.setLon(sc.nextDouble());
            this.sourceParam.setDepth(sc.nextDouble());
            sc.next();
            nobs = sc.nextInt();
            nzero = sc.nextInt();
            this.sourceParam.setRms(sc.nextDouble());
            this.sourceParam.setOperator("Loc3dSB");
            double d2k = 111.19;
            this.sourceParam.setOriginTimeError(sc.nextDouble());
            double er_lat = sc.nextDouble();
            double er_lon = sc.nextDouble();
            this.sourceParam.setErh(Math.max(er_lat, er_lon) * 111.19);
            this.sourceParam.setErz(sc.nextDouble());
            Hashtable<String, Float> tblDelta = new Hashtable<String, Float>();
            Hashtable<String, Float> tblAzi = new Hashtable<String, Float>();
            Hashtable<String, Float> tblTobs = new Hashtable<String, Float>();
            Hashtable<String, Float> tblRes = new Hashtable<String, Float>();
            String line = sc.nextLine();
            sc.nextLine();
            int i = 0;
            while (i < nobs) {
                line = sc.nextLine();
                Scanner sc1 = new Scanner(line);
                sc1.next();
                String sta = sc1.next();
                sc1.next();
                sc1.next();
                sc1.next();
                String pha = sc1.next();
                tblDelta.put(String.valueOf(sta) + "_" + pha, Float.valueOf(sc1.nextFloat()));
                tblAzi.put(String.valueOf(sta) + "_" + pha, Float.valueOf(sc1.nextFloat()));
                tblTobs.put(String.valueOf(sta) + "_" + pha, Float.valueOf(sc1.nextFloat()));
                tblRes.put(String.valueOf(sta) + "_" + pha, Float.valueOf(sc1.nextFloat()));
                sc1.close();
                ++i;
            }
            sc.close();
            Vector<Phase>[] vec = this.getStnPhases();
            int i2 = 0;
            while (i2 < vec.length) {
                for (Phase p : vec[i2]) {
                    Float res;
                    Float azi;
                    if (p.getPhaType() != 0) continue;
                    String sta = String.valueOf(p.getNetCode()) + p.getStationCode();
                    String key = String.valueOf(sta) + "_" + p.getPhaseName();
                    Float delta = (Float)tblDelta.get(key);
                    if (delta != null) {
                        p.setDistance(delta.floatValue());
                    }
                    if ((azi = (Float)tblAzi.get(key)) != null) {
                        p.setAzimuth(azi.floatValue());
                    }
                    if ((res = (Float)tblRes.get(key)) == null) continue;
                    p.setResi(res.floatValue());
                }
                ++i2;
            }
            ret = 0;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.sourceParam.gapAzi = this.getGapAzi();
        return ret == 0;
    }

    public String getDetailLocationResult() {
        String buf = super.getDetailLocationResult();
        return String.valueOf(buf) + this.result.substring(0);
    }

    public double getDetailResidual(int stn, String phaseName) {
        Phase phase = this.getPhase(stn, phaseName);
        if (phase == null) {
            return -99999.0;
        }
        return phase.getResi();
    }

    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    public EvtData getEvtData() {
        return this.evtData;
    }

    public void setEvtData(EvtData evtData) {
        EvtData.generateChuanDianStationList(evtData);
        TTTChuanDian.init();
        this.evtData = evtData;
    }

    public void setComputedTravelTime(ComputedTravelTime newCompTT) {
        this.computedTravelTime = new TTTChuanDian();
    }
}

