/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.signal.NumericProcess;

public class MwTsuboi {
    private static final double TUBOI_MAGIC = 2.1065416724532307E10;
    private static final double MO_CONSTANT = 9.0;
    private static final double CONST1 = 1.5;
    private static final double CONST2 = 0.13333;
    private static final double[] INT_AC = new double[]{1.0, -1.99529652093414, 0.99531621372129};
    private static final double[] INT_BC = new double[]{6.2243356986E-4, 0.00124449022277, 6.1948714358E-4};
    private static final double KM_PER_DEG = 111.19;
    public static final double DELTA_MIN = 3.0;
    public static final double DELTA_MAX = 105.0;

    private MwTsuboi() {
    }

    public static double computeAmp(double[] wave, int srate, double gain, int phaseIdx, double delta, double pct) {
        if (delta < 3.0 || delta > 105.0) {
            return Double.NaN;
        }
        double average = MwTsuboi.computeAverage(phaseIdx, wave);
        int i = 0;
        while (i < wave.length) {
            int n = i++;
            wave[n] = wave[n] - average;
        }
        int iw = (int)((double)wave.length * pct);
        MwTsuboi.doWeight(wave, iw);
        double[] dis = MwTsuboi.velocityToDistance(wave, srate);
        double maxIntegDisAmp = Math.abs(dis[phaseIdx - 1]);
        int i2 = phaseIdx;
        while (i2 < dis.length) {
            double m0 = Math.abs(dis[i2]);
            if (maxIntegDisAmp < m0) {
                maxIntegDisAmp = m0;
            }
            ++i2;
        }
        return maxIntegDisAmp / gain * 1000.0;
    }

    public static double computeMwp(double[] wave, int srate, double gain, int phaseIdx, double delta, double pct) {
        double maxIntegDisAmp = MwTsuboi.computeAmp(wave, srate, gain, phaseIdx, delta, pct);
        return MwTsuboi.computeMwp(maxIntegDisAmp, delta);
    }

    public static double computeMwp(double maxIntegDisAmp, double delta) {
        if (delta < 3.0 || delta > 105.0) {
            return Double.NaN;
        }
        if (maxIntegDisAmp <= 0.0) {
            return Double.NaN;
        }
        double amo = Math.log10(Math.abs(maxIntegDisAmp)) + Math.log10(2.1065416724532307E10 * delta * 111.19) + 9.0;
        return amo / 1.5 + 0.13333;
    }

    private static double computeAverage(int n, double[] data) {
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += data[i];
            ++i;
        }
        return sum / (double)n;
    }

    private static void doWeight(double[] d, int iw) {
        int nwgt = 2 * iw;
        double[] wgt = new double[nwgt];
        int i = 0;
        while (i <= nwgt) {
            wgt[i] = Math.cos(Math.PI * (double)(i - iw) / (double)nwgt);
            ++i;
        }
        i = 0;
        while (i <= iw) {
            int n = i;
            d[n] = d[n] * wgt[i];
            int n2 = d.length - 1 - i;
            d[n2] = d[n2] * wgt[nwgt - i];
            ++i;
        }
    }

    static double[] velocityToDistance(double[] vel, double srate) {
        double[] d = NumericProcess.trapezium(vel, 1.0 / srate);
        return NumericProcess.trapezium(d, 1.0 / srate);
    }

    static double[] velocityToDistance__orig(double[] vel, int n) {
        double[] dis = new double[n];
        int i = 2;
        while (i < n) {
            dis[i] = INT_BC[0] * vel[i] + INT_BC[1] * vel[i - 1] + INT_BC[2] * vel[i - 2] - (INT_AC[1] * dis[i - 1] + INT_AC[2] * dis[i - 2]);
            ++i;
        }
        return dis;
    }
}

