/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.seis.BasicStation;
import cn.org.gddsn.seis.evtformat.EvtData;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Scanner;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StationMapping {
    static Logger logger = Logger.getLogger(StationMapping.class);
    private int staMaxLength = 6;
    private Hashtable<String, String> s2ns = new Hashtable(256);
    private Hashtable<String, String> ns2s = new Hashtable(256);
    private File aliasFile = new File("cfg/StaAlias.txt");

    public StationMapping() {
        this(6);
    }

    public StationMapping(int staMaxLength) {
        this.staMaxLength = staMaxLength;
        this.readStaAlias();
    }

    public void readStaAlias() {
        if (!this.aliasFile.exists()) {
            return;
        }
        try {
            String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
            Scanner sc = new Scanner(new File("cfg", "StaAlias.txt")).useDelimiter(delimiter);
            while (sc.hasNext()) {
                String key = sc.next();
                String ss = sc.next();
                this.ns2s.put(key, ss);
                this.s2ns.put(ss, key);
            }
            sc.close();
        }
        catch (IOException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void buildStationMap(EvtData evt) {
        this.ns2s.clear();
        this.s2ns.clear();
        int i = 0;
        while (i < evt.getTCN()) {
            String net = evt.getNetworkCode(i);
            String sta = evt.getStationCode(i);
            String key = String.valueOf(net) + "." + sta;
            String sta1 = this.ns2s.get(key);
            if (sta1 == null) {
                String ss = (String.valueOf(net) + "." + sta).toUpperCase();
                if (ss.length() > this.staMaxLength) {
                    ss = sta.toUpperCase();
                }
                this.ns2s.put(key, ss);
                String nsta1 = this.s2ns.get(ss);
                if (nsta1 == null) {
                    this.s2ns.put(ss, key);
                } else {
                    int n = 0;
                    while (n < 1000) {
                        nsta1 = this.s2ns.get("S" + n);
                        if (nsta1 == null) {
                            this.ns2s.put(key, "S" + n);
                            this.s2ns.put("S" + n, key);
                            break;
                        }
                        ++n;
                    }
                }
            }
            ++i;
        }
    }

    public void buildStationMap(Collection<BasicStation> stnList) {
        this.ns2s.clear();
        this.s2ns.clear();
        block0: for (BasicStation bs : stnList) {
            String net = bs.getNet();
            String sta = bs.getSta();
            String key = String.valueOf(net) + "." + sta;
            String sta1 = this.ns2s.get(key);
            if (sta1 != null) continue;
            String ss = (String.valueOf(net) + "." + sta).toUpperCase();
            if (ss.length() > this.staMaxLength) {
                ss = sta.toUpperCase();
            }
            this.ns2s.put(key, ss);
            String nsta1 = this.s2ns.get(ss);
            if (nsta1 == null) {
                this.s2ns.put(ss, key);
                continue;
            }
            int n = 0;
            while (n < 1000) {
                nsta1 = this.s2ns.get("S" + n);
                if (nsta1 == null) {
                    this.ns2s.put(key, "S" + n);
                    this.s2ns.put("S" + n, key);
                    continue block0;
                }
                ++n;
            }
        }
    }

    public String getStation(String net, String sta) {
        return this.ns2s.get(String.valueOf(net) + "." + sta);
    }

    public String getNetStation(String sta) {
        return this.s2ns.get(sta);
    }
}

