/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location;

import cn.org.gddsn.convert.SphereUtil;
import cn.org.gddsn.seis.location.ComputedTravelTime;
import com.nr.UniVarRealValueFun;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class TTLayeredSpace
implements UniVarRealValueFun,
ComputedTravelTime {
    static Logger logger = Logger.getLogger(TTLayeredSpace.class);
    public static final String[] PHS = new String[]{"P", "S", "Pn", "Sn", "Pg", "Sg", "P*", "PmP"};
    private static final int MAXLAY = 20;
    private int nLay = 0;
    private int iSrc;
    private double zSrc;
    private double xSrc;
    private double[] zTop = new double[40];
    private double[] vLay = new double[40];
    boolean initMod = false;
    private double PoverS = 1.72;

    public double funk(double x) {
        return this.t_dis(x);
    }

    public int t_model(double z, double v) {
        if (this.nLay < 20) {
            this.zTop[this.nLay] = z;
            this.vLay[this.nLay] = v;
            ++this.nLay;
        }
        int i = 1;
        while (i < this.nLay) {
            this.zTop[2 * this.nLay - 1 - i] = 2.0 * this.zTop[this.nLay - 1] - this.zTop[i];
            this.vLay[2 * this.nLay - 1 - i] = this.vLay[i - 1];
            ++i;
        }
        this.zTop[this.nLay] = this.zTop[this.nLay - 1] + 0.01;
        return this.nLay;
    }

    private int t_set() {
        if (this.initMod) {
            return this.nLay;
        }
        this.initMod = true;
        return this.nLay;
    }

    public double t_fun(double r) {
        double p = Math.atan(r / this.zSrc);
        double t = 0.0;
        int i = 0;
        while (i <= this.iSrc) {
            double td;
            if (i == this.iSrc) {
                td = Math.abs(this.zSrc - this.zTop[i]) / Math.cos(p) / this.vLay[i];
            } else {
                double q = Math.asin(this.vLay[i] * Math.sin(p) / this.vLay[this.iSrc]);
                td = (this.zTop[i + 1] - this.zTop[i]) / Math.cos(q) / this.vLay[i];
            }
            t += td;
            ++i;
        }
        return t;
    }

    public double t_dis(double r) {
        double p = Math.atan(r / this.zSrc);
        double x = 0.0;
        int i = 0;
        while (i <= this.iSrc) {
            double xd;
            if (i == this.iSrc) {
                xd = (this.zSrc - this.zTop[i]) * Math.tan(p);
            } else {
                double q = Math.asin(this.vLay[i] * Math.sin(p) / this.vLay[this.iSrc]);
                xd = (this.zTop[i + 1] - this.zTop[i]) * Math.tan(q);
            }
            x += xd;
            ++i;
        }
        return (x - this.xSrc) * (x - this.xSrc);
    }

    public double t_lay(double r, double z, double[] dtdr, double[] dtdz) {
        double toa = 0.0;
        double[] ax = new double[1];
        double[] bx = new double[1];
        double[] cx = new double[1];
        double[] fa = new double[1];
        double[] fb = new double[1];
        double[] fc = new double[1];
        double[] xmin = new double[1];
        this.t_set();
        double tmin = 10000.0;
        double sgn = 1.0;
        if (z < 0.0) {
            z = -z;
            sgn = -sgn;
        }
        int isrc = 0;
        int i = 1;
        while (i < this.nLay) {
            if (z > this.zTop[i]) {
                isrc = i;
            }
            ++i;
        }
        this.iSrc = isrc;
        this.zSrc = z;
        if (this.zSrc < 0.01) {
            this.zSrc = 0.01;
        }
        this.xSrc = r;
        i = isrc + 1;
        while (i < this.nLay) {
            double t = 0.0;
            double x = 0.0;
            double p = 1.0 / this.vLay[i];
            int j = 0;
            while (j < i) {
                double q = Math.asin(p * this.vLay[j]);
                double td = (this.zTop[j + 1] - this.zTop[j]) / Math.cos(q) / this.vLay[j];
                double xd = (this.zTop[j + 1] - this.zTop[j]) * Math.tan(q);
                t += td;
                x += xd;
                if (j == isrc) {
                    t += td * (this.zTop[j + 1] - z) / (this.zTop[j + 1] - this.zTop[j]);
                    x += xd * (this.zTop[j + 1] - z) / (this.zTop[j + 1] - this.zTop[j]);
                }
                if (j > isrc) {
                    t += td;
                    x += xd;
                }
                ++j;
            }
            if (x < r && (t += (r - x) / this.vLay[i]) < tmin) {
                tmin = t;
                toa = Math.PI - Math.asin(p * this.vLay[isrc]);
            }
            ++i;
        }
        ax[0] = 0.8 * this.xSrc;
        bx[0] = 1.5 * this.xSrc;
        Callback.mnbrak(ax, bx, cx, fa, fb, fc, this);
        Callback.brent(ax[0], bx[0], cx[0], this, 0.001, xmin);
        double tdir = this.t_fun(xmin[0]);
        if (tdir < tmin) {
            tmin = tdir;
            toa = Math.atan(xmin[0] / this.zSrc);
            if (toa < 0.0) {
                toa += Math.PI;
            }
        }
        dtdz[0] = sgn * Math.cos(toa) / this.vLay[isrc];
        dtdr[0] = Math.sin(toa) / this.vLay[isrc];
        return tmin;
    }

    public double t_direct(double r, double z, double[] dtdr, double[] dtdz) {
        double[] ax = new double[1];
        double[] bx = new double[1];
        double[] cx = new double[1];
        double[] fa = new double[1];
        double[] fb = new double[1];
        double[] fc = new double[1];
        double[] xmin = new double[1];
        this.iSrc = 0;
        int i = 1;
        while (i < this.nLay) {
            if (z > this.zTop[i]) {
                this.iSrc = i;
            }
            ++i;
        }
        this.zSrc = z;
        this.xSrc = r;
        ax[0] = 0.8 * this.xSrc;
        bx[0] = 1.5 * this.xSrc;
        Callback.mnbrak(ax, bx, cx, fa, fb, fc, this);
        Callback.brent(ax[0], bx[0], cx[0], this, 0.001, xmin);
        double toa = Math.atan(xmin[0] / z);
        if (toa < 0.0) {
            toa += Math.PI;
        }
        double tp = this.t_fun(xmin[0]);
        dtdz[0] = Math.cos(toa) / this.vLay[this.iSrc];
        dtdr[0] = Math.sin(toa) / this.vLay[this.iSrc];
        return tp;
    }

    public double t_pmp(double r, double z, double[] dtdr, double[] dtdz) {
        double[] ax = new double[1];
        double[] bx = new double[1];
        double[] cx = new double[1];
        double[] fa = new double[1];
        double[] fb = new double[1];
        double[] fc = new double[1];
        double[] xmin = new double[1];
        int nlay = this.nLay;
        this.nLay = 2 * nlay - 1;
        this.iSrc = 0;
        int i = 1;
        while (i < this.nLay) {
            if (z > this.zTop[i]) {
                this.iSrc = i;
            }
            ++i;
        }
        this.zSrc = z;
        this.xSrc = r;
        ax[0] = 0.8 * this.xSrc;
        bx[0] = 1.5 * this.xSrc;
        Callback.mnbrak(ax, bx, cx, fa, fb, fc, this);
        Callback.brent(ax[0], bx[0], cx[0], this, 0.001, xmin);
        double toa = Math.atan(xmin[0] / z);
        if (toa < 0.0) {
            toa += Math.PI;
        }
        double tpmp = this.t_fun(xmin[0]);
        dtdz[0] = -Math.cos(toa) / this.vLay[this.iSrc];
        dtdr[0] = Math.sin(toa) / this.vLay[this.iSrc];
        this.nLay = nlay;
        return tpmp;
    }

    public double t_phase(int ph, double r, double z, double[] dtdr, double[] dtdz) {
        double t = -1.0;
        this.t_set();
        switch (ph) {
            case 0: 
            case 2: {
                t = this.t_lay(r, z, dtdr, dtdz);
                break;
            }
            case 1: 
            case 3: {
                t = this.PoverS * this.t_lay(r, z, dtdr, dtdz);
                dtdr[0] = dtdr[0] * this.PoverS;
                dtdz[0] = dtdz[0] * this.PoverS;
                break;
            }
            case 4: {
                --this.nLay;
                t = this.t_lay(r, z, dtdr, dtdz);
                ++this.nLay;
                break;
            }
            case 5: {
                --this.nLay;
                t = this.PoverS * this.t_lay(r, z, dtdr, dtdz);
                ++this.nLay;
                dtdr[0] = dtdr[0] * this.PoverS;
                dtdz[0] = dtdz[0] * this.PoverS;
                break;
            }
            case 6: {
                t = this.t_direct(r, z, dtdr, dtdz);
                break;
            }
            case 7: {
                t = this.t_pmp(r, z, dtdr, dtdz);
            }
        }
        return t;
    }

    public int t_region(double r, double z, TPHASE[] treg) {
        double[] dtdr = new double[1];
        double[] dtdz = new double[1];
        double t = this.t_lay(r, z, dtdr, dtdz);
        treg[0].phase = 0;
        treg[0].t = t;
        treg[0].dtdr = dtdr[0];
        treg[0].dtdz = dtdz[0];
        treg[1].phase = 1;
        treg[1].t = this.PoverS * t;
        treg[1].dtdr = this.PoverS * dtdr[0];
        treg[1].dtdz = this.PoverS * dtdz[0];
        if (this.nLay < 2) {
            return 2;
        }
        --this.nLay;
        t = this.t_lay(r, z, dtdr, dtdz);
        ++this.nLay;
        if (t < treg[0].t + 0.1) {
            return 2;
        }
        treg[0].phase = 2;
        treg[1].phase = 3;
        treg[2].phase = 4;
        treg[2].t = t;
        treg[2].dtdr = dtdr[0];
        treg[2].dtdz = dtdz[0];
        treg[3].phase = 5;
        treg[3].t = this.PoverS * t;
        treg[3].dtdr = this.PoverS * dtdr[0];
        treg[3].dtdz = this.PoverS * dtdz[0];
        return 4;
    }

    public double calDelta(double depth, double time, int phaseType) {
        return -1.0;
    }

    public double calTravelTime(double depth, double deta, int phaseType) {
        int type = -1;
        switch (phaseType) {
            case 8: {
                type = 0;
            }
            case 9: {
                type = 1;
            }
            case 1: {
                type = 2;
            }
            case 2: {
                type = 3;
            }
            case 3: {
                type = 4;
            }
            case 4: {
                type = 5;
            }
        }
        type = -1;
        if (type == -1) {
            return -1.0;
        }
        double[] dtdr = new double[1];
        double[] dtdz = new double[1];
        return this.t_phase(type, depth, deta * 111.19, dtdr, dtdz);
    }

    public double calTravelTime(double[] src, double[] stn, int phaseType) {
        double z = SphereUtil.distOnSphere((double)src[0], (double)src[1], (double)stn[0], (double)stn[1]);
        return this.calTravelTime(src[2], z, phaseType);
    }

    public double calDelta(double depth, double time, String phaseType) {
        return -1.0;
    }

    public double calTravelTime(double[] src, double[] stn, String phaseType) {
        double z = SphereUtil.distOnSphere((double)src[0], (double)src[1], (double)stn[0], (double)stn[1]);
        return this.calTravelTime(src[2], z, phaseType);
    }

    public double calTravelTime(double depth, double delta, String phaseType) {
        if (!(phaseType.equals("Pn") || phaseType.equals("Sn") || phaseType.equals("Pg") || phaseType.equals("Sg") || phaseType.equals("P") || phaseType.equals("S"))) {
            return -1.0;
        }
        int type = -1;
        type = phaseType.equals("P") ? 0 : (phaseType.equals("S") ? 1 : (phaseType.equals("Pn") ? 2 : (phaseType.equals("Sn") ? 3 : (phaseType.equals("Pg") ? 4 : (phaseType.equals("Sg") ? 5 : -1)))));
        if (type == -1) {
            return -1.0;
        }
        double[] dtdr = new double[1];
        double[] dtdz = new double[1];
        return this.t_phase(type, depth, delta * 111.19, dtdr, dtdz);
    }

    public void loadModel(String modelFile) throws IOException {
        Scanner sc = new Scanner(new File(modelFile));
        int count = 0;
        while (sc.hasNext()) {
            String key = sc.next();
            if (key.startsWith("#")) {
                sc.skip(".*\n");
                continue;
            }
            if (key.equals("Vp/Vs")) {
                this.PoverS = sc.nextDouble();
                continue;
            }
            double z = Double.parseDouble(key);
            double vp = sc.nextDouble();
            this.t_model(z, vp);
            if (++count >= 20) break;
        }
        sc.close();
    }

    public static void main(String[] args) throws IOException {
        String[] phs;
        if (args.length == 0) {
            System.err.println("Usage: TTLayeredSpace [nph,nph] r z");
            System.err.println("0 = P, 1 = S, 2 = Pn, 3 = Sn, 4 = Pg, 5 = Sg, 6 = P*, 7=PmP");
            System.exit(-1);
        }
        TTLayeredSpace htt = new TTLayeredSpace();
        htt.loadModel("model.par");
        double r = Double.parseDouble(args[1]);
        double z = Double.parseDouble(args[2]);
        double[] dtdr = new double[1];
        double[] dtdz = new double[1];
        String[] stringArray = phs = args[0].split(",");
        int n = phs.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            int ph = Integer.parseInt(p.trim());
            double tt = htt.t_phase(ph, r, z, dtdr, dtdz);
            System.out.printf("ph = %-4s, t = %7.2f, dtdr = %7.2f, dtdz = %7.2f\n", PHS[ph], tt, dtdr[0], dtdz[0]);
            ++n2;
        }
    }

    private static class Callback {
        private static final int ITMAX = 100;
        private static final double CGOLD = 0.381966;
        private static final double ZEPS = 1.0E-10;
        private static final double GOLD = 1.618034;
        private static final double GLIMIT = 100.0;
        private static final double TINY = 1.0E-20;

        private Callback() {
        }

        private static double SIGN(double a, double b) {
            return b > 0.0 ? Math.abs(a) : -Math.abs(a);
        }

        static double brent(double ax, double bx, double cx, UniVarRealValueFun svrvf, double tol, double[] xmin) {
            double fx;
            double v;
            double d = 0.0;
            double e = 0.0;
            double a = ax < cx ? ax : cx;
            double b = ax > cx ? ax : cx;
            double w = v = bx;
            double x = v;
            double fv = fx = svrvf.funk(x);
            double fw = fx;
            int iter = 1;
            while (iter <= 100) {
                double u;
                double xm = 0.5 * (a + b);
                double tol1 = tol * Math.abs(x) + 1.0E-10;
                double tol2 = 2.0 * tol1;
                if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                    xmin[0] = x;
                    return fx;
                }
                if (Math.abs(e) > tol1) {
                    double r = (x - w) * (fx - fv);
                    double q = (x - v) * (fx - fw);
                    double p = (x - v) * q - (x - w) * r;
                    if ((q = 2.0 * (q - r)) > 0.0) {
                        p = -p;
                    }
                    q = Math.abs(q);
                    double etemp = e;
                    e = d;
                    if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                        e = x >= xm ? a - x : b - x;
                        d = 0.381966 * e;
                    } else {
                        d = p / q;
                        u = x + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = Callback.SIGN(tol1, xm - x);
                        }
                    }
                } else {
                    e = x >= xm ? a - x : b - x;
                    d = 0.381966 * e;
                }
                u = Math.abs(d) >= tol1 ? x + d : x + Callback.SIGN(tol1, d);
                double fu = svrvf.funk(u);
                if (fu <= fx) {
                    if (u >= x) {
                        a = x;
                    } else {
                        b = x;
                    }
                    v = w;
                    w = x;
                    x = u;
                    fv = fw;
                    fw = fx;
                    fx = fu;
                } else {
                    if (u < x) {
                        a = u;
                    } else {
                        b = u;
                    }
                    if (fu <= fw || w == x) {
                        v = w;
                        w = u;
                        fv = fw;
                        fw = fu;
                    } else if (fu <= fv || v == x || v == w) {
                        v = u;
                        fv = fu;
                    }
                }
                ++iter;
            }
            xmin[0] = x;
            return fx;
        }

        static void mnbrak(double[] ax, double[] bx, double[] cx, double[] fa, double[] fb, double[] fc, UniVarRealValueFun svrvf) {
            fa[0] = svrvf.funk(ax[0]);
            fb[0] = svrvf.funk(bx[0]);
            if (fb[0] > fa[0]) {
                double dum = ax[0];
                ax[0] = bx[0];
                bx[0] = dum;
                dum = fb[0];
                fb[0] = fa[0];
                fa[0] = dum;
            }
            cx[0] = bx[0] + 1.618034 * (bx[0] - ax[0]);
            fc[0] = svrvf.funk(cx[0]);
            while (fb[0] > fc[0]) {
                double fu;
                double r = (bx[0] - ax[0]) * (fb[0] - fc[0]);
                double q = (bx[0] - cx[0]) * (fb[0] - fa[0]);
                double u = bx[0] - ((bx[0] - cx[0]) * q - (bx[0] - ax[0]) * r) / (2.0 * Callback.SIGN(Math.max(Math.abs(q - r), 1.0E-20), q - r));
                double ulim = bx[0] + 100.0 * (cx[0] - bx[0]);
                if ((bx[0] - u) * (u - cx[0]) > 0.0) {
                    fu = svrvf.funk(u);
                    if (fu < fc[0]) {
                        ax[0] = bx[0];
                        bx[0] = u;
                        fa[0] = fb[0];
                        fb[0] = fu;
                        return;
                    }
                    if (fu > fb[0]) {
                        cx[0] = u;
                        fc[0] = fu;
                        return;
                    }
                    u = cx[0] + 1.618034 * (cx[0] - bx[0]);
                    fu = svrvf.funk(u);
                } else if ((cx[0] - u) * (u - ulim) > 0.0) {
                    fu = svrvf.funk(u);
                    if (fu < fc[0]) {
                        bx[0] = cx[0];
                        cx[0] = u;
                        u = cx[0] + 1.618034 * (cx[0] - bx[0]);
                        fb[0] = fc[0];
                        fc[0] = fu;
                        fu = svrvf.funk(u);
                    }
                } else if ((u - ulim) * (ulim - cx[0]) >= 0.0) {
                    u = ulim;
                    fu = svrvf.funk(u);
                } else {
                    u = cx[0] + 1.618034 * (cx[0] - bx[0]);
                    fu = svrvf.funk(u);
                }
                ax[0] = bx[0];
                bx[0] = cx[0];
                cx[0] = u;
                fa[0] = fb[0];
                fb[0] = fc[0];
                fc[0] = fu;
            }
        }
    }

    public static class TPHASE {
        public int phase;
        public double t;
        public double dtdr;
        public double dtdz;
    }
}

