/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.hyposat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class HyposatParameter {
    public static final String GLOBAL_MODEL = "GLOBAL MODEL                       :";
    public static final String GLOBAL_MODEL2 = "GLOBAL MODEL 2                     :";
    public static final String GLOBAL_MODEL3 = "GLOBAL MODEL 3                     :";
    public static final String GLOBAL_MODEL4 = "GLOBAL MODEL 4                     :";
    public static final String LOCAL_OR_REGIONAL_MODEL = "LOCAL OR REGIONAL MODEL            :";
    public static final String PHASE_INDEX_FOR_LOCAL_MODEL = "PHASE INDEX FOR LOCAL MODEL        :";
    public static final String CRUST = "CRUST 5.1                          :";
    public static final String CRUST_PATH = "CRUST 5.1 PATH                     :";
    public static final String OUTPUT_OF_REGIONAL_MODEL = "OUTPUT OF REGIONAL MODEL (DEF 0)   :";
    public static final String STATION_FILE = "STATION FILE                       :";
    public static final String P_VELOCITY_TO_CORRECT_ELEVATION = "P-VELOCITY TO CORRECT ELEVATION    :";
    public static final String S_VELOCITY_TO_CORRECT_ELEVATION = "S-VELOCITY TO CORRECT ELEVATION    :";
    public static final String STATION_CORRECTION_FILE = "STATION CORRECTION FILE            :";
    public static final String LG_GROUP_VELOCITY = "LG GROUP-VELOCITY (DEF 3.5  [km/s]):";
    public static final String RG_GROUP_VELOCITY = "RG GROUP-VELOCITY (DEF 2.5  [km/s]):";
    public static final String LQ_GROUP_VELOCITY = "LQ GROUP-VELOCITY (DEF 4.4  [km/s]):";
    public static final String LR_GROUP_VELOCITY = "LR GROUP-VELOCITY (DEF 3.95 [km/s]):";
    public static final String AZIMUTH_ONLY_INITIAL_SOLUTION = "AZIMUTH ONLY INITIAL SOLUTION (0/1):";
    public static final String PLANE_WAVE_APPROXIMATION = "PLANE WAVE APPROXIMATION (0/1)     :";
    public static final String STARTING_SOURCE_LATITUDE = "STARTING SOURCE LATITUDE  [deg]    :";
    public static final String STARTING_LATITUDE_ERROR = "STARTING LATITUDE ERROR   [deg]    :";
    public static final String STARTING_SOURCE_LONGITUDE = "STARTING SOURCE LONGITUDE [deg]    :";
    public static final String STARTING_LONGITUDE_ERROR = "STARTING LONGITUDE ERROR  [deg]    :";
    public static final String STARTING_SOURCE_DEPTH = "STARTING SOURCE DEPTH     [km]     :";
    public static final String STARTING_DEPTH_ERROR = "STARTING DEPTH ERROR      [km]     :";
    public static final String DEPTH_FLAG = "DEPTH FLAG (f,b,d,F,B,D)           :";
    public static final String STARTING_SOURCE_TIME = "STARTING SOURCE TIME (EPOCHAL TIME):";
    public static final String STARTING_TIME_ERROR = "STARTING TIME ERROR       [s]      :";
    public static final String MAXIMUM_OF_ITERATIONS = "MAXIMUM # OF ITERATIONS            :";
    public static final String LOCATION_ACCURACY = "LOCATION ACCURACY [km] (DEFAULT 1.):";
    public static final String CONSTRAIN_SOLUTION = "CONSTRAIN SOLUTION (0/1)           :";
    public static final String CONFIDENCE_LEVEL = "CONFIDENCE LEVEL  (68.3 - 99.99 %) :";
    public static final String EPICENTER_ERROR_ELLIPSE = "EPICENTER ERROR ELLIPSE (DEF 1)    :";
    public static final String SLOWNESS = "SLOWNESS [S/DEG] ( 0 = APP. VEL)   :";
    public static final String MAXIMUM_AZIMUTH_ERROR = "MAXIMUM AZIMUTH ERROR     [deg]    :";
    public static final String MAXIMUM_SLOWNESS_ERROR = "MAXIMUM SLOWNESS ERROR    [s/deg]  :";
    public static final String FLAG_USING_TRAVEL_TIME_DIFFERENCES = "FLAG USING TRAVEL-TIME DIFFERENCES :";
    public static final String MAGNITUDE_CALCULATION = "MAGNITUDE CALCULATION (DEF 0)      :";
    public static final String P_ATTENUATION_MODEL = "P-ATTENUATION MODEL (G-R or V-C)   :";
    public static final String S_ATTENUATION_MODEL = "S-ATTENUATION MODEL (IASPEI or R-P):";
    public static final String INPUT_FILE_NAME = "INPUT FILE NAME (DEF hyposat-in)   :";
    public static final String OUTPUT_SWITCH = "OUTPUT SWITCH  (YES = 1, DEFAULT)  :";
    public static final String OUTPUT_FILE_NAME = "OUTPUT FILE NAME (DEF hyposat-out) :";
    public static final String OUTPUT_LEVEL = "OUTPUT LEVEL                       :";
    private File paramFile = null;
    private Hashtable<String, String> param = new Hashtable();

    public void parse() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.paramFile)));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.length() <= 37 || line.charAt(35) != ':') continue;
            String key = line.substring(0, 36);
            String value = line.substring(37);
            this.param.put(key, value);
        }
        bufferedReader.close();
    }

    public void export() throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(this.paramFile));
        Enumeration<String> enu = this.param.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextElement();
            pw.println(String.valueOf(key) + " " + this.param.get(key));
        }
        pw.close();
    }

    public void setValue(String key, String value) {
        this.param.put(key, value);
    }

    public String getValue(String key) {
        return this.param.get(key);
    }

    public void print() {
        Enumeration<String> enu = this.param.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextElement();
            System.out.println(String.valueOf(key) + " " + this.param.get(key));
        }
    }

    public File getParamFile() {
        return this.paramFile;
    }

    public void setParamFile(File paramFile) {
        this.paramFile = paramFile;
    }

    public static void main(String[] args) throws Exception {
        HyposatParameter hp = new HyposatParameter();
        hp.setParamFile(new File("/tmp/hyposat-parameter"));
        hp.parse();
        hp.print();
    }
}

