/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class Correction {
    static Logger logger = Logger.getLogger(Correction.class);
    static final double P_JB_CRUST_TIME = 5.459328207203562;
    static final double S_JB_CRUST_TIME = 9.186564144071227;
    private static final double JB_ISO_HEIGHT = 91.41;
    private static final int[][] crust_type = new int[90][180];
    private static final Crust[] c_type = new Crust[360];
    private static final int CRUST_CORR_MIN_DELTA = 20;
    private static final int[] delta_step;

    static {
        try {
            int j;
            InputStream in = Correction.class.getResourceAsStream("crust_type.h");
            Scanner sc = new Scanner(in);
            sc.useDelimiter("[\\s\\{\\},]+");
            int i = 0;
            while (i < 90) {
                j = 0;
                while (j < 180) {
                    Correction.crust_type[i][j] = sc.nextInt();
                    ++j;
                }
                ++i;
            }
            sc.close();
            in.close();
            in = Correction.class.getResourceAsStream("crust_type_key.h");
            sc = new Scanner(in);
            sc.useDelimiter("[\\s\\{\\},]+");
            i = 0;
            while (i < 360) {
                Correction.c_type[i] = new Crust();
                sc.next();
                Correction.c_type[i].descrip = sc.nextLine();
                j = 0;
                while (j < 8) {
                    Correction.c_type[i].p_vel[j] = sc.nextDouble();
                    ++j;
                }
                j = 0;
                while (j < 8) {
                    Correction.c_type[i].s_vel[j] = sc.nextDouble();
                    ++j;
                }
                j = 0;
                while (j < 8) {
                    Correction.c_type[i].density[j] = sc.nextDouble();
                    ++j;
                }
                j = 0;
                while (j < 9) {
                    Correction.c_type[i].thick[j] = sc.nextDouble();
                    ++j;
                }
                ++i;
            }
            sc.close();
            in.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
        }
        delta_step = new int[]{9, 13, 22, 41, 63, 72, 83, 124, 140, 180};
    }

    public static double calc_elev_corr(ISCPha pp) {
        double elev_corr;
        if (pp.sta_elev == 9999999.0) {
            return 0.0;
        }
        if (pp.phase.equals("P") || pp.phase.equals("PKP") || pp.phase.equals("Pn") || pp.phase.equals("Pb")) {
            elev_corr = 5.57 * (pp.dtdd / 111.195);
            elev_corr *= elev_corr;
            elev_corr = 1.0 / Math.sqrt(1.0 - elev_corr);
            elev_corr *= pp.sta_elev / 5570.0;
        } else if (pp.phase.equals("S") || pp.phase.equals("SKS") || pp.phase.equals("Sn") || pp.phase.equals("Sb")) {
            elev_corr = 3.34 * (pp.dtdd / 111.195);
            elev_corr *= elev_corr;
            elev_corr = 1.0 / Math.sqrt(1.0 - elev_corr);
            elev_corr *= pp.sta_elev / 3340.0;
        } else {
            elev_corr = 0.0;
        }
        return elev_corr;
    }

    public static double calc_crust_corr(char ps, double lat, double lon, double depth, double elev, double dtdd) {
        double jb_crust_time;
        double layer_time;
        int i;
        double n_vel;
        double b_vel;
        double g_vel;
        double[] vel = new double[8];
        double elev_corr = 0.0;
        int col = (int)((90.0 - lat) / 2.0);
        int row = (int)((180.0 + lon) / 2.0);
        int c = crust_type[col][row];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_crust_corr: lat=%.3f lon=%.3f c[%d][%d]=%d", lat, lon, col, row, c));
        }
        if (ps == 'P') {
            g_vel = 5.57;
            b_vel = 6.5;
            n_vel = 7.88;
            i = 0;
            while (i < 8) {
                vel[i] = Correction.c_type[c].p_vel[i];
                ++i;
            }
        } else if (ps == 'S') {
            g_vel = 3.34;
            b_vel = 3.83;
            n_vel = 4.38;
            i = 0;
            while (i < 8) {
                vel[i] = Correction.c_type[c].s_vel[i];
                ++i;
            }
        } else {
            logger.debug((Object)String.format("calc_crust_corr: wrong ps value %c", Character.valueOf(ps)));
            return 1.0;
        }
        if (depth > 33.0 || depth > Correction.c_type[c].thick[8]) {
            return 0.0;
        }
        double iso_height = 0.0;
        i = 0;
        while (i < 7) {
            iso_height += Correction.c_type[c].thick[i] * Correction.c_type[c].density[i];
            ++i;
        }
        double extra_mantle = (91.41 - iso_height) / 3.32;
        double iso_corr = n_vel * (dtdd / 111.195);
        iso_corr *= iso_corr;
        iso_corr = 1.0 / Math.sqrt(1.0 - iso_corr);
        iso_corr *= extra_mantle / n_vel;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_crust_corr: extra_mantle=%.3f iso_corr=%.3f", extra_mantle, iso_corr));
        }
        if (depth < 15.0) {
            layer_time = b_vel * (dtdd / 111.195);
            layer_time *= layer_time;
            layer_time = 1.0 / Math.sqrt(1.0 - layer_time);
            jb_crust_time = layer_time *= 18.0 / b_vel;
            layer_time = g_vel * (dtdd / 111.195);
            layer_time *= layer_time;
            layer_time = 1.0 / Math.sqrt(1.0 - layer_time);
            jb_crust_time += (layer_time *= (15.0 - depth) / g_vel);
        } else {
            layer_time = b_vel * (dtdd / 111.195);
            layer_time *= layer_time;
            layer_time = 1.0 / Math.sqrt(1.0 - layer_time);
            jb_crust_time = layer_time *= (33.0 - depth) / b_vel;
        }
        double crust_time = 0.0;
        double cumulative_thick = 0.0;
        i = 2;
        while (i < 7) {
            if (!(depth > (cumulative_thick += Correction.c_type[c].thick[i]))) {
                if (crust_time > 0.0) {
                    layer_time = vel[i] * (dtdd / 111.195);
                    if ((layer_time *= layer_time) >= 1.0) {
                        logger.debug((Object)String.format("WARN: layer_time = %f", layer_time));
                    } else {
                        layer_time = 1.0 / Math.sqrt(1.0 - layer_time);
                        crust_time += (layer_time *= Correction.c_type[c].thick[i] / vel[i]);
                    }
                } else {
                    layer_time = vel[i] * (dtdd / 111.195);
                    if ((layer_time *= layer_time) >= 1.0) {
                        logger.debug((Object)String.format("WARN: layer_time = %f", layer_time));
                    } else {
                        layer_time = 1.0 / Math.sqrt(1.0 - layer_time);
                        layer_time *= cumulative_thick - depth;
                        crust_time += (layer_time /= vel[i]);
                    }
                }
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_crust_corr:dtdd=%.3f time %.3f cf jb %.3f", dtdd, crust_time, jb_crust_time));
        }
        if (depth == 0.0 && elev != 9999999.0) {
            double uplift = Correction.c_type[c].thick[8] + extra_mantle - 33.0;
            double elev_diff = elev / 1000.0 - uplift;
            if (Correction.c_type[c].thick[2] + elev_diff < 0.0) {
                logger.debug((Object)String.format("WARN: calc_crust_corr: elev_diff=%f", elev_diff));
            } else {
                layer_time = vel[2] * (dtdd / 111.195);
                layer_time *= layer_time;
                layer_time = 1.0 / Math.sqrt(1.0 - layer_time);
                elev_corr = layer_time *= elev_diff / vel[2];
            }
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append(String.format("calc_crust_corr: uplift=%.3f ", uplift));
                sb.append(String.format("elev_diff=%.3f ", elev_diff));
                sb.append(String.format("elev_corr=%.3f", elev_corr));
                logger.debug((Object)sb.substring(0));
            }
        } else {
            elev_corr = 0.0;
        }
        return crust_time + iso_corr - jb_crust_time + elev_corr;
    }

    public static int correct_ttime(ISCSol sp, ISCPha pp) {
        double geoid_corr = Correction.calc_geoid_corr(sp.lat, pp);
        pp.ttime += geoid_corr;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("correct_ttime: %s geoid_corr=%.3f", pp.sta, geoid_corr));
        }
        if (Config.crust_corr_on == 1 && pp.delta > 20.0f) {
            if (pp.phase.equals("P")) {
                double elev = 9999999.0;
                double source_corr = Correction.calc_crust_corr('P', sp.lat, sp.lon, sp.depth, elev, pp.dtdd);
                elev = Config.elev_corr_on == 1 ? pp.sta_elev : 9999999.0;
                double station_corr = Correction.calc_crust_corr('P', pp.sta_lat, pp.sta_lon, 0.0, elev, pp.dtdd);
                if (logger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.format("correct_ttime:P: %s ", pp.sta));
                    sb.append(String.format("source_corr=%.3f ", source_corr));
                    sb.append(String.format("station_corr=%.3f", station_corr));
                    logger.debug((Object)sb.substring(0));
                }
                pp.ttime += source_corr + station_corr;
            } else if (pp.phase.equals("S")) {
                double elev = 9999999.0;
                double source_corr = Correction.calc_crust_corr('S', sp.lat, sp.lon, sp.depth, elev, pp.dtdd);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("correct_ttime:S: %s %.3f", pp.sta, Float.valueOf(pp.delta)));
                }
                if (Config.elev_corr_on == 1) {
                    elev = pp.sta_elev;
                }
                double station_corr = Correction.calc_crust_corr('S', pp.sta_lat, pp.sta_lon, 0.0, elev, pp.dtdd);
                if (logger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.format("correct_ttime:S: %s ", pp.sta));
                    sb.append(String.format("source_corr=%.3f ", source_corr));
                    sb.append(String.format("station_corr=%.3f", station_corr));
                    logger.debug((Object)sb.substring(0));
                }
                pp.ttime += source_corr + station_corr;
            }
        } else if (Config.elev_corr_on == 1) {
            double station_corr = Correction.calc_elev_corr(pp);
            pp.ttime += station_corr;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("correct_ttime: %s ", pp.sta));
                logger.debug((Object)String.format("elev_corr=%.3f", station_corr));
            }
        }
        return 0;
    }

    public static double calc_geoid_corr(double lat, ISCPha pp) {
        double elcor;
        double epi_hams = Correction.height_above_mean_sphere(lat * (Math.PI / 180));
        double sta_hams = Correction.height_above_mean_sphere(pp.sta_lat * (Math.PI / 180));
        if (pp.phase.equals("PKP")) {
            elcor = pp.delta < 140.0f ? 0.1 : 0.094;
        } else {
            int i = 0;
            while ((int)((double)pp.delta + 0.5) > delta_step[i]) {
                ++i;
            }
            elcor = 0.01 * (double)i;
        }
        double geoid_corr = elcor * (epi_hams + sta_hams);
        return geoid_corr;
    }

    private static double height_above_mean_sphere(double lat) {
        return 10.738 * Math.cos(2.0 * lat) - 3.549 - 0.023 * Math.cos(4.0 * lat);
    }

    public static void main(String[] args) {
        System.out.println(Correction.c_type[359].descrip);
    }

    public static class Crust {
        String descrip;
        double[] p_vel = new double[8];
        double[] s_vel = new double[8];
        double[] density = new double[8];
        double[] thick = new double[9];
    }
}

