/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCEvent;
import cn.org.gddsn.seis.location.iscloc.ISCHyp;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.ISFIO;
import cn.org.gddsn.seis.location.iscloc.Mag;
import cn.org.gddsn.seis.location.iscloc.PhaseId;
import cn.org.gddsn.seis.location.iscloc.Solve;
import cn.org.gddsn.seis.location.iscloc.Utils;
import cn.org.gddsn.seis.location.iscloc.Weight;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.netlib.util.StringW;

public class ISCLoc {
    static Logger logger = Logger.getLogger(ISCLoc.class);
    private static String CONFIG_FILE = "./config.txt";

    public static void main(String[] args) throws IOException {
        String instruction;
        BufferedReader isfin = null;
        BufferedReader instructfp = null;
        PrintWriter isfout = null;
        StringW isf_infile = new StringW("");
        ISFIO.ISC_DATA isc_data = new ISFIO.ISC_DATA();
        isc_data.ep = new ISCEvent();
        isc_data.sol = new ISCSol();
        ISCEvent e = isc_data.ep;
        ISCSol s = isc_data.sol;
        ISCHyp[] h = null;
        ISCPha[] p = null;
        if (Config.read_config(CONFIG_FILE) > 0) {
            System.exit(1);
        }
        instructfp = Config.instructfile.equals("stdin") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(Config.instructfile));
        if (Config.isf_outfile != null) {
            isfout = Config.isf_outfile.equals("stdin") ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(Config.isf_outfile));
        }
        String prev_isf_infile = "";
        int fail = 0;
        int opt2 = 0;
        int opt1 = 0;
        int opt0 = 0;
        int total = 0;
        while ((instruction = instructfp.readLine()) != null) {
            logger.info((Object)String.format("=============================================", new Object[0]));
            if (ISFIO.read_instruction(instruction, e, isf_infile) > 0) continue;
            if (e.evid == 9999999) {
                if (!prev_isf_infile.equals(isf_infile)) {
                    try {
                        isfin = new BufferedReader(new FileReader(isf_infile.val));
                    }
                    catch (IOException ioEx) {
                        logger.warn((Object)String.format("Can't open %s", isf_infile));
                        continue;
                    }
                    prev_isf_infile = isf_infile.val.substring(0);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling read_isf_event", new Object[0]));
                }
                if (ISFIO.read_isf_event(isfin, isc_data) > 0) continue;
                h = isc_data.hp;
                p = isc_data.pp;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling init_event", new Object[0]));
            }
            if (Solve.init_event(e, h) > 0) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling rank_hyp", new Object[0]));
            }
            if (Solve.rank_hyp(e, h, p) > 0) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling print_hyp", new Object[0]));
            }
            if (Solve.print_hyp(e, h) > 0) continue;
            int option = 0;
            while (option < 3) {
                if (e.fixed_time != 9999999.0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling init_sol to fix all", new Object[0]));
                    }
                    if (Solve.init_sol(s, e, h[0]) > 0) {
                        Utils.handle_error();
                    }
                    s.number_of_unknowns = 0;
                    s.converged = 1;
                    option = 3;
                    break;
                }
                if (e.fixed_depth != 9999999.0 || e.fix_on_depdp != 0) {
                    ++option;
                }
                if (e.fixed_lat != 9999999.0) {
                    ++option;
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)String.format("option %d", option));
                }
                s.number_of_unknowns = option == 0 ? 4 : (option == 1 ? 3 : 1);
                int hyp = 0;
                while (hyp < e.numhyps) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling init_sol", new Object[0]));
                    }
                    if (Solve.init_sol(s, e, h[hyp]) > 0) {
                        Utils.handle_error();
                        ++hyp;
                        continue;
                    }
                    int i = 0;
                    while (i < s.numphas) {
                        p[i].purged = 0;
                        ++i;
                    }
                    s.iteration = 0;
                    while (s.iteration < Config.max_iter) {
                        logger.info((Object)String.format("opt%d %s iter %d: %s", option, h[hyp].agency, s.iteration, Utils.print_sol(s)));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling calc_delaz", new Object[0]));
                        }
                        if (Solve.calc_delaz(s, p) > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling id_pha", new Object[0]));
                        }
                        if (PhaseId.id_pha(s, p, e.reid_phase) > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (e.fix_on_depdp != 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("Calling calc_depdp", new Object[0]));
                            }
                            if (Solve.calc_depdp(s, p) > 0) {
                                Utils.handle_error();
                                break;
                            }
                            if (s.depdp == 9999999.0) {
                                logger.warn((Object)"no depdp to fix on");
                                break;
                            }
                            s.depth = s.depdp;
                            logger.info((Object)String.format("Fixing depth on depdp=%f", s.depdp));
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("Calling id_pha", new Object[0]));
                            }
                            if (PhaseId.id_pha(s, p, e.reid_phase) > 0) {
                                Utils.handle_error();
                                break;
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling get_weight_factor", new Object[0]));
                        }
                        if (Weight.get_weight_factor(p, s.numphas) > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling mark_duplicates", new Object[0]));
                        }
                        if (Solve.mark_duplicates(s, p) > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling calc_resid", new Object[0]));
                        }
                        if (Solve.calc_resid(s, p, "use") > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling calc_weight", new Object[0]));
                        }
                        if (Weight.calc_weight(s, p) > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Calling solve", new Object[0]));
                        }
                        if (Solve.solve(s, p) > 0) {
                            Utils.handle_error();
                            break;
                        }
                        if (s.iteration != 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("Calling decide_iter", new Object[0]));
                            }
                            if (Solve.decide_iter(s, p) > 0) {
                                Utils.handle_error();
                                break;
                            }
                            if (s.diverging != 0) {
                                logger.info((Object)String.format("DIVERGING", new Object[0]));
                                break;
                            }
                            if (s.converged != 0) {
                                logger.info((Object)String.format("CONVERGED", new Object[0]));
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)String.format("Calling change_weighting", new Object[0]));
                                }
                                if (Weight.change_weighting(s) > 0) {
                                    Utils.handle_error();
                                    s.diverging = 1;
                                    break;
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)String.format("Calling purge_pha", new Object[0]));
                                }
                                if (Solve.purge_pha(e, s, p) > 0) {
                                    Utils.handle_error();
                                    s.diverging = 1;
                                    break;
                                }
                                if (s.converged == 0) {
                                    s.iteration = -1;
                                }
                            }
                            if (s.converged != 0) break;
                        }
                        ++s.iteration;
                    }
                    logger.info((Object)String.format("last  : %s", Utils.print_sol(s)));
                    if (s.converged != 0) break;
                    ++hyp;
                }
                if (s.converged != 0) break;
                ++option;
            }
            if (s.converged != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling calc_delaz", new Object[0]));
                }
                if (Solve.calc_delaz(s, p) > 0) {
                    Utils.handle_error();
                    break;
                }
                if (e.fixed_time != 9999999.0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Calling id_pha", new Object[0]));
                    }
                    if (PhaseId.id_pha(s, p, e.reid_phase) > 0) {
                        Utils.handle_error();
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling calc_resid", new Object[0]));
                }
                if (Solve.calc_resid(s, p, "all") > 0) {
                    Utils.handle_error();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling calc_error", new Object[0]));
                }
                if (Solve.calc_error(s, p) > 0) {
                    Utils.handle_error();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling calc_netmag", new Object[0]));
                }
                if (Mag.calc_netmag(s, p) > 0) {
                    Utils.handle_error();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Calling calc_depdp", new Object[0]));
                }
                if (Solve.calc_depdp(s, p) > 0) {
                    Utils.handle_error();
                }
                if (Config.isf_outfile != null && ISFIO.write_isf_event(isfout, e, s, h, p) > 0) {
                    Utils.handle_error();
                }
                Utils.print_pha(s.numphas, p);
                logger.info((Object)String.format("final : %s", Utils.print_sol(s)));
                if (s.depdp != 9999999.0) {
                    logger.info((Object)String.format("depdp=%.2f err=%.2f", s.depdp, s.depdp_error));
                }
                if (s.bodymag != 0.0) {
                    logger.info((Object)String.format("mb=%.2f nsta=%d", s.bodymag, s.nsta_mb));
                }
                if (s.surfmag != 0.0) {
                    logger.info((Object)String.format("ms=%.2f nsta=%d", s.surfmag, s.nsta_ms));
                }
                if (option == 0) {
                    ++opt0;
                }
                if (option == 1) {
                    ++opt1;
                }
                if (option == 2) {
                    ++opt2;
                }
                if (option >= 3) continue;
                ++total;
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Calling init_sol", new Object[0]));
            }
            if (Solve.init_sol(s, e, h[0]) > 0) {
                Utils.handle_error();
            }
            logger.info((Object)String.format("FAILURE", new Object[0]));
            ++fail;
        }
        logger.info((Object)String.format("opt0 %d, opt1 %d, opt2 %d converge %d fail %d", opt0, opt1, opt2, total, fail));
        if (isfin != null) {
            isfin.close();
        }
        if (isfout != null) {
            isfout.close();
        }
        instructfp.close();
    }
}

