/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.isf.ISF;
import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCEvent;
import cn.org.gddsn.seis.location.iscloc.ISCHyp;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.StringW;

public class ISFIO {
    static Logger logger = Logger.getLogger(ISFIO.class);
    private static final int MAXOPT = 10;
    private static final int MAXSTA = 10000;
    private static sta_rec[] stalist = new sta_rec[10000];
    private static int numsta;

    public static int read_instruction(String instruction, ISCEvent ep, StringW infile_name) {
        String[] opt = new String[10];
        String[] val = new String[10];
        ep.evid = 9999999;
        ep.seed_agency = "";
        ep.depth_agency = "";
        ep.location_agency = "";
        ep.time_agency = "";
        ep.fixed_depth = 9999999.0;
        ep.fixed_lat = 9999999.0;
        ep.fixed_lon = 9999999.0;
        ep.fixed_time = 9999999.0;
        ep.reid_phase = 1;
        ep.purge_phase = 1;
        ep.fix_on_depdp = 0;
        infile_name.val = "";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("read_instruction: %s", instruction));
        }
        Scanner sc = new Scanner(instruction).useDelimiter("[\\s=]+");
        int k = 0;
        while (sc.hasNext()) {
            opt[k] = sc.next();
            val[k++] = sc.next();
        }
        int i = 0;
        while (i < k) {
            int j = 0;
            while (j < i) {
                if (opt[i].equals(opt[j])) {
                    logger.warn((Object)String.format("read_instruction: two option %s", opt[i]));
                    return 1;
                }
                ++j;
            }
            if (Character.isDigit(opt[i].charAt(0))) {
                if (ep.evid != 9999999 || infile_name.val.length() != 0) {
                    logger.warn((Object)String.format("read_instruction: two evids %s", instruction));
                    return 1;
                }
                try {
                    ep.evid = Integer.parseInt(opt[i]);
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("read_instruction: bad evid %s", opt[i]));
                    return 1;
                }
            } else if (opt[i].equals("seed")) {
                ep.seed_agency = val[i];
            } else if (opt[i].equals("depth")) {
                if (Character.isDigit(val[i].charAt(0))) {
                    try {
                        ep.fixed_depth = Integer.parseInt(val[i]);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("read_instruction: bad depth %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.depth_agency = val[i];
                }
            } else if (opt[i].equals("location")) {
                ep.location_agency = val[i];
            } else if (opt[i].equals("lat")) {
                try {
                    ep.fixed_lat = Float.parseFloat(val[i]);
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("read_instruction: bad lat %s", val[i]));
                    return 1;
                }
            } else if (opt[i].equals("lon")) {
                try {
                    ep.fixed_lon = Float.parseFloat(val[i]);
                }
                catch (Exception ex) {
                    logger.warn((Object)String.format("read_instruction: bad lon %s", val[i]));
                    return 1;
                }
            } else if (opt[i].equals("time")) {
                if (Character.isDigit(val[i].charAt(0))) {
                    try {
                        ep.fixed_time = Float.parseFloat(val[i]);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)String.format("read_instruction: bad time %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.time_agency = val[i];
                }
            } else if (opt[i].equals("no_reid_phase")) {
                ep.reid_phase = 0;
            } else if (opt[i].equals("no_purge_phase")) {
                ep.purge_phase = 0;
            } else if (opt[i].equals("fix_on_depdp")) {
                ep.fix_on_depdp = 1;
            } else if (opt[i].equals("filename")) {
                if (ep.evid != 9999999) {
                    logger.warn((Object)String.format("read_instruction: two evids %s", instruction));
                    return 1;
                }
                infile_name.val = val[i];
            } else {
                logger.warn((Object)String.format("read_instruction: unknown option %s", opt[i]));
                return 1;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("read_instruction:%d %s %s", i, opt[i], val[i]));
            }
            ++i;
        }
        if (ep.evid == 9999999 && infile_name.val.length() == 0) {
            logger.warn((Object)String.format("read_instruction: no evid %s", instruction));
            return 1;
        }
        if (ep.fixed_lat != 9999999.0 || ep.fixed_lon != 9999999.0) {
            if (ep.fixed_lat == 9999999.0 || ep.fixed_lon == 9999999.0) {
                logger.warn((Object)String.format("read_instruction: must fix both lat,lon", new Object[0]));
                return 1;
            }
            if (ep.location_agency.length() != 0) {
                logger.warn((Object)String.format("read_instruction: location fixed twice", new Object[0]));
                return 1;
            }
        }
        if (ep.location_agency.length() != 0 && (ep.fixed_depth != 9999999.0 || ep.depth_agency.length() != 0)) {
            logger.warn((Object)String.format("read_instruction: depth fixed twice", new Object[0]));
            return 1;
        }
        return 0;
    }

    public static int read_stafile(sta_rec[] stalist) {
        int i = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(Config.isf_stafile));
            String line = null;
            while ((line = br.readLine()) != null) {
                ISF.Station stn = ISF.Station.parse(line);
                stalist[i].net = stn.net;
                stalist[i].sta = stn.sta;
                stalist[i].lat = stn.lat;
                stalist[i].lon = stn.lon;
                stalist[i].elev = stn.elev == 9999999.0f ? 9999999.0 : stalist[i].elev;
                ++i;
            }
            br.close();
        }
        catch (IOException ioEx) {
            logger.warn((Object)String.format("read_stafile: Can't open %s", Config.isf_stafile));
            return -1;
        }
        return i;
    }

    public static int read_isf_event(BufferedReader infile, ISC_DATA isc_data) throws IOException {
        ISCPha temp_pha;
        int j;
        String evid;
        int i = 0;
        while (i < 10000) {
            ISFIO.stalist[i] = new sta_rec();
            ++i;
        }
        int yyyy = 0;
        int mm = 0;
        int dd = 0;
        int hh = 0;
        int mi = 0;
        int ss = 0;
        int msec = 0;
        boolean found = false;
        ISF.Origin[] origs = new ISF.Origin[50];
        double[] hyp_time = new double[50];
        ISF.Phase[] isf_phs = new ISF.Phase[5000];
        double[] pha_time = new double[5000];
        if (ISFIO.stalist[0].sta.length() == 0) {
            numsta = ISFIO.read_stafile(stalist);
            if (numsta == 0) {
                logger.warn((Object)String.format("read_stafile: no stations read", new Object[0]));
                return 1;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("read_isf_event: read in station file.", new Object[0]));
            }
        }
        String line = null;
        ISF.Event event = new ISF.Event();
        while ((line = infile.readLine()) != null) {
            if (!event.parseEventId(line)) continue;
        }
        if ((evid = event.evid).equals("")) {
            logger.warn((Object)String.format("read_isf_event: no event line found", new Object[0]));
            return 1;
        }
        isc_data.ep.evid = Integer.parseInt(evid);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("read_isf_event: found event id %d", isc_data.ep.evid));
        }
        ISF.Origin orig = new ISF.Origin();
        while ((line = infile.readLine()) != null) {
            if (!orig.parseOriginHead(line)) continue;
        }
        int i2 = 0;
        while ((line = infile.readLine()) != null) {
            if (line.trim().length() == 0) break;
            if (ISF.read_comment(line) != null) continue;
            origs[i2] = new ISF.Origin();
            origs[i2].parseOrigin(line);
            yyyy = origs[i2].yyyy;
            mm = origs[i2].mm;
            dd = origs[i2].dd;
            hh = origs[i2].hh;
            mi = origs[i2].mi;
            ss = origs[i2].ss;
            msec = origs[i2].msec;
            hyp_time[i2] = ISF.get_time(yyyy, mm, dd, hh, mi, ss, msec);
            ++i2;
        }
        if ((isc_data.ep.numhyps = i2) == 0) {
            logger.warn((Object)String.format("read_isf_event: no hypocentres read", new Object[0]));
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("read_isf_event: %d hypocentres read", isc_data.ep.numhyps));
        }
        ISF.Phase isf_ph = new ISF.Phase();
        while ((line = infile.readLine()) != null) {
            if (!isf_ph.parsePhaseHead(line)) continue;
            found = true;
            break;
        }
        if (!found) {
            logger.warn((Object)String.format("read_isf_event: no phase header found", new Object[0]));
            return 1;
        }
        i2 = 0;
        while ((line = infile.readLine()) != null) {
            if (line.trim().length() == 0) break;
            if (ISF.read_comment(line) != null) continue;
            isf_phs[i2] = new ISF.Phase();
            if (!isf_phs[i2].parsePhase(line)) continue;
            hh = isf_phs[i2].hh;
            mi = isf_phs[i2].mi;
            ss = isf_phs[i2].ss;
            msec = isf_phs[i2].msec;
            if (hh == 9999999) {
                pha_time[i2] = 9999999.0;
            } else {
                if (msec == 9999999) {
                    msec = 9999999;
                }
                pha_time[i2] = ISF.get_time(yyyy, mm, dd, hh, mi, ss, msec);
                if (pha_time[i2] < hyp_time[0]) {
                    pha_time[i2] = ISF.get_time(yyyy, mm, dd + 1, hh, mi, ss, msec);
                }
            }
            if (isf_phs[i2].dist == 9999999.0f) {
                logger.warn((Object)String.format("read_isf_event: phases must have delta", new Object[0]));
                return 1;
            }
            ++i2;
        }
        if ((isc_data.ep.numphas = i2) == 0) {
            logger.warn((Object)String.format("read_isf_event: no phases read", new Object[0]));
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("read_isf_event: %d phases read", isc_data.ep.numphas));
        }
        isc_data.hp = new ISCHyp[isc_data.ep.numhyps];
        isc_data.pp = new ISCPha[isc_data.ep.numphas];
        ISCHyp[] h = isc_data.hp;
        i2 = 0;
        while (i2 < isc_data.ep.numhyps) {
            h[i2] = new ISCHyp();
            h[i2].hypid = Integer.parseInt(origs[i2].origid);
            h[i2].time = hyp_time[i2];
            h[i2].lat = origs[i2].lat;
            h[i2].lon = origs[i2].lon;
            Utils.calc_dircos(origs[i2].lat, origs[i2].lon, h[i2].dircos);
            h[i2].depth = origs[i2].depth == 9999999.0f ? 9999999.0 : (double)origs[i2].depth;
            h[i2].ndef = origs[i2].ndef == 9999999 ? 9999999 : origs[i2].ndef;
            h[i2].ndefsta = origs[i2].nsta == 9999999 ? 9999999 : origs[i2].nsta;
            h[i2].nsta = 9999999;
            h[i2].mindist = origs[i2].mindist == 9999999.0f ? 9999999.0 : (double)origs[i2].mindist;
            h[i2].maxdist = origs[i2].maxdist == 9999999.0f ? 9999999.0 : (double)origs[i2].maxdist;
            h[i2].azimgap = origs[i2].gap == 9999999 ? 9999999.0 : (double)origs[i2].gap;
            h[i2].etype = origs[i2].etype;
            h[i2].agency = origs[i2].author;
            h[i2].sdobs = origs[i2].sdobs == 9999999.0f ? 9999999.0 : (double)origs[i2].sdobs;
            h[i2].stime = origs[i2].stime == 9999999.0f ? 9999999.0 : (double)origs[i2].stime;
            h[i2].sdepth = origs[i2].sdepth == 9999999.0f ? 9999999.0 : (double)origs[i2].sdepth;
            h[i2].minax = origs[i2].smin == 9999999.0f ? 9999999.0 : (double)origs[i2].smin;
            h[i2].majax = origs[i2].smaj == 9999999.0f ? 9999999.0 : (double)origs[i2].smaj;
            h[i2].theta = origs[i2].strike == 9999999 ? 9999999.0 : (double)origs[i2].strike;
            h[i2].timfix = 0;
            h[i2].epifix = 0;
            h[i2].depfix = 0;
            if (origs[i2].depfix == 'f') {
                h[i2].depfix = 1;
            }
            if (origs[i2].epifix == 'f') {
                h[i2].epifix = 1;
            }
            if (origs[i2].timfix == 'f') {
                h[i2].timfix = 1;
            }
            ++i2;
        }
        ISCPha[] p = isc_data.pp;
        i2 = 0;
        while (i2 < isc_data.ep.numphas) {
            p[i2] = new ISCPha();
            p[i2].hypid = h[0].hypid;
            p[i2].phid = Integer.parseInt(isf_phs[i2].arrid);
            p[i2].rep_phase = isf_phs[i2].phase;
            p[i2].sta = isf_phs[i2].sta;
            p[i2].time = pha_time[i2] == 9999999.0 ? 9999999.0 : pha_time[i2];
            p[i2].slow = isf_phs[i2].slow == 9999999.0f ? 9999999.0f : isf_phs[i2].slow;
            p[i2].azim = isf_phs[i2].azim == 9999999.0f ? 9999999.0f : isf_phs[i2].azim;
            p[i2].delta = isf_phs[i2].dist;
            if (isf_phs[i2].amp == 9999999.0f) {
                p[i2].numamps = 0;
            } else {
                p[i2].numamps = 1;
                p[i2].a[0].amp = isf_phs[i2].amp;
                p[i2].a[0].per = isf_phs[i2].per;
            }
            p[i2].sp_fm = isf_phs[i2].sp_fm;
            p[i2].detchar = isf_phs[i2].detchar;
            ++i2;
        }
        i2 = 0;
        while (i2 < isc_data.ep.numphas) {
            j = i2 - 1;
            while (j > -1) {
                if (p[j].time > p[j + 1].time && p[j + 1].time != 9999999.0 || p[j].time == 9999999.0) {
                    temp_pha = p[j];
                    p[j] = p[j + 1];
                    p[j + 1] = temp_pha;
                }
                --j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < isc_data.ep.numphas) {
            j = i2 - 1;
            while (j > -1) {
                if (!p[j].sta.equals(p[j + 1].sta)) {
                    temp_pha = p[j];
                    p[j] = p[j + 1];
                    p[j + 1] = temp_pha;
                }
                --j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < isc_data.ep.numphas) {
            j = i2 - 1;
            while (j > -1) {
                if (p[j].delta > p[j + 1].delta) {
                    temp_pha = p[j];
                    p[j] = p[j + 1];
                    p[j + 1] = temp_pha;
                }
                --j;
            }
            ++i2;
        }
        String prev_sta = "";
        int rdid = 0;
        i2 = 0;
        while (i2 < isc_data.ep.numphas) {
            block44: {
                block45: {
                    block42: {
                        block43: {
                            if (p[i2].sta.equals(prev_sta)) break block42;
                            p[i2].rdid = rdid++;
                            p[i2].init = '\u0001';
                            j = 0;
                            while (j < numsta) {
                                if (p[i2].sta.equals(ISFIO.stalist[j].sta)) {
                                    p[i2].sta_lat = ISFIO.stalist[j].lat;
                                    p[i2].sta_lon = ISFIO.stalist[j].lon;
                                    p[i2].sta_elev = ISFIO.stalist[j].elev;
                                    Utils.calc_dircos(p[i2].sta_lat, p[i2].sta_lon, p[i2].dircos);
                                    break;
                                }
                                ++j;
                            }
                            if (j != numsta) break block43;
                            logger.warn((Object)String.format("read_isf_event: sta %s not found.", p[i2].sta));
                            break block44;
                        }
                        prev_sta = p[i2].sta;
                        break block45;
                    }
                    p[i2].rdid = p[i2 - 1].rdid;
                    p[i2].sta_lat = p[i2 - 1].sta_lat;
                    p[i2].sta_lon = p[i2 - 1].sta_lon;
                    p[i2].sta_elev = p[i2 - 1].sta_elev;
                    int k = 1;
                    while (k <= 6) {
                        p[i2].dircos[k] = p[i2 - 1].dircos[k];
                        ++k;
                    }
                }
                p[i2].pref_rd = p[i2].rdid;
            }
            ++i2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("read_isf_event:", new Object[0]));
            Utils.print_pha(isc_data.ep.numphas, p);
        }
        return 0;
    }

    public static int write_isf_event(PrintWriter isfout, ISCEvent ep, ISCSol sp, ISCHyp[] h, ISCPha[] p) throws IOException {
        return 1;
    }

    private ISFIO() {
    }

    public static class ISC_DATA {
        public ISCEvent ep = new ISCEvent();
        public ISCHyp[] hp;
        public ISCPha[] pp;
        public ISCSol sol = new ISCSol();
    }

    private static class sta_rec {
        String net = "";
        String sta = "";
        double lat;
        double lon;
        double elev;

        private sta_rec() {
        }
    }
}

