/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.BodyMagCor;
import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import org.apache.log4j.Logger;

public class Mag {
    static Logger logger = Logger.getLogger(Mag.class);

    public static int calc_sta_mb(ISCSol sp, ISCPha pp) {
        int totlogat = 0;
        int numlogat = 0;
        if (pp.phase.equals("P") && (double)pp.delta >= Config.body_mag_min_dist && (double)pp.delta <= Config.body_mag_max_dist && pp.numamps > 0) {
            double minper = Config.body_mag_max_per;
            double logat = 9999999.0;
            int i = 0;
            while (i < pp.numamps) {
                if (pp.a[i].per >= Config.body_mag_min_per && pp.a[i].per <= minper && pp.a[i].amp != 0.0 && pp.a[i].amp != 9999999.0) {
                    minper = pp.a[i].per;
                    logat = Math.log10(pp.a[i].amp / pp.a[i].per);
                }
                ++i;
            }
            if (logat == 9999999.0) {
                numlogat = 0;
                totlogat = 0;
                i = 0;
                while (i < pp.numamps) {
                    if (pp.a[i].logat != 9999999.0) {
                        totlogat = (int)((double)totlogat + pp.a[i].logat);
                        ++numlogat;
                    }
                    ++i;
                }
                if (numlogat > 0) {
                    logat = totlogat / numlogat;
                }
            }
            if (logat != 9999999.0) {
                double depth_erad = (sp.depth - 33.0) / 6338.0;
                int col = (int)(1.5 + 100.0 * depth_erad);
                int row = (int)((double)pp.delta + 0.5);
                pp.bodymag = logat + 0.1 * (double)BodyMagCor.magcor[col][row] - 3.0;
                if (logger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.format("calc_sta_mb: depth=%.2f,col=%d ", sp.depth, col));
                    sb.append(String.format("%s %s ", pp.sta, pp.phase));
                    sb.append(String.format("logat=%.2f, magcor=%d ", logat, BodyMagCor.magcor[col][row]));
                    sb.append(String.format("bodymag=%.2f", pp.bodymag));
                    logger.debug((Object)sb.substring(0));
                }
            }
        }
        return 0;
    }

    public static double calc_sta_ms(int[] reading, int n, ISCPha[] p) {
        StringBuffer sb;
        double z_amp = 0.0;
        double n_amp = 0.0;
        double e_amp = 0.0;
        double msh = 0.0;
        double msz = 0.0;
        int z_phase = 0;
        int n_phase = 0;
        int e_phase = 0;
        double reading_ms = 0.0;
        double minper = Config.surf_mag_min_per;
        double maxper = Config.surf_mag_max_per;
        e_amp = 0.0;
        n_amp = 0.0;
        z_amp = 0.0;
        double amp = 0.0;
        double e_per = 0.0;
        double n_per = 0.0;
        double z_per = 0.0;
        double per = 0.0;
        int i = reading[0];
        while (i <= reading[n - 1]) {
            if (p[i].phase.equals("") && p[i].numamps > 0 && (double)p[i].delta >= Config.surf_mag_min_dist && (double)p[i].delta <= Config.surf_mag_max_dist) {
                int j = 0;
                while (j < p[i].numamps) {
                    if (p[i].a[j].per >= minper && p[i].a[j].per <= maxper && p[i].a[j].amp != 0.0 && p[i].a[j].amp != 9999999.0 && p[i].a[j].comp != '\u0000') {
                        if (p[i].a[j].comp == 'Z' && z_amp == 0.0) {
                            z_amp = p[i].a[j].amp;
                            z_per = p[i].a[j].per;
                            z_phase = i;
                        } else if (p[i].a[j].comp == 'N' && n_amp == 0.0) {
                            n_amp = p[i].a[j].amp;
                            n_per = p[i].a[j].per;
                            n_phase = i;
                        } else if (p[i].a[j].comp == 'E' && e_amp == 0.0) {
                            e_amp = p[i].a[j].amp;
                            e_per = p[i].a[j].per;
                            e_phase = i;
                        }
                        minper = p[i].a[j].per - 5.0;
                        if (minper < Config.surf_mag_min_per) {
                            minper = Config.surf_mag_min_per;
                        }
                        if ((maxper = p[i].a[j].per + 5.0) > Config.surf_mag_max_per) {
                            maxper = Config.surf_mag_max_per;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (n_amp != 0.0 && e_amp != 0.0) {
            amp = Math.sqrt(n_amp * n_amp + e_amp * e_amp);
            per = (n_per + e_per) / 2.0;
            msh = Math.log10(amp / per) + 1.66 * Math.log10(p[reading[0]].delta) + 0.3;
            if (logger.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append(String.format("calc_sta_ms: %s N and E ", p[reading[0]].sta));
                sb.append(String.format("amp=%.2f per=%.2f msh=%.2f", amp, per, msh));
                logger.debug((Object)sb.substring(0));
            }
            p[n_phase].surfmag = msh;
            p[e_phase].surfmag = msh;
            reading_ms = msh;
        }
        if (z_amp != 0.0) {
            msz = Math.log10(z_amp / z_per) + 1.66 * Math.log10(p[reading[0]].delta) + 0.3;
            if (logger.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append(String.format("calc_sta_ms: %s Z ", p[reading[0]].sta));
                sb.append(String.format("amp=%.2f per=%.2f msz=%.2f", amp, per, msz));
                logger.debug((Object)sb.substring(0));
            }
            p[z_phase].surfmag = msz;
            if (reading_ms != 0.0) {
                reading_ms = (msh + msz) / 2.0;
            }
            if (z_phase == n_phase) {
                p[z_phase].surfmag = reading_ms;
            } else {
                reading_ms = msz;
            }
        }
        return reading_ms;
    }

    public static int calc_netmag(ISCSol sp, ISCPha[] p) {
        double sta_mb = 0.0;
        double sta_ms = 0.0;
        double reading_ms = 0.0;
        int n_pha_mb = 0;
        int n_read_ms = 0;
        int[] reading = new int[50];
        n_read_ms = 0;
        n_pha_mb = 0;
        reading_ms = 0.0;
        sta_ms = 0.0;
        sta_mb = 0.0;
        sp.nsta_ms = 0;
        sp.nsta_mb = 0;
        sp.bodymag = 0.0;
        sp.surfmag = 0.0;
        double min_ms = 12.0;
        double min_mb = 12.0;
        double max_ms = 0.0;
        double max_mb = 0.0;
        int prev_rdid = 0;
        int j = 0;
        String prev_mb_sta = "";
        String prev_ms_sta = "";
        int i = 0;
        while (i < sp.numphas) {
            p[i].bodymag = 0.0;
            p[i].surfmag = 0.0;
            if (p[i].purged <= 0) {
                Mag.calc_sta_mb(sp, p[i]);
                if (p[i].bodymag != 0.0) {
                    if (!p[i].sta.equals(prev_mb_sta)) {
                        if (sta_mb != 0.0) {
                            sp.bodymag += (sta_mb /= (double)n_pha_mb);
                            ++sp.nsta_mb;
                            if (sta_mb < min_mb) {
                                min_mb = sta_mb;
                            }
                            if (sta_mb > max_mb) {
                                max_mb = sta_mb;
                            }
                        }
                        n_pha_mb = 0;
                        sta_mb = 0;
                        prev_mb_sta = p[i].sta;
                    }
                    sta_mb += p[i].bodymag;
                    ++n_pha_mb;
                }
                if (p[i].rdid != prev_rdid) {
                    if (j > 0) {
                        reading_ms = Mag.calc_sta_ms(reading, j, p);
                    }
                    if (reading_ms != 0.0) {
                        if (!p[i].sta.equals(prev_ms_sta)) {
                            if (sta_ms != 0.0) {
                                sp.surfmag += (sta_ms /= (double)n_read_ms);
                                ++sp.nsta_ms;
                                if (sta_ms < min_ms) {
                                    min_ms = sta_ms;
                                }
                                if (sta_ms > max_ms) {
                                    max_ms = sta_ms;
                                }
                            }
                            sta_ms = 0.0;
                            n_read_ms = 0;
                            prev_ms_sta = p[i].sta;
                        }
                        sta_ms += reading_ms;
                        ++n_read_ms;
                    }
                    j = 0;
                    prev_rdid = p[i].rdid;
                }
                reading[j++] = i;
                if (j > 50) {
                    logger.warn((Object)String.format("calc_netmag: %s: too many phases", p[i].sta));
                    return 1;
                }
            }
            ++i;
        }
        if (sta_mb != 0.0) {
            sp.bodymag += (sta_mb /= (double)n_pha_mb);
            ++sp.nsta_mb;
            if (sta_mb < min_mb) {
                min_mb = sta_mb;
            }
            if (sta_mb > max_mb) {
                max_mb = sta_mb;
            }
            sp.bodymag /= (double)sp.nsta_mb;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("calc_netmag: bodymag=%.2f nsta=%d", sp.bodymag, sp.nsta_mb));
            }
            if (max_mb - min_mb > Config.mag_range_warn_thresh) {
                logger.debug((Object)String.format("WARN: mb RANGE %.1f - %.1f", min_mb, max_mb));
            }
        }
        if (sta_ms != 0.0) {
            sp.surfmag += (sta_ms /= (double)n_read_ms);
            ++sp.nsta_ms;
            if (sta_ms < min_ms) {
                min_ms = sta_ms;
            }
            if (sta_ms > max_ms) {
                max_ms = sta_ms;
            }
            sp.surfmag /= (double)sp.nsta_ms;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("calc_netmag: surfmag=%.2f nsta=%d", sp.surfmag, sp.nsta_ms));
            }
            if (max_ms - min_ms > Config.mag_range_warn_thresh) {
                logger.warn((Object)String.format("WARN: MS RANGE %.1f - %.1f", min_ms, max_ms));
            }
        }
        return 0;
    }

    private Mag() {
    }
}

