/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.ModelJB;
import cn.org.gddsn.seis.location.iscloc.Utils;
import org.apache.log4j.Logger;

public class PhaseId {
    static Logger logger = Logger.getLogger(PhaseId.class);
    private static final int NUM_PHASE_MAP = 40;
    private static phase_map[] phase_map = new phase_map[]{new phase_map("p", "P"), new phase_map("P", "P"), new phase_map("pP", "pP"), new phase_map("AP", "pP"), new phase_map("Pg", "Pg"), new phase_map("P*", "Pb"), new phase_map("Pb", "Pb"), new phase_map("Pn", "Pn"), new phase_map("PG", "Pg"), new phase_map("PB", "Pb"), new phase_map("PN", "Pn"), new phase_map("PKP", "PKP"), new phase_map("P/PKP", "P"), new phase_map("Pdiff", "Pdiff"), new phase_map("PDIF", "Pdiff"), new phase_map("s", "S"), new phase_map("S", "S"), new phase_map("Sg", "Sg"), new phase_map("S*", "Sb"), new phase_map("Sb", "Sb"), new phase_map("Sn", "Sn"), new phase_map("SG", "Sg"), new phase_map("SB", "Sb"), new phase_map("SN", "Sn"), new phase_map("SKS", "SKS"), new phase_map("S/(SKS)", "S"), new phase_map("PcP", "PcP"), new phase_map("ScS", "ScS"), new phase_map("PP", "PP"), new phase_map("PPP", "PPP"), new phase_map("PS", "PS"), new phase_map("SP", "SP"), new phase_map("PPS", "PPS"), new phase_map("SPP", "SPP"), new phase_map("PSP", "PSP"), new phase_map("SS", "SS"), new phase_map("SSP", "SSP"), new phase_map("PSS", "PSS"), new phase_map("SPS", "SPS"), new phase_map("SSS", "SSS")};

    public static int id_pha(ISCSol sp, ISCPha[] p, int reid_phase) {
        int i = 0;
        while (i < sp.numphas) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("id_pha:%s rep_phase=%s", p[i].sta, p[i].rep_phase));
            }
            p[i].phase = "";
            if (p[i].time != 9999999.0) {
                if (p[i].rep_phase.equals("") && p[i].init > '\u0000') {
                    p[i].phase = "P";
                }
                int j = 0;
                while (j < 40) {
                    if (p[i].rep_phase.equals(PhaseId.phase_map[j].rep_phase)) {
                        p[i].phase = PhaseId.phase_map[j].phase;
                        break;
                    }
                    ++j;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("id_pha:%s mapped phase=%s", p[i].sta, p[i].phase));
                }
                if (p[i].phase.equals("P") && p[i].init == '\u0000') {
                    p[i].phase = "";
                }
                if (reid_phase > 0 && PhaseId.id_jb(sp, p[i]) > 0) {
                    Utils.handle_error();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("id_pha:%s phase=%s", p[i].sta, p[i].phase));
                }
            }
            ++i;
        }
        return 0;
    }

    public static int id_jb(ISCSol sp, ISCPha pp) {
        StringBuffer sb;
        double n_time;
        double b_time;
        double g_time;
        if (sp.depth > 764.52) {
            return 0;
        }
        if (pp.phase.equals("PKP") && (double)pp.delta < 106.0) {
            pp.phase = "P";
        }
        if (pp.phase.equals("Pdiff") && pp.delta < 102.0f) {
            pp.phase = "P";
        }
        if (pp.phase.equals("P") || pp.phase.equals("Pg") || pp.phase.equals("Pb") || pp.phase.equals("Pn")) {
            if ((double)pp.delta > 8.0 || sp.depth > 33.0) {
                pp.phase = "P";
                if (pp.delta >= 102.0f) {
                    pp.phase = "Pdiff";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        pp.phase = "";
                    } else if (Math.abs(pp.time - sp.time - pp.ttime) > Config.max_resid) {
                        pp.phase = "";
                    }
                }
                if ((double)pp.delta > 106.0 && !pp.phase.equals("Pdiff")) {
                    pp.phase = "PKP";
                }
            } else if (sp.depth < 15.0) {
                if (pp.phase.equals("P")) {
                    pp.phase = "Pg";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                        pp.ttime = -9999999.0;
                    }
                    g_time = pp.ttime;
                    pp.phase = "Pb";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                        pp.ttime = -9999999.0;
                    }
                    b_time = pp.ttime;
                    pp.phase = "Pn";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                        pp.ttime = -9999999.0;
                    }
                    n_time = pp.ttime;
                    pp.phase = g_time == -9999999.0 && b_time == -9999999.0 && n_time == -9999999.0 ? "" : (g_time <= b_time && g_time < n_time ? "Pg" : (b_time < g_time && b_time < n_time ? "Pb" : "Pn"));
                    if (logger.isDebugEnabled()) {
                        sb = new StringBuffer();
                        sb.append(String.format("id_jb: del=%f ", Float.valueOf(pp.delta)));
                        sb.append(String.format("z=%f g=%f ", sp.depth, g_time));
                        sb.append(String.format("b=%f n=%f", b_time, n_time));
                        logger.debug((Object)sb.substring(0));
                    }
                }
            } else if (pp.phase.equals("P") || pp.phase.equals("Pg")) {
                pp.phase = "Pb";
                if (ModelJB.read_ttime(sp, pp) > 0) {
                    logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                    pp.ttime = -9999999.0;
                }
                b_time = pp.ttime;
                pp.phase = "Pn";
                if (ModelJB.read_ttime(sp, pp) > 0) {
                    logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                    pp.ttime = -9999999.0;
                }
                n_time = pp.ttime;
                pp.phase = b_time == -9999999.0 && n_time == -9999999.0 ? "" : (b_time < n_time ? "Pb" : "Pn");
                if (logger.isDebugEnabled()) {
                    sb = new StringBuffer();
                    sb.append(String.format("id_jb: del=%f ", Float.valueOf(pp.delta)));
                    sb.append(String.format("z=%f ", sp.depth));
                    sb.append(String.format("b=%f n=%f", b_time, n_time));
                    logger.debug((Object)sb.substring(0));
                }
            }
        }
        if (pp.phase.equals("SKS") && (double)pp.delta < 62.0) {
            pp.phase = "S";
        }
        if (pp.phase.equals("S") || pp.phase.equals("Sg") || pp.phase.equals("Sb") || pp.phase.equals("Sn")) {
            if ((double)pp.delta > 10.0 || sp.depth > 33.0) {
                pp.phase = "S";
                if ((double)pp.delta > 105.0) {
                    pp.phase = "SKS";
                }
            } else if (sp.depth < 15.0) {
                if (pp.phase.equals("S")) {
                    pp.phase = "Sg";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                        pp.ttime = -9999999.0;
                    }
                    g_time = pp.ttime;
                    pp.phase = "Sb";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                        pp.ttime = -9999999.0;
                    }
                    b_time = pp.ttime;
                    pp.phase = "Sn";
                    if (ModelJB.read_ttime(sp, pp) > 0) {
                        logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                        pp.ttime = -9999999.0;
                    }
                    n_time = pp.ttime;
                    pp.phase = g_time == -9999999.0 && b_time == -9999999.0 && n_time == -9999999.0 ? "" : (g_time <= b_time && g_time < n_time ? "Sg" : (b_time < g_time && b_time < n_time ? "Sb" : "Sn"));
                    if (logger.isDebugEnabled()) {
                        sb = new StringBuffer();
                        sb.append(String.format("id_jb: del=%f ", Float.valueOf(pp.delta)));
                        sb.append(String.format("z=%f g=%f ", sp.depth, g_time));
                        sb.append(String.format("b=%f n=%f", b_time, n_time));
                        logger.debug((Object)sb.substring(0));
                    }
                }
            } else if (pp.phase.equals("S") || pp.phase.equals("Sg")) {
                pp.phase = "Sb";
                if (ModelJB.read_ttime(sp, pp) > 0) {
                    logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                    pp.ttime = -9999999.0;
                }
                b_time = pp.ttime;
                pp.phase = "Sn";
                if (ModelJB.read_ttime(sp, pp) > 0) {
                    logger.warn((Object)String.format("id_jb: Not use %d:", pp.phid));
                    pp.ttime = -9999999.0;
                }
                n_time = pp.ttime;
                pp.phase = b_time == -9999999.0 && n_time == -9999999.0 ? "" : (b_time < n_time ? "Sb" : "Sn");
                if (logger.isDebugEnabled()) {
                    sb = new StringBuffer();
                    sb.append(String.format("id_jb: del=%f ", Float.valueOf(pp.delta)));
                    sb.append(String.format("z=%f ", sp.depth));
                    sb.append(String.format("b=%f n=%f", b_time, n_time));
                    logger.debug((Object)sb.substring(0));
                }
            }
        }
        return 0;
    }

    private PhaseId() {
    }

    private static class phase_map {
        String rep_phase;
        String phase;

        phase_map(String rep_phase, String phase) {
            this.rep_phase = rep_phase;
            this.phase = phase;
        }
    }
}

