/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc;

import cn.org.gddsn.seis.location.iscloc.Config;
import cn.org.gddsn.seis.location.iscloc.ISCEvent;
import cn.org.gddsn.seis.location.iscloc.ISCHyp;
import cn.org.gddsn.seis.location.iscloc.ISCPha;
import cn.org.gddsn.seis.location.iscloc.ISCSol;
import cn.org.gddsn.seis.location.iscloc.ModelJB;
import cn.org.gddsn.seis.location.iscloc.Utils;
import org.apache.log4j.Logger;

public class Solve {
    static Logger logger = Logger.getLogger(Solve.class);
    private static final int XSQ_LIM = 70;
    private static final double MIN_TOTAL_WEIGHT = 1.9;

    public static int calc_delaz(ISCSol sp, ISCPha[] p) {
        double delta = 0.0;
        double esaz = 0.0;
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].init != '\u0000') {
                delta = Utils.calc_delta(p[i].dircos, sp.dircos);
                esaz = Utils.calc_esaz(p[i].dircos, sp.dircos, p[i].sta_lon, sp.lon, delta);
            }
            p[i].delta = (float)delta;
            p[i].esaz = (float)esaz;
            ++i;
        }
        if (logger.isDebugEnabled()) {
            Utils.print_pha(sp.numphas, p);
        }
        return 0;
    }

    public static int calc_depdp(ISCSol sp, ISCPha[] p) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Calling find_pP");
        }
        if (ModelJB.find_pP(sp, p) > 0) {
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Calling pP_duplicates");
        }
        if (Solve.pP_duplicates(sp, p) > 0) {
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Calling calc_pP_resid");
        }
        if (Solve.calc_pP_resid(sp, p) > 0) {
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Calling solve_depdp");
        }
        if (Solve.solve_depdp(sp, p) > 0) {
            return 1;
        }
        return 0;
    }

    public static int calc_error(ISCSol sp, ISCPha[] p) {
        double[] esaz = new double[sp.numphas];
        String prev_net = "";
        String prev_sta = "";
        String prev_def_net = "";
        String prev_def_sta = "";
        int pha_for_sta = 0;
        sp.ndefsta = 0;
        sp.nsta = 0;
        sp.nass = 0;
        sp.ndef = 0;
        int weight_for_sta = 0;
        int purge_for_sta = 0;
        pha_for_sta = 0;
        sp.mindist = 360.0;
        sp.maxdist = 0.0;
        int i = 0;
        while (i < sp.numphas) {
            if (!p[i].sta.equals(prev_sta) || !p[i].net.equals(prev_net)) {
                if (pha_for_sta > 0 && (purge_for_sta == 0 || weight_for_sta > 0)) {
                    ++sp.nsta;
                    sp.nass += pha_for_sta;
                }
                weight_for_sta = 0;
                purge_for_sta = 0;
                pha_for_sta = 0;
            }
            ++pha_for_sta;
            if (p[i].weight_factor > 0.0 && p[i].resid != 9999999.0) {
                if (!p[i].sta.equals(prev_def_sta) || !p[i].net.equals(prev_def_net)) {
                    if ((double)p[i].delta < sp.mindist) {
                        sp.mindist = p[i].delta;
                    }
                    if ((double)p[i].delta > sp.maxdist) {
                        sp.maxdist = p[i].delta;
                    }
                    esaz[sp.ndefsta++] = p[i].esaz;
                    prev_def_sta = p[i].sta;
                    prev_def_net = p[i].net;
                }
                ++sp.ndef;
                ++weight_for_sta;
            }
            if (p[i].purged != 0) {
                ++purge_for_sta;
            }
            prev_sta = p[i].sta;
            prev_net = p[i].net;
            ++i;
        }
        if (pha_for_sta > 0 && (purge_for_sta == 0 || weight_for_sta > 0)) {
            ++sp.nsta;
            sp.nass += pha_for_sta;
        }
        if (sp.ndef > 0) {
            sp.sdobs = sp.sigma;
            sp.sdobs *= Math.sqrt(sp.ndef / (sp.ndef - sp.number_of_unknowns));
        } else {
            sp.sdobs = 9999999.0;
            sp.mindist = 9999999.0;
            sp.maxdist = 9999999.0;
        }
        if (sp.ndef > 0) {
            Utils.dsort(esaz, 0, sp.ndefsta - 1);
            sp.azimgap = esaz[0] + 360.0 - esaz[sp.ndefsta - 1];
            i = 0;
            while (i < sp.ndefsta - 1) {
                if (esaz[i + 1] - esaz[i] > sp.azimgap) {
                    sp.azimgap = esaz[i + 1] - esaz[i];
                }
                ++i;
            }
        } else {
            sp.azimgap = 9999999.0;
            sp.ndef = 9999999;
            sp.ndefsta = 9999999;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_error: nsta=%d nass=%d ", sp.nsta, sp.nass));
            logger.debug((Object)String.format("ndefsta=%d ndef=%d ", sp.ndefsta, sp.ndef));
            logger.debug((Object)String.format("gap=%f ", sp.azimgap));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_error: calling get_fact", new Object[0]));
        }
        double scale_fact = Solve.get_fact(sp.numphas, sp.number_of_unknowns);
        i = 1;
        while (i <= sp.number_of_unknowns) {
            sp.error[i] = scale_fact * Math.sqrt(sp.covar[i][i]);
            ++i;
        }
        i = sp.number_of_unknowns + 1;
        while (i < 5) {
            sp.error[i] = 9999999.0;
            ++i;
        }
        if (sp.number_of_unknowns < 3) {
            sp.majax = 9999999.0;
            sp.minax = 9999999.0;
            sp.theta = 9999999.0;
            return 0;
        }
        sp.error[3] = sp.error[3] / Math.cos(sp.lat * (Math.PI / 180));
        double km_per_deg = Math.PI / 180 * (6371.0 - sp.depth);
        double var_lat = km_per_deg * km_per_deg * sp.covar[2][2];
        double lat_lon = km_per_deg * km_per_deg * sp.covar[2][3];
        double var_lon = km_per_deg * km_per_deg * sp.covar[3][3];
        double b = var_lat + var_lon;
        double c = var_lat * var_lon - lat_lon * lat_lon;
        double eigen1 = 0.5 * (b + Math.sqrt(b * b - 4.0 * c));
        double eigen2 = 0.5 * (b - Math.sqrt(b * b - 4.0 * c));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_error: calling get_fact2", new Object[0]));
        }
        scale_fact = Solve.get_fact2(sp.numphas, sp.number_of_unknowns);
        sp.majax = Math.sqrt(eigen1) * scale_fact;
        sp.minax = Math.sqrt(eigen2) * scale_fact;
        sp.theta = Math.atan(2.0 * lat_lon / (var_lat - var_lon)) / (Math.PI / 180);
        if (sp.theta < 0.0) {
            sp.theta += 180.0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("calc_error: position %f", Math.sqrt(sp.majax * sp.minax)));
        }
        return 0;
    }

    public static double get_fact(int num, int nunk) {
        double factor = num > nunk ? (nunk > 3 ? 1.94 * (0.926 + 0.333 / Math.sqrt(num - nunk)) : 1.94 * (0.905 + 0.306 / Math.sqrt(num - nunk))) : (nunk > 3 ? 5.72 : 2.64);
        return factor;
    }

    public static double get_fact2(int num, int nunk) {
        double factor = num > nunk ? (nunk > 3 ? 2.94 * (0.926 + 0.333 / Math.sqrt(num - nunk)) : 2.52 * (0.905 + 0.306 / Math.sqrt(num - nunk))) : (nunk > 3 ? 8.67 : 3.43);
        return factor;
    }

    public static int calc_gap(ISCEvent ep, ISCHyp[] h, ISCPha[] p) {
        double[] esaz = new double[ep.numphas];
        int i = 0;
        while (i < ep.numhyps) {
            if (h[i].nsta == 9999999 || h[i].mindist == 9999999.0 || h[i].azimgap == 9999999.0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("calc_gap: %s ", h[i].agency));
                }
                int nsta = 0;
                double mindist = 180.0;
                int j = 0;
                while (j < ep.numphas) {
                    if (p[j].hypid == h[i].hypid && p[j].init != '\u0000') {
                        double delta = Utils.calc_delta(p[j].dircos, h[i].dircos);
                        esaz[nsta++] = Utils.calc_esaz(p[j].dircos, h[i].dircos, p[j].sta_lon, h[i].lon, delta);
                        if (delta < mindist) {
                            mindist = delta;
                        }
                    }
                    ++j;
                }
                if (nsta != 0) {
                    if (h[i].nsta == 9999999) {
                        h[i].nsta = nsta;
                    }
                    if (h[i].mindist == 9999999.0) {
                        h[i].mindist = mindist;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("nsta=%d min=%.1f", h[i].nsta, h[i].mindist));
                    }
                    if (h[i].nsta > 1 && h[i].azimgap == 9999999.0) {
                        Utils.dsort(esaz, 0, nsta - 1);
                        h[i].azimgap = esaz[0] + 360.0 - esaz[nsta - 1];
                        j = 0;
                        while (j < nsta - 1) {
                            if (esaz[j + 1] - esaz[j] > h[i].azimgap) {
                                h[i].azimgap = esaz[j + 1] - esaz[j];
                            }
                            ++j;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("calc_gap: gap=%.1f", h[i].azimgap));
                        }
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    public static int calc_pP_resid(ISCSol sp, ISCPha[] p) {
        double p_time = 0.0;
        int p_index = 0;
        int i = 0;
        while (i < sp.numphas) {
            p[i].pP_resid = 9999999.0;
            if (sp.depth != 9999999.0 && p[i].time != 9999999.0) {
                if (p[i].phase.equals("P")) {
                    p_time = p[i].time;
                    p_index = i;
                } else if (p[i].phase.equals("pP")) {
                    if (p[i].rdid != p[p_index].rdid) {
                        logger.warn((Object)String.format("calc_pP_resid:%s: pP without P", p[i].sta));
                    } else if (p[p_index].purged == 0) {
                        if (ModelJB.read_pP_P(sp.depth, p[i]) > 0) {
                            logger.warn((Object)String.format("calc_pP_resid:%s:", p[i].sta));
                        } else {
                            p[i].pP_resid = p[i].time - p_time - p[i].pP_P_time;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)String.format("calc_pP_resid: %5s %2s ", p[i].sta, p[i].phase));
                                logger.debug((Object)String.format("%7.3f %8.3f", sp.depth, Float.valueOf(p[i].delta)));
                                logger.debug((Object)String.format(" pP-P=%f ", p[i].pP_P_time));
                                logger.debug((Object)String.format("dtdh=%f r=%f", p[i].pP_dtdh, p[i].pP_resid));
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    public static int calc_resid(ISCSol sp, ISCPha[] p, String mode) {
        boolean all;
        if (mode.equals("all")) {
            all = true;
        } else if (mode.equals("use")) {
            all = false;
        } else {
            logger.warn((Object)String.format("calc_resid: unrecognised mode %s.", mode));
            return 1;
        }
        if (sp.depth == 9999999.0) {
            logger.warn((Object)String.format("calc_resid: depthless hypocentre.", new Object[0]));
            return 1;
        }
        if (sp.depth > 764.52) {
            logger.debug((Object)String.format("SOLUTION TOO DEEP", new Object[0]));
            return 1;
        }
        int i = 0;
        while (i < sp.numphas) {
            p[i].resid = 9999999.0;
            if (!(!all && p[i].weight_factor == 0.0 || p[i].time == 9999999.0 || p[i].phase.length() == 0 || p[i].phase.equals("pP") || p[i].phase.equals("sP"))) {
                double obtime = p[i].time - sp.time;
                int status = ModelJB.read_ttime(sp, p[i]);
                if (status != 0) {
                    logger.warn((Object)String.format("calc_resid: %s %s:", p[i].sta, p[i].phase));
                    if (all) {
                        p[i].phase = "";
                    } else if (status == 1) {
                        Utils.handle_error();
                    }
                    p[i].weight_factor = 0.0;
                } else {
                    p[i].resid = obtime - p[i].ttime;
                    if (logger.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(String.format("calc_resid: %5s %2s ", p[i].sta, p[i].phase));
                        sb.append(String.format("%8.3f tt=%f ", Float.valueOf(p[i].delta), p[i].ttime));
                        sb.append(String.format("dtdd=%f dtdh=%f ", p[i].dtdd, p[i].dtdh));
                        sb.append(String.format("r=%f", p[i].resid));
                        logger.debug((Object)sb.substring(0));
                    }
                }
            }
            ++i;
        }
        return 0;
    }

    public static int decide_iter(ISCSol sp, ISCPha[] p) {
        double avg_weight = 0.0;
        int ndef = 0;
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].weight_factor > 0.0) {
                avg_weight += p[i].weight;
                ++ndef;
            }
            ++i;
        }
        avg_weight /= (double)ndef;
        double dsigma = Math.abs(sp.sigma - sp.prev_sigma);
        double dalpha = Math.abs(sp.alpha - sp.prev_alpha);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("decide: avg=%f ndef=%d alpha=%f prev_alpha=%f", avg_weight, ndef, sp.alpha, sp.prev_alpha));
        }
        if (Math.abs(sp.alpha) <= Config.alpha_thresh && dsigma > Config.dsigma_low && dsigma < Config.dsigma_high && avg_weight > Config.avg_weight_thresh) {
            sp.converged = 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("decide: converged: avg=%f da=%f ds=%f depth=%f", avg_weight, dalpha, dsigma, sp.depth));
            }
            return 0;
        }
        if (avg_weight < Config.avg_weight_thresh || dalpha > Config.dalpha_thresh && dsigma < Config.dsigma_low) {
            sp.diverging = 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("decide: diverging: avg=%f da=%f ds=%f depth=%f", avg_weight, dalpha, dsigma, sp.depth));
            }
        }
        return 0;
    }

    public static int init_event(ISCEvent ep, ISCHyp[] h) {
        int i;
        if (ep.numphas < Config.min_phases) {
            logger.debug((Object)String.format("init_event: %d: only %d phases", ep.evid, ep.numphas));
            return 1;
        }
        if (ep.depth_agency.length() != 0) {
            i = 0;
            while (i < ep.numhyps) {
                if (h[i].agency.equals(ep.depth_agency)) {
                    ep.fixed_depth = h[i].depth;
                    break;
                }
                ++i;
            }
            if (ep.fixed_depth == 9999999.0) {
                logger.warn((Object)String.format("init_event: %d: no depth_agency hyp", ep.evid));
                return 1;
            }
            if (ep.seed_agency.length() == 0) {
                ep.seed_agency = ep.depth_agency;
            }
        }
        if (ep.location_agency.length() != 0) {
            i = 0;
            while (i < ep.numhyps) {
                if (h[i].agency.equals(ep.location_agency)) {
                    ep.fixed_lat = h[i].lat;
                    ep.fixed_lon = h[i].lon;
                    break;
                }
                ++i;
            }
            if (ep.fixed_lat == 9999999.0) {
                logger.warn((Object)String.format("init_event: %d: no location_agency hyp", ep.evid));
                return 1;
            }
            if (ep.fixed_depth == 9999999.0) {
                ep.fixed_depth = h[i].depth;
            }
            if (ep.seed_agency.length() == 0) {
                ep.seed_agency = ep.location_agency;
            }
        }
        if (ep.time_agency.length() != 0) {
            i = 0;
            while (i < ep.numhyps) {
                if (h[i].agency.equals(ep.time_agency)) {
                    ep.fixed_time = h[i].time;
                    break;
                }
                ++i;
            }
            if (ep.fixed_time == 9999999.0) {
                logger.warn((Object)String.format("init_event: %d: no time_agency hyp", ep.evid));
                return 1;
            }
            if (ep.fixed_lat == 9999999.0) {
                ep.fixed_lat = h[i].lat;
                ep.fixed_lon = h[i].lon;
            }
            if (ep.fixed_depth == 9999999.0) {
                ep.fixed_depth = h[i].depth;
            }
            if (ep.seed_agency.length() == 0) {
                ep.seed_agency = ep.location_agency;
            }
        }
        if (ep.fixed_lat != 9999999.0 && ep.fixed_depth == 9999999.0) {
            ep.fixed_depth = Config.default_depth;
        }
        if (ep.fixed_time != 9999999.0 && ep.fixed_lat == 9999999.0) {
            logger.warn((Object)String.format("init_event: %d: time fixed but not location", ep.evid));
            return 1;
        }
        ep.etype = "";
        int max_severity = 0;
        i = 0;
        while (i < ep.numhyps) {
            int severity = 0;
            if (h[i].etype.length() != 0) {
                if (h[i].etype.charAt(0) == 'd') {
                    severity = 40;
                } else if (h[i].etype.charAt(0) == 'f') {
                    severity = 30;
                } else if (h[i].etype.charAt(0) == 'k') {
                    severity = 20;
                } else if (h[i].etype.charAt(0) == 's') {
                    severity = 10;
                }
                if (h[i].etype.charAt(1) == 'n') {
                    severity += 9;
                } else if (h[i].etype.charAt(1) == 'r') {
                    severity += 8;
                } else if (h[i].etype.charAt(1) == 'm') {
                    severity += 7;
                } else if (h[i].etype.charAt(1) == 'x') {
                    severity += 6;
                } else if (h[i].etype.charAt(1) == 'h') {
                    severity += 5;
                }
                if (severity > max_severity) {
                    max_severity = severity;
                    ep.etype = h[i].etype;
                }
            }
            ++i;
        }
        return 0;
    }

    public static int init_sol(ISCSol sp, ISCEvent ep, ISCHyp hp) {
        int i;
        sp.converged = 0;
        sp.diverging = 0;
        sp.numphas = ep.numphas;
        if (ep.fixed_lat != 9999999.0) {
            sp.lat = ep.fixed_lat;
            sp.lon = ep.fixed_lon;
            Utils.calc_dircos(sp.lat, sp.lon, sp.dircos);
        } else {
            sp.lat = hp.lat;
            sp.lon = hp.lon;
            i = 1;
            while (i <= 6) {
                sp.dircos[i] = hp.dircos[i];
                ++i;
            }
        }
        sp.depth = ep.fixed_depth != 9999999.0 ? ep.fixed_depth : (hp.depth != 9999999.0 ? hp.depth : Config.default_depth);
        sp.time = ep.fixed_time != 9999999.0 ? ep.fixed_time : hp.time;
        i = 0;
        while (i < 5) {
            sp.error[i] = 9999999.0;
            ++i;
        }
        sp.sdobs = 9999999.0;
        sp.maxdist = 9999999.0;
        sp.mindist = 9999999.0;
        sp.theta = 9999999.0;
        sp.minax = 9999999.0;
        sp.majax = 9999999.0;
        sp.weighting_type = Config.weighting1;
        if (sp.weighting_type.length() == 0) {
            logger.warn((Object)String.format("init_sol: weighting1 not set", new Object[0]));
            return 1;
        }
        if (Config.sigma_start == 0.0) {
            logger.warn((Object)String.format("init_sol: sigma_start not set", new Object[0]));
            return 1;
        }
        sp.sigma = Config.sigma_start;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("init_sol: weight=%s sigma=%.3f", sp.weighting_type, sp.sigma));
        }
        sp.depdp = 9999999.0;
        sp.phases_purged = ep.purge_phase != 0 ? (char)'\u0000' : '\u0001';
        return 0;
    }

    public static int mark_duplicates(ISCSol sp, ISCPha[] p) {
        int[] samesta = new int[50];
        int i = 0;
        while (i < sp.numphas) {
            int j = 0;
            if (p[i].weight_factor == 0.0 && p[i].purged == 0) {
                ++i;
            } else {
                int k = i;
                while (k < sp.numphas) {
                    if (!p[k].sta.equals(p[i].sta) || !p[k].net.equals(p[i].net)) break;
                    p[k].duplicate = 0;
                    if (p[k].weight_factor == 0.0 && p[k].purged == 0) {
                        ++i;
                    } else {
                        samesta[j++] = k;
                        if (j > 50) {
                            logger.warn((Object)String.format("mark_duplicates: %s: too many phases", p[i].sta));
                            return 1;
                        }
                    }
                    ++k;
                }
                if (Solve.same_sta(samesta, j, sp, p) > 0) {
                    return 1;
                }
            }
            i += j;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("mark_duplicates: done", new Object[0]));
            Utils.print_pha(sp.numphas, p);
        }
        return 0;
    }

    public static int same_sta(int[] samesta, int n, ISCSol sp, ISCPha[] p) {
        int k;
        int j;
        int[] sametime = new int[50];
        int[] samepha = new int[50];
        int[] done = new int[50];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("same_sta: %s %d phases", p[samesta[0]].sta, n));
        }
        int i = 0;
        while (i < n) {
            done[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            if (done[i] <= 0) {
                j = 0;
                k = i;
                while (k < n) {
                    if (p[samesta[k]].time == p[samesta[i]].time) {
                        sametime[j++] = samesta[k];
                        done[k] = 1;
                    }
                    ++k;
                }
                if (Solve.same_time(sametime, j, sp, p) > 0) {
                    return 1;
                }
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            done[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            if (done[i] <= 0) {
                j = 0;
                k = i;
                while (k < n) {
                    if (p[samesta[k]].phase.equals(p[samesta[i]].phase)) {
                        samepha[j++] = samesta[k];
                        done[k] = 1;
                    }
                    ++k;
                }
                if (Solve.same_pha(samepha, j, p) > 0) {
                    return 1;
                }
            }
            ++i;
        }
        return 0;
    }

    public static int same_pha(int[] samepha, int n, ISCPha[] p) {
        int j;
        int[] sametime = new int[50];
        int[] done = new int[50];
        double[] unique_time = new double[50];
        int x = 0;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("same_pha: %s %s %d phases", p[samepha[0]].phase, p[samepha[0]].sta, n));
        }
        unique_time[0] = p[samepha[0]].time;
        int number_of_times = 1;
        int i = 1;
        while (i < n) {
            boolean match = false;
            j = 0;
            while (j < number_of_times) {
                if (p[samepha[i]].time == unique_time[j]) {
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                unique_time[number_of_times++] = p[samepha[i]].time;
            }
            ++i;
        }
        if (number_of_times > 1) {
            i = 0;
            while (i < n) {
                p[samepha[i]].weight_factor /= (double)number_of_times;
                ++i;
            }
        }
        i = 0;
        while (i < n) {
            done[i] = 0;
            ++i;
        }
        i = 0;
        while (i < n) {
            if (done[i] <= 0) {
                j = 0;
                int k = i;
                while (k < n) {
                    if (p[samepha[k]].time == p[samepha[i]].time) {
                        sametime[j++] = samepha[k];
                        done[k] = 1;
                    }
                    ++k;
                }
                k = 0;
                while (k < j) {
                    if (p[sametime[k]].rdid == p[sametime[k]].pref_rd) {
                        x = sametime[k];
                        break;
                    }
                    ++k;
                }
                if (k == j) {
                    x = sametime[0];
                }
                k = 0;
                while (k < j) {
                    if (sametime[k] != x) {
                        p[sametime[k]].weight_factor = 0.0;
                        p[sametime[k]].duplicate = 1;
                        p[sametime[k]].pref_rd = p[x].rdid;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("%s %s DUP", p[sametime[k]].sta, p[sametime[k]].phase));
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        return 0;
    }

    public static int same_time(int[] sametime, int n, ISCSol sp, ISCPha[] p) {
        int[] phacode = new int[50];
        int min_resid_index = 0;
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("same_time: ", new Object[0]));
            sb.append(String.format("%s %f ", p[sametime[0]].sta, p[sametime[0]].time));
            sb.append(String.format("%d phases", n));
            logger.debug((Object)sb.substring(0));
        }
        phacode[0] = sametime[0];
        int number_of_codes = 1;
        int i = 1;
        while (i < n) {
            if (!p[sametime[i]].phase.equals("pP") && !p[sametime[i]].phase.equals("sP")) {
                boolean match = false;
                int j = 0;
                while (j < number_of_codes) {
                    if (p[sametime[i]].phase.equals(p[phacode[j]].phase)) {
                        match = true;
                        break;
                    }
                    ++j;
                }
                if (!match) {
                    phacode[number_of_codes++] = sametime[i];
                }
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("same_time: %d different phases", number_of_codes));
        }
        if (number_of_codes == 1) {
            return 0;
        }
        double obtime = p[sametime[0]].time - sp.time;
        double min_resid = Math.abs(9999999);
        i = 0;
        while (i < number_of_codes) {
            double resid;
            if (ModelJB.read_ttime(sp, p[phacode[i]]) > 0) {
                p[phacode[i]].ttime = 9999999.0;
            }
            if ((resid = Math.abs(p[phacode[i]].ttime - obtime)) < min_resid) {
                min_resid = resid;
                min_resid_index = phacode[i];
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("same_time: %s %f %f %f", p[phacode[i]].phase, obtime, p[phacode[i]].ttime, resid));
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("same_time: set to %s", p[min_resid_index].phase));
        }
        i = 0;
        while (i < n) {
            p[sametime[i]].phase = p[min_resid_index].phase;
            ++i;
        }
        return 0;
    }

    public static int print_hyp(ISCEvent ep, ISCHyp[] h) {
        logger.info((Object)String.format("evid=%d", ep.evid));
        logger.info((Object)String.format("numhyps=%d numphas=%d", ep.numhyps, ep.numphas));
        logger.info((Object)String.format("hypid   agency time                    lat     lon      depth  nsta  def ndef nass gap   mindist stime sdep  smaj  score", new Object[0]));
        int i = 0;
        while (i < ep.numhyps) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.format("%7d ", h[i].hypid));
            sb.append(String.format("%-6s %23s ", h[i].agency, Utils.write_time(h[i].time)));
            sb.append(String.format("%7.3f %8.3f ", h[i].lat, h[i].lon));
            if (h[i].depth != 9999999.0) {
                sb.append(String.format("%5.1f  ", h[i].depth));
            } else {
                sb.append(String.format("%5s  ", ""));
            }
            if (h[i].nsta != 9999999) {
                sb.append(String.format("%4d ", h[i].nsta));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].ndefsta != 9999999) {
                sb.append(String.format("%4d ", h[i].ndefsta));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].ndef != 9999999) {
                sb.append(String.format("%4d ", h[i].ndef));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].nass != 9999999) {
                sb.append(String.format("%4d ", h[i].nass));
            } else {
                sb.append(String.format("%4s ", ""));
            }
            if (h[i].azimgap != 9999999.0) {
                sb.append(String.format("%5.1f ", h[i].azimgap));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            if (h[i].mindist != 9999999.0) {
                sb.append(String.format("%6.2f ", h[i].mindist));
            } else {
                sb.append(String.format("%6s ", ""));
            }
            if (h[i].stime != 9999999.0) {
                sb.append(String.format("%5.2f ", h[i].stime));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            if (h[i].sdepth != 9999999.0) {
                sb.append(String.format("%5.2f ", h[i].sdepth));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            if (h[i].majax != 9999999.0) {
                sb.append(String.format("%5.1f ", h[i].majax));
            } else {
                sb.append(String.format("%5s ", ""));
            }
            sb.append(String.format("%5d ", h[i].rank));
            logger.info((Object)sb.substring(0));
            ++i;
        }
        logger.info((Object)String.format("", new Object[0]));
        return 0;
    }

    public static int pP_duplicates(ISCSol sp, ISCPha[] p) {
        int[] samesta = new int[50];
        int j = 0;
        int num_pP = 0;
        num_pP = 0;
        String prevsta = "";
        String prevnet = "";
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].phase.equals("pP")) {
                if (!p[i].sta.equals(prevsta) || !p[i].net.equals(prevnet)) {
                    j = 0;
                    while (j < num_pP) {
                        p[samesta[j]].weight_factor = 1.0 / (double)num_pP;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("pP_duplicates: %s %f", p[samesta[j]].sta, p[samesta[j]].weight_factor));
                        }
                        ++j;
                    }
                    prevsta = p[i].sta;
                    prevnet = p[i].net;
                    num_pP = 0;
                }
                samesta[num_pP++] = i;
                if (j > 50) {
                    logger.warn((Object)String.format("pP_duplicates: %s: too many pP phases", p[i].sta));
                    return 1;
                }
            }
            ++i;
        }
        j = 0;
        while (j < num_pP) {
            p[samesta[j]].weight_factor = 1.0 / (double)num_pP;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("pP_duplicates: %s %f", p[samesta[j]].sta, p[samesta[j]].weight_factor));
            }
            ++j;
        }
        return 0;
    }

    public static int purge_pha(ISCEvent ep, ISCSol sp, ISCPha[] p) {
        int[] reading = new int[50];
        if (sp.phases_purged != '\u0000') {
            return 0;
        }
        int prev_rdid = 0;
        int j = 0;
        boolean keep = true;
        int purged = 0;
        int i = 0;
        while (i < sp.numphas) {
            if (p[i].rdid != prev_rdid) {
                if (!keep) {
                    int k = reading[0];
                    while (k <= reading[j - 1]) {
                        if (Math.abs(p[k].resid) <= Config.purge_resid) {
                            keep = true;
                        }
                        ++k;
                    }
                    if (!keep) {
                        k = reading[0];
                        while (k <= reading[j - 1]) {
                            p[k].purged = 2;
                            ++k;
                        }
                    }
                    keep = true;
                }
                j = 0;
                prev_rdid = p[i].rdid;
            }
            if (Math.abs(p[i].resid) > Config.purge_resid && p[i].resid != 9999999.0) {
                p[i].purged = 1;
                keep = false;
                ++purged;
            }
            reading[j++] = i++;
            if (j <= 50) continue;
            logger.warn((Object)String.format("purge_pha: %s: too many phases", p[i].sta));
            return 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("phases with |resid| > %f purged:", Config.purge_resid));
            logger.debug((Object)String.format("(weights not reset yet)", new Object[0]));
            Utils.print_pha(sp.numphas, p);
        }
        sp.phases_purged = '\u0001';
        if (purged > 0) {
            sp.converged = 0;
        }
        return 0;
    }

    public static int rank_hyp(ISCEvent ep, ISCHyp[] h, ISCPha[] p) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Calling calc_gap", new Object[0]));
        }
        if (Solve.calc_gap(ep, h, p) > 0) {
            return 0;
        }
        int i = 0;
        while (i < ep.numhyps) {
            int score = 0;
            if (!ep.seed_agency.equals("")) {
                if (h[i].agency.equals(ep.seed_agency)) {
                    score += 100;
                }
            } else if (h[i].agency.equals("ISC")) {
                score += 100;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("hyp %d from %s gets %d ", i, h[i].agency, score));
            }
            int number = h[i].ndef != 9999999 ? h[i].ndef : (h[i].ndefsta != 9999999 ? h[i].ndefsta : (h[i].nsta != 9999999 ? h[i].nsta : 1));
            score = (int)((double)score + Math.log10(number));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("+ %d ", (int)Math.log10(number)));
            }
            int gap = h[i].azimgap != 9999999.0 ? (int)h[i].azimgap : 360;
            score += (360 - gap) / 60;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("+ %d ", (360 - gap) / 60));
            }
            if (h[i].mindist < 5.0) {
                score += 3;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("+ 3 ", new Object[0]));
                }
            }
            h[i].rank = score;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("= %d points", score));
            }
            ++i;
        }
        i = 0;
        while (i < ep.numhyps) {
            int j = i - 1;
            while (j > -1) {
                if (h[j].rank < h[j + 1].rank) {
                    ISCHyp h_temp = h[j + 1];
                    h[j + 1] = h[j];
                    h[j] = h_temp;
                }
                --j;
            }
            ++i;
        }
        return 0;
    }

    public static int solve(ISCSol sp, ISCPha[] p) {
        int k;
        int j;
        double[][] c = new double[5][5];
        double[] d = new double[5];
        double[] e = new double[5];
        double[][] f = new double[10][5];
        double[] ermax = new double[5];
        int nunk = 0;
        int npp = 0;
        nunk = sp.number_of_unknowns;
        int num = sp.numphas;
        npp = nunk * 2 + 1;
        if (nunk == 0) {
            return 0;
        }
        if (nunk == 2 || nunk > 4) {
            logger.warn((Object)String.format("solve: number of unknowns wrong %d", nunk));
            return 1;
        }
        double[] simulb = new double[num];
        double[][] simula = new double[5][num];
        int i = 0;
        while (i < num) {
            if (p[i].weight_factor != 0.0) {
                simula[1][i] = 1.0;
                simulb[i] = p[i].resid;
                if (nunk > 2) {
                    simula[2][i] = -p[i].dtdd * Math.cos((double)p[i].esaz * (Math.PI / 180));
                    simula[3][i] = -p[i].dtdd * Math.sin((double)p[i].esaz * (Math.PI / 180));
                }
                if (nunk > 3) {
                    simula[4][i] = p[i].dtdh;
                }
                double sqrt_weight = Math.sqrt(p[i].weight);
                int n = i;
                simulb[n] = simulb[n] * sqrt_weight;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("solve: %s %s simulb=%f", p[i].sta, p[i].phase, simulb[i]));
                }
                j = 1;
                while (j <= nunk) {
                    double[] dArray = simula[j];
                    int n2 = i;
                    dArray[n2] = dArray[n2] * sqrt_weight;
                    ++j;
                }
            }
            ++i;
        }
        i = 1;
        while (i <= nunk) {
            j = 1;
            while (j <= nunk) {
                c[j][i] = 0.0;
                k = 0;
                while (k < num) {
                    if (p[k].weight_factor > 0.0) {
                        double[] dArray = c[j];
                        int n = i;
                        dArray[n] = dArray[n] + simula[i][k] * simula[j][k];
                    }
                    ++k;
                }
                ++j;
            }
            d[i] = 0.0;
            k = 0;
            while (k < num) {
                if (p[k].weight_factor > 0.0) {
                    int n = i;
                    d[n] = d[n] + simula[i][k] * simulb[k];
                }
                ++k;
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("solve:c1=%f %f %f %f", c[1][1], c[2][1], c[3][1], c[4][1]));
            logger.debug((Object)String.format("      c2=%f %f %f %f", c[1][2], c[2][2], c[3][2], c[4][2]));
            logger.debug((Object)String.format("      c3=%f %f %f %f", c[1][3], c[2][3], c[3][3], c[4][3]));
            logger.debug((Object)String.format("      c4=%f %f %f %f", c[1][4], c[2][4], c[3][4], c[4][4]));
            logger.debug((Object)String.format("       d=%f %f %f %f", d[1], d[2], d[3], d[4]));
        }
        i = 1;
        while (i <= nunk) {
            j = 1;
            while (j <= nunk) {
                f[j][i] = c[j][i];
                ++j;
            }
            f[nunk + 1][i] = d[i];
            j = nunk + 2;
            while (j <= npp) {
                f[j][i] = 0.0;
                ++j;
            }
            f[nunk + 1 + i][i] = 1.0;
            ++i;
        }
        ermax[1] = (double)nunk + 0.5 * Config.max_err_factor;
        ermax[2] = (double)nunk * Config.max_err_factor;
        ermax[3] = (double)nunk * Config.max_err_factor;
        ermax[4] = 1.0E-4 * Config.max_err_factor;
        i = 1;
        while (i <= nunk) {
            if (f[i][i] < ermax[i]) {
                logger.warn((Object)String.format("SOLUTION INDETERMINATE, row %d", i));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("ermax=%f value=%f", ermax[i], f[i][i]));
                }
                return 1;
            }
            double y = 1.0 / f[i][i];
            j = i;
            while (j <= npp) {
                f[j][i] = f[j][i] * y;
                ++j;
            }
            if (i < nunk) {
                j = i + 1;
                while (j <= nunk) {
                    y = f[i][j];
                    k = i;
                    while (k <= npp) {
                        double[] dArray = f[k];
                        int n = j;
                        dArray[n] = dArray[n] - y * f[k][i];
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        e[nunk] = f[nunk + 1][nunk];
        if (nunk > 1) {
            i = nunk - 1;
            while (i > 0) {
                e[i] = f[nunk + 1][i];
                j = i + 1;
                while (j <= nunk) {
                    int n = i;
                    e[n] = e[n] - e[j] * f[j][i];
                    ++j;
                }
                --i;
            }
            i = 2 * nunk;
            while (i > nunk + 1) {
                j = nunk - 1;
                while (j > 0) {
                    k = j + 1;
                    while (k <= nunk) {
                        double[] dArray = f[i];
                        int n = j;
                        dArray[n] = dArray[n] - f[k][j] * f[i][k];
                        ++k;
                    }
                    --j;
                }
                --i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("solve: e=%f %f %f %f", e[1], e[2], e[3], e[4]));
        }
        i = 1;
        while (i <= nunk) {
            j = 1;
            while (j <= nunk) {
                sp.covar[j][i] = f[nunk + 1 + j][i];
                ++j;
            }
            ++i;
        }
        sp.time += e[1];
        if (nunk > 1) {
            int dir;
            sp.lat += e[2];
            if (Math.abs(sp.lat) >= 90.0) {
                sp.lat = sp.lat / Math.abs(sp.lat) * 180.0 - sp.lat;
                sp.lon = sp.lon / Math.abs(sp.lon) * 180.0 - sp.lon;
                dir = -1;
            } else {
                dir = 1;
            }
            sp.lon += (double)dir * e[3] / Math.cos(sp.lat * (Math.PI / 180));
            if (Math.abs(sp.lon) >= 180.0) {
                sp.lon -= sp.lon / Math.abs(sp.lon) * 360.0;
            }
            Utils.calc_dircos(sp.lat, sp.lon, sp.dircos);
            if (nunk == 4) {
                sp.depth += e[4];
                if (sp.depth < 0.0) {
                    logger.warn((Object)String.format("NEGATIVE DEPTH", new Object[0]));
                    return 1;
                }
            }
        }
        return 0;
    }

    public static int solve_depdp(ISCSol sp, ISCPha[] p) {
        double xsq;
        int i;
        double alpha;
        double total_weight;
        if (sp.depdp == 9999999.0) {
            total_weight = 0.0;
            alpha = 0.0;
            i = 0;
            while (i < sp.numphas) {
                if (!(p[i].pP_resid > Config.init_max_resid) && p[i].pP_resid != 9999999.0) {
                    alpha += p[i].pP_resid * p[i].weight_factor;
                    total_weight += 1.0;
                }
                ++i;
            }
            if (total_weight == 0.0) {
                return 0;
            }
            alpha /= total_weight;
            i = 0;
            while (i < sp.numphas) {
                if (p[i].pP_resid != 9999999.0 && !((xsq = 0.125 * (p[i].pP_resid - alpha) * (p[i].pP_resid - alpha)) > 70.0)) {
                    p[i].pP_weight = 1.0 / (1.0 + 0.1 * Math.exp(xsq));
                }
                ++i;
            }
        }
        total_weight = 0.0;
        alpha = 0.0;
        i = 0;
        while (i < sp.numphas) {
            if (p[i].pP_resid != 9999999.0) {
                alpha += p[i].pP_resid * p[i].pP_weight * p[i].weight_factor;
                total_weight += p[i].pP_weight * p[i].weight_factor;
            }
            ++i;
        }
        sp.depdp = 9999999.0;
        if (total_weight == 0.0) {
            return 0;
        }
        alpha /= total_weight;
        int num_pP = 0;
        double sum2 = total_weight = (double)0;
        double sum1 = total_weight;
        i = 0;
        while (i < sp.numphas) {
            if (p[i].pP_resid != 9999999.0 && p[i].weight_factor != 0.0 && !((xsq = 0.125 * (p[i].pP_resid - alpha) * (p[i].pP_resid - alpha)) > 70.0)) {
                p[i].pP_weight = 1.0 / (1.0 + 0.1 * Math.exp(xsq));
                sum1 += p[i].weight_factor * p[i].pP_weight * p[i].pP_resid * p[i].pP_dtdh;
                sum2 += p[i].weight_factor * p[i].pP_weight * p[i].pP_dtdh * p[i].pP_dtdh;
                total_weight += p[i].weight_factor * p[i].pP_weight;
                ++num_pP;
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("solve_depdp:sum1=%f,sum2=%f total_weight=%f", sum1, sum2, total_weight));
        }
        if (sum2 == 0.0 || total_weight < 1.9) {
            return 0;
        }
        sp.depdp = sp.depth + sum1 / sum2;
        if (sp.depdp < 0.0) {
            logger.warn((Object)String.format("solve_depdp: NEGATIVE DEPTH", new Object[0]));
            sp.depdp = 9999999.0;
            return 1;
        }
        sum1 = 0.0;
        i = 0;
        while (i < sp.numphas) {
            if (p[i].pP_resid != 9999999.0) {
                double pP_P_ob = p[i].pP_resid + p[i].pP_P_time;
                if (ModelJB.read_pP_P(sp.depdp, p[i]) > 0) {
                    Utils.handle_error();
                } else {
                    p[i].pP_resid = pP_P_ob - p[i].pP_P_time;
                    sum1 += p[i].pP_weight * p[i].pP_resid * p[i].pP_resid;
                }
            }
            ++i;
        }
        sp.depdp_error = Math.sqrt(sum1 / (sum2 * total_weight));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("solve_depdp: depdp= %.2f +/- %.2f using %d phases", sp.depdp, sp.depdp_error, num_pP));
        }
        return 0;
    }

    private Solve() {
    }
}

