/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.DataCovariance;
import cn.org.gddsn.seis.location.iscloc2.EC_COEF;
import cn.org.gddsn.seis.location.iscloc2.EllipticityCorr;
import cn.org.gddsn.seis.location.iscloc2.FE;
import cn.org.gddsn.seis.location.iscloc2.GeoRegion;
import cn.org.gddsn.seis.location.iscloc2.ISCEvent;
import cn.org.gddsn.seis.location.iscloc2.ISCSta;
import cn.org.gddsn.seis.location.iscloc2.MAGQ;
import cn.org.gddsn.seis.location.iscloc2.Magnitude;
import cn.org.gddsn.seis.location.iscloc2.PhaseMap;
import cn.org.gddsn.seis.location.iscloc2.PhaseWeight;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import cn.org.gddsn.seis.location.iscloc2.VarioGram;
import cn.org.gddsn.seis.location.rstt.SlbmInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Config {
    static Logger logger = Logger.getLogger(Config.class);
    public static final int NULLVAL = 9999999;
    public static final double SAMETIME_TOL = 0.1;
    public static final double DEPSILON = 1.0E-8;
    public static final double CONV_TOL = 1.0E-8;
    public static final double ZERO_TOL = 1.0E-10;
    public static final int MAXBUF = 1024;
    public static final int MAXOPT = 100;
    public static final int MAXHYP = 50;
    public static final int MAXPHA = 5000;
    public static final int MAXAMP = 10;
    public static final int MAXPHACODES = 400;
    public static final int MAXNUMPHA = 200;
    public static final int MAXTTPHA = 95;
    public static final int PHA_PER_READ = 80;
    public static final int DELTA_SAMPLES = 6;
    public static final int DEPTH_SAMPLES = 4;
    public static final int MIN_SAMPLES = 2;
    public static final int NA_MAXND = 4;
    public static final int NA_MAXITER = 100;
    public static final int NA_MAXSAMP = 5000;
    public static final int NA_MAXBIT = 30;
    public static final int NA_MAXDEG = 10;
    public static final int NA_MAXSEQ = 20000;
    public static final int NA_MAXMOD = 500001;
    public static final double PI2 = 1.5707963267948966;
    public static final double TWOPI = Math.PI * 2;
    public static final double EARTH_RADIUS = 6371.0;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double DEG2KM = 111.19492664455873;
    public static final double FLATTENING = 0.00335281066474;
    public static final int phaseTT_num = 95;
    public static final String[] phaseTT = new String[]{"firstP", "firstS", "P", "Pn", "Pg", "Pb", "PKPdf", "PKPab", "PKPbc", "PKSdf", "PKSab", "PKSbc", "S", "Sn", "Sg", "Sb", "SKPdf", "SKPab", "SKPbc", "SKSdf", "SKSac", "pP", "pwP", "sP", "pPKPdf", "PcP", "PcS", "ScP", "ScS", "Pdif", "PKKPdf", "PKKPab", "PKKPbc", "PKKSdf", "PKKSab", "PKKSbc", "Sdif", "SKKPdf", "SKKPab", "SKKPbc", "SKKSdf", "SKKSac", "PKPdif", "PKiKP", "PP", "PbPb", "PnPn", "PgS", "PnS", "P'P'df", "P'P'ab", "P'P'bc", "SKiKP", "SS", "SbSb", "SnSn", "SPg", "SPn", "S'S'df", "S'S'ac", "pS", "sS", "pPb", "sPb", "sSb", "pPn", "sPn", "sSn", "pPdif", "sPdif", "pSdif", "sSdif", "pPKiKP", "sPKiKP", "pPKPab", "sPKPab", "pPKPbc", "sPKPbc", "sPKPdf", "pSKSac", "sSKSac", "pSKSdf", "sSKSdf", "pPKPdif", "sPKPdif", "PPP", "PSP", "PSS", "PS", "SPP", "SSS", "SP", "SSP", "PgPg", "SgSg"};
    public static int errorcode;
    public static final String[] errorcodes;
    public static double moho;
    public static double conrad;
    public static double max_depth_km;
    public static double psurfvel;
    public static double ssurfvel;
    public static PhaseMap[] phase_map;
    public static int phase_map_num;
    public static PhaseWeight[] phase_weight;
    public static int phase_weight_num;
    public static String[] allowable_phase;
    public static int no_allowable_phase_num;
    public static String[] firstPphase;
    public static int firstPphase_num;
    public static String[] firstSphase;
    public static int firstSphase_num;
    public static String[] firstPopt;
    public static int firstPopt_num;
    public static String[] firstSopt;
    public static int firstSopt_num;
    public static String[] no_resid_phase;
    public static int no_resid_phase_num;
    public static String[] mb_phase;
    public static int mb_phase_num;
    public static String[] ms_phase;
    public static int ms_phase_num;
    public static String logfile;
    public static String errfile;
    public static String isf_stafile;
    public static String isf_outfile;
    public static String isf_infile;
    public static int update_db;
    public static String nextid_db;
    public static int repid;
    public static String out_agency;
    public static String in_agency;
    public static String ttime_table;
    public static double default_depth;
    public static int min_iter;
    public static int max_iter;
    public static int min_phases;
    public static double sigmathres;
    public static int do_correlated_errors;
    public static int allow_damping;
    public static double confidence;
    public static int mindepthpha;
    public static int ndepagency;
    public static double localdist;
    public static int minlocalsta;
    public static double spdist;
    public static int min_s_p;
    public static int min_corepha;
    public static double maxdeperror_shallow;
    public static double maxdeperror_deep;
    public static int set_to_best_fitting_phase;
    public static String mbQ_table;
    public static double body_mag_min_dist;
    public static double body_mag_max_dist;
    public static double surf_mag_min_dist;
    public static double surf_mag_max_dist;
    public static double body_mag_min_per;
    public static double body_mag_max_per;
    public static double surf_mag_min_per;
    public static double surf_mag_max_per;
    public static double surf_mag_max_depth;
    public static double mag_range_warn_thresh;
    public static int do_gridsearch;
    public static int write_gridsearch_results;
    public static double na_radius;
    public static double na_deptol;
    public static double na_ottol;
    public static double na_lpnorm;
    public static int na_itermax;
    public static int na_nsamplei;
    public static int na_nsample;
    public static int na_ncells;
    public static long iseed;
    public static String[] nohypoagency;
    public static int numnohypoagency;
    public static String etopofile;
    public static int etoponlon;
    public static int etoponlat;
    public static double etopores;
    public static String indb;
    public static String outdb;
    public static int verbose;
    public static String[] agencies;
    public static int numagencies;
    public static ISCSta[] stationlist;
    public static int numsta;
    public static SlbmInterface slbm;
    public static final boolean RSTT_ENABLE = false;
    public static final double MAX_RSTT_DIST = 15.0;
    public static final boolean singleCore = true;

    static {
        errorcodes = new String[]{"unknown error, please consult log file", "memory allocation error", "could not open file", "bad instruction", "diverging solution", "insufficient number of phases", "insufficient number of independent phases", "phase loss", "slow convergence", "singular G matrix", "abnormally ill-conditioned problem", "invalid station code"};
        phase_map = new PhaseMap[400];
        phase_weight = new PhaseWeight[200];
        allowable_phase = new String[95];
        firstPphase = new String[95];
        firstSphase = new String[95];
        firstPopt = new String[95];
        firstSopt = new String[95];
        no_resid_phase = new String[200];
        mb_phase = new String[200];
        ms_phase = new String[200];
        logfile = "";
        errfile = "";
        isf_stafile = "";
        isf_outfile = "";
        isf_infile = "";
        nextid_db = "";
        out_agency = "";
        in_agency = "";
        ttime_table = "";
        set_to_best_fitting_phase = 1;
        mbQ_table = "";
        nohypoagency = new String[1024];
        agencies = new String[1024];
        slbm = null;
        int i = 0;
        while (i < phase_map.length) {
            Config.phase_map[i] = new PhaseMap();
            ++i;
        }
        i = 0;
        while (i < phase_weight.length) {
            Config.phase_weight[i] = new PhaseWeight();
            ++i;
        }
    }

    private Config() {
    }

    public static boolean streq(String A, String B) {
        return A.equals(B);
    }

    public static int read_config(String filename) {
        logfile = "stdout";
        errfile = "stderr";
        isf_stafile = "";
        nextid_db = "isc";
        out_agency = "ISC";
        in_agency = "ISC";
        ttime_table = "ak135";
        etopofile = "etopo5_bed_g_i2.bin";
        mbQ_table = "GR";
        etoponlon = 4321;
        etoponlat = 2161;
        etopores = 0.0833333;
        default_depth = 0.0;
        min_phases = 4;
        confidence = 90.0;
        update_db = 0;
        min_iter = 4;
        max_iter = 20;
        sigmathres = 4.0;
        do_correlated_errors = 1;
        allow_damping = 1;
        mindepthpha = 5;
        ndepagency = 2;
        localdist = 0.2;
        minlocalsta = 1;
        spdist = 3.0;
        min_s_p = 5;
        min_corepha = 5;
        maxdeperror_shallow = 30.0;
        maxdeperror_deep = 60.0;
        do_gridsearch = 0;
        na_radius = 5.0;
        na_deptol = 300.0;
        na_ottol = 30.0;
        na_lpnorm = 1.0;
        na_itermax = 10;
        na_nsamplei = 1000;
        na_nsample = 100;
        na_ncells = 20;
        iseed = 5590L;
        body_mag_min_dist = 21.0;
        body_mag_max_dist = 100.0;
        surf_mag_min_dist = 20.0;
        surf_mag_max_dist = 160.0;
        body_mag_min_per = 0.0;
        body_mag_max_per = 3.0;
        surf_mag_min_per = 10.0;
        surf_mag_max_per = 60.0;
        surf_mag_max_depth = 60.0;
        mag_range_warn_thresh = 2.2;
        numnohypoagency = 0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(filename));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage());
            return 1;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        while (sc.hasNext()) {
            String par = sc.next();
            if (Config.streq(par, "out_agency")) {
                out_agency = sc.next();
            }
            if (Config.streq(par, "in_agency")) {
                in_agency = sc.next();
                continue;
            }
            if (Config.streq(par, "repid")) {
                repid = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "update_db")) {
                update_db = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "nextid_db")) {
                nextid_db = sc.next();
                continue;
            }
            if (Config.streq(par, "isf_stafile")) {
                isf_stafile = sc.next();
                continue;
            }
            if (Config.streq(par, "logfile")) {
                logfile = sc.next();
                continue;
            }
            if (Config.streq(par, "errfile")) {
                errfile = sc.next();
                continue;
            }
            if (Config.streq(par, "confidence")) {
                confidence = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "do_correlated_errors")) {
                do_correlated_errors = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "allow_damping")) {
                allow_damping = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "min_phases")) {
                min_phases = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "sigmathres")) {
                sigmathres = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "min_iter")) {
                min_iter = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "max_iter")) {
                max_iter = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "ttime_table")) {
                ttime_table = sc.next();
                continue;
            }
            if (Config.streq(par, "etopofile")) {
                etopofile = sc.next();
                continue;
            }
            if (Config.streq(par, "etoponlon")) {
                etoponlon = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "etoponlat")) {
                etoponlat = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "etopores")) {
                etopores = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "default_depth")) {
                default_depth = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "mindepthpha")) {
                mindepthpha = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "ndepagency")) {
                ndepagency = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "localdist")) {
                localdist = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "minlocalsta")) {
                minlocalsta = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "spdist")) {
                spdist = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "min_s_p")) {
                min_s_p = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "min_corepha")) {
                min_corepha = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "maxdeperror_shallow")) {
                maxdeperror_shallow = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "maxdeperror_deep")) {
                maxdeperror_deep = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "mbQ_table")) {
                mbQ_table = sc.next();
                continue;
            }
            if (Config.streq(par, "body_mag_min_dist")) {
                body_mag_min_dist = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "body_mag_max_dist")) {
                body_mag_max_dist = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "surf_mag_min_dist")) {
                surf_mag_min_dist = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "surf_mag_max_dist")) {
                surf_mag_max_dist = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "body_mag_min_per")) {
                body_mag_min_per = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "body_mag_max_per")) {
                body_mag_max_per = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "surf_mag_min_per")) {
                surf_mag_min_per = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "surf_mag_max_per")) {
                surf_mag_max_per = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "surf_mag_max_depth")) {
                surf_mag_max_depth = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "mag_range_warn_thresh")) {
                mag_range_warn_thresh = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "do_gridsearch")) {
                do_gridsearch = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "na_radius")) {
                na_radius = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "na_deptol")) {
                na_deptol = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "na_ottol")) {
                na_ottol = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "na_lpnorm")) {
                na_lpnorm = sc.nextDouble();
                continue;
            }
            if (Config.streq(par, "na_itermax")) {
                na_itermax = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "na_nsamplei")) {
                na_nsamplei = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "na_nsample")) {
                na_nsample = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "na_ncells")) {
                na_ncells = sc.nextInt();
                continue;
            }
            if (Config.streq(par, "iseed")) {
                iseed = sc.nextLong();
                continue;
            }
            if (!Config.streq(par, "nohypo_agencies")) continue;
            int i = 0;
            Scanner sc1 = new Scanner(sc.next()).useDelimiter(",");
            while (sc1.hasNext()) {
                Config.nohypoagency[i++] = sc1.next();
            }
            sc1.close();
            numnohypoagency = i;
        }
        sc.close();
        return 0;
    }

    public static int read_model(String filename) {
        Scanner sc = null;
        try {
            sc = new Scanner(new File(filename));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage());
            return 1;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        while (sc.hasNext()) {
            String phase;
            int i;
            String par = sc.next();
            if (Config.streq(par, "moho")) {
                moho = sc.nextDouble();
            } else if (Config.streq(par, "conrad")) {
                conrad = sc.nextDouble();
            } else if (Config.streq(par, "max_depth_km")) {
                max_depth_km = sc.nextDouble();
            } else if (Config.streq(par, "psurfvel")) {
                psurfvel = sc.nextDouble();
            } else if (Config.streq(par, "ssurfvel")) {
                ssurfvel = sc.nextDouble();
            }
            if (Config.streq(par, "phase_map")) {
                i = 0;
                while (sc.hasNext()) {
                    String rep_phase = sc.next();
                    if (rep_phase.equals("allowable_phases")) {
                        par = rep_phase;
                        break;
                    }
                    phase = sc.next();
                    Config.phase_map[i].rep_phase = rep_phase;
                    Config.phase_map[i].phase = phase;
                    ++i;
                }
                phase_map_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes into phase_map", i));
                }
            }
            if (Config.streq(par, "allowable_phases")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("allowable_first_P")) {
                        par = phase;
                        break;
                    }
                    Config.allowable_phase[i++] = phase;
                }
                no_allowable_phase_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in allowable_phase", i));
                }
            }
            if (Config.streq(par, "allowable_first_P")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("optional_first_P")) {
                        par = phase;
                        break;
                    }
                    Config.firstPphase[i++] = phase;
                }
                firstPphase_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in allowable_first_P", i));
                }
            }
            if (Config.streq(par, "optional_first_P")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("allowable_first_S")) {
                        par = phase;
                        break;
                    }
                    Config.firstPopt[i++] = phase;
                }
                firstPopt_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in optional_first_P", i));
                }
            }
            if (Config.streq(par, "allowable_first_S")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("optional_first_S")) {
                        par = phase;
                        break;
                    }
                    Config.firstSphase[i++] = phase;
                }
                firstSphase_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in allowable_first_S", i));
                }
            }
            if (Config.streq(par, "optional_first_S")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("no_resid_phase")) {
                        par = phase;
                        break;
                    }
                    Config.firstSopt[i++] = phase;
                }
                firstSopt_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in optional_first_S", i));
                }
            }
            if (Config.streq(par, "no_resid_phase")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("phase_weight")) {
                        par = phase;
                        break;
                    }
                    Config.no_resid_phase[i++] = phase;
                }
                no_resid_phase_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in no_resid_phase", i));
                }
            }
            if (Config.streq(par, "phase_weight")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("mb_phase")) {
                        par = phase;
                        break;
                    }
                    Config.phase_weight[i].delta1 = sc.nextDouble();
                    Config.phase_weight[i].delta2 = sc.nextDouble();
                    Config.phase_weight[i].measurement_error = sc.nextDouble();
                    Config.phase_weight[i].phase = phase;
                    ++i;
                }
                phase_weight_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d lines into phase_weight", i));
                }
            }
            if (Config.streq(par, "mb_phase")) {
                i = 0;
                while (sc.hasNext()) {
                    phase = sc.next();
                    if (phase.equals("ms_phase")) {
                        par = phase;
                        break;
                    }
                    Config.mb_phase[i++] = phase;
                }
                mb_phase_num = i;
                if (verbose > 1) {
                    logger.info((Object)String.format("    read %d codes in mb_phase", i));
                }
            }
            if (!Config.streq(par, "ms_phase")) continue;
            i = 0;
            while (sc.hasNext()) {
                phase = sc.next();
                Config.ms_phase[i++] = phase;
            }
            ms_phase_num = i;
            if (verbose <= 1) continue;
            logger.info((Object)String.format("    read %d codes in ms_phase", i));
        }
        sc.close();
        return 0;
    }

    public static int parse_instruction(String instruction, ISCEvent ep, int isf) {
        String[] opt = new String[100];
        String[] val = new String[100];
        ep.evid = 9999999;
        ep.depth_agency = "";
        ep.location_agency = "";
        ep.time_agency = "";
        ep.hypo_agency = "";
        ep.start_depth = 9999999.0;
        ep.start_lat = 9999999.0;
        ep.start_lon = 9999999.0;
        ep.start_time = 9999999.0;
        ep.surface_fix = false;
        ep.time_fix = false;
        ep.depth_fix = false;
        ep.depth_fix_editor = false;
        ep.epi_fix = false;
        ep.hypo_fix = false;
        ep.fix_depth_default = false;
        ep.fix_depth_depdp = false;
        Scanner sc = new Scanner(instruction);
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|=|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        int k = 0;
        while (sc.hasNext()) {
            opt[k] = sc.next();
            if (!Character.isDigit(opt[k].charAt(0))) {
                val[k] = sc.next();
            }
            ++k;
        }
        int numopt = k;
        int i = 0;
        while (i < numopt) {
            int j = 0;
            while (j < i) {
                if (Config.streq(opt[i], opt[j])) {
                    logger.error((Object)String.format("ABORT: two options %s", opt[i]));
                    return 1;
                }
                ++j;
            }
            if (Character.isDigit(opt[i].charAt(0))) {
                if (ep.evid != 9999999 || isf != 0) {
                    logger.error((Object)String.format("ABORT: two evids %s", instruction));
                    return 1;
                }
                try {
                    ep.evid = Integer.parseInt(opt[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad evid %s", opt[i]));
                    return 1;
                }
            }
            if (Config.streq(opt[i], "set_to_best_fitting_phase")) {
                try {
                    set_to_best_fitting_phase = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad set_to_best_fitting_phase %s", val[i]));
                    return 1;
                }
            }
            if (Config.streq(opt[i], "depth")) {
                if (Character.isDigit(val[i].charAt(0))) {
                    try {
                        ep.start_depth = Double.parseDouble(val[i]);
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)String.format("ABORT: bad depth %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.depth_agency = val[i];
                }
            } else if (Config.streq(opt[i], "fix_depth")) {
                if (Character.isDigit(val[i].charAt(0))) {
                    try {
                        ep.start_depth = Double.parseDouble(val[i]);
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)String.format("ABORT: bad fix_depth %s", val[i]));
                        return 1;
                    }
                    ep.depth_fix_editor = true;
                } else {
                    ep.depth_agency = val[i];
                    if (Config.streq(ep.depth_agency, "")) {
                        logger.warn((Object)String.format("WARNING: No depth agency is given! ", new Object[0]));
                        logger.warn((Object)String.format("Depth will be fixed to the median reported depth.", new Object[0]));
                    }
                }
                ep.depth_fix = true;
            } else if (Config.streq(opt[i], "lat")) {
                if (Character.isDigit(val[i].charAt(0)) || val[i].charAt(0) == '-') {
                    try {
                        ep.start_lat = Double.parseDouble(val[i]);
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)String.format("ABORT: bad lat %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.location_agency = val[i];
                }
            } else if (Config.streq(opt[i], "lon")) {
                if (Character.isDigit(val[i].charAt(0)) || val[i].charAt(0) == '-') {
                    try {
                        ep.start_lon = Double.parseDouble(val[i]);
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)String.format("ABORT: bad lon %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.location_agency = val[i];
                }
            } else if (Config.streq(opt[i], "fix_location")) {
                ep.location_agency = val[i];
                ep.epi_fix = true;
                if (Config.streq(ep.location_agency, "")) {
                    logger.warn((Object)String.format("WARNING: No location agency is given! ", new Object[0]));
                }
            } else if (Config.streq(opt[i], "time")) {
                if (Character.isDigit(val[i].charAt(0))) {
                    ep.start_time = Utils.read_time(val[i]);
                    if (ep.start_time == 0.0) {
                        logger.error((Object)String.format("ABORT: bad time %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.time_agency = val[i];
                }
            } else if (Config.streq(opt[i], "fix_time")) {
                if (Character.isDigit(val[i].charAt(0))) {
                    ep.start_time = Utils.read_time(val[i]);
                    if (ep.start_time == 0.0) {
                        logger.error((Object)String.format("ABORT: bad time %s", val[i]));
                        return 1;
                    }
                } else {
                    ep.time_agency = val[i];
                    if (Config.streq(ep.time_agency, "")) {
                        logger.warn((Object)String.format("WARNING: No time agency is given! ", new Object[0]));
                        logger.warn((Object)String.format("Origin time will be fixed to the median origin time.", new Object[0]));
                    }
                }
                ep.time_fix = true;
            } else if (Config.streq(opt[i], "fix_hypo")) {
                ep.hypo_agency = val[i];
                if (Config.streq(ep.hypo_agency, "")) {
                    logger.warn((Object)String.format("WARNING: No hypocentre agency is given! ", new Object[0]));
                    logger.warn((Object)String.format("Hypocentre will be fixed to the median hypocentre", new Object[0]));
                }
                ep.hypo_fix = true;
            } else if (Config.streq(opt[i], "fix_depth_depdp")) {
                ep.fix_depth_depdp = true;
                ep.depth_fix = true;
            } else if (Config.streq(opt[i], "fix_depth_default")) {
                ep.fix_depth_default = true;
                ep.depth_fix = true;
            } else if (Config.streq(opt[i], "mindepthpha")) {
                try {
                    mindepthpha = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad mindepthpha %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "ndepagency")) {
                try {
                    ndepagency = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad ndepagency %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "localdist")) {
                try {
                    localdist = Double.parseDouble(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad localdist %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "spdist")) {
                try {
                    spdist = Double.parseDouble(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad spdist %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "minlocalsta")) {
                try {
                    minlocalsta = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad minlocalsta %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "min_s_p")) {
                try {
                    min_s_p = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad min_s_p %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "min_corepha")) {
                try {
                    min_corepha = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad min_corepha %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "do_correlated_errors")) {
                do_correlated_errors = Integer.parseInt(val[i]);
            } else if (Config.streq(opt[i], "verbose")) {
                try {
                    verbose = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad verbose %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "do_gridsearch")) {
                do_gridsearch = Integer.parseInt(val[i]);
            } else if (Config.streq(opt[i], "na_radius")) {
                try {
                    na_radius = Double.parseDouble(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_radius %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "na_deptol")) {
                try {
                    na_deptol = Double.parseDouble(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_deptol %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "na_ottol")) {
                try {
                    na_ottol = Double.parseDouble(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_ottol %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "na_nsamplei")) {
                try {
                    na_nsamplei = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_nsamplei %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "na_nsample")) {
                try {
                    na_nsample = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_nsample %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "na_ncells")) {
                try {
                    na_ncells = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_ncells %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "na_itermax")) {
                try {
                    na_itermax = Integer.parseInt(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("ABORT: bad na_itermax %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "write_gridsearch_results")) {
                write_gridsearch_results = Integer.parseInt(val[i]);
            } else if (Config.streq(opt[i], "iseed")) {
                try {
                    iseed = Long.parseLong(val[i]);
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)String.format("read_instruction: bad iseed %s", val[i]));
                    return 1;
                }
            } else if (Config.streq(opt[i], "isf_stafile")) {
                isf_stafile = val[i];
            } else if (Config.streq(opt[i], "isf_infile")) {
                isf_infile = val[i];
            } else if (Config.streq(opt[i], "isf_outfile")) {
                isf_outfile = val[i];
            } else if (Config.streq(opt[i], "indb")) {
                indb = String.valueOf(val[i]) + ".";
            } else if (Config.streq(opt[i], "outdb")) {
                outdb = String.valueOf(val[i]) + ".";
            } else if (Config.streq(opt[i], "update_db")) {
                update_db = Integer.parseInt(val[i]);
            } else {
                logger.error((Object)String.format("read_instruction: unknown option %s", opt[i]));
            }
            if (verbose > 1) {
                logger.info((Object)String.format("    read_instruction: %d %s %s", i, opt[i], val[i]));
            }
            ++i;
        }
        if (ep.evid == 9999999 && isf == 0) {
            logger.error((Object)String.format("ABORT: no evid %s", instruction));
            return 1;
        }
        if (ep.start_lat != 9999999.0 || ep.start_lon != 9999999.0) {
            if (ep.start_lat == 9999999.0 || ep.start_lon == 9999999.0) {
                logger.error((Object)String.format("ABORT: must set both lat and lon", new Object[0]));
                return 1;
            }
            if (ep.location_agency.length() != 0) {
                logger.error((Object)String.format("ABORT: location set twice", new Object[0]));
                return 1;
            }
        }
        if (verbose > 1) {
            logger.info((Object)String.format("    read_instruction: evid: %d", ep.evid));
        }
        return 0;
    }

    public static int read_data_files(String configdir, DataStruct ds) {
        String dirname;
        String filename;
        double[] gd = null;
        if (Config.streq(ttime_table, "jb")) {
            filename = String.format("%s/iscloc/jb_model.txt", configdir);
            dirname = String.format("%s/jb", configdir);
            logger.info((Object)String.format("model=jb", new Object[0]));
        } else if (Config.streq(ttime_table, "ak135")) {
            filename = String.format("%s/iscloc/ak135_model.txt", configdir);
            dirname = String.format("%s/ak135", configdir);
            logger.info((Object)String.format("model=ak135", new Object[0]));
        } else {
            logger.error((Object)String.format("Bad ttime_table %s in config.txt", ttime_table));
            return 1;
        }
        logger.info((Object)String.format("    read_model: %s", filename));
        if (Config.read_model(filename) != 0) {
            return 1;
        }
        filename = String.format("%s/FlinnEngdahl/FE.dat", configdir);
        logger.info((Object)String.format("    read_FlinnEngdahl: %s", filename));
        if (GeoRegion.read_FlinnEngdahl(filename, ds.fep) != 0) {
            return 1;
        }
        filename = String.format("%s/FlinnEngdahl/grn_default_depth.%s.dat", configdir, ttime_table);
        logger.info((Object)String.format("    read_default_depth_region: %s", filename));
        gd = GeoRegion.read_default_depth_region(filename);
        if (gd == null) {
            logger.error((Object)String.format("Cannot read default GRN depths!", new Object[0]));
            GeoRegion.free_fe(ds.fep);
            return 1;
        }
        filename = String.format("%s/FlinnEngdahl/default.depth0.5.grid", configdir);
        logger.info((Object)String.format("    read_default_depth_grid: %s", filename));
        ds.depthgrid = GeoRegion.read_default_depth_grid(filename, ds.gres, ds.ngrid);
        if (ds.depthgrid == null) {
            logger.error((Object)String.format("Cannot read default depth grid!", new Object[0]));
            GeoRegion.free_fe(ds.fep);
            gd = null;
            return 1;
        }
        if (Config.streq(ttime_table, "ak135")) {
            filename = String.format("%s/ELCOR.dat", dirname);
            logger.info((Object)String.format("    read_elcor_tbl: %s", filename));
            ds.ec = EllipticityCorr.read_elcor_tbl(ds.num_ecphases, filename);
            if (ds.ec == null) {
                logger.error((Object)String.format("Cannot read ellipticity correction file %s", filename));
                GeoRegion.free_fe(ds.fep);
                gd = null;
                ds.depthgrid = null;
                return 1;
            }
            logger.info((Object)String.format("    read_tt_tables: %s", dirname));
            ds.tt_tables = TravelTimes.read_tt_tables(dirname);
            if (ds.tt_tables == null) {
                logger.error((Object)String.format("Cannot read ak135 TT tables!", new Object[0]));
                if (ds.ec != null) {
                    EllipticityCorr.free_elcor_tbl(ds.ec, ds.num_ecphases.val);
                }
                GeoRegion.free_fe(ds.fep);
                gd = null;
                ds.depthgrid = null;
                return 1;
            }
        }
        if (Config.streq(ttime_table, "jb")) {
            logger.info((Object)String.format("    read_tt_tables: %s", dirname));
            ds.tt_tables = TravelTimes.read_tt_tables(dirname);
            if (ds.tt_tables == null) {
                logger.error((Object)String.format("Cannot read JB TT tables!", new Object[0]));
                GeoRegion.free_fe(ds.fep);
                gd = null;
                ds.depthgrid = null;
                return 1;
            }
        }
        filename = String.format("%s/topo/%s", configdir, etopofile);
        logger.info((Object)String.format("    read_etopo1: %s", filename));
        ds.topo = TravelTimes.read_etopo1(filename);
        if (ds.topo == null) {
            logger.error((Object)String.format("Cannot read ETOPO file %s", filename));
            if (ds.tt_tables != null) {
                TravelTimes.free_tt_tbl(ds.tt_tables);
            }
            if (ds.ec != null) {
                EllipticityCorr.free_elcor_tbl(ds.ec, ds.num_ecphases.val);
            }
            GeoRegion.free_fe(ds.fep);
            gd = null;
            ds.depthgrid = null;
            return 1;
        }
        if (!mbQ_table.equals("none")) {
            filename = String.format("%s/magnitude/%smbQ.dat", configdir, mbQ_table);
            logger.info((Object)String.format("    read_magQ: %s", filename));
            if (Magnitude.read_magQ(filename, ds.mbQp) != 0) {
                logger.error((Object)String.format("Cannot read magnitude Q file %s", filename));
                if (ds.tt_tables != null) {
                    TravelTimes.free_tt_tbl(ds.tt_tables);
                }
                if (ds.ec != null) {
                    EllipticityCorr.free_elcor_tbl(ds.ec, ds.num_ecphases.val);
                }
                GeoRegion.free_fe(ds.fep);
                gd = null;
                ds.depthgrid = null;
                ds.topo = null;
                return 1;
            }
            ds.ismbQ.val = 1;
            if (mbQ_table.startsWith("VC")) {
                ds.ismbQ.val = 2;
            }
        }
        filename = String.format("%s/variogram/variogram.model", configdir);
        logger.info((Object)String.format("    read_variogram: %s", filename));
        if (DataCovariance.read_variogram(filename, ds.variogramp) != 0) {
            logger.error((Object)String.format("Cannot read variogram file %s", filename));
            if (ds.tt_tables != null) {
                TravelTimes.free_tt_tbl(ds.tt_tables);
            }
            if (ds.ec != null) {
                EllipticityCorr.free_elcor_tbl(ds.ec, ds.num_ecphases.val);
            }
            GeoRegion.free_fe(ds.fep);
            gd = null;
            ds.depthgrid = null;
            ds.topo = null;
            if (ds.ismbQ.val != 0) {
                ds.mbQp.deltas = null;
                ds.mbQp.depths = null;
                ds.mbQp.q = null;
            }
            return 1;
        }
        ds.grn_depth = gd;
        return 0;
    }

    public static class DataStruct {
        public intW ismbQ = new intW(0);
        public MAGQ mbQp;
        public FE fep;
        public double[] grn_depth;
        public doubleW gres = new doubleW(0.0);
        public intW ngrid = new intW(0);
        public double[][] depthgrid;
        public short[][] topo;
        public intW num_ecphases = new intW(0);
        public EC_COEF[] ec;
        public TT_TABLE[] tt_tables;
        public VarioGram variogramp;
    }
}

