/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSta;
import cn.org.gddsn.seis.location.iscloc2.Interpolate;
import cn.org.gddsn.seis.location.iscloc2.StaOrder;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import cn.org.gddsn.seis.location.iscloc2.VarioGram;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DataCovariance {
    static Logger logger = Logger.getLogger(DataCovariance.class);

    public static ISCSta[] get_stalist(int numphas, ISCPha[] p, intW nsta) {
        Object[] stalist = null;
        String prev_prista = "";
        int n = 0;
        int i = 0;
        while (i < numphas) {
            if (!Config.streq(p[i].prista, prev_prista)) {
                prev_prista = p[i].prista;
                ++n;
            }
            ++i;
        }
        stalist = new ISCSta[n];
        i = 0;
        while (i < n) {
            stalist[i] = new ISCSta();
            ++i;
        }
        prev_prista = "";
        int j = 0;
        i = 0;
        while (i < numphas) {
            if (!Config.streq(p[i].prista, prev_prista)) {
                prev_prista = p[i].prista;
                ((ISCSta)stalist[j]).sta = p[i].prista;
                ((ISCSta)stalist[j]).lat = p[i].sta_lat;
                ((ISCSta)stalist[j]).lon = p[i].sta_lon;
                ((ISCSta)stalist[j]).elev = p[i].sta_elev;
                ++j;
            }
            ++i;
        }
        Arrays.sort(stalist, 0, n);
        nsta.val = n;
        return stalist;
    }

    public static double[][] distance_matrix(int nsta, ISCSta[] stalist) {
        int j;
        double[][] distmatrix = null;
        int isnew = 0;
        double d = 0.0;
        doubleW esaz = new doubleW(0.0);
        doubleW seaz = new doubleW(0.0);
        distmatrix = new double[nsta][nsta];
        int i = 0;
        while (i < nsta) {
            isnew = 1;
            distmatrix[i][i] = 0.0;
            j = i + 1;
            while (j < nsta) {
                double d2 = d = 111.19492664455873 * Utils.distaz(stalist[j].lat, stalist[j].lon, stalist[i].lat, stalist[i].lon, seaz, esaz, isnew);
                distmatrix[j][i] = d2;
                distmatrix[i][j] = d2;
                isnew = 0;
                ++j;
            }
            ++i;
        }
        if (Config.verbose > 2) {
            logger.info((Object)String.format("    distance matrix (%d x %d):", nsta, nsta));
            i = 0;
            while (i < nsta) {
                StringBuffer sb = new StringBuffer(128);
                sb.append(String.format("      %-6s ", stalist[i].sta));
                j = 0;
                while (j < nsta) {
                    sb.append(String.format("%7.1f ", distmatrix[i][j]));
                    ++j;
                }
                logger.info((Object)sb.substring(0));
                ++i;
            }
        }
        return distmatrix;
    }

    public static int get_sta_index(int nsta, ISCSta[] stalist, String sta) {
        int klo = 0;
        int khi = nsta - 1;
        int k = 0;
        if (nsta > 2) {
            while (khi - klo > 1) {
                k = khi + klo >> 1;
                int i = stalist[k].sta.compareTo(sta);
                if (i == 0) {
                    return k;
                }
                if (i > 0) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
            if (khi == 1) {
                k = 0;
                if (Config.streq(sta, stalist[k].sta)) {
                    return k;
                }
                return -1;
            }
            if (klo == nsta - 2) {
                k = nsta - 1;
                if (Config.streq(sta, stalist[k].sta)) {
                    return k;
                }
                return -1;
            }
        } else {
            if (nsta == 2) {
                if (Config.streq(sta, stalist[0].sta)) {
                    return 0;
                }
                if (Config.streq(sta, stalist[1].sta)) {
                    return 1;
                }
                return -1;
            }
            if (Config.streq(sta, stalist[0].sta)) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static void sort_phaserec_nn(int numphas, int nsta, ISCPha[] p, ISCSta[] stalist, StaOrder[] staorder) {
        int j;
        int i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].time > p[j + 1].time && p[j + 1].time != 9999999.0 || p[j].time == 9999999.0) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                if (p[j].rdid > p[j + 1].rdid) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
        i = 1;
        while (i < numphas) {
            j = i - 1;
            while (j > -1) {
                int m = DataCovariance.get_sta_index(nsta, stalist, p[j].prista);
                int kp = staorder[m].index;
                m = DataCovariance.get_sta_index(nsta, stalist, p[j + 1].prista);
                int k = staorder[m].index;
                if (kp > k) {
                    Utils.swap(p, j, j + 1);
                }
                --j;
            }
            ++i;
        }
    }

    public static double[][] data_covariance_matrix(int nsta, int numphas, int nd, ISCPha[] p, ISCSta[] stalist, double[][] distmatrix, VarioGram variogramp) {
        int j;
        int sind1 = 0;
        int sind2 = 0;
        double stasep = 0.0;
        double var = 0.0;
        doubleW dydx = new doubleW(0.0);
        doubleW d2ydx = new doubleW(0.0);
        double[][] dcov = null;
        dcov = new double[nd][nd];
        int k = 0;
        int i = 0;
        while (i < numphas) {
            if (p[i].timedef) {
                sind1 = DataCovariance.get_sta_index(nsta, stalist, p[i].prista);
                if (sind1 < 0) {
                    return null;
                }
                dcov[k][k] = variogramp.sill + p[i].measerr * p[i].measerr;
                p[i].covindex = k;
                if (Config.verbose > 4) {
                    logger.info((Object)String.format("                i=%d k=%d sind1=%d sta=%s phase=%s", i, k, sind1, p[i].prista, p[i].phase));
                }
                int m = k + 1;
                j = i + 1;
                while (j < numphas) {
                    if (p[j].timedef) {
                        if (!p[i].phase.equals(p[j].phase)) {
                            ++m;
                        } else {
                            sind2 = DataCovariance.get_sta_index(nsta, stalist, p[j].prista);
                            if (sind2 < 0) {
                                return null;
                            }
                            var = 0.0;
                            stasep = distmatrix[sind1][sind2];
                            if (stasep < variogramp.maxsep) {
                                var = Interpolate.spline_int(stasep, variogramp.n, variogramp.x, variogramp.y, variogramp.d2y, 0, dydx, d2ydx);
                                var = variogramp.sill - var;
                            }
                            dcov[k][m] = var;
                            dcov[m][k] = var;
                            if (Config.verbose > 4) {
                                logger.info((Object)String.format("                  j=%d m=%d sind2=%d sta=%s phase=%s stasep=%.1f var=%.3f", j, m, sind2, p[j].prista, p[j].phase, stasep, var));
                            }
                            ++m;
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        if (Config.verbose > 2) {
            logger.info((Object)String.format("        Data covariance matrix C(%d x %d):", nd, nd));
            i = 0;
            k = 0;
            while (k < numphas) {
                if (p[k].timedef) {
                    StringBuilder sb = new StringBuilder(128);
                    sb.append(String.format("          %4d %-6s %-8s ", i, p[k].prista, p[k].phase));
                    j = 0;
                    while (j < nd) {
                        sb.append(String.format("%6.4f ", dcov[i][j]));
                        ++j;
                    }
                    logger.info((Object)sb.substring(0));
                    ++i;
                }
                ++k;
            }
        }
        return dcov;
    }

    public static int read_variogram(String fname, VarioGram variogramp) {
        int n = 0;
        Scanner sc = null;
        try {
            sc = new Scanner(new File(fname));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)e.getMessage());
            Config.errorcode = 2;
            return 1;
        }
        String delimiter = "((#.*\n)+|(#.*\r\n)+|(#.*\r)+|\\p{javaWhitespace}+)+";
        sc.useDelimiter(delimiter);
        variogramp.n = n = sc.nextInt();
        variogramp.sill = sc.nextDouble();
        variogramp.maxsep = sc.nextDouble();
        double[] tmp = new double[n];
        variogramp.x = new double[n];
        variogramp.y = new double[n];
        variogramp.d2y = new double[n];
        int i = 0;
        while (i < n) {
            variogramp.x[i] = sc.nextDouble();
            variogramp.y[i] = sc.nextDouble();
            ++i;
        }
        sc.close();
        Interpolate.spline(n, variogramp.x, variogramp.y, variogramp.d2y, tmp);
        return 0;
    }

    public static void free_variogram(VarioGram variogramp) {
        variogramp.d2y = null;
        variogramp.y = null;
        variogramp.x = null;
    }
}

