/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.seis.location.iscloc2;

import cn.org.gddsn.seis.location.iscloc2.Config;
import cn.org.gddsn.seis.location.iscloc2.ISCPha;
import cn.org.gddsn.seis.location.iscloc2.ISCSol;
import cn.org.gddsn.seis.location.iscloc2.Interpolate;
import cn.org.gddsn.seis.location.iscloc2.READING;
import cn.org.gddsn.seis.location.iscloc2.TT_TABLE;
import cn.org.gddsn.seis.location.iscloc2.TravelTimes;
import cn.org.gddsn.seis.location.iscloc2.Utils;
import org.apache.log4j.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DepthPhases {
    static Logger logger = Logger.getLogger(DepthPhases.class);

    public static int depth_resolution(ISCSol sp, READING[] rdindx, ISCPha[] p, boolean isverbose) {
        int k;
        int[] ageindex = new int[1024];
        int nsdef = 0;
        int ncoredef = 0;
        int nlocal = 0;
        int has_depth_resolution = 0;
        int nagent = 0;
        int i = 0;
        while (i < Config.numagencies) {
            ageindex[i] = 0;
            ++i;
        }
        i = 0;
        while (i < sp.nreading) {
            int m = rdindx[i].start;
            int np = rdindx[i].start + rdindx[i].npha;
            if (!p[m].duplicate && p[m].timedef && p[m].firstP && p[m].delta <= Config.localdist) {
                ++nlocal;
            }
            k = m + 1;
            while (k < np) {
                if (p[m].timedef && p[k].timedef) {
                    if (!p[k].duplicate && (Config.streq(p[k].phase, "PcP") || Config.streq(p[k].phase, "ScS"))) {
                        ++ncoredef;
                    }
                    if (p[m].firstP && p[k].firstS && p[m].delta <= Config.spdist && !(p[m].duplicate & p[k].duplicate)) {
                        ++nsdef;
                    }
                }
                ++k;
            }
            ++i;
        }
        if (ncoredef != 0) {
            i = 0;
            while (i < sp.numphas) {
                if (!p[i].duplicate && (Config.streq(p[i].phase, "PcP") || Config.streq(p[i].phase, "ScS"))) {
                    k = 0;
                    while (k < Config.numagencies) {
                        if (Config.streq(p[i].agency, Config.agencies[k])) {
                            int n = k;
                            ageindex[n] = ageindex[n] + 1;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            if (isverbose && Config.verbose > 1) {
                logger.info((Object)String.format("    agencies contributing PcP/ScS", new Object[0]));
            }
            nagent = 0;
            i = 0;
            while (i < Config.numagencies) {
                if (ageindex[i] != 0) {
                    ++nagent;
                    if (isverbose && Config.verbose > 1) {
                        logger.info((Object)String.format("      %3d %-17s %4d PcP/ScS", nagent, Config.agencies[i], ageindex[i]));
                    }
                }
                ++i;
            }
        }
        if (nlocal >= Config.minlocalsta || nsdef >= Config.min_s_p || ncoredef >= Config.min_corepha && nagent >= Config.ndepagency) {
            has_depth_resolution = 1;
        }
        if (isverbose) {
            logger.info((Object)String.format("    Depth resolution: %d", has_depth_resolution));
            logger.info((Object)String.format("        %d stations within %.2f degrees", nlocal, Config.localdist));
            logger.info((Object)String.format("        %d defining S-P pairs within %.2f degrees", nsdef, Config.spdist));
            logger.info((Object)String.format("        %d agencies reported %d defining PcP/ScS phases", nagent, ncoredef));
        }
        return has_depth_resolution;
    }

    public static int depth_phase_check(ISCSol sp, READING[] rdindx, ISCPha[] p, boolean isverbose) {
        int has_depdpres;
        int nagent;
        int ndepassoc;
        block36: {
            int k;
            ndepassoc = 0;
            nagent = 0;
            has_depdpres = 0;
            int[] ageindex = new int[1024];
            int i = 0;
            while (i < Config.numagencies) {
                ageindex[i] = 0;
                ++i;
            }
            i = 0;
            while (i < sp.numphas) {
                p[i].firstP = false;
                p[i].hasdepthphase = 0;
                p[i].pwPindex = 0;
                p[i].pPindex = 0;
                p[i].sSindex = 0;
                p[i].sPindex = 0;
                p[i].pSindex = 0;
                ++i;
            }
            i = 0;
            while (i < sp.nreading) {
                int m = rdindx[i].start;
                int np = rdindx[i].start + rdindx[i].npha;
                if (p[m].timedef && p[m].phase.length() > 0 && p[m].phase.charAt(0) == 'P') {
                    p[m].firstP = true;
                }
                if (rdindx[i].npha == 1 && !p[m].firstP && p[m].phase.length() > 0 && Character.isLowerCase(p[m].phase.charAt(0))) {
                    p[m].timedef = false;
                }
                k = m + 1;
                while (k < np) {
                    if (p[k].timedef && (p[k].phase.length() <= 0 || !Character.isUpperCase(p[k].phase.charAt(0)))) {
                        if (!p[m].firstP && p[k].phase.length() > 0 && Character.isLowerCase(p[k].phase.charAt(0))) {
                            p[k].timedef = false;
                        } else if (p[k].phase.startsWith("pP")) {
                            ++p[m].hasdepthphase;
                            p[m].pPindex = k;
                            if (!p[m].duplicate) {
                                ++ndepassoc;
                            }
                        } else if (p[k].phase.startsWith("pw")) {
                            ++p[m].hasdepthphase;
                            p[m].pwPindex = k;
                            if (!p[m].duplicate) {
                                ++ndepassoc;
                            }
                        } else if (p[k].phase.startsWith("pS")) {
                            ++p[m].hasdepthphase;
                            p[m].pSindex = k;
                            if (!p[m].duplicate) {
                                ++ndepassoc;
                            }
                        } else if (p[k].phase.startsWith("sP")) {
                            ++p[m].hasdepthphase;
                            p[m].sPindex = k;
                            if (!p[m].duplicate) {
                                ++ndepassoc;
                            }
                        } else if (p[k].phase.startsWith("sS")) {
                            ++p[m].hasdepthphase;
                            p[m].sSindex = k;
                            if (!p[m].duplicate) {
                                ++ndepassoc;
                            }
                        }
                    }
                    ++k;
                }
                ++i;
            }
            if (isverbose && Config.verbose > 1) {
                logger.info((Object)String.format("    %d associated depth phases", ndepassoc));
            }
            if (ndepassoc == 0) break block36;
            i = 0;
            while (i < sp.numphas) {
                block37: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        if (!p[i].firstP || p[i].hasdepthphase == 0) break block37;
                                        if (p[i].pPindex == 0) break block38;
                                        k = p[i].pPindex;
                                        if (!p[k].timedef || p[k].duplicate) break block37;
                                    }
                                    if (p[i].pwPindex == 0) break block39;
                                    k = p[i].pwPindex;
                                    if (!p[k].timedef || p[k].duplicate) break block37;
                                }
                                if (p[i].pSindex == 0) break block40;
                                k = p[i].pSindex;
                                if (!p[k].timedef || p[k].duplicate) break block37;
                            }
                            if (p[i].sPindex == 0) break block41;
                            k = p[i].sPindex;
                            if (!p[k].timedef || p[k].duplicate) break block37;
                        }
                        if (p[i].sSindex == 0) break block42;
                        k = p[i].sSindex;
                        if (!p[k].timedef || p[k].duplicate) break block37;
                    }
                    int j = 0;
                    while (j < Config.numagencies) {
                        if (Config.streq(p[i].agency, Config.agencies[j])) {
                            int n = j;
                            ageindex[n] = ageindex[n] + 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (isverbose && Config.verbose > 1) {
                logger.info((Object)String.format("    agencies contributing depth phases", new Object[0]));
            }
            nagent = 0;
            i = 0;
            while (i < Config.numagencies) {
                if (ageindex[i] != 0) {
                    ++nagent;
                    if (isverbose && Config.verbose > 1) {
                        logger.info((Object)String.format("      %3d %-17s %4d depth phases", nagent, Config.agencies[i], ageindex[i]));
                    }
                }
                ++i;
            }
        }
        int n = has_depdpres = ndepassoc < Config.mindepthpha || nagent < Config.ndepagency ? 0 : 1;
        if (isverbose) {
            logger.info((Object)String.format("    Depth-phase depth resolution: %d", has_depdpres));
            logger.info((Object)String.format("        %d agencies reported %d defining depth phases", nagent, ndepassoc));
        }
        return has_depdpres;
    }

    public static int depth_phase_stack(ISCSol sp, ISCPha[] p, TT_TABLE[] tt_tables, short[][] topo) {
        int m;
        int j;
        int n;
        int k;
        int ndep = 0;
        int ndel = 0;
        int ndp = 0;
        int ns = 0;
        int prev_rdid = 0;
        int d = 0;
        int dlo = 0;
        int dhi = 0;
        int iP = 0;
        int ipP = 0;
        int ipwP = 0;
        int ipS = 0;
        int isP = 0;
        int isS = 0;
        int nsamp = (int)Config.max_depth_km + 1;
        int med = 0;
        double delta = 0.0;
        double depth = 0.0;
        double esaz = 0.0;
        double moveout = 0.0;
        double deltim = 0.0;
        double smad = 0.0;
        double[] tz = null;
        double[] pt = null;
        double[] pp = null;
        int[] stack = null;
        int[] trace = null;
        TT_TABLE Pfirst = tt_tables[0];
        double[] depths = tt_tables[0].depths;
        sp.depdp = 9999999.0;
        sp.depdp_error = 9999999.0;
        sp.ndp = 0;
        ndep = tt_tables[0].ndep;
        ndel = tt_tables[0].ndel;
        tz = new double[ndep];
        pt = new double[ndep];
        trace = new int[nsamp];
        stack = new int[nsamp];
        pp = new double[ndep];
        prev_rdid = -1;
        int i = 0;
        while (i < sp.numphas) {
            block49: {
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                block50: {
                                    if (p[i].rdid == prev_rdid || !p[i].timedef || !p[i].firstP || p[i].hasdepthphase == 0) break block49;
                                    delta = p[i].delta;
                                    esaz = p[i].esaz;
                                    if (delta < tt_tables[0].deltas[0] || delta > tt_tables[0].deltas[ndel - 1]) break block49;
                                    isS = 0;
                                    isP = 0;
                                    ipS = 0;
                                    ipwP = 0;
                                    ipP = 0;
                                    iP = TravelTimes.get_phase_index(p[i].phase);
                                    if (iP < 0) break block49;
                                    if (p[i].pPindex == 0) break block50;
                                    k = p[i].pPindex;
                                    if (!p[k].timedef || p[k].duplicate) break block49;
                                    ipP = Math.max(0, TravelTimes.get_phase_index(p[k].phase));
                                    if (ipP != 0) {
                                        n = tt_tables[ipP].ndel;
                                        if (delta < tt_tables[ipP].deltas[0] || delta > tt_tables[ipP].deltas[n - 1]) {
                                            ipP = 0;
                                        }
                                    }
                                }
                                if (p[i].pwPindex == 0) break block51;
                                k = p[i].pwPindex;
                                if (!p[k].timedef || p[k].duplicate) break block49;
                                ipwP = Math.max(0, TravelTimes.get_phase_index(p[k].phase));
                                if (ipwP != 0) {
                                    n = tt_tables[ipwP].ndel;
                                    if (delta < tt_tables[ipwP].deltas[0] || delta > tt_tables[ipwP].deltas[n - 1]) {
                                        ipwP = 0;
                                    }
                                }
                            }
                            if (p[i].pSindex == 0) break block52;
                            k = p[i].pSindex;
                            if (!p[k].timedef || p[k].duplicate) break block49;
                            ipS = Math.max(0, TravelTimes.get_phase_index(p[k].phase));
                            if (ipS != 0) {
                                n = tt_tables[ipS].ndel;
                                if (delta < tt_tables[ipS].deltas[0] || delta > tt_tables[ipS].deltas[n - 1]) {
                                    ipS = 0;
                                }
                            }
                        }
                        if (p[i].sPindex == 0) break block53;
                        k = p[i].sPindex;
                        if (!p[k].timedef || p[k].duplicate) break block49;
                        isP = Math.max(0, TravelTimes.get_phase_index(p[k].phase));
                        if (isP != 0) {
                            n = tt_tables[isP].ndel;
                            if (delta < tt_tables[isP].deltas[0] || delta > tt_tables[isP].deltas[n - 1]) {
                                isP = 0;
                            }
                        }
                    }
                    if (p[i].sSindex == 0) break block54;
                    k = p[i].sSindex;
                    if (!p[k].timedef || p[k].duplicate) break block49;
                    isS = Math.max(0, TravelTimes.get_phase_index(p[k].phase));
                    if (isS != 0) {
                        n = tt_tables[isS].ndel;
                        if (delta < tt_tables[isS].deltas[0] || delta > tt_tables[isS].deltas[n - 1]) {
                            isS = 0;
                        }
                    }
                }
                if (ipP != 0 || ipwP != 0 || ipS != 0 || isP != 0 || isS != 0) {
                    j = 0;
                    while (j < ndep) {
                        tz[j] = -999.0;
                        pt[j] = -999.0;
                        ++j;
                    }
                    j = DepthPhases.phase_tt_h(delta, esaz, sp, tt_tables[iP], Pfirst, topo, 0, 0, tz);
                    if (ipP != 0) {
                        k = p[i].pPindex;
                        if (Config.verbose > 1) {
                            logger.info((Object)String.format("        %s, %s - %s, delta = %.2f statrace", p[i].prista, p[k].phase, p[i].phase, delta));
                        }
                        n = DepthPhases.phase_tt_h(delta, esaz, sp, tt_tables[ipP], Pfirst, topo, 1, 0, pt);
                        m = Math.min(n, j);
                        deltim = p[k].measerr;
                        moveout = p[k].ttime - p[i].ttime;
                        DepthPhases.stacker(m, moveout, deltim, pt, tz, depths, pp, trace, stack);
                        ++ndp;
                    }
                    if (ipwP != 0) {
                        k = p[i].pwPindex;
                        if (Config.verbose > 1) {
                            logger.info((Object)String.format("        %s, %s - %s, delta = %.2f statrace", p[i].prista, p[k].phase, p[i].phase, delta));
                        }
                        n = DepthPhases.phase_tt_h(delta, esaz, sp, tt_tables[ipwP], Pfirst, topo, 1, 1, pt);
                        m = Math.min(n, j);
                        deltim = p[k].measerr;
                        moveout = p[k].ttime - p[i].ttime;
                        DepthPhases.stacker(m, moveout, deltim, pt, tz, depths, pp, trace, stack);
                        ++ndp;
                    }
                    if (ipS != 0) {
                        k = p[i].pSindex;
                        if (Config.verbose > 1) {
                            logger.info((Object)String.format("        %s, %s - %s, delta = %.2f statrace", p[i].prista, p[k].phase, p[i].phase, delta));
                        }
                        n = DepthPhases.phase_tt_h(delta, esaz, sp, tt_tables[ipS], Pfirst, topo, 2, 0, pt);
                        m = Math.min(n, j);
                        deltim = p[k].measerr;
                        moveout = p[k].ttime - p[i].ttime;
                        DepthPhases.stacker(m, moveout, deltim, pt, tz, depths, pp, trace, stack);
                        ++ndp;
                    }
                    if (isP != 0) {
                        k = p[i].sPindex;
                        if (Config.verbose > 1) {
                            logger.info((Object)String.format("        %s, %s - %s, delta = %.2f statrace", p[i].prista, p[k].phase, p[i].phase, delta));
                        }
                        n = DepthPhases.phase_tt_h(delta, esaz, sp, tt_tables[isP], Pfirst, topo, 2, 0, pt);
                        m = Math.min(n, j);
                        deltim = p[k].measerr;
                        moveout = p[k].ttime - p[i].ttime;
                        DepthPhases.stacker(m, moveout, deltim, pt, tz, depths, pp, trace, stack);
                        ++ndp;
                    }
                    if (isS != 0) {
                        k = p[i].sSindex;
                        if (Config.verbose > 1) {
                            logger.info((Object)String.format("        %s, %s - %s, delta = %.2f statrace", p[i].prista, p[k].phase, p[i].phase, delta));
                        }
                        n = DepthPhases.phase_tt_h(delta, esaz, sp, tt_tables[isS], Pfirst, topo, 3, 0, pt);
                        m = Math.min(n, j);
                        deltim = p[k].measerr;
                        moveout = p[k].ttime - p[i].ttime;
                        DepthPhases.stacker(m, moveout, deltim, pt, tz, depths, pp, trace, stack);
                        ++ndp;
                    }
                }
            }
            ++i;
        }
        if (ndp < 3) {
            if (Config.verbose > 0) {
                logger.info((Object)String.format("    insufficient number of depth phases (%d)!", ndp));
            }
        } else {
            StringBuffer sb = new StringBuffer(128);
            if (Config.verbose > 0) {
                sb.append(String.format("    network depth stack trace  \n", new Object[0]));
            }
            ns = 0;
            d = 0;
            m = 0;
            j = 0;
            while (j < nsamp) {
                ns += stack[j];
                if (Config.verbose > 0) {
                    sb.append(String.format("%d ", stack[j]));
                }
                if (stack[j] > m) {
                    d = j;
                    m = stack[j];
                }
                ++j;
            }
            if (Config.verbose > 0) {
                logger.info((Object)sb.toString());
            }
            if ((ndp = m) < 3) {
                if (Config.verbose > 0) {
                    logger.info((Object)String.format("    insufficient number of consistent depth phases (%d)!", ndp));
                }
            } else {
                j = d;
                while (j > -1) {
                    if (stack[j] < 1) break;
                    --j;
                }
                dlo = Math.max(j + 1, 0);
                j = d;
                while (j < nsamp) {
                    if (stack[j] < 1) break;
                    ++j;
                }
                dhi = Math.min(j, nsamp);
                if (Config.verbose > 1) {
                    logger.info((Object)String.format("        stack width (%d-%d)", dlo, dhi));
                }
                trace[0] = stack[dlo];
                k = 1;
                j = dlo + 1;
                while (j < dhi) {
                    trace[k] = trace[k - 1] + stack[j];
                    if ((double)trace[k - 1] / (double)ns < 0.5 && (double)trace[k] / (double)ns >= 0.5) {
                        m = k;
                    }
                    ++k;
                    ++j;
                }
                med = (int)((double)(m + dlo) + ((double)ns / 2.0 - (double)trace[m - 1]) / (double)stack[m + dlo]);
                depth = med;
                j = 0;
                while (j < nsamp) {
                    trace[j] = 0;
                    ++j;
                }
                n = 0;
                j = dlo;
                while (j < dhi) {
                    int n2 = k = Math.abs(j - med);
                    trace[n2] = trace[n2] + stack[j];
                    if (k > n) {
                        n = k;
                    }
                    ++j;
                }
                stack[0] = trace[0];
                k = 1;
                j = 1;
                while (j < n) {
                    stack[k] = stack[k - 1] + trace[j];
                    if ((double)stack[k - 1] / (double)ns < 0.5 && (double)stack[k] / (double)ns >= 0.5) {
                        m = k;
                    }
                    ++k;
                    ++j;
                }
                smad = 1.4826 * (double)m + ((double)ns / 2.0 - (double)stack[m - 1]) / (double)trace[m];
                if (Config.verbose > 1) {
                    logger.info((Object)String.format("        depth=%.1f, smad=%.2f", depth, smad));
                }
                sp.depdp = depth;
                sp.depdp_error = smad;
                sp.ndp = ndp;
            }
        }
        pp = null;
        stack = null;
        trace = null;
        pt = null;
        tz = null;
        return ndp;
    }

    private static int phase_tt_h(double delta, double esaz, ISCSol sp, TT_TABLE tt_tablep, TT_TABLE Pfirst, short[][] topo, int ips, int ispwP, double[] pt) {
        boolean exactdelta = false;
        int ilo = 0;
        int ihi = 0;
        int jlo = 0;
        int jhi = 0;
        int idel = 0;
        int jdel = 0;
        doubleW dydx = new doubleW(0.0);
        doubleW d2ydx = new doubleW(0.0);
        double[] x = new double[6];
        double[] t = new double[6];
        double[] d2y = new double[6];
        double[] b = new double[6];
        double[] p = new double[6];
        double[] tmp = new double[6];
        double tcor = 0.0;
        double rayp = 0.0;
        double tt = 0.0;
        double bpaz = 0.0;
        double bpdel = 0.0;
        doubleW bplat = new doubleW(0.0);
        doubleW bplon = new doubleW(0.0);
        doubleW tcorw = new doubleW(0.0);
        int ndep = tt_tablep.ndep;
        int ndel = tt_tablep.ndel;
        int jndel = Pfirst.ndel;
        intW iloW = new intW(0);
        intW ihiW = new intW(0);
        Interpolate.bracket(delta, ndel, tt_tablep.deltas, iloW, ihiW);
        ilo = iloW.val;
        ihi = ihiW.val;
        if (Math.abs(delta - tt_tablep.deltas[ilo]) < 1.0E-8) {
            idel = ilo;
            exactdelta = true;
        } else if (Math.abs(delta - tt_tablep.deltas[ihi]) < 1.0E-8) {
            idel = ihi;
            exactdelta = true;
        } else {
            idel = ilo;
            ilo = idel - 3 + 1;
            ihi = idel + 3 + 1;
            if (ilo < 0) {
                ilo = 0;
                ihi = ilo + 6;
            }
            if (ihi > ndel) {
                ihi = ndel;
                ilo = ihi - 6;
            }
        }
        intW jloW = new intW(0);
        intW jhiW = new intW(0);
        Interpolate.bracket(delta, jndel, Pfirst.deltas, jloW, jhiW);
        jlo = jloW.val;
        jhi = jhiW.val;
        if (Math.abs(delta - Pfirst.deltas[jlo]) < 1.0E-8) {
            jdel = jlo;
        } else if (Math.abs(delta - Pfirst.deltas[jhi]) < 1.0E-8) {
            jdel = jhi;
        } else {
            jdel = jlo;
            jlo = jdel - 3 + 1;
            jhi = jdel + 3 + 1;
            if (jlo < 0) {
                jlo = 0;
                jhi = jlo + 6;
            }
            if (jhi > jndel) {
                jhi = jndel;
                jlo = jhi - 6;
            }
        }
        int j = 0;
        while (j < ndep) {
            if (exactdelta) {
                pt[j] = ips == 0 ? (tt_tablep.tt[idel][j] < 0.0 ? Pfirst.tt[jdel][j] : tt_tablep.tt[idel][j]) : tt_tablep.tt[idel][j];
                if (ips != 0) {
                    bpdel = tt_tablep.bpdel[idel][j];
                    rayp = tt_tablep.dtdd[idel][j];
                    bpaz = esaz;
                    if (rayp < 0.0) {
                        bpaz += 180.0;
                    }
                    if (bpaz > 360.0) {
                        bpaz -= 360.0;
                    }
                    Utils.deltaloc(sp.lat, sp.lon, bpdel, bpaz, bplat, bplon);
                    tcor = TravelTimes.topcor(ips, rayp, bplat.val, bplon.val, topo, tcorw);
                    int n = j;
                    pt[n] = pt[n] + tcor;
                    if (ispwP != 0) {
                        int n2 = j;
                        pt[n2] = pt[n2] + tcorw.val;
                    }
                }
            } else {
                int m = 0;
                int k = jlo;
                int i = ilo;
                while (i < ihi) {
                    tt = ips == 0 ? (tt_tablep.tt[i][j] < 0.0 ? Pfirst.tt[k][j] : tt_tablep.tt[i][j]) : tt_tablep.tt[i][j];
                    if (!(tt < 0.0)) {
                        x[m] = tt_tablep.deltas[i];
                        t[m] = tt;
                        if (ips != 0) {
                            b[m] = tt_tablep.bpdel[i][j];
                            p[m] = tt_tablep.dtdd[i][j];
                        }
                        ++m;
                    }
                    ++k;
                    ++i;
                }
                if (m < 2) {
                    pt[j] = -999.0;
                } else {
                    Interpolate.spline(m, x, t, d2y, tmp);
                    pt[j] = Interpolate.spline_int(delta, m, x, t, d2y, 0, dydx, d2ydx);
                    if (ips != 0) {
                        Interpolate.spline(m, x, b, d2y, tmp);
                        bpdel = Interpolate.spline_int(delta, m, x, b, d2y, 0, dydx, d2ydx);
                        Interpolate.spline(m, x, p, d2y, tmp);
                        rayp = Interpolate.spline_int(delta, m, x, p, d2y, 0, dydx, d2ydx);
                        bpaz = esaz;
                        if (rayp < 0.0) {
                            bpaz += 180.0;
                        }
                        if (bpaz > 360.0) {
                            bpaz -= 360.0;
                        }
                        Utils.deltaloc(sp.lat, sp.lon, bpdel, bpaz, bplat, bplon);
                        tcor = TravelTimes.topcor(ips, rayp, bplat.val, bplon.val, topo, tcorw);
                        int n = j;
                        pt[n] = pt[n] + tcor;
                        if (ispwP != 0) {
                            int n3 = j;
                            pt[n3] = pt[n3] + tcorw.val;
                        }
                    }
                }
            }
            ++j;
        }
        return ndep;
    }

    private static void stacker(int n, double moveout, double deltim, double[] pt, double[] tz, double[] depths, double[] pp, int[] trace, int[] stack) {
        int k = 0;
        int nsamp = (int)Config.max_depth_km + 1;
        pp[k++] = 0.0;
        int j = 0;
        while (j < n) {
            if (!(tz[j + 1] < 0.0) && !(pt[j] < 0.0)) {
                pp[k++] = pt[j] - tz[j + 1];
            }
            ++j;
        }
        if (k < 1) {
            return;
        }
        DepthPhases.sta_trace(k, moveout, deltim, pp, depths, trace);
        StringBuilder sb = new StringBuilder(128);
        if (Config.verbose > 2) {
            sb.append(String.format("        ", new Object[0]));
        }
        j = 0;
        while (j < nsamp) {
            int n2 = j;
            stack[n2] = stack[n2] + trace[j];
            if (Config.verbose > 2) {
                sb.append(String.format("%d ", trace[j]));
            }
            ++j;
        }
        if (Config.verbose > 2) {
            logger.info((Object)sb.substring(0));
        }
    }

    private static void sta_trace(int n, double moveout, double deltim, double[] pp, double[] h, int[] trace) {
        int hhi;
        int i;
        int idel;
        int hlo;
        int nsamp = (int)Config.max_depth_km + 1;
        double tp = 0.0;
        double hp = 0.0;
        doubleW dydx = new doubleW(0.0);
        doubleW d2ydx = new doubleW(0.0);
        double[] d2y = new double[6];
        double[] tmp = new double[6];
        double[] z = new double[6];
        double[] t = new double[6];
        int j = 0;
        while (j < nsamp) {
            trace[j] = 0;
            ++j;
        }
        tp = moveout - deltim;
        intW iloW = new intW(0);
        intW ihiW = new intW(0);
        Interpolate.bracket(tp, n, pp, iloW, ihiW);
        int ilo = iloW.val;
        int ihi = ihiW.val;
        if (Math.abs(tp - pp[ilo]) < 1.0E-8) {
            hlo = (int)Math.floor(h[ilo]);
        } else if (Math.abs(tp - pp[ihi]) < 1.0E-8) {
            hlo = (int)Math.floor(h[ihi]);
        } else {
            idel = ilo;
            ilo = idel - 3 + 1;
            ihi = idel + 3 + 1;
            if (ilo < 0) {
                ilo = 0;
                ihi = ilo + 6;
            }
            if (ihi > n) {
                ihi = n;
                ilo = ihi - 6;
            }
            j = 0;
            i = ilo;
            while (i < ihi) {
                z[j] = h[i];
                t[j] = pp[i];
                ++j;
                ++i;
            }
            Interpolate.spline(j, t, z, d2y, tmp);
            hp = Interpolate.spline_int(tp, j, t, z, d2y, 0, dydx, d2ydx);
            hlo = (int)Math.floor(hp);
        }
        if (hlo < 0) {
            hlo = 0;
        }
        tp = moveout + deltim;
        iloW = new intW(0);
        ihiW = new intW(0);
        Interpolate.bracket(tp, n, pp, iloW, ihiW);
        ilo = iloW.val;
        ihi = ihiW.val;
        if (Math.abs(tp - pp[ilo]) < 1.0E-8) {
            hhi = (int)Math.ceil(h[ilo]);
        } else if (Math.abs(tp - pp[ihi]) < 1.0E-8) {
            hhi = (int)Math.ceil(h[ihi]);
        } else {
            idel = ilo;
            ilo = idel - 3 + 1;
            ihi = idel + 3 + 1;
            if (ilo < 0) {
                ilo = 0;
                ihi = ilo + 6;
            }
            if (ihi > n) {
                ihi = n;
                ilo = ihi - 6;
            }
            j = 0;
            i = ilo;
            while (i < ihi) {
                z[j] = h[i];
                t[j] = pp[i];
                ++j;
                ++i;
            }
            Interpolate.spline(j, t, z, d2y, tmp);
            hp = Interpolate.spline_int(tp, j, t, z, d2y, 0, dydx, d2ydx);
            hhi = (int)Math.ceil(hp);
        }
        if (hhi > nsamp) {
            hhi = nsamp;
        }
        i = hlo;
        while (i < hhi) {
            trace[i] = 1;
            ++i;
        }
    }
}

